<?php
/*
Template Name: Blog
*/
get_header();

/**
 * Get settings
 *
 */
$settings = get_query_var( 'ghostpool_page_settings' );
if ( $settings && is_array( $settings ) ) {
	extract( $settings );
}

// Post types
if ( ! is_array( $post_types ) && $post_types ) {
	$post_types = explode( ',', $post_types );
}

// Post/page IDs
if ( ! is_array( $page_ids ) && $page_ids ) {
	$page_ids = explode( ',', $page_ids );
}
		
?>

<?php ghostpool_page_header( get_the_ID(), $header, $header_bg, $header_height ); ?>

<?php if ( 'gp-minimal-page-header' !== $header ) { ghostpool_page_title( '', $header ); } ?>

<div id="gp-content-wrapper" class="gp-container">

	<?php do_action( 'ghostpool_begin_content_wrapper' ); ?>
	
	<div id="gp-inner-container">
	
		<div id="gp-content">
		
			<?php if ( 'gp-minimal-page-header' === $header ) { ghostpool_page_title( '', $header ); } ?>
	
			<?php if ( have_posts() ) : while ( have_posts() ) : the_post();
				the_content();
			endwhile;
			endif; ?>

			<?php $args = array(
				'post_status' 	      => 'publish',
				'post_type'           => $post_types,
				'post__in'      	  => $page_ids,
				'tax_query'           => ghostpool_cats( $cats ),
				'tag'                 => $tags,
				'orderby'             => ghostpool_orderby( $orderby, 'orderby' ),
				'order'               => ghostpool_orderby( $orderby, 'order' ),
				'meta_key'            => ghostpool_orderby( $orderby, 'meta_key' ),
				'meta_query' 		  => ghostpool_orderby( $orderby, 'meta_query' ),
				'posts_per_page'      => $per_page,
				'paged'          	  => ghostpool_paged(),
			);
			$args = apply_filters( 'ghostpool_blog_query', $args );
			$gp_query = new WP_Query( $args );

			// Classes
			$css_classes = array(
				'gp-posts-wrapper',
				'gp-archive-wrapper',
				$format,
				$style,
				$alignment,
			);
			$css_classes = trim( implode( ' ', array_filter( array_unique( $css_classes ) ) ) );
			
			?>
		
			<div class="<?php echo esc_attr( $css_classes ); ?>" data-type="blog-template"<?php if ( function_exists( 'ghostpool_filter_variables' ) ) { echo ghostpool_filter_variables( $settings ); } ?>>
			
					<?php ghostpool_filter( $settings ); ?>
													
					<div class="gp-section-loop <?php echo sanitize_html_class( ghostpool_option( 'ajax' ) ); ?>">
						
						<?php if ( $gp_query->have_posts() ) : ?>
						
							<div class="gp-section-loop-inner">								
								<?php if ( $format == 'gp-posts-masonry' ) { ?><div class="gp-gutter-size"></div><?php } ?>					
								<?php while ( $gp_query->have_posts() ) : $gp_query->the_post();
									get_template_part( 'lib/sections/taxonomies/post-loop-standard' ); 
								endwhile; ?>
							</div>
						
							<?php echo ghostpool_pagination( $gp_query->max_num_pages, 'page-numbers' ); ?>
					
					<?php else : ?>

						<strong class="gp-no-items-found"><?php esc_html_e( 'No items found.', 'aardvark' ); ?></strong>

					<?php endif; wp_reset_postdata(); ?>
					
				</div>	
		
			</div>

		</div>

		<?php get_sidebar( 'left' ); ?>
	
		<?php get_sidebar( 'right' ); ?>

	</div>

	<?php do_action( 'ghostpool_end_content_wrapper' ); ?>
			
	<div class="gp-clear"></div>

</div>

<?php get_footer();