<?php if ( ! function_exists( 'ghostpool_global_setting_sections' ) ) {
	function ghostpool_global_setting_sections( $theme_slug = '' ) {
			 
		$sections = array(
		
			$theme_slug . '_general' => array(
				'id' => $theme_slug . '_general',
				'title' => esc_html__( 'General', 'aardvark' ),
				'subsections' => array(						
					$theme_slug . '_general' => array(
						'title' => esc_html__( 'General', 'aardvark' ),
						'desc' => esc_html__( 'General options for main sections of the theme.', 'aardvark' ),
					),
					$theme_slug . '_desktop_header' => array(
						'title' => esc_html__( 'Desktop Header', 'aardvark' ),
						'desc' => esc_html__( 'Options for the header on desktop devices.', 'aardvark' ),
					),	
					$theme_slug . '_mobile_header' => array(
						'title' => esc_html__( 'Mobile Header', 'aardvark' ),
						'desc' => esc_html__( 'Options for the header on mobile and smaller tablet devices.', 'aardvark' ),
					),	
					$theme_slug . '_top_header' => array(
						'title' => esc_html__( 'Top Header', 'aardvark' ),
						'desc' => esc_html__( 'Options for the top header.', 'aardvark' ),
					),
					$theme_slug . '_side_menu' => array(
						'title' => esc_html__( 'Side Menu', 'aardvark' ),
						'desc' => esc_html__( 'Options for the side menu.', 'aardvark' ),
					),
					$theme_slug . '_footer' => array(
						'title' => esc_html__( 'Footer', 'aardvark' ),
						'desc' => esc_html__( 'Options for the footer.', 'aardvark' ),
					),
					$theme_slug . '_title_header' => array(
						'title' => esc_html__( 'Title Header', 'aardvark' ),
						'desc' => esc_html__( 'Global options for the title header (some options can be overridden on individual pages).', 'aardvark' ),
					),
					$theme_slug . '_other_styling' => array(
						'title' => esc_html__( 'Other Styling', 'aardvark' ),
						'desc' => esc_html__( 'Options for the general theme styling.', 'aardvark' ),
					),
					$theme_slug . '_custom_code' => array(
						'title' => esc_html__( 'Custom Code', 'aardvark' ),
						'desc' => esc_html__( 'Options for adding custom code - this code will not be lost if you update the theme.', 'aardvark' ),
					),	
				),	
			),
			
			$theme_slug . '_posts' => array(
				'id' => $theme_slug . '_posts',
				'title' => esc_html__( 'Post Types', 'aardvark' ),
				'subsections' => array(
					$theme_slug . '_posts' => array(
						'title' => esc_html__( 'Posts', 'aardvark' ),
						'desc' => esc_html__( 'Global options for all posts (some options can be overridden on individual posts).', 'aardvark' ),
					),
					$theme_slug . '_pages' => array(
						'title' => esc_html__( 'Pages', 'aardvark' ),								
						'desc' => esc_html__( 'Global options for all pages (some options can be overridden on individual pages).', 'aardvark' ),
					 ),
					$theme_slug . '_post_submission' => array(
						'title' => esc_html__( 'Post Submission Page', 'aardvark' ),								
						'desc' => esc_html__( 'Global options for the post submission page.', 'aardvark' ),
					 ),
				),	
			),
			
			$theme_slug . '_archives' => array(
				'id' => $theme_slug . '_archives',
				'title' => esc_html__( 'Archives', 'aardvark' ),
				'subsections' => array(
					$theme_slug . '_archives' => array(
						'title' => esc_html__( 'Post Categories/Tags', 'aardvark' ),
						'desc' => esc_html__( 'Global options for all post categories/tags (some options can be overridden on individual post categories/tags or by using the Blog page template).', 'aardvark' ),
					),
					$theme_slug . '_archives_search_results' => array(
						'title' => esc_html__( 'Search Results', 'aardvark' ),								
						'desc' => esc_html__( 'Global options for search results.', 'aardvark' ),
					),
					$theme_slug . '_archives_author_posts' => array(
						'title' => esc_html__( 'Author Posts', 'aardvark' ),
						'desc' => esc_html__( 'Global options for author posts.', 'aardvark' ),
					 ),	
				),	
			),
			
			$theme_slug . '_membership' => array(
				'id' => $theme_slug . '_membership',
				'title' => esc_html__( 'Membership', 'aardvark' ),
				'subsections' => array(
					$theme_slug . '_membership' => array(
						'title' => esc_html__( 'Membership', 'aardvark' ),
						'desc' => ( function_exists( 'yz_is_membership_system_active' ) && true === yz_is_membership_system_active() ) ? '<span class="gp-notice-field">' . sprintf( esc_html__( 'This section is disabled because you have the Youzer Membership System activated. If you want to use these theme options instead click %s and disable the "Activate Membership System" option.', 'aardvark' ), '<a href="' .  admin_url( 'admin.php?page=youzer-panel' ) . '">' . esc_html__( 'here', 'aardvark' ) . '</a>' ) . '</span>' : esc_html__( 'Options for the membership.', 'aardvark' ),
						'class' => ( function_exists( 'yz_is_membership_system_active' ) && true === yz_is_membership_system_active() ) ? 'gp-disabled' : '',
					),
				),	
			),		
										
			$theme_slug . '_buddypress' => array(
				'id' => $theme_slug . '_buddypress',
				'title' => esc_html__( 'BuddyPress', 'aardvark' ),
				'subsections' => array(
					$theme_slug . '_buddypress' => array( 
						'title' => esc_html__( 'General', 'aardvark' ), 
						'desc' => esc_html__( 'Global options for all BuddyPress pages (some options can be overridden on individual pages).', 'aardvark' ),
					),
					$theme_slug . '_buddypress_activity_page' => array(
						'title' => esc_html__( 'Activity Page', 'aardvark' ),
						'desc' => esc_html__( 'Global options for the BuddyPress activity page.', 'aardvark' ),
					),
					$theme_slug . '_buddypress_members_page' => array(
						'title' => esc_html__( 'Members Page', 'aardvark' ),
						'desc' => esc_html__( 'Global options for the BuddyPress members page.', 'aardvark' ),
					),	
					$theme_slug . '_buddypress_groups_page' => array(
						'title' => esc_html__( 'Groups Page', 'aardvark' ),
						'desc' => esc_html__( 'Global options for the BuddyPress groups page.', 'aardvark' ),
					),	
					$theme_slug . '_buddypress_registration_page' => array(
						'title' => esc_html__( 'Registration Page', 'aardvark' ),
						'desc' => esc_html__( 'Global options for the BuddyPress registration page.', 'aardvark' ),
					),	
					$theme_slug . '_buddypress_activation_page' => array(
						'title' => esc_html__( 'Activation Page', 'aardvark' ),
						'desc' => esc_html__( 'Global options for the BuddyPress activation page.', 'aardvark' ),
					),
					$theme_slug . '_buddypress_bbpress' => array(
						'title' => esc_html__( 'bbPress', 'aardvark' ),
						'desc' => esc_html__( 'Global options for all bbPress pages (some options can be overridden on individual forums and topics).', 'aardvark' ),
					),
				),
			),
			
			$theme_slug . '_woocommerce' => array(
				'id' => $theme_slug . '_woocommerce',
				'title' => esc_html__( 'WooCommerce', 'aardvark' ),
				'subsections' => array(
					$theme_slug . '_woocommerce' => array(
						'title' => esc_html__( 'Shop Page', 'aardvark' ),
						'desc' => esc_html__( 'Global options for the main WooCommerce shop page.', 'aardvark' ),
					),	
					$theme_slug . '_woocommerce_product_categories' => array(
						'title' => esc_html__( 'Product Categories/Tags', 'aardvark' ),
						'desc' => esc_html__( 'Global options for all product categories and tags (some options can be overridden on individual product categories and tags).', 'aardvark' ),
					),
					$theme_slug . '_woocommerce_product_pages' => array(
						'title' => esc_html__( 'Product Pages', 'aardvark' ),
						'desc' => esc_html__( 'Global options for all product pages (some options can be overridden on individual product pages).', 'aardvark' ),
					),	
				),	
			),
			
			$theme_slug . '_sensei' => array(
				'id' => $theme_slug . '_sensei',
				'title' => esc_html__( 'Sensei', 'aardvark' ),
				'subsections' => array(
					$theme_slug . '_sensei' => array(
						'title' => esc_html__( 'Course Archives', 'aardvark' ),						
						'desc' => esc_html__( 'Global options for the courses archive page.', 'aardvark' ),
					),	
					$theme_slug . '_sensei_course_pages' => array(
						'title' => esc_html__( 'Course Pages', 'aardvark' ),
						'desc' => esc_html__( 'Global options for all course pages.', 'aardvark' ),
					),	
					$theme_slug . '_sensei_lesson_pages' => array(
						'title' => esc_html__( 'Lesson Pages', 'aardvark' ),
						'desc' => esc_html__( 'Global options for all lesson pages.', 'aardvark' ),
					),	
				),	
			),
			
			$theme_slug . '_advanced' => array(
				'id' => $theme_slug . '_advanced',
				'title' => esc_html__( 'Advanced', 'aardvark' ),
				'subsections' => array(
					$theme_slug . '_advanced' => array(
						'title' => esc_html__( 'Advanced', 'aardvark' ),						
						'desc' => esc_html__( 'Advanced options for the theme.', 'aardvark' ),
					),
				),
			),	
		
		);
		
		$sections = apply_filters( 'ghostpool_global_setting_sections', $sections, $theme_slug );
		
		return $sections;

	}
}	
			
if ( ! function_exists( 'ghostpool_global_settings' ) ) {
	function ghostpool_global_settings( $theme_slug = '' ) {
	
		$settings = array(

			/**
			 * General - Page Sections
			 *
			 */	
			 // Page
			array(
				'id' => 'overall_page_section',
				'title' => esc_html__( 'Overall Page', 'aardvark' ),
				'section' => $theme_slug . '_general',
				'type' => 'section-header',
				'class' => 'gp-setting gp-setting-begin',
			),	

				array(  
					'id' => 'theme_layout',
					'title' => esc_html__( 'Theme Layout', 'aardvark' ),
					'section' => $theme_slug . '_general',
					'type' => 'radio',
					'options'   => array(
						'gp-wide-layout' => esc_html__( 'Wide', 'aardvark' ),
						'gp-boxed-layout' => esc_html__( 'Boxed', 'aardvark' ),
					),
					'default'   => 'gp-wide-layout',	
				),
									
				array(
					'id' => 'page_bg',
					'title' => esc_html__( 'Page Background', 'aardvark' ),
					'section' => $theme_slug . '_general',
					'type'  => 'background',
					'output' => 'body, .gp-wide-layout .gp-divider-title, .gp-theme #buddypress:not(.youzer) .rtm-plupload-list .plupload_file_name .dashicons, .gp-full-page-page-header #gp-content-wrapper, .gp-theme.bp-user #buddypress .profile .bp-widget h2',
					'default' => array(
						'background-color' => '#fff',
						'background-image' => '',
						'background-repeat' => 'no-repeat',
						'background-attachment' => 'scroll',
						'background-position' => 'center center',
						'background-size' => 'inherit',	
					),	
				),
			
				array(
					'id' => 'primary_color',
					'title' => esc_html__( 'Primary Color', 'aardvark' ),
					'section' => $theme_slug . '_general',
					'type'  => 'color_gradient',
					'desc'  => esc_html__( 'The primary color used for various elements throughout the theme.', 'aardvark' ),
					'default' => array(
						'from' => '#00a0e3',
						'to' => '#39c8df',
					),
					'output' => array(
							'border-color' => '.woocommerce .widget_price_filter .ui-slider .ui-slider-handle',
							'background-color' => '.gp-ranking-counter, .tagcloud a, .woocommerce span.onsale, .gp-primary-color .vc-hoverbox-back, .wpb-js-composer .vc_tta.vc_tta-style-gp-1 .vc_tta-tab.vc_active, .wpb-js-composer .vc_tta.vc_tta-style-gp-1 .vc_tta-panel.vc_active .vc_tta-panel-title, .wpb-js-composer .vc_tta.vc_tta-style-gp-2 .vc_tta-tab.vc_active:before, .wpb-js-composer .vc_tta.vc_tta-style-gp-2 .vc_tta-panel.vc_active .vc_tta-panel-title:before, .wpb-js-composer .vc_tta.vc_tta-style-gp-3 .vc_tta-tab.vc_active, .wpb-js-composer .vc_tta.vc_tta-style-gp-3 .vc_tta-panel.vc_active .vc_tta-panel-title, .wpb-js-composer .vc_tta.vc_general.vc_tta-style-gp-1 .vc_tta-tab:not(.vc_active):hover .vc_tta-title-text, .wpb-js-composer .vc_tta.vc_general.vc_tta-style-gp-1 .vc_tta-panel:not(.vc_active) .vc_tta-panel-title:hover .vc_tta-title-text, .wpb-js-composer .vc_tta.vc_general.vc_tta-style-gp-3 .vc_tta-tab:not(.vc_active):hover .vc_tta-title-text, .wpb-js-composer .vc_tta.vc_general.vc_tta-style-gp-3 .vc_tta-panel:not(.vc_active) .vc_tta-panel-title:hover .vc_tta-title-text, .wpb-js-composer .vc_tta.vc_general.vc_tta-style-gp-2 .vc_tta-tab.vc_active .vc_tta-title-text, .wpb-js-composer .vc_tta.vc_general.vc_tta-style-gp-2 .vc_tta-tab:hover .vc_tta-title-text, .wpb-js-composer .vc_tta.vc_general.vc_tta-style-gp-2 .vc_tta-panel.vc_active .vc_tta-title-text, .wpb-js-composer .vc_tta.vc_general.vc_tta-style-gp-2 .vc_tta-panel:hover .vc_tta-title-text',
						),
					),
						 
			 // Content Wrapper
			array(
				'id' => 'content_wrapper_section',
				'title' => esc_html__( 'Content Wrapper', 'aardvark' ),
				'section' => $theme_slug . '_general',
				'type' => 'section-header',
				'class' => 'gp-setting gp-setting-begin',
			),	
			
				array(
					'id' => 'content_wrapper_bg',
					'title' => esc_html__( 'Background', 'aardvark' ),
					'section' => $theme_slug . '_general',
					'type'  => 'background',
					'default' => array(
						'background-color' => '#fff',
						'background-image' => '',
						'background-repeat' => 'no-repeat',
						'background-attachment' => 'scroll',
						'background-position' => 'center center',
						'background-size' => 'inherit',
					),
					'output' => '#gp-content-wrapper',
				),
				
				array(
					'id' => 'content_wrapper_border',
					'title' => esc_html__( 'Border', 'aardvark' ),
					'section' => $theme_slug . '_general',
					'type'  => 'border',
					'output' => '#gp-content-wrapper',
					'default'   => array(
						'border-bottom' => 0,
						'border-color' => '',
						'border-style' => 'solid',
						'border-radius' => 0,
					),
				),	
		
				array(
					'id' => 'desktop_content_wrapper_padding',
					'title' => esc_html__( 'Desktop Padding', 'aardvark' ),
					'section' => $theme_slug . '_general',
					'type' => 'spacing',
					'default' => array(
						'padding-top' => 40,
						'padding-bottom' => 40,
					),
					'media_query' => '@media only screen and (min-width: 992px)',
					'output' => '#gp-content-wrapper',
				),

				array(
					'id' => 'mobile_content_wrapper_padding',
					'title' => esc_html__( 'Mobile Padding', 'aardvark' ),
					'section' => $theme_slug . '_general',
					'type' => 'spacing',
					'default' => array(
						'padding-top' => 30,
						'padding-bottom' => 30,
					),
					'media_query' => '@media only screen and (max-width: 991px)',
					'output' => '#gp-content-wrapper',
				),

			 // Content Column
			array(
				'id' => 'content_section',
				'title' => esc_html__( 'Content Column', 'aardvark' ),
				'section' => $theme_slug . '_general',
				'type' => 'section-header',
				'class' => 'gp-setting gp-setting-begin',
			),					 
			
				array(
					'id' => 'content_bg',
					'title' => esc_html__( 'Background', 'aardvark' ),
					'section' => $theme_slug . '_general',
					'type'  => 'color_rgba',
					'output' => array( 
						'background-color' => 'body:not(.page-template-homepage-template) #gp-content, .gp-wide-layout .gp-divider-title, .gp-boxed-layout .gp-divider-title, .gp-theme.bp-user #buddypress .profile .bp-widget h2' 
					),
					'default'   => '',
				),					 
			
				array(
					'id' => 'content_border',
					'title' => esc_html__( 'Border', 'aardvark' ),
					'section' => $theme_slug . '_general',
					'type'  => 'border',
					'output' => 'body:not(.page-template-homepage-template) #gp-content',
					'default'   => array(
						'border-bottom' => 0,
						'border-color' => '',
						'border-style' => 'solid',
						'border-radius' => 0,
					),
				),					

				array(
					'id' => 'content_width',
					'title' => esc_html__( 'Width', 'aardvark' ),
					'section' => $theme_slug . '_general',
					'type' => 'dimensions',
					'units' => '%',
					'default' => array(
						'width' => 72,
					),	
					'media_query' => '@media only screen and (min-width: 992px)',
					'output' => '.gp-left-sidebar #gp-content, .gp-right-sidebar #gp-content, .gp-both-sidebars #gp-content',
				),

				array(
					'id' => 'content_padding',
					'title' => esc_html__( 'Padding', 'aardvark' ),
					'section' => $theme_slug . '_general',
					'type' => 'spacing',
					'output' => 'body:not(.page-template-homepage-template) #gp-content',
					'default' => array(
						'padding-top' => 0,
						'padding-right' => 0,
						'padding-bottom' => 0,
						'padding-left' => 0,
					),
				),
			
			// Sidebar Column
			array(
				'id' => 'sidebar_section',
				'title' => esc_html__( 'Sidebar Column', 'aardvark' ),
				'section' => $theme_slug . '_general',
				'type' => 'section-header',
				'class' => 'gp-setting gp-setting-begin',
			),	
						
				array(  
					'id' => 'sidebar_display',
					'title' => esc_html__( 'Sidebar Display', 'aardvark' ),
					'section' => $theme_slug . '_general',
					'type' => 'radio',
					'options' => array(
						'gp-sidebar-all' => esc_html__( 'Show on all devices', 'aardvark' ),
						'gp-sidebar-desktop' => esc_html__( 'Only show on desktop devices', 'aardvark' ),
					),
					'default' => 'gp-sidebar-desktop',
				),

				array(
					'id' => 'sidebar_bg',
					'title' => esc_html__( 'Background', 'aardvark' ),
					'section' => $theme_slug . '_general',
					'type'  => 'background',
					'output' => '.gp-sidebar',
					'default' => array(
						'background-color' => '',
						'background-image' => '',
						'background-repeat' => 'no-repeat',
						'background-attachment' => 'scroll',
						'background-position' => 'center center',
						'background-size' => 'inherit',
					),
				),	
				
				array(
					'id' => 'sidebar_border',
					'title' => esc_html__( 'Border', 'aardvark' ),
					'section' => $theme_slug . '_general',
					'type'  => 'border',
					'output' => '.gp-sidebar',
					'default'   => array(
						'border-bottom' => 0,
						'border-color' => '',
						'border-style' => 'solid',
						'border-radius' => 0,
					),
				),	
										
				array(
					'id' => 'sidebar_width',
					'title' => esc_html__( 'Width', 'aardvark' ),
					'section' => $theme_slug . '_general',
					'type' => 'dimensions',
					'units' => '%',
					'output' => '.gp-sidebar',
					'default' => array(
						'width' => 25,
					),	
				),
				
				array(
					'id' => 'left_sidebar_margin',
					'title' => esc_html__( 'Left Sidebar Margin', 'aardvark' ),
					'section' => $theme_slug . '_general',
					'desc' => esc_html__( 'The space between the left sidebar and main content column.', 'aardvark' ),
					'type' => 'spacing',
					'units' => '%',
					'rtl' => true,
					'default' => array(
						'margin-right' => 3,
					),	
					'output' => '#gp-sidebar-left',
				),

				array(
					'id' => 'right_sidebar_margin',
					'title' => esc_html__( 'Right Sidebar Margin', 'aardvark' ),
					'section' => $theme_slug . '_general',
					'desc' => esc_html__( 'The space between the right sidebar and main content column.', 'aardvark' ),
					'type' => 'spacing',
					'units' => '%',
					'rtl' => true,
					'default' => array(
						'margin-left' => 3,
					),	
					'output' => '#gp-sidebar-right',
				),
								
				array(
					'id' => 'sidebar_padding',
					'title' => esc_html__( 'Padding', 'aardvark' ),
					'section' => $theme_slug . '_general',
					'desc' => esc_html__( 'The padding inside the sidebar.', 'aardvark' ),
					'type' => 'spacing',
					'output' => '.gp-sidebar',
					'default' => array(
						'padding-top' => 0,
						'padding-right' => 0,
						'padding-bottom' => 0,
						'padding-left' => 0,
					),
				),

				array(
					'id' => 'widget_bg',
					'title' => esc_html__( 'Widget Background', 'aardvark' ),
					'section' => $theme_slug . '_general',
					'type' => 'color_rgba',
					'output' => array( 'background-color' => '.gp-sidebar .widget' ),
					'default'   => '',
				),
				
				array(
					'id' => 'widget_border',
					'title' => esc_html__( 'Widget Border', 'aardvark' ),
					'section' => $theme_slug . '_general',
					'type'  => 'border',
					'output' => '.gp-sidebar .widget',
					'default'   => array(
						'border-bottom' => 0,
						'border-color' => '',
						'border-style' => 'solid',
						'border-radius' => 0,
					),
				),	
				
				array(
					'id' => 'widget_padding',
					'title' => esc_html__( 'Widget Padding', 'aardvark' ),
					'section' => $theme_slug . '_general',
					'type' => 'spacing',
					'output' => '.gp-sidebar .widget',
					'default' => array(
						'padding-top' => '0',
						'padding-right' => '0',
						'padding-bottom' => '0',
						'padding-left' => '0',
					),
				),

				array(
					'id' => 'widget_spacing',
					'title' => esc_html__( 'Widget Spacing', 'aardvark' ),
					'section' => $theme_slug . '_general',
					'type' => 'spacing',
					'output' => '.gp-sidebar .widget',
					'default' => array(
						'margin-bottom' => '35',
					),
				),
			
				array(
					'id' => 'widget_title_typography',
					'title' => esc_html__( 'Widget Title', 'aardvark' ),
					'section' => $theme_slug . '_general',
					'type'      => 'typography',
					'output' =>  '.widget-title, .widget-title a, .wpb_heading',
					'default'   => array(
						'font-size' => array(
							'value' => '19',
						),
						'line-height' => array(
							'value' => '19',
						),
						'font-family' => 'Roboto',
						'font-backup' => 'Arial, Helvetica, sans-serif',
						'font-weight' => '400',
						'subsets' => 'latin',
						'letter-spacing' => array(
							'value' => '0',
						),
						'color' => '#232323',
						'text-transform' => 'none',
					),
				),

				array(
					'id' => 'widget_text_typography',
					'title' => esc_html__( 'Widget Text', 'aardvark' ),
					'section' => $theme_slug . '_general',
					'type'      => 'typography',
					'output' => '.widget',
					'default'   => array(
						'font-size' => array(
							'value' => '16',
						),
						'line-height' => array(
							'value' => '24',
						),
						'font-family' => 'Roboto',
						'font-backup' => 'Arial, Helvetica, sans-serif',
						'font-weight' => '400',
						'subsets' => 'latin',
						'letter-spacing' => array(
							'value' => '0',
						),
						'color' => '#777',
						'text-transform' => 'none',
					),
				),

				array(
					'id' => 'widget_link_colors',
					'title' => esc_html__( 'Widget Links', 'aardvark' ),
					'section' => $theme_slug . '_general',
					'type'      => 'link_color',
					'output' => '.widget a',
					'default'   => array(
						'regular' => '#777',
						'hover'   => '#39c8df',
					),
				),
			
			// Page Loader
			array(
				'id' => 'page_loader_section',
				'title' => esc_html__( 'Page Loader', 'aardvark' ),
				'section' => $theme_slug . '_general',
				'type' => 'section-header',
				'class' => 'gp-setting gp-setting-begin',
			),			 
			
				array(  
					'id' => 'page_loader',
					'title' => esc_html__( 'Page Loader', 'aardvark' ),
					'section' => $theme_slug . '_general',
					'desc' => esc_html__( 'Display a loading icon until the page has loaded all content.', 'aardvark' ),
					'type' => 'radio',
					'options'   => array(
						'enabled' => esc_html__( 'Enabled', 'aardvark' ),
						'disabled' => esc_html__( 'Disabled', 'aardvark' )
					),
					'default'   => 'enabled',	
				),
							
				array(
					'id' => 'page_loader_bg',
					'title' => esc_html__( 'Background', 'aardvark' ),
					'section' => $theme_slug . '_general',
					'type'  => 'background',
					'output' => '.gp-loader',
					'default' => array(
						'background-color' => '#fff',
						'background-image' => '',
						'background-repeat' => 'no-repeat',
						'background-attachment' => 'scroll',
						'background-position' => 'center center',
						'background-size' => 'inherit',	
					),	
					'conditions' => array(
						'page_loader' => 'enabled',
					),
				),
			
				array( 
					'id' => 'page_loader_icon_type',
					'title' => esc_html__( 'Type', 'aardvark' ),
					'section' => $theme_slug . '_general',
					'type' => 'select',
					'options' => array( 
						'cube' => esc_html__( 'Cube', 'aardvark' ),
						'custom-icon' => esc_html__( 'Custom Icon', 'aardvark' ),
						'custom-code' => esc_html__( 'Custom Code', 'aardvark' ),
					),
					'default' => 'cube',
					'conditions' => array(
						'page_loader' => 'enabled',
					),
				),
								
				array(
					'id' => 'page_loader_cube_color',
					'title' => esc_html__( 'Cube Color', 'aardvark' ),
					'section' => $theme_slug . '_general',
					'type'  => 'color_rgba',
					'output' => array(
						'background-color' => '.sk-folding-cube .sk-cube:before',
					),	
					'default' => '#eee',
					'conditions' => array(
						'page_loader' => 'enabled',
					),
				),
								
				array(
					'id' => 'page_loader_custom_icon',
					'title' => esc_html__( 'Custom Icon', 'aardvark' ),
					'section' => $theme_slug . '_general',
					'type'  => 'styling',	
					'styling' => array(
						'icon' => array(
							'title' => esc_html__( 'Icon', 'aardvark' ),
							'type' => 'icon',
							'default' => '',
						),
						'size' => array(
							'title' => esc_html__( 'Size', 'aardvark' ),
							'type' => 'dimensions',
							'output' => '.gp-loader-custom-icon',
							'default' => array(
								'font-size' => '',
							),
						),
						'color' => array(
							'title' => esc_html__( 'Color', 'aardvark' ),
							'type' => 'color_rgba',
							'output' => '.gp-loader-custom-icon',
							'default' => '',
						),
					),
					'conditions' => array(
						'page_loader' => 'enabled',
					),
				),
												
				array( 
					'id' => 'page_loader_custom_code',
					'title' => esc_html__( 'Custom Code', 'aardvark' ),
					'desc' => esc_html__( 'Add your own HTML.', 'aardvark' ),
					'section' => $theme_slug . '_general',
					'type' => 'textarea',
					'conditions' => array(
						'page_loader' => 'enabled',
					),
				),
							
			/**
			 * Desktop Header
			 *
			 */
			// General
			array(
				'id' => 'desktop_header_section',
				'title' => esc_html__( 'General', 'aardvark' ),
				'section' => $theme_slug . '_desktop_header',
				'type' => 'section-header',
				'class' => 'gp-setting gp-setting-begin',
			),
			
				array( 
					'id' => 'header_display',
					'title' => esc_html__( 'Display', 'aardvark' ),
					'section' => $theme_slug . '_desktop_header',
					'type' => 'select',
					'options' => array( 
						'gp-header-above-content' => esc_html__( 'Above Content', 'aardvark' ),
						'gp-header-over-content' => esc_html__( 'Over Content', 'aardvark' ),
						'gp-header-disabled' => esc_html__( 'Disabled', 'aardvark' ),
					),
					'default' => 'gp-header-above-content',
				),
						 
				array( 
					'id' => 'header_layout',
					'title' => esc_html__( 'Layout', 'aardvark' ),
					'section' => $theme_slug . '_desktop_header',
					'type' => 'image_select',
					'options' => array( 
						'gp-header-logo-left-1' => array( esc_html__( 'Header 1', 'aardvark' ), 'img' => get_template_directory_uri() . '/lib/framework/settings/images/logo-left-1.jpg' ),
						'gp-header-logo-left-2' => array( esc_html__( 'Header 2', 'aardvark' ), 'img' => get_template_directory_uri() . '/lib/framework/settings/images/logo-left-2.jpg' ),
						'gp-header-logo-right-1' => array( esc_html__( 'Header 3', 'aardvark' ), 'img' => get_template_directory_uri() . '/lib/framework/settings/images/logo-right-1.jpg' ),
						'gp-header-nav-bottom-1' => array( esc_html__( 'Header 4', 'aardvark' ), 'img' => get_template_directory_uri() . '/lib/framework/settings/images/nav-bottom-1.jpg' ),
						'gp-header-nav-bottom-2' => array( esc_html__( 'Header 5', 'aardvark' ), 'img' => get_template_directory_uri() . '/lib/framework/settings/images/nav-bottom-2.jpg' ),
						'gp-header-nav-bottom-3' => array( esc_html__( 'Header 6', 'aardvark' ), 'img' => get_template_directory_uri() . '/lib/framework/settings/images/nav-bottom-3.jpg' ),
						'gp-header-side-menu' => array( esc_html__( 'Header 7', 'aardvark' ), 'img' => get_template_directory_uri() . '/lib/framework/settings/images/side-menu.jpg' ),
					),
					'default' => 'gp-header-logo-left-1',	
				),
			
				array( 
					'id' => 'header_format',
					'title' => esc_html__( 'Format', 'aardvark' ),
					'section' => $theme_slug . '_desktop_header',
					'type' => 'radio',
					'options' => array( 
						'gp-header-wide' => esc_html__( 'Wide', 'aardvark' ),
						'gp-header-boxed' => esc_html__( 'Boxed', 'aardvark' ),
					),
					'default' => 'gp-header-boxed',
				),

				array(  
					'id' => 'fixed_header',
					'title' => esc_html__( 'Fixed Header', 'aardvark' ),
					'section' => $theme_slug . '_desktop_header',
					'type' => 'select',
					'options' => array(
						'gp-fixed-header-all' => esc_html__( 'Show on all devices', 'aardvark' ),
						'gp-fixed-header-desktop' => esc_html__( 'Only show on desktop devices', 'aardvark' ),
						'gp-relative-header' => esc_html__( 'Disabled', 'aardvark' ),
					),
					'default' => 'gp-fixed-header-all',
				),

				array(  
					'id' => 'fixed_header_type',
					'title' => esc_html__( 'Fixed Header Type', 'aardvark' ),
					'section' => $theme_slug . '_desktop_header',
					'type' => 'radio',
					'options' => array(
						'gp-fixed-scrolling-up-down' => esc_html__( 'Fixed when scrolling up and down', 'aardvark' ),
						'gp-fixed-scrolling-up' => esc_html__( 'Fixed only when scrolling up', 'aardvark' ),
					),
					'default' => 'gp-fixed-scrolling-up-down',
					'conditions' => array(
						'fixed_header' => array( 
							'value' => 'gp-relative-header',
							'operator' => '!=',
						),
					),
				),

				array(
					'id' => 'scroll_to_fixed_header',
					'title' => esc_html__( 'Scroll To Fixed Header', 'aardvark' ),
					'section' => $theme_slug . '_desktop_header',
					'desc' => esc_html__( 'The amount of pixels to scroll before fixing the header.', 'aardvark' ),
					'type' => 'dimensions',
					'default' => array(
						'height' => 200,
					),	
					'conditions' => array(
						'fixed_header' => array( 
							'value' => 'gp-relative-header',
							'operator' => '!=',
						),
					),
				),
			
			// Standard Header
			array(
				'id' => 'desktop_standard_header_section',
				'title' => esc_html__( 'Standard Header', 'aardvark' ),
				'section' => $theme_slug . '_desktop_header',
				'type' => 'section-header',
				'class' => 'gp-setting gp-setting-begin',
			),

				array(
					'id' => 'logo',
					'title' => esc_html__( 'Logo', 'aardvark' ),	
					'section' => $theme_slug . '_desktop_header',				
					'type' => 'styling',
					'styling' => array(
						'standard' => array(
							'title' => esc_html__( 'Standard', 'aardvark' ),
							'type' => 'media',
							'default' => get_template_directory_uri() . '/lib/images/original/logo.png',
						),
						'retina' => array(
							'title' => esc_html__( 'Retina', 'aardvark' ),
							'type' => 'media',
							'default' => get_template_directory_uri() . '/lib/images/original/logo-retina.png',
						),
						'width' => array(
							'title' => esc_html__( 'Width', 'aardvark' ),
							'type' => 'dimensions',
							'default' => 117,
						),
						'height' => array(
							'title' => esc_html__( 'Height', 'aardvark' ),
							'type' => 'dimensions',
							'default' => 24,
						),
					),
				),

				array( 
					'id' => 'text_logo',
					'title' => esc_html__( 'Text Logo', 'aardvark' ),	
					'section' => $theme_slug . '_desktop_header',
					'desc' => esc_html__( 'Adding a text logo will remove any image logos.', 'aardvark' ),				
					'type' => 'text',
					'default'  => '',
				),

				array(
					'id' => 'text_logo_typography',
					'title' => esc_html__( 'Text Logo Typography', 'aardvark' ),
					'section' => $theme_slug . '_desktop_header',
					'type'      => 'typography',
					'output' => '#gp-standard-header .gp-text-logo, #gp-side-menu-logo .gp-text-logo',
					'default'   => array(
						'font-family' => 'Roboto',
						'font-backup' => 'Arial, Helvetica, sans-serif',
						'font-weight' => '500',
						'subsets' => 'latin',
						'font-size' => array(
							'value' => '30',
						),
						'line-height' => array(
							'value' => '30',
						),
						'letter-spacing' => array(
							'value' => '-1.5',
						),
						'color'       => '#232323',
						'text-transform' => 'none',
					),
					'conditions' => array(
						'text_logo' => array(
							'operator' => 'not_empty',
						),
					),
				),
			
				array(
					'id' => 'desktop_header_height',
					'title' => esc_html__( 'Header Height', 'aardvark' ),
					'section' => $theme_slug . '_desktop_header',
					'type' => 'dimensions',
					'default' => array(
						'height' => 90,
					),
					'output' => '.gp-header-logo-left-1 #gp-standard-header .gp-logo, .gp-header-logo-left-2 #gp-standard-header .gp-logo, .gp-header-logo-right-1 #gp-standard-header .gp-logo, .gp-header-side-menu #gp-standard-header, .gp-nav-column, #gp-standard-header #gp-header-row-1',
				),

				array(
					'id' => 'main_header_bg',
					'title' => esc_html__( 'Main Background', 'aardvark' ),
					'section' => $theme_slug . '_desktop_header',
					'type' => 'background',
					'output' => '#gp-standard-header, #gp-header-row-1, #gp-mobile-header',
					'default'   => array(
						'background-color' => '#fff',
						'background-image' => '',
						'background-repeat' => 'no-repeat',
						'background-attachment' => 'scroll',
						'background-position' => 'center center',
						'background-size' => 'inherit',
					),
				),
							
				array(
					'id' => 'main_header_border',
					'title' => esc_html__( 'Main Border', 'aardvark' ),
					'section' => $theme_slug . '_desktop_header',
					'type'      => 'border',
					'output' => '.gp-header-above-content #gp-standard-header',
					'default'   => array(
						'border-bottom' => 1,
						'border-color' => '#e6e6e6',
						'border-style' => 'solid',
					),
				),
			
				array(
					'id' => 'main_header_nav_bg',
					'title' => esc_html__( 'Navigation Background', 'aardvark' ),
					'section' => $theme_slug . '_desktop_header',
					'type' => 'background',
					'output' => '.gp-header-nav-bottom-1 #gp-standard-header #gp-header-row-2, .gp-header-nav-bottom-2 #gp-standard-header #gp-header-row-2, .gp-header-nav-bottom-3 #gp-standard-header #gp-header-row-2',
					'default'   => array(
						'background-color' => '#fff',
						'background-image' => '',
						'background-repeat' => 'no-repeat',
						'background-attachment' => 'scroll',
						'background-position' => 'center center',
						'background-size' => 'inherit',
					),
					'conditions' => array(
						'header_layout' => array( 
							'value' => array( 'gp-header-nav-bottom-1', 'gp-header-nav-bottom-2', 'gp-header-nav-bottom-3' ),
							'operator' => 'in_array',
						),
					),
				),
				
				array(
					'id' => 'desktop_header_nav_height',
					'title' => esc_html__( 'Navigation Height', 'aardvark' ),
					'section' => $theme_slug . '_desktop_header',
					'desc' => esc_html__( 'The height of the navigation below the logo on larger devices.', 'aardvark' ),
					'type' => 'dimensions',
					'default' => array(
						'height' => 60,
					),	
					'output' => '#gp-standard-header #gp-header-row-2',
					'conditions' => array(
						'header_layout' => array( 
							'value' => array( 'gp-header-nav-bottom-1', 'gp-header-nav-bottom-2', 'gp-header-nav-bottom-3' ),
							'operator' => 'in_array',
						),
					),
				),
			
				array(
					'id' => 'main_header_nav_border',
					'title' => esc_html__( 'Navigation Border', 'aardvark' ),
					'section' => $theme_slug . '_desktop_header',
					'type'      => 'border',
					'output' => '#gp-standard-header #gp-header-row-2',
					'default'   => array(
						'border-top' => 1,
						'border-color' => '#e6e6e6',
						'border-style' => 'solid',
					),
					'conditions' => array(
						'header_layout' => array( 
							'value' => array( 'gp-header-nav-bottom-1', 'gp-header-nav-bottom-2', 'gp-header-nav-bottom-3' ),
							'operator' => 'in_array',
						),
					),
				),		

				array(
					'id' => 'main_header_nav_link_divider',
					'title' => esc_html__( 'Navigation Link Divider', 'aardvark' ),
					'section' => $theme_slug . '_desktop_header',
					'type'      => 'border',
					'output' => '.gp-header-nav-bottom-1 #gp-standard-header #gp-main-header-primary-nav > ul > li:after, .gp-header-nav-bottom-2 #gp-standard-header #gp-main-header-primary-nav > ul > li:after',
					'default'   => array(
						'border-right' => 1,
						'border-color' => '#e6e6e6',
						'border-style' => 'solid',
					),
					'conditions' => array(
						'header_layout' => array( 
							'value' => array( 'gp-header-nav-bottom-1', 'gp-header-nav-bottom-2' ),
							'operator' => 'in_array',
						),
					),
				),

			// Desktop - Overlay Header
			array(
				'id' => 'desktop_overlay_header_title',
				'title' => esc_html__( 'Overlay Header', 'aardvark' ),
				'section' => $theme_slug . '_desktop_header',
				'type' => 'section-header',
				'class' => 'gp-setting gp-setting-begin',
			),
	
				array( 
					'id' => 'logo_overlay',	
					'title' => esc_html__( 'Logo', 'aardvark' ),		
					'section' => $theme_slug . '_desktop_header',			
					'type' => 'styling',
					'styling' => array(
						'standard' => array(
							'title' => esc_html__( 'Standard', 'aardvark' ),
							'type' => 'media',
							'default' => '',
						),
						'retina' => array(
							'title' => esc_html__( 'Retina', 'aardvark' ),
							'type' => 'media',
							'default' => '',
						),
						'width' => array(
							'title' => esc_html__( 'Width', 'aardvark' ),
							'type' => 'dimensions',
							'default' => '',
						),
						'height' => array(
							'title' => esc_html__( 'Height', 'aardvark' ),
							'type' => 'dimensions',
							'default' => '',
						),
					),
				),

				array(
					'id' => 'main_header_over_content_bg',
					'title' => esc_html__( 'Main Background', 'aardvark' ),
					'section' => $theme_slug . '_desktop_header',
					'type'      => 'background',
					'output' => '.gp-header-over-content.gp-header-logo-left-1 #gp-standard-header, .gp-header-over-content.gp-header-logo-left-2 #gp-standard-header, .gp-header-over-content.gp-header-logo-right-1 #gp-standard-header, .gp-header-over-content.gp-header-side-menu #gp-standard-header, .gp-header-over-content.gp-header-nav-bottom-1 #gp-header-row-1, .gp-header-over-content.gp-header-nav-bottom-2 #gp-header-row-1,	 .gp-header-over-content.gp-header-nav-bottom-3 #gp-header-row-1',
					'default'   => array(
						'background-color' => 'rgba(0,0,0,0)',
						'background-image' => '',
						'background-repeat' => 'no-repeat',
						'background-attachment' => 'scroll',
						'background-position' => 'center center',
						'background-size' => 'inherit',
					),
				),

				array(
					'id' => 'main_header_over_content_border',
					'title' => esc_html__( 'Main Border', 'aardvark' ),
					'section' => $theme_slug . '_desktop_header',
					'type'      => 'border',
					'output' => '.gp-header-over-content #gp-standard-header',
					'default'   => array(
						'border-bottom' => '0',
						'border-color' => '#e6e6e6',
						'border-style' => 'solid',
					),
				),

				array(
					'id' => 'main_header_over_content_nav_bg',
					'title' => esc_html__( 'Navigation Background', 'aardvark' ),
					'section' => $theme_slug . '_desktop_header',
					'type'      => 'background',
					'output' => '.gp-header-over-content.gp-header-nav-bottom-1 #gp-standard-header #gp-header-row-2, .gp-header-over-content.gp-header-nav-bottom-2 #gp-standard-header #gp-header-row-2, .gp-header-over-content.gp-header-nav-bottom-3 #gp-standard-header #gp-header-row-2',
					'default'   => array(
						'background-color' => 'rgba(0,0,0,0)',
						'background-image' => '',
						'background-repeat' => 'no-repeat',
						'background-attachment' => 'scroll',
						'background-position' => 'center center',
						'background-size' => 'inherit',
					),
					'conditions' => array(
						'header_layout' => array( 
							'value' => array( 'gp-header-nav-bottom-1', 'gp-header-nav-bottom-2', 'gp-header-nav-bottom-3' ),
							'operator' => 'in_array',
						),
					),
				),
			
				array(
					'id' => 'main_header_over_content_nav_border',
					'title' => esc_html__( 'Navigation Border', 'aardvark' ),
					'section' => $theme_slug . '_desktop_header',
					'type'      => 'border',
					'output' => '.gp-header-over-content #gp-standard-header #gp-header-row-2',
					'default'   => array(
						'border-top' => '0',
						'border-color' => '#e6e6e6',
						'border-style' => 'solid',
					),
					'conditions' => array(
						'header_layout' => array( 
							'value' => array( 'gp-header-nav-bottom-1', 'gp-header-nav-bottom-2', 'gp-header-nav-bottom-3' ),
							'operator' => 'in_array',
						),
					),
				),		

				array(
					'id' => 'main_header_over_content_nav_link_divider',
					'title' => esc_html__( 'Navigation Link Divider', 'aardvark' ),
					'section' => $theme_slug . '_desktop_header',
					'type'      => 'border',
					'output' => '.gp-header-over-content.gp-header-nav-bottom-1 #gp-standard-header #gp-main-header-primary-nav > ul > li:after, .gp-header-over-content.gp-header-nav-bottom-2 #gp-standard-header #gp-main-header-primary-nav > ul > li:after',
					'default'   => array(
						'border-right' => 1,
						'border-color' => '#e6e6e6',
						'border-style' => 'solid',
					),
					'conditions' => array(
						'header_layout' => array( 
							'value' => array( 'gp-header-nav-bottom-1', 'gp-header-nav-bottom-2' ),
							'operator' => 'in_array',
						),
					),
				),
													
			// Desktop - Scrolling Header
			array(
				'id' => 'desktop_scrolling_header_title',
				'title' => esc_html__( 'Scrolling Header', 'aardvark' ),
				'section' => $theme_slug . '_desktop_header',
				'type' => 'section-header',
				'class' => 'gp-setting gp-setting-begin',
			),	

			   array( 
					'id' => 'logo_scrolling',
					'title' => esc_html__( 'Logo', 'aardvark' ),		
					'section' => $theme_slug . '_desktop_header',
					'type' => 'styling',
					'styling' => array(
						'standard' => array(
							'title' => esc_html__( 'Standard', 'aardvark' ),
							'type' => 'media',
							'default' => '',
						),
						'retina' => array(
							'title' => esc_html__( 'Retina', 'aardvark' ),
							'type' => 'media',
							'default' => '',
						),
						'width' => array(
							'title' => esc_html__( 'Width', 'aardvark' ),
							'type' => 'dimensions',
							'default' => '',
						),
						'height' => array(
							'title' => esc_html__( 'Height', 'aardvark' ),
							'type' => 'dimensions',
							'default' => '',
						),
					),
				),
			
				array(
					'id' => 'desktop_scrolling_header_height',
					'title' => esc_html__( 'Header Height', 'aardvark' ),
					'section' => $theme_slug . '_desktop_header',
					'desc' => esc_html__( 'The height of the header on larger devices when scrolling.', 'aardvark' ),
					'type' => 'dimensions',
					'default' => array(
						'height' => 90,
					),
					'output' => '.gp-header-logo-left-1.gp-scrolling #gp-standard-header .gp-logo,.gp-header-logo-left-2.gp-scrolling #gp-standard-header .gp-logo,.gp-header-logo-right-1.gp-scrolling #gp-standard-header .gp-logo,.gp-scrolling .gp-nav-column,.gp-scrolling #gp-standard-header #gp-header-row-1',
				),

				array(
					'id' => 'main_header_scrolling_bg',
					'title' => esc_html__( 'Main Background', 'aardvark' ),
					'section' => $theme_slug . '_desktop_header',
					'type'      => 'background',
					'output' => '.gp-header-logo-left-1.gp-scrolling #gp-standard-header,.gp-header-logo-left-2.gp-scrolling #gp-standard-header,.gp-header-logo-right-1.gp-scrolling #gp-standard-header,.gp-header-nav-bottom-1.gp-scrolling #gp-header-row-1,.gp-header-nav-bottom-2.gp-scrolling #gp-header-row-1,	.gp-header-nav-bottom-3.gp-scrolling #gp-header-row-1',
					'default' => array(
						'background-color' => 'rgba(255,255,255,0.9)',
						'background-image' => '',
						'background-repeat' => 'no-repeat',
						'background-attachment' => 'scroll',
						'background-position' => 'center center',
						'background-size' => 'inherit',
					),
				),
			
				array(
					'id' => 'main_header_scrolling_border',
					'title' => esc_html__( 'Main Border', 'aardvark' ),
					'section' => $theme_slug . '_desktop_header',
					'type'      => 'border',
					'output' => '.gp-scrolling #gp-standard-header',
					'default'   => array(
						'border-bottom' => 1,
						'border-style' => 'solid',
						'border-color' => '#e6e6e6',
					),
				),
		
				array(
					'id' => 'desktop_scrolling_header_nav_height',
					'title' => esc_html__( 'Navigation Height', 'aardvark' ),
					'section' => $theme_slug . '_desktop_header',
					'desc' => esc_html__( 'The height of the navigation below the logo on larger devices when scrolling.', 'aardvark' ),
					'type' => 'dimensions',
					'default' => array(
						'height' => 60,
					),
					'output' => '.gp-scrolling #gp-standard-header #gp-header-row-2',
					'conditions' => array(
						'header_layout' => array( 
							'value' => array( 'gp-header-nav-bottom-1', 'gp-header-nav-bottom-2', 'gp-header-nav-bottom-3' ),
							'operator' => 'in_array',
						),
					),
				),
						
				array(
					'id' => 'main_header_scrolling_nav_bg',
					'title' => esc_html__( 'Navigation Background', 'aardvark' ),
					'section' => $theme_slug . '_desktop_header',
					'type'      => 'background',
					'output' => '.gp-header-nav-bottom-1.gp-scrolling #gp-standard-header #gp-header-row-2, .gp-header-nav-bottom-2.gp-scrolling #gp-standard-header #gp-header-row-2, .gp-header-nav-bottom-3.gp-scrolling #gp-standard-header #gp-header-row-2',
					'default' => array(
						'background-color' => 'rgba(255,255,255,0.9)',
						'background-image' => '',
						'background-repeat' => 'no-repeat',
						'background-attachment' => 'scroll',
						'background-position' => 'center center',
						'background-size' => 'inherit',
					),
					'conditions' => array(
						'header_layout' => array( 
							'value' => array( 'gp-header-nav-bottom-1', 'gp-header-nav-bottom-2', 'gp-header-nav-bottom-3' ),
							'operator' => 'in_array',
						),
					),
				),
						
				array(
					'id' => 'main_header_scrolling_nav_border',
					'title' => esc_html__( 'Navigation Border', 'aardvark' ),
					'section' => $theme_slug . '_desktop_header',
					'type'      => 'border',
					'output' => '.gp-scrolling #gp-header-row-2',	
					'default'   => array(
						'border-top' => 1,
						'border-color' => '#e6e6e6',
						'border-style' => 'solid',
					),
					'conditions' => array(
						'header_layout' => array( 
							'value' => array( 'gp-header-nav-bottom-1', 'gp-header-nav-bottom-2', 'gp-header-nav-bottom-3' ),
							'operator' => 'in_array',
						),
					),
				),

				array(
					'id' => 'main_header_scrolling_nav_link_divider',
					'title' => esc_html__( 'Navigation Link Divider', 'aardvark' ),
					'section' => $theme_slug . '_desktop_header',
					'type'      => 'border',
					'output' => '.gp-header-nav-bottom-1.gp-scrolling #gp-main-header-primary-nav > ul > li:after, .gp-header-nav-bottom-2.gp-scrolling #gp-main-header-primary-nav > ul > li:after',
					'default'   => array(
						'border-right' => 1,
						'border-color' => '#e6e6e6',
						'border-style' => 'solid',
					),
					'conditions' => array(
						'header_layout' => array( 
							'value' => array( 'gp-header-nav-bottom-1', 'gp-header-nav-bottom-2' ),
							'operator' => 'in_array',
						),
					),
				),	
				
			// Navigation
			array(
				'id' => 'desktop_header_nav_section',
				'title' => esc_html__( 'Navigation', 'aardvark' ),
				'section' => $theme_slug . '_desktop_header',
				'type' => 'section-header',
				'class' => 'gp-setting gp-setting-begin',
			),

				array( 
					'id' => 'hide_move_primary_menu_links',
					'title' => esc_html__( 'Hide/Move Primary Navigation Menu Links', 'aardvark' ),
					'section' => $theme_slug . '_desktop_header',
					'desc' => esc_html__( 'If you have too many menu links in the primary navigation area, automatically hide and move them to a dropdown menu.', 'aardvark' ),	
					'type' => 'radio',
					'options' => array( 
						'enabled' => esc_html__( 'Enabled', 'aardvark' ),
						'disabled' => esc_html__( 'Disabled', 'aardvark' ),
					),
					'default' => 'enabled',
				),
			
				array(
					'id' => 'main_header_primary_nav_typography',
					'title' => esc_html__( 'Primary Navigation Text', 'aardvark' ),
					'section' => $theme_slug . '_desktop_header',
					'type'      => 'typography',
					'output' => '#gp-standard-header .menu > .menu-item',
					'default' => array(
						'font-size' => array(
							'value' => '14',
						),	
						'line-height' => array(
							'value' => '18',
						),	
						'font-weight' => '500',
						'subsets' => 'latin',
						'text-transform' => 'none',
						'letter-spacing' => array(
							'value' => '0',
						),
						'font-family' => 'Roboto',
						'font-backup' => 'Arial, Helvetica, sans-serif',
					),
				),

				array(
					'id' => 'main_header_primary_nav_link_colors',
					'title' => esc_html__( 'Primary Navigation Links', 'aardvark' ),
					'section' => $theme_slug . '_desktop_header',
					'type'      => 'link_color',
					'output' => '#gp-standard-header .menu > .menu-item > a, #gp-standard-header .menu > .menu-item .gp-more-menu-items-icon',
					'default'   => array(
						'regular'   => '#232323',
						'hover' => '#39c8df',
					),
				),

				array(
					'id' => 'main_header_primary_nav_link_bottom_border',
					'title' => esc_html__( 'Primary Navigation Links Bottom Border', 'aardvark' ),
					'section' => $theme_slug . '_desktop_header',
					'type'      => 'border',
					'output' => '#gp-main-header-primary-nav .menu > .current-menu-item > a:before, #gp-main-header-primary-nav .menu > .menu-item > a:hover:before',	
					'default'   => array(
						'border-bottom' => '0',
						'border-style' => 'solid',
						'border-color' => '#39c8df',
					),
				),			

				array(
					'id' => 'main_header_secondary_nav_typography',
					'title' => esc_html__( 'Secondary Navigation Text', 'aardvark' ),
					'section' => $theme_slug . '_desktop_header',
					'type'      => 'typography',
					'output' => '#gp-main-header-secondary-nav > .menu > .menu-item',
					'default'   => array(
						'font-size' => array(
							'value' => '14',
						),	
						'line-height' => array(
							'value' => '18',
						),	
						'font-weight' => '500',
						'subsets' => 'latin',
						'text-transform' => 'none',
						'letter-spacing' => array(
							'value' => '0',
						),
						'font-family' => 'Roboto',
						'font-backup' => 'Arial, Helvetica, sans-serif',
					),
				),

				array(
					'id' => 'main_header_secondary_nav_link_colors',
					'title' => esc_html__( 'Secondary Navigation Links', 'aardvark' ),
					'section' => $theme_slug . '_desktop_header',
					'type'      => 'link_color',
					'output' => '#gp-main-header-secondary-nav > .menu > .menu-item > a, #gp-main-header-secondary-nav .menu > .menu-item .gp-more-menu-items-icon',
					'default'   => array(
						'regular'   => '#39c8df',
						'hover' => '#232323',
					),
				),

				array(
					'id' => 'main_header_secondary_nav_bg',
					'title' => esc_html__( 'Secondary Navigation Background', 'aardvark' ),
					'section' => $theme_slug . '_desktop_header',
					'type'      => 'color_rgba',
					'output' => array( 
						'background-color' => '#gp-main-header-secondary-nav > .menu > .menu-item > a' 
					),
					'default'   => 'rgba(0,0,0,0)',
				),

				array(
					'id' => 'main_header_secondary_nav_bg_hover',
					'title' => esc_html__( 'Secondary Navigation Background Hover', 'aardvark' ),
					'section' => $theme_slug . '_desktop_header',
					'type'      => 'color_rgba',
					'output' => array( 
						'background-color' => '#gp-main-header-secondary-nav > .menu > .menu-item > a:hover' 
					),
					'default'   => 'rgba(0,0,0,0)',
				),

				array(
					'id' => 'main_header_secondary_nav_border',
					'title' => esc_html__( 'Secondary Navigation Border', 'aardvark' ),
					'section' => $theme_slug . '_desktop_header',
					'type'      => 'border',
					'output' => '#gp-main-header-secondary-nav > .menu > .menu-item > a',
					'default'   => array(
						'border-width' => 2,
						'border-style' => 'solid',
						'border-color' => '#39c8df',
						'border-radius' => 4,
					),
				),

				array(
					'id' => 'main_header_secondary_nav_border_hover',
					'title' => esc_html__( 'Secondary Navigation Border Hover', 'aardvark' ),
					'section' => $theme_slug . '_desktop_header',
					'type'      => 'border',
					'output' => '#gp-main-header-secondary-nav > .menu > .menu-item > a:hover',
					'default'   => array(
						'border-width' => 2,
						'border-style' => 'solid',
						'border-color' => '#232323',
						'border-radius' => 4,
					),
				),
			
			// Dropdown Menus
			array(
				'id' => 'desktop_header_dropdown_menus_section',
				'title' => esc_html__( 'Dropdown Menus', 'aardvark' ),
				'section' => $theme_slug . '_desktop_header',
				'type' => 'section-header',
				'class' => 'gp-setting gp-setting-begin',
			),
									
				array(
					'id' => 'dropdown_menu_bg',
					'title' => esc_html__( 'Background', 'aardvark' ),
					'section' => $theme_slug . '_desktop_header',
					'type' => 'color_rgba',
					'output' => array( 'background-color' => '.gp-nav .sub-menu, .gp-search-box .searchform' ),
					'default' => '#fff',
				),

				array(
					'id' => 'dropdown_menu_border',
					'title' => esc_html__( 'Border', 'aardvark' ),
					'section' => $theme_slug . '_desktop_header',
					'type' => 'border',
					'output' => '.gp-nav .sub-menu, .gp-menu-tabs, .gp-nav .gp-menu-tabs .menu-item, .gp-nav span.gp-menu-header, .gp-search-box .searchform, .gp-profile-tab, .gp-notifications-tab',
					'default'   => array(
						'border-width' => 1,
						'border-style' => 'solid',
						'border-color' => '#e6e6e6',
						'border-radius' => 0,
					),
				),

				array(
					'id' => 'dropdown_menu_nav_header_color',
					'title' => esc_html__( 'Menu Header', 'aardvark' ),
					'section' => $theme_slug . '_desktop_header',
					'type' => 'color_rgba',
					'output' => array( 'color' => 'span.gp-menu-header' ),
					'default' => '#39c8df',
				),
			
				array(
					'id' => 'dropdown_menu_link_colors',
					'title' => esc_html__( 'Menu Links', 'aardvark' ),
					'section' => $theme_slug . '_desktop_header',
					'type'      => 'link_color',
					'output' => '#gp-top-header .sub-menu .menu-item a, #gp-standard-header .sub-menu .menu-item a',
					'default'   => array(
						'regular'   => '#232323',
						'hover' => '#39c8df',
					),
				),
			
			// Header Buttons
			array(
				'id' => 'desktop_header_icons_section',
				'title' => esc_html__( 'Header Icons', 'aardvark' ),
				'section' => $theme_slug . '_desktop_header',
				'type' => 'section-header',
				'class' => 'gp-setting gp-setting-begin',
			),
									 
				array(  
					'id' => 'profile_button',
					'title' => esc_html__( 'Profile Button', 'aardvark' ),
					'section' => $theme_slug . '_desktop_header',
					'type' => 'select',
					'options' => array(
						'gp-profile-button-all' => esc_html__( 'Show on all devices', 'aardvark' ),
						'gp-profile-button-desktop' => esc_html__( 'Only show on desktop devices', 'aardvark' ),
						'gp-profile-button-mobile' => esc_html__( 'Only show on mobile devices', 'aardvark' ),
						'gp-profile-button-disabled' => esc_html__( 'Disabled', 'aardvark' ),
					),
					'default' => 'gp-profile-button-all',
				),
				
				array(  
					'id' => 'profile_button_logged_out_page',
					'title' => esc_html__( 'Profile Button Logged Out Page', 'aardvark' ),
					'section' => $theme_slug . '_desktop_header',
					'desc' => esc_html__( 'The page the profile icon links to when a user is logged out.', 'aardvark' ),
					'type' => 'select',					
					'data' => 'pages',
					'default_pages' => array( 'login-link', 'register-link' ),
					'default' => 'login-link',
					'select2' => true,
				),
				
				array(  
					'id' => 'profile_button_logged_in_page',
					'title' => esc_html__( 'Profile Button Logged In Page', 'aardvark' ),
					'section' => $theme_slug . '_desktop_header',
					'desc' => esc_html__( 'The page the profile icon links to when a user is logged in.', 'aardvark' ),
					'type' => 'select',
					'data' => 'pages',
					'default_pages' => array( 'dashboard', 'profile', 'author', 'logout-link' ),
					'default' => 'profile',
					'select2' => true,
				),				

				array(  
					'id' => 'search_button',
					'title' => esc_html__( 'Search Button', 'aardvark' ),
					'section' => $theme_slug . '_desktop_header',
					'type' => 'select',
					'options' => array(
						'gp-search-button-all' => esc_html__( 'Show on all devices', 'aardvark' ),
						'gp-search-button-desktop' => esc_html__( 'Only show on desktop devices', 'aardvark' ),
						'gp-search-button-mobile' => esc_html__( 'Only show on mobile devices', 'aardvark' ),
						'gp-search-button-disabled' => esc_html__( 'Disabled', 'aardvark' ),
					),
					'default' => 'gp-search-button-all',
				),
		
				array(  
					'id' => 'cart_button',
					'title' => esc_html__( 'Cart Button', 'aardvark' ),
					'section' => $theme_slug . '_desktop_header',
					'type' => 'select',
					'options' => array(
						'gp-cart-button-all' => esc_html__( 'Show on all devices', 'aardvark' ),
						'gp-cart-button-desktop' => esc_html__( 'Only show on desktop devices', 'aardvark' ),
						'gp-cart-button-mobile' => esc_html__( 'Only show on mobile devices', 'aardvark' ),
						'gp-cart-button-disabled' => esc_html__( 'Disabled', 'aardvark' ),
					),
					'default' => 'gp-cart-button-all',	
				),
														
				array(
					'id' => 'header_buttons_size',
					'title' => esc_html__( 'Button Size', 'aardvark' ),
					'section' => $theme_slug . '_desktop_header',
					'type'      => 'typography',
					'default'   => array(
						'font-size' => array(
							'value' => '14',
						),	
					),
					'output' => '#gp-standard-header .gp-header-button:before, #gp-standard-header .gp-cart-button .gp-cart-bag',
				),

				array(
					'id' => 'header_buttons_link_colors',
					'title' => esc_html__( 'Icon Color', 'aardvark' ),
					'section' => $theme_slug . '_desktop_header',
					'type'      => 'color',
					'default'   => '#232323',
					'output' => array(
						'color' => '#gp-standard-header .gp-header-button:before, #gp-standard-header .gp-cart-button .gp-cart-bag',
						'border-color' => '#gp-standard-header .gp-cart-bag, #gp-standard-header .gp-cart-handle',
					),	
				),
							
				array(
					'id' => 'header_buttons_link_colors_hover',
					'title' => esc_html__( 'Icon Hover Color', 'aardvark' ),
					'section' => $theme_slug . '_desktop_header',
					'type'      => 'color',
					'default'   => '#39c8df',
					'output' => array(
						'color' => '#gp-standard-header .gp-header-button:hover:before, #gp-standard-header .gp-header-button.gp-active:before, #gp-standard-header .gp-cart-button:hover .gp-cart-bag',
						'border-color' => '#gp-standard-header .gp-cart-button:hover .gp-cart-bag, #gp-standard-header .gp-cart-button:hover .gp-cart-handle',	
					),	
				),
						
				array(
					'id' => 'nav_counter_bg',
					'title' => esc_html__( 'Notifications Counter Background', 'aardvark' ),
					'section' => $theme_slug . '_desktop_header',
					'type' => 'color_rgba',
					'output' => array( 
						'background-color' => '#gp-standard-header .menu > .menu-item .gp-notification-counter', 
					),                        
					'default' => '#39c8df',
				),

				array(
					'id' => 'nav_counter_text_color',
					'title' => esc_html__( 'Notifications Text', 'aardvark' ),
					'section' => $theme_slug . '_desktop_header',
					'type' => 'color_rgba',
					'output' => array( 
						'color' => '#gp-standard-header .menu > .menu-item .gp-notification-counter, #gp-standard-header .menu > .menu-item .gp-notification-counter:hover', 
					),                        
					'default' => '#fff',
				),
			
			// Search Bar
			array(
				'id' => 'desktop_header_search_bar_section',
				'title' => esc_html__( 'Search Bar', 'aardvark' ),
				'section' => $theme_slug . '_desktop_header',
				'type' => 'section-header',
				'class' => 'gp-setting gp-setting-begin',
			),
			
				array(  
					'id' => 'header_search_bar',
					'title' => esc_html__( 'Search Bar', 'aardvark' ),
					'section' => $theme_slug . '_desktop_header',
					'type' => 'radio',
					'options' => array(
						'enabled' => esc_html__( 'Enabled', 'aardvark' ),
						'disabled' => esc_html__( 'Disabled', 'aardvark' ),	
					),
					'default' => 'disabled',
				),

				array(  
					'id' => 'header_search_bar_position',
					'title' => esc_html__( 'Search Bar Position', 'aardvark' ),
					'section' => $theme_slug . '_desktop_header',
					'type' => 'radio',
					'options' => array(
						'left' => esc_html__( 'Left', 'aardvark' ),
						'right' => esc_html__( 'Right', 'aardvark' ),
					),
					'default' => 'left',
					'conditions' => array(
						'header_search_bar' => 'enabled',
					),
				),								 

				array(
					'id' => 'main_header_search_bar',
					'title' => esc_html__( 'Search Bar Border', 'aardvark' ),
					'section' => $theme_slug . '_desktop_header',
					'type'      => 'border',
					'output' => '#gp-header-search .gp-search-bar',
					'default'   => array(
						'border-width' => 2,
						'border-style' => 'solid',
						'border-color' => '#e6e6e6',
						'border-radius' => 4,
					),
					'conditions' => array(
						'header_search_bar' => 'enabled',
					),
				),
														
			// Mobile - Standard Header
			array(
				'id' => 'mobile_standard_header_section',
				'title' => esc_html__( 'Standard Header', 'aardvark' ),
				'section' => $theme_slug . '_mobile_header',
				'type' => 'section-header',
				'class' => 'gp-setting gp-setting-begin',
			),
				
				array( 
					'id' => 'mobile_logo',	
					'title' => esc_html__( 'Standard Logo', 'aardvark' ),		
					'section' => $theme_slug . '_mobile_header',				
					'type' => 'styling',
					'styling' => array(
						'standard' => array(
							'title' => esc_html__( 'Standard', 'aardvark' ),
							'type' => 'media',
							'default' => '',
						),
						'retina' => array(
							'title' => esc_html__( 'Retina', 'aardvark' ),
							'type' => 'media',
							'default' => '',
						),
						'width' => array(
							'title' => esc_html__( 'Width', 'aardvark' ),
							'type' => 'dimensions',
							'default' => '',
						),
						'height' => array(
							'title' => esc_html__( 'Height', 'aardvark' ),
							'type' => 'dimensions',
							'default' => '',
						),
					),
				),

				array(
					'id' => 'mobile_text_logo_typography',	
					'title' => esc_html__( 'Text Logo Typography', 'aardvark' ),		
					'section' => $theme_slug . '_mobile_header',
					'type'      => 'typography',
					'output' => '#gp-mobile-header .gp-text-logo',
					'default' => array(
						'font-size' => array(
							'value' => '30',
						),
						'line-height' => array(
							'value' => '30',
						),
						'font-family' => 'Roboto',
						'font-backup' => 'Arial, Helvetica, sans-serif',
						'font-weight' => '500',
						'subsets' => 'latin',
						'color'       => '#232323',
						'letter-spacing' => array(
							'value' => '-1.5',
						),
						'text-transform' => 'none',
					),
				),
						 
				array(
					'id' => 'mobile_header_height',
					'title' => esc_html__( 'Header Height', 'aardvark' ),
					'section' => $theme_slug . '_mobile_header',
					'type' => 'dimensions',
					'default' => array(
						'height' => 90,
					),
					'output' => '#gp-mobile-header > .gp-container',
				),

				array(
					'id' => 'mobile_header_bg',
					'title' => esc_html__( 'Background', 'aardvark' ),
					'section' => $theme_slug . '_mobile_header',
					'type' => 'background',
					'output' => '.gp-header-above-content #gp-mobile-header',
					'default' => array(
						'background-color' => '#fff',
						'background-image' => '',
						'background-repeat' => 'no-repeat',
						'background-attachment' => 'scroll',
						'background-position' => 'center center',
						'background-size' => 'inherit',
					),
				),

				array(
					'id' => 'mobile_header_border',
					'title' => esc_html__( 'Bottom Border', 'aardvark' ),
					'section' => $theme_slug . '_mobile_header',
					'type'      => 'border',
					'output' => '.gp-header-above-content #gp-mobile-header, .gp-header-over-content.gp-scrolling #gp-mobile-header',	
					'default'   => array(
						'border-color' => '#e6e6e6',
						'border-bottom' => 1,
						'border-style' => 'solid',
					),
				),
				
			// Mobile - Overlay Header
			array(
				'id' => 'mobile_overlay_header_section',
				'title' => esc_html__( 'Overlay Header', 'aardvark' ),
				'section' => $theme_slug . '_mobile_header',
				'type' => 'section-header',
				'class' => 'gp-setting gp-setting-begin',	
			),
			
				array( 
					'id' => 'mobile_logo_overlay',
					'title' => esc_html__( 'Logo', 'aardvark' ),			
					'section' => $theme_slug . '_mobile_header',				
					'type' => 'styling',
					'styling' => array(
						'standard' => array(
							'title' => esc_html__( 'Standard', 'aardvark' ),
							'type' => 'media',
							'default' => '',
						),
						'retina' => array(
							'title' => esc_html__( 'Retina', 'aardvark' ),
							'type' => 'media',
							'default' => '',
						),
						'width' => array(
							'title' => esc_html__( 'Width', 'aardvark' ),
							'type' => 'dimensions',
							'default' => '',
						),
						'height' => array(
							'title' => esc_html__( 'Height', 'aardvark' ),
							'type' => 'dimensions',
							'default' => '',
						),
					),
				),

				array(
					'id' => 'mobile_header_over_content_bg',
					'title' => esc_html__( 'Background', 'aardvark' ),	
					'section' => $theme_slug . '_mobile_header',		
					'type'      => 'background',		
					'output' => '.gp-header-over-content #gp-mobile-header',
					'default' => array(
						'background-color' => 'rgba(0,0,0,0)',
						'background-image' => '',
						'background-repeat' => 'no-repeat',
						'background-attachment' => 'scroll',
						'background-position' => 'center center',
						'background-size' => 'inherit',
					),
				),
											
			// Mobile - Scrolling Header
			array(
				'id' => 'mobile_scrolling_header_section',
				'title' => esc_html__( 'Scrolling Header', 'aardvark' ),
				'section' => $theme_slug . '_mobile_header',
				'type' => 'section-header',
				'class' => 'gp-setting gp-setting-begin',	
			),
			
			   array( 
					'id' => 'mobile_logo_scrolling',
					'title' => esc_html__( 'Logo', 'aardvark' ),
					'section' => $theme_slug . '_mobile_header',
					'type' => 'styling',
					'styling' => array(
						'standard' => array(
							'title' => esc_html__( 'Standard', 'aardvark' ),
							'type' => 'media',
							'default' => '',
						),
						'retina' => array(
							'title' => esc_html__( 'Retina', 'aardvark' ),
							'type' => 'media',
							'default' => '',
						),
						'width' => array(
							'title' => esc_html__( 'Width', 'aardvark' ),
							'type' => 'dimensions',
							'default' => '',
						),
						'height' => array(
							'title' => esc_html__( 'Height', 'aardvark' ),
							'type' => 'dimensions',
							'default' => '',
						),
					),
				),

				array(
					'id' => 'mobile_header_scrolling_bg',
					'title' => esc_html__( 'Background', 'aardvark' ),
					'section' => $theme_slug . '_mobile_header',		
					'type'      => 'background',
					'output' => '.gp-scrolling #gp-mobile-header',
					'default' => array(
						'background-color' => 'rgba(255,255,255.0.9)',
						'background-image' => '',
						'background-repeat' => 'no-repeat',
						'background-attachment' => 'scroll',
						'background-position' => 'center center',
						'background-size' => 'inherit',
					),
				),

			// Mobile - Header Icons
			array(
				'id' => 'mobile_header_icons_section',
				'title' => esc_html__( 'Header Icons', 'aardvark' ),
				'section' => $theme_slug . '_mobile_header',
				'type' => 'section-header',
				'class' => 'gp-setting gp-setting-begin',
			),
			
				array(
					'id' => 'mobile_header_buttons_size',
					'title' => esc_html__( 'Icon Size', 'aardvark' ),
					'section' => $theme_slug . '_mobile_header',
					'type'      => 'typography',
					'default'   => array(
						'font-size' => array(
							'value' => '18',
						),	
					),
					'output' => '#gp-mobile-header .gp-header-button:before, #gp-mobile-header .gp-cart-button .gp-cart-bag',
				),

				array(
					'id' => 'mobile_header_buttons_link_colors',
					'title' => esc_html__( 'Icon Color', 'aardvark' ),
					'section' => $theme_slug . '_mobile_header',
					'type'      => 'color',
					'default'   => '#232323',
					'output' => array(
						'color' => '#gp-mobile-header .gp-header-button:before, #gp-mobile-header .gp-cart-button .gp-cart-bag',
						'border-color' => '#gp-mobile-header .gp-cart-bag, #gp-mobile-header .gp-cart-handle',
					),
				),

				array(
					'id' => 'mobile_header_buttons_link_colors_hover',
					'title' => esc_html__( 'Icon Color Hover', 'aardvark' ),
					'section' => $theme_slug . '_mobile_header',
					'type'      => 'color',
					'default'   => '#39c8df',
					'output' => array(
						'color' => '#gp-mobile-header .gp-header-button:hover:before,#gp-mobile-header .gp-header-button.gp-active:before,#gp-mobile-header .gp-cart-button:hover .gp-cart-bag',
						'border-color' => '#gp-mobile-header .gp-cart-button:hover .gp-cart-bag,#gp-mobile-header .gp-cart-button:hover .gp-cart-handle',	
					),	
				),
							
				array(
					'id' => 'mobile_nav_counter_bg',
					'title' => esc_html__( 'Notifications Counter Background', 'aardvark' ),
					'section' => $theme_slug . '_mobile_header',
					'type' => 'color_rgba',
					'output' => array( 
						'background-color' => '#gp-mobile-header .gp-nav.menu .gp-notification-counter' 
					),                        
					'default' => '#39c8df',
				),

				array(
					'id' => 'mobile_nav_counter_text_color',
					'title' => esc_html__( 'Notifications Text', 'aardvark' ),
					'section' => $theme_slug . '_mobile_header',
					'type' => 'color_rgba',
					'output' => array( 
						'color' => '#gp-mobile-header .gp-nav.menu .gp-notification-counter' 
					),                        
					'default' => '#fff',
				),
				
			// Mobile - Navigation
			array(
				'id' => 'mobile_nav_section',
				'title' => esc_html__( 'Navigation', 'aardvark' ),
				'section' => $theme_slug . '_mobile_header',
				'type' => 'section-header',
				'class' => 'gp-setting gp-setting-begin',
			),
								
				array(
					'id' => 'open_mobile_nav_button_color',
					'title' => esc_html__( 'Open Button', 'aardvark' ),
					'section' => $theme_slug . '_mobile_header',
					'type' => 'color_rgba',
					'output' => array( 
						'background-color' => '.gp-nav-button-icon, .gp-nav-button-icon:before, .gp-nav-button-icon:after' 
					),
					'default' => '#232323',
				),

				array(
					'id' => 'close_mobile_nav_button_color',
					'title' => esc_html__( 'Close Button', 'aardvark' ),
					'section' => $theme_slug . '_mobile_header',
					'type' => 'color_rgba',
					'output' => array( 
						'color' => '#gp-close-mobile-nav-button' 
					),
					'default' => '#fff',
				),
			
				array(
					'id' => 'mobile_nav_bg',
					'title' => esc_html__( 'Background', 'aardvark' ),
					'section' => $theme_slug . '_mobile_header',
					'type' => 'color_rgba',
					'output' => array( 
						'background-color' => '#gp-mobile-primary-nav, #gp-mobile-profile-nav' 
					),
					'default' => '#fff',
				),

				array(
					'id' => 'mobile_nav_border',
					'title' => esc_html__( 'Border', 'aardvark' ),
					'section' => $theme_slug . '_mobile_header',
					'type' => 'color_rgba',
					'output' => array( 
						'border-color' => '#gp-mobile-primary-nav .gp-profile-tab, #gp-mobile-profile-nav .gp-notifications-tab' 
					),
					'default' => '#e6e6e6',
				),

				array(
					'id' => 'mobile_nav_typography',
					'title' => esc_html__( 'Text', 'aardvark' ),
					'section' => $theme_slug . '_mobile_header',
					'type'      => 'typography',
					'output' => '#gp-mobile-primary-nav .menu-item, #gp-mobile-profile-nav .menu-item',
					'default'   => array(
						'font-size' => array(
							'value' => '16',
						),	
						'line-height' => array(
							'value' => '20',
						),
						'font-weight' => '400',
						'subsets' => 'latin',
						'text-transform' => 'none',
						'letter-spacing' => array(
							'value' => '0',
						),
						'font-family' => 'Roboto',
						'font-backup' => 'Arial, Helvetica, sans-serif',
					),
				),

				array(
					'id' => 'mobile_nav_link_colors',
					'title' => esc_html__( 'Menu Links', 'aardvark' ),
					'section' => $theme_slug . '_mobile_header',
					'type'      => 'link_color',
					'output' => '#gp-mobile-primary-nav .menu-item a, #gp-mobile-profile-nav .menu-item a, .gp-mobile-dropdown-icon',
					'default'   => array(
						'regular'   => '#232323',
						'hover' => '#39c8df',
					),
				),

				array(
					'id' => 'mobile_nav_sub_menu_link_colors',
					'title' => esc_html__( 'Sub Menu Links', 'aardvark' ),
					'section' => $theme_slug . '_mobile_header',
					'type'      => 'link_color',
					'output' => '#gp-mobile-primary-nav .sub-menu .menu-item a, #gp-mobile-profile-nav .sub-menu .menu-item a, .sub-menu .gp-mobile-dropdown-icon',
					'default'   => array(
							'regular'   => '#232323',
							'hover' => '#39c8df',
						),
					),
										
			/**
			 * Top Header
			 *
	 		*/
			array(
				'id' => 'top_header',
				'title' => esc_html__( 'Display', 'aardvark' ),
				'section' => $theme_slug . '_top_header',				
				'type' => 'select',
				'desc' => esc_html__( 'Show a header above the main header.', 'aardvark' ),	
				'options' => array(
					'gp-top-header-all' => esc_html__( 'Show on all devices', 'aardvark' ),
					'gp-top-header-desktop' => esc_html__( 'Only show on desktop devices', 'aardvark' ),
					'gp-top-header-mobile' => esc_html__( 'Only show on mobile devices', 'aardvark' ),
					'gp-top-header-disabled' => esc_html__( 'Disabled', 'aardvark' ),
				),
				'default' => 'gp-top-header-disabled',	
			),			
				 		
			array(
				'id' => 'top_header_bg',
				'title' => esc_html__( 'Background', 'aardvark' ),
				'section' => $theme_slug . '_top_header',
				'type' => 'color_rgba',
				'output' => array( 'background-color' => '#gp-top-header' ),
				'default'    => '#f8f8f8',
				'conditions' => array(
					'top_header' => array( 
						'value' => 'gp-top-header-disabled',
						'operator' => '!=',
					),
				),
			),

			array(
				'id' => 'top_header_border',
				'title' => esc_html__( 'Border', 'aardvark' ),
				'section' => $theme_slug . '_top_header',
				'type'      => 'border',
				'output' => '#gp-top-header',
				'default'   => array(
					'border-color' => '#e6e6e6',
					'border-bottom' => 1,
					'border-style' => 'solid',
				),
				'conditions' => array(
					'top_header' => array( 
						'value' => 'gp-top-header-disabled',
						'operator' => '!=',
					),
				),
			),

			array(
				'id' => 'top_header_nav_typography',
				'title' => esc_html__( 'Text', 'aardvark' ),
				'section' => $theme_slug . '_top_header',
				'type'      => 'typography',
				'output' => array( '#gp-top-header .menu > .menu-item' ),
				'default'   => array(
					'font-family' => 'Roboto',
					'font-backup' => 'Arial, Helvetica, sans-serif',
					'font-weight' => '400',
					'subsets' => 'latin',
					'text-transform' => 'none',
					'font-size' => array(
						'value' => '12',
					),	
					'line-height' =>  array(
						'value' => '16',
					),	
					'letter-spacing' => array(
						'value' => '0',
					),
				),
				'conditions' => array(
					'top_header' => array( 
						'value' => 'gp-top-header-disabled',
						'operator' => '!=',
					),
				),
			),
			
			array(
				'id' => 'top_header_nav_link_colors',
				'title' => esc_html__( 'Menu Links', 'aardvark' ),
				'section' => $theme_slug . '_top_header',
				'type'      => 'link_color',
				'output' => '#gp-top-header .menu > .menu-item > a',
				'default'   => array(
					'regular'   => '#777',
					'hover' => '#232323',
				),
				'conditions' => array(
					'top_header' => array( 
						'value' => 'gp-top-header-disabled',
						'operator' => '!=',
					),
				),
			),
										
			/**
			 * Side Menu
			 *
			 */
			array(  
				'id' => 'side_menu',
				'title' => esc_html__( 'Display', 'aardvark' ),
				'section' => $theme_slug . '_side_menu',
				'type' => 'select',
				'options' => array(
					'gp-side-menu-all' => esc_html__( 'Show on all devices', 'aardvark' ),
					'gp-side-menu-desktop' => esc_html__( 'Only show on desktop devices', 'aardvark' ),
				),
				'default' => 'gp-side-menu-all',
			),

			array(
				'id' => 'side_menu_show_by_default',
				'title' => esc_html__( 'Open By Default', 'aardvark' ),
				'desc' => esc_html__( 'This only applies to larger devices, it will always be closed by default on smaller devices.', 'aardvark' ),
				'section' => $theme_slug . '_side_menu',
				'type' => 'radio',
				'options' => array(
					'enabled' => esc_html__( 'Enabled', 'aardvark' ),
					'disabled' => esc_html__( 'Disabled', 'aardvark' ),
				),
				'default' => 'enabled',
			),		
			
			array(
				'id' => 'side_menu_header_height',
				'title' => esc_html__( 'Header Height', 'aardvark' ),
				'section' => $theme_slug . '_side_menu',
				
					'desc' => esc_html__( 'The height of the header in the side menu.', 'aardvark' ),
					'type' => 'dimensions',
				'default' => array(
						'height' => 90,
					),
				'output' => '.gp-header-side-menu #gp-side-menu-logo',	
			),	

			array(
				'id' => 'side_menu_header_bg',
				'title' => esc_html__( 'Header Background', 'aardvark' ),
				'section' => $theme_slug . '_side_menu',
				'type' => 'background',
				'output' => '#gp-side-menu-logo',
				'default' => array(
					'background-color' => '#39c8df',
					'background-image' => '',
					'background-repeat' => 'no-repeat',
					'background-attachment' => 'scroll',
					'background-position' => 'center center',
					'background-size' => 'inherit',
				),
			),
		
			array(
				'id' => 'side_menu_header_border',
				'title' => esc_html__( 'Header Bottom Border', 'aardvark' ),
				'section' => $theme_slug . '_side_menu',
				'type'      => 'border',
				'output' => '#gp-side-menu-logo',	
				'default'   => array(
					'border-color' => '#e6e6e6',
					'border-bottom' => '0',
					'border-style' => 'solid',
				),
			),

			array(
				'id' => 'side_menu_nav_bg',
				'title' => esc_html__( 'Navigation Background', 'aardvark' ),
				'section' => $theme_slug . '_side_menu',
				'type' => 'background',
				'output' => '#gp-side-menu-nav',
				'default' => array(
					'background-color' => '#f1f1f1',
					'background-image' => '',
					'background-repeat' => 'no-repeat',
					'background-attachment' => 'scroll',
					'background-position' => 'center center',
					'background-size' => 'inherit',
				),
			),

			array(
				'id' => 'side_menu_content_bg',
				'title' => esc_html__( 'Content Background', 'aardvark' ),
				'section' => $theme_slug . '_side_menu',
				'type' => 'background',
				'output' => '#gp-side-menu-wrapper',
				'default' => array(
					'background-color' => '#fff',
					'background-image' => '',
					'background-repeat' => 'no-repeat',
					'background-attachment' => 'scroll',
					'background-position' => 'center center',
					'background-size' => 'inherit',
				),
			),

			array(
				'id' => 'side_menu_divider_color',
				'title' => esc_html__( 'Divider', 'aardvark' ),
				'section' => $theme_slug . '_side_menu',
				'type' => 'color_rgba',
				'output' => array( 
					'color' => '#gp-side-menu-content .wp-block-separator.is-style-dots:before',
					'border-color' => '#gp-side-menu-content hr, #gp-side-menu-content .wp-block-separator, #gp-side-menu-content th, #gp-side-menu-content td, #gp-side-menu-content .widget li, #gp-side-menu-content .gp-recent-comments ul li, #gp-side-menu-content .gp-posts-list .gp-post-item, #gp-side-menu-content .gp-login-or-left-line, #gp-side-menu-content .gp-login-or-right-line, .gp-theme #gp-side-menu-content .widget.buddypress #friends-list li, .gp-theme #gp-side-menu-content .widget.buddypress #groups-list li, .gp-theme #gp-side-menu-content .widget.buddypress #members-list li, #gp-side-menu-content .gp-bps-wrapper form, #gp-side-menu-content .gp-stats-list .gp-stats-col',
				),
				'default'   => '#e6e6e6',
			),
			
			array(
				'id' => 'side_menu_nav_typography',
				'title' => esc_html__( 'Text', 'aardvark' ),
				'section' => $theme_slug . '_side_menu',
				'type'      => 'typography',
				'output' => array( '#gp-side-menu-nav .menu-item' ),
				'default'   => array(
					'font-size' => array(
						'value' => '16',
					),	
					'line-height' => array(
						'value' => '24',
					),	
					'font-weight' => '400',
					'subsets' => 'latin',
					'text-transform' => 'none',
					'letter-spacing' => array(
						'value' => '0',
					),
					'font-family' => 'Roboto',
					'font-backup' => 'Arial, Helvetica, sans-serif',
				),
			),

			array(
				'id' => 'side_menu_nav_link_colors',
				'title' => esc_html__( 'Menu Links', 'aardvark' ),
				'section' => $theme_slug . '_side_menu',
				'type'      => 'link_color',
				'output' => '#gp-side-menu-nav .menu-item a, #gp-side-menu-nav .menu-item .gp-mobile-dropdown-icon',
				'default'   => array(
					'regular'   => '#232323',
					'hover' => '#39c8df',
				),
			),

			array(
				'id' => 'side_menu_nav_sub_menu_link_colors',
				'title' => esc_html__( 'Sub Menu Links', 'aardvark' ),
				'section' => $theme_slug . '_side_menu',
				'type'      => 'link_color',
				'output' => '#gp-side-menu-nav .sub-menu .menu-item a, #gp-side-menu-nav .sub-menu .menu-item .gp-mobile-dropdown-icon',
				'default'   => array(
					'regular'   => '#232323',
					'hover' => '#39c8df',
				),
			),

			array(
				'id' => 'side_menu_widget_title_typography',
				'title' => esc_html__( 'Widget Title', 'aardvark' ),
				'section' => $theme_slug . '_side_menu',
				'type'      => 'typography',
				'output' => array( '#gp-side-menu-content .widget-title, #gp-side-menu-content .widget-title a' ),
				'default'   => array(
					'font-size' => array(
						'value' => '19',
					),
					'line-height' => array(
						'value' => '19',
					),
					'font-family' => 'Roboto',
					'font-backup' => 'Arial, Helvetica, sans-serif',
					'font-weight' => '400',
					'subsets' => 'latin',
					'letter-spacing' => array(
						'value' => '0',
					),
					'color' => '#232323',
					'text-transform' => 'none',
				),
			),

			array(
				'id' => 'side_menu_widget_text_typography',
				'title' => esc_html__( 'Widget Text', 'aardvark' ),
				'section' => $theme_slug . '_side_menu',
				'type'      => 'typography',
				'output' => array( '#gp-side-menu-content .widget' ),
				'default'   => array(
					'font-size' => array(
						'value' => '16',
					),
					'line-height' => array(
						'value' => '20',
					),
					'font-family' => 'Roboto',
					'font-backup' => 'Arial, Helvetica, sans-serif',
					'font-weight' => '400',
					'subsets' => 'latin',
					'letter-spacing' => array(
						'value' => '0',
					),
					'color' => '#999',
					'text-transform' => 'none',
				),
			),

			array(
				'id' => 'side_menu_link_colors',
				'title' => esc_html__( 'Widget Links', 'aardvark' ),
				'section' => $theme_slug . '_side_menu',
				'type'      => 'link_color',
				'output' => '#gp-side-menu-content .widget a',
				'default'   => array(
					'regular' => '#39c8df',
					'hover'   => '#00a0e3',
				),
			),

			array(
				'id' => 'side_menu_toggle_bg',
				'title' => esc_html__( 'Toggle Button Background', 'aardvark' ),
				'section' => $theme_slug . '_side_menu',
				'type' => 'color_rgba',
				'output' => array( 'background-color' => '#gp-side-menu-toggle, #gp-open-side-menu-button' ),
				'default'   => '#39c8df',
			),

			array(
				'id' => 'side_menu_toggle_text_color',
				'title' => esc_html__( 'Toggle Button Text', 'aardvark' ),
				'section' => $theme_slug . '_side_menu',
				'type' => 'color_rgba',
				'output' => array( 'color' => '#gp-side-menu-toggle, #gp-open-side-menu-button' ),
				'default'   => '#fff',
			),
					
			/**
			 * Title Header
			 *
			 */	
			array(
				'id' => 'page_header_bg',
				'title' => esc_html__( 'Image Background', 'aardvark' ),
				'desc' => esc_html__( 'Global title background image used on any page set to display a title header (can be overridden on individual pages).', 'aardvark' ),
				'section' => $theme_slug . '_title_header',
				'type' => 'background',
				'output' => '#gp-page-header-inner, #gp-full-page-bg', 
				'default'   => array(
					'background-color' => '#f8f8f8',
					'background-image' => '',
					'background-repeat' => 'no-repeat',
					'background-attachment' => 'scroll',
					'background-position' => 'center center',
					'background-size' => 'inherit',
				),
			),
			
			array(
				'id' => 'title_header_featured_image_fallback',
				'title' => esc_html__( 'Featured Image Fallback', 'aardvark' ),
				'desc' => esc_html__( 'If your post/page does not have a title header background image it will use the featured image instead.', 'aardvark' ),
				'section' => $theme_slug . '_title_header',
				'type'  => 'checkbox',
				'default' => 0,
			),

			array(
				'id' => 'page_title_bg',
				'title' => esc_html__( 'Title Background', 'aardvark' ),
				'section' => $theme_slug . '_title_header',
				'type' => 'color_rgba',
				'output' => array( 'background-color' => '#gp-page-title' ),        
				'default'   => '#f8f8f8',
				),

			array(
				'id' => 'page_title_border',
				'title' => esc_html__( 'Title Border', 'aardvark' ),
				'section' => $theme_slug . '_title_header',
				'type'      => 'border',
				'output' => '#gp-page-title',
				'default'   => array(
					'border-bottom' => 1,
					'border-style' => 'solid',
					'border-color' => '#e6e6e6',
				),
			),
												
			array(
				'id' => 'page_title_typography',
				'title' => esc_html__( 'Desktop Title', 'aardvark' ),
				'section' => $theme_slug . '_title_header',
				'type'      => 'typography',
				'default'   => array(
					'font-size' => array(
							'value' => '30',
						),
					'line-height' => array(
							'value' => '34',
						),
					'color' => '#232323',                           	
					'font-family' => 'Roboto',
					'font-backup' => 'Arial, Helvetica, sans-serif',
					'font-weight' => '400',
					'subsets' => 'latin',
					'letter-spacing' => array(
							'value' => '-1',
						),
					'text-transform' => 'none',
				),
				//'media_query' => '@media only screen and (min-width: 992px)',
				'output' => '#gp-page-title h1',
			),

			array(
				'id' => 'mobile_page_title_typography',
				'title' => esc_html__( 'Mobile Title', 'aardvark' ),
				'section' => $theme_slug . '_title_header',
				'type'      => 'typography',
				'default'   => array(
					'font-size' => array(
							'value' => '24',
						),
					'line-height' => array(
							'value' => '28',
						),
					'letter-spacing' => array(
							'value' => '-1',
						),
				),
				'media_query' => '@media only screen and (max-width: 991px)',
				'output' => '#gp-page-title h1',
				),

			array(
				'id' => 'page_subtitle_typography',
				'title' => esc_html__( 'Subtitle', 'aardvark' ),
				'section' => $theme_slug . '_title_header',
				'type'      => 'typography',
				'output' => '#gp-page-title #gp-page-title-subtitle',
				'default'   => array(
					'font-size' => array(
							'value' => '16',
						),
					'line-height' => array(
							'value' => '22',
						),
					'color' => '#999',                           	
					'font-family' => 'Roboto',
					'font-backup' => 'Arial, Helvetica, sans-serif',
					'font-weight' => '400',
					'subsets' => 'latin',
					'letter-spacing' => array(
							'value' => '0',
						),
					'text-transform' => 'none',
				),
			),

			array(
				'id' => 'page_title_meta_typography',
				'title' => esc_html__( 'Title Meta Text', 'aardvark' ),
				'section' => $theme_slug . '_title_header',
				'type'      => 'typography',
				'default'   => array(
						'font-size' => array(
							'value' => '13',
						),
						'line-height' => array(
							'value' => '13',
						),
						'color' => '#b1b1b1',                           	
						'font-family' => 'Roboto',
						'font-backup' => 'Arial, Helvetica, sans-serif',
						'font-weight' => '400',
						'subsets' => 'latin',
						'letter-spacing' => array(
							'value' => '0',
						),
					),
				'output' => '#gp-page-title .gp-entry-meta, #gp-page-title .gp-entry-meta a, #gp-page-title #gp-breadcrumbs',
				),

			array(
				'id' => 'min_page_title_typography',
				'title' => esc_html__( 'Minimal Desktop Title', 'aardvark' ),
				'section' => $theme_slug . '_title_header',
				'type'      => 'typography',
				'default'   => array(
					'font-size' => array(
							'value' => '30',
						),
					'line-height' => array(
							'value' => '34',
						),
					'color' => '#232323',                           	
					'font-family' => 'Roboto',
					'font-backup' => 'Arial, Helvetica, sans-serif',
					'font-weight' => '400',
					'subsets' => 'latin',
					'letter-spacing' => array(
							'value' => '-1',
						),
					'text-transform' => 'none',
				),
				//REMOVE'media_query' => '@media only screen and (min-width: 992px)',
				'output' => '.gp-minimal-page-header #gp-page-title-text h1',
				),

			array(
				'id' => 'min_mobile_page_title_typography',
				'title' => esc_html__( 'Minimal Mobile Title', 'aardvark' ),
				'section' => $theme_slug . '_title_header',
				'type'      => 'typography',
				'default'   => array(
					'font-size' => array(
							'value' => '24',
						),
					'line-height' => array(
							'value' => '28',
						),
					'letter-spacing' => array(
							'value' => '-1',
						),
				),
				'media_query' => '@media only screen and (max-width: 991px)',
				'output' => '.gp-minimal-page-header #gp-page-title-text h1',
				),

			array(
				'id' => 'min_page_subtitle_typography',
				'title' => esc_html__( 'Minimal Subtitle', 'aardvark' ),
				'section' => $theme_slug . '_title_header',
				'output' => '.gp-minimal-page-header #gp-page-title-subtitle',
					'type'      => 'typography',
				'default'   => array(
						'font-size' => array(
							'value' => '16',
						),
						'line-height' => array(
							'value' => '22',
						),
						'color' => '#999',                           	
						'font-family' => 'Roboto',
						'font-backup' => 'Arial, Helvetica, sans-serif',
						'font-weight' => '400',
						'subsets' => 'latin',
						'letter-spacing' => array(
							'value' => '0',
						),
						'text-transform' => 'none',
					),
				),

			array(
				'id' => 'min_page_title_meta_typography',
				'title' => esc_html__( 'Minimal Title Meta Text', 'aardvark' ),
				'section' => $theme_slug . '_title_header',
				'type'      => 'typography',
				'output' => '.gp-minimal-page-header #gp-page-title-text .gp-entry-meta, .gp-minimal-page-header #gp-page-title-text .gp-entry-meta a, .gp-minimal-page-header #gp-page-title-text #gp-breadcrumbs',
				'default'   => array(
					'font-size' => array(
							'value' => '13',
						),
					'line-height' => array(
							'value' => '13',
						),
					'color'       => '#b1b1b1',                           	
					'font-family' => 'Roboto',
					'font-backup' => 'Arial, Helvetica, sans-serif',
					'font-weight' => '400',
					'subsets' => 'latin',
					'letter-spacing' => array(
							'value' => '0',
						),
				),
			),
				
			/**
			 * Footer
			 *
			 */

			// General
			array(
				'id' => 'footer_section',
				'title' => esc_html__( 'General', 'aardvark' ),
				'section' => $theme_slug . '_footer',
				'type' => 'section-header',
				'class' => 'gp-setting gp-setting-begin',
			),
						 
				array( 
					'id' => 'footer_display',
					'title' => esc_html__( 'Display', 'aardvark' ),
					'section' => $theme_slug . '_footer',
					'type' => 'radio',
					'options' => array( 
						'enabled' => esc_html__( 'Enabled', 'aardvark' ),
						'disabled' => esc_html__( 'Disabled', 'aardvark' ),
					),
					'default' => 'enabled',
				),

				array( 
					'id' => 'footer_format',
					'title' => esc_html__( 'Format', 'aardvark' ),
					'section' => $theme_slug . '_footer',
					'type' => 'radio',
					'options' => array( 
						'gp-footer-wide' => esc_html__( 'Wide', 'aardvark' ),
						'gp-footer-boxed' => esc_html__( 'Boxed', 'aardvark' ),
					),
					'default' => 'gp-footer-boxed',
				),
				
				array( 
					'id' => 'footer_sticky',
					'title' => esc_html__( 'Sticky Footer', 'aardvark' ),
					'desc' => esc_html__( 'If the page content does not reach the bottom of page the footer will still be placed at the bottom.', 'aardvark' ),
					'section' => $theme_slug . '_footer',
					'type' => 'radio',
					'options' => array( 
						'gp-sticky-footer' => esc_html__( 'Enabled', 'aardvark' ),
						'gp-relative-footer' => esc_html__( 'Disabled', 'aardvark' ),
					),
					'default' => 'gp-relative-footer',
				),
								
				array( 
					'id' => 'footer_image',
					'title' => esc_html__( 'Image', 'aardvark' ),	
					'section' => $theme_slug . '_footer',	
					'type' => 'styling',
					'styling' => array(
						'standard' => array(
							'title' => esc_html__( 'Standard', 'aardvark' ),
							'type' => 'media',
							'default' => get_template_directory_uri() . '/lib/images/original/logo.png',
						),
						'retina' => array(
							'title' => esc_html__( 'Retina', 'aardvark' ),
							'type' => 'media',
							'default' => get_template_directory_uri() . '/lib/images/original/logo-retina.png',
						),
						'width' => array(
							'title' => esc_html__( 'Standard', 'aardvark' ),
							'type' => 'dimensions',
							'default' => 117,
						),
						'height' => array(
							'title' => esc_html__( 'Standard', 'aardvark' ),
							'type' => 'dimensions',
							'default' => 24,
						),
					),
				),
						
				array(
					'id' => 'footer_image_spacing',
					'title' => esc_html__( 'Image Spacing', 'aardvark' ),
					'section' => $theme_slug . '_footer',
					'type' => 'spacing',
					'default'   => array(
						'padding-top'    => 0, 		
						'padding-right'  => 0, 
						'padding-bottom' => 0, 		
						'padding-left'   => 0,
					),
					'output' => array( 'background-color' => '#gp-footer img' ),
				),

				array(
					'id' => 'footer_bg',
					'title' => esc_html__( 'Footer Background', 'aardvark' ),
					'section' => $theme_slug . '_footer',
					'type' => 'background',
					'output' => '#gp-footer',
					'default' => array(
						'background-color' => '#fff',
						'background-image' => '',
						'background-repeat' => 'no-repeat',
						'background-attachment' => 'scroll',
						'background-position' => 'center center',
						'background-size' => 'inherit',
					),
				),

				array(
					'id' => 'footer_border',
					'title' => esc_html__( 'Footer Border', 'aardvark' ),
					'section' => $theme_slug . '_footer',
					'type' => 'color_rgba',
					'desc'  => esc_html__( 'Divides the footer widgets and copyright text.', 'aardvark' ),
					'output' => array( 
						'border-color' => '#gp-footer, #gp-footer-widgets, .gp-footer-widget .widget li' 
					),
					'default'   => '#e6e6e6',
				),

				array(  
					'id' => 'back_to_top',
					'title' => esc_html__( 'Back To Top Button', 'aardvark' ),
					'section' => $theme_slug . '_footer',
					'type' => 'select',
					'options' => array(
						'gp-back-to-top-all' => esc_html__( 'Show on all devices', 'aardvark' ),
						'gp-back-to-top-desktop' => esc_html__( 'Only show on desktop devices', 'aardvark' ),
						'gp-no-back-to-top' => esc_html__( 'Disabled', 'aardvark' )
					),
					'default' => 'gp-back-to-top-desktop',
				),
						
				array(
					'id' => 'back_to_top_bg',
					'title' => esc_html__( 'Back To Top Background', 'aardvark' ),
					'section' => $theme_slug . '_footer',
					'type' => 'color_rgba',
					'output' => array( 'background-color' => '#gp-to-top' ),
					'default'   => '#000',
					'conditions' => array(
						'back_to_top' => array(
							'value' => 'gp-no-back-to-top',
							'operator' => '!=',
						),	
					),
				),
											
				array(
					'id' => 'back_to_top_icon_color',
					'title' => esc_html__( 'Back To Top Icon', 'aardvark' ),
					'section' => $theme_slug . '_footer',
					'type' => 'color_rgba',
					'output' => '#gp-to-top',
					'default'   => '#fff',
					'conditions' => array(
						'back_to_top' => array(
							'value' => 'gp-no-back-to-top',
							'operator' => '!=',
						),	
					),
				),								
						
			// Footer widgets
			array(
				'id' => 'footer_widgets_section',
				'title' => esc_html__( 'Footer Widgets', 'aardvark' ),
				'section' => $theme_slug . '_footer',
				'type' => 'section-header',
				'class' => 'gp-setting gp-setting-begin',
			),
					
				array(  
					'id' => 'footer_widgets_display',
					'title' => esc_html__( 'Display', 'aardvark' ),
					'section' => $theme_slug . '_footer',
					'type' => 'radio',
					'options' => array(
						'gp-footer-widgets-all' => esc_html__( 'Show on all devices', 'aardvark' ),
						'gp-footer-widgets-desktop' => esc_html__( 'Only show on desktop devices', 'aardvark' )
					),
					'default' => 'gp-footer-widgets-desktop',
				),
				
				array(
					'id' => 'footer_widget_bg',
					'title' => esc_html__( 'Widget Background', 'aardvark' ),
					'section' => $theme_slug . '_footer',
					'type' => 'color_rgba',
					'output' => array( 'background-color' => '.gp-footer-widget' ),
					'default'   => '',
				),

				array(
					'id' => 'footer_widget_padding',
					'title' => esc_html__( 'Widget Padding', 'aardvark' ),
					'section' => $theme_slug . '_footer',
					'type' => 'spacing',
					'output' => '.gp-footer-widget',
					'default' => array(
						'padding-top' => '0',
						'padding-right' => '0',
						'padding-bottom' => '0',
						'padding-left' => '0',
					),
				),

				array(
					'id' => 'footer_widget_spacing',
					'title' => esc_html__( 'Widget Spacing', 'aardvark' ),
					'section' => $theme_slug . '_footer',
					'type' => 'spacing',
					'output' => '.gp-footer-widget',
					'default' => array(
						'margin-bottom' => '35',
					),
				),
			
				array(
					'id' => 'footer_widget_title_typography',
					'title' => esc_html__( 'Widget Title', 'aardvark' ),
					'section' => $theme_slug . '_footer',
					'type'      => 'typography',
					'output' => array( '.gp-footer-widget .widget-title, .gp-footer-widget .widget-title a' ),
					'default'   => array(
							'font-size' => array(
							'value' => '19',
						),
							'line-height' => array(
							'value' => '19',
						),
							'font-family' => 'Roboto',
							'font-backup' => 'Arial, Helvetica, sans-serif',
							'font-weight' => '400',
							'subsets' => 'latin',
							'letter-spacing' => array(
							'value' => '0',
						),
							'color' => '#232323',
							'text-transform' => 'none',
						),
					),

				array(
					'id' => 'footer_widget_text_typography',
					'title' => esc_html__( 'Widget Text', 'aardvark' ),
					'section' => $theme_slug . '_footer',
					'type'      => 'typography',
					'output' => array( '.gp-footer-widget .widget' ),
					'default'   => array(
							'font-size' => array(
							'value' => '16',
						),
							'line-height' => array(
							'value' => '20',
						),
							'font-family' => 'Roboto',
							'font-backup' => 'Arial, Helvetica, sans-serif',
							'font-weight' => '400',
							'subsets' => 'latin',
							'letter-spacing' => array(
							'value' => '0',
						),
							'color' => '#999',
							'text-transform' => 'none',
						),
					),

				array(
					'id' => 'footer_widget_link_colors',
					'title' => esc_html__( 'Widget Links', 'aardvark' ),
					'section' => $theme_slug . '_footer',
					'type'      => 'link_color',
					'output' => '.gp-footer-widget .widget a',
					'default'   => array(
							'regular' => '#39c8df',
							'hover'   => '#00a0e3',
						),
					),

			// Copyright
			array(
				'id' => 'copyright_section',
				'title' => esc_html__( 'Copyright', 'aardvark' ),
				'section' => $theme_slug . '_footer',
				'type' => 'section-header',
				'class' => 'gp-setting gp-setting-begin',
			),
																																															
				array( 
					'id' => 'copyright_display',
					'title' => esc_html__( 'Display', 'aardvark' ),
					'section' => $theme_slug . '_footer',
					'type' => 'radio',
					'options' => array( 
						'enabled' => esc_html__( 'Enabled', 'aardvark' ),
						'disabled' => esc_html__( 'Disabled', 'aardvark' ),
					),
					'default' => 'enabled',
				),
												
				array( 
					'id' => 'copyright_text',
					'title' => esc_html__( 'Content', 'aardvark' ),
					'desc' => esc_html__( 'This will overwrite the default copyright text.', 'aardvark' ),
					'section' => $theme_slug . '_footer',
					'type' => 'textarea',
					'conditions' => array(
						'copyright_display' => 'enabled',
					),
				),

				array(
					'id' => 'copyright_text_typography',
					'title' => esc_html__( 'Text', 'aardvark' ),
					'section' => $theme_slug . '_footer',
					'type'      => 'typography',
					'output' => array( '#gp-copyright' ),
					'default'   => array(
						'font-size' => array(
							'value' => '14',
						),
						'line-height' => array(
							'value' => '20',
						),
						'font-family' => 'Roboto',
						'font-backup' => 'Arial, Helvetica, sans-serif',
						'font-weight' => '400',
						'subsets' => 'latin',
						'letter-spacing' => array(
							'value' => '0',
						),
						'color' => '#232323',
						'text-transform' => 'none',
					),
					'conditions' => array(
						'copyright_display' => 'enabled',
					),
				),

				array(
					'id' => 'copyright_link_colors',
					'title' => esc_html__( 'Copyright Links', 'aardvark' ),
					'section' => $theme_slug . '_footer',
					'type'      => 'link_color',
					'output' => '#gp-copyright-text a',
					'default'   => array(
						'regular' => '#39c8df',
						'hover'   => '#00a0e3',
					),
					'conditions' => array(
						'copyright_display' => 'enabled',
					),
				),
			
				array(
					'id' => 'footer_nav_link_colors',
					'title' => esc_html__( 'Menu Links', 'aardvark' ),
					'section' => $theme_slug . '_footer',
					'type'      => 'link_color',
					'output' => '#gp-footer-nav > .menu > li > a',
					'default'   => array(
						'regular' => '#39c8df',
						'hover'   => '#00a0e3',
					),
					'conditions' => array(
						'copyright_display' => 'enabled',
					),
				),	
				
			/**
			 * Other Styling
			 *
			 */
			// Typography
			array(
				'id' => 'other_styling_typography_section',
				'title' => esc_html__( 'Typography', 'aardvark' ),
				'section' => $theme_slug . '_other_styling',
				'type' => 'section-header',
				'class' => 'gp-setting gp-setting-begin',
			),
						
				array(
					'id' => 'general_typography',
					'title' => esc_html__( 'Body Text', 'aardvark' ),
					'section' => $theme_slug . '_other_styling',
					'type'  => 'typography',
					'output' => 'body',
					'default'   => array(
						'font-size' => array( 
							'value' => '14',
						),
						'line-height' => array( 
							'value' => '28',
						),
						'font-family' => 'Roboto',
						'font-backup' => 'Arial, Helvetica, sans-serif',
						'font-weight' => '400',
						'subsets' => 'latin',
						'color'   => '#777',
						'letter-spacing' => array( 
							'value' => '0',
						),
						'text-transform' => 'none',
					),
				),			
			
				array(
					'id' => 'bold_text_weight',
					'title' => esc_html__( 'Bold Text Weight', 'aardvark' ),
					'section' => $theme_slug . '_other_styling',
					'type'  => 'select',
					'options'   => array(
						'200' => '200',
						'400' => '400',
						'500' => '500',
						'600' => '600',
						'700' => '700',
						'900' => '900',
					),
					'output' => array( 'font-weight' => 'strong, b' ),
					'default' => '500',
				),
																														
				array(
					'id' => 'general_link_colors',
					'title' => esc_html__( 'Links', 'aardvark' ),
					'section' => $theme_slug . '_other_styling',
					'type'  => 'link_color',
					'output' => 'a, .gp-course-details-wrapper .sensei-results-links a',
					'default'   => array(
						'regular'  => '#39c8df',
						'hover'    => '#00a0e3',
					),
				),

				array(
					'id' => 'h1_typography',
					'title' => esc_html__( 'H1 Tag', 'aardvark' ),
					'section' => $theme_slug . '_other_styling',
					'type'  => 'typography',
					'output' => 'h1',
					'default'   => array(
						'font-size' => array( 
							'value' => '32'
						),
						'line-height' => array( 
							'value' => '40',
						),	
						'font-family' => 'Roboto',
						'font-backup' => 'Arial, Helvetica, sans-serif',
						'font-weight' => '400',
						'subsets' => 'latin',
						'letter-spacing' => array( 
							'value' => '-1',
						),	
						'color' => '#232323',
						'text-transform' => 'none',
					),
				),

				array(
					'id' => 'h2_typography',
					'title' => esc_html__( 'H2 Tag', 'aardvark' ),
					'section' => $theme_slug . '_other_styling',
					'type'  => 'typography',
					'output' => 'h2',
					'default'   => array(
						'font-size' => array(
							'value' => '24',
						),
						'line-height' => array(
							'value' => '32',
						),
						'font-family' => 'Roboto',
						'font-backup' => 'Arial, Helvetica, sans-serif',
						'font-weight' => '400',
						'subsets' => 'latin',
						'letter-spacing' => array(
							'value' => '-1',
						),
						'color' => '#232323',
						'text-transform' => 'none',
					),
				),

				array(
					'id' => 'h3_typography',
					'title' => esc_html__( 'H3 Tag', 'aardvark' ),
					'section' => $theme_slug . '_other_styling',
					'type'  => 'typography',
					'output' => 'h3',
					'default'   => array(
						'font-size' => array(
							'value' => '19',
						),
						'line-height' => array(
							'value' => '27',
						),
						'font-family' => 'Roboto',
						'font-backup' => 'Arial, Helvetica, sans-serif',
						'font-weight' => '500',
						'subsets' => 'latin',
						'letter-spacing' => array(
							'value' => '0',
						),
						'color' => '#232323',
						'text-transform' => 'none',
					),
				),

				array(
					'id' => 'h4_typography',
					'title' => esc_html__( 'H4 Tag', 'aardvark' ),
					'section' => $theme_slug . '_other_styling',
					'type'  => 'typography',
					'output' => 'h4',			
					'default'   => array(
						'font-size' => array(
							'value' => '16',
						),
						'line-height' => array(
							'value' => '24',
						),
						'font-family' => 'Roboto',
						'font-backup' => 'Arial, Helvetica, sans-serif',
						'font-weight' => '400',
						'subsets' => 'latin',
						'letter-spacing' => array(
							'value' => '0',
						),
						'color' => '#232323',
						'text-transform' => 'none',
					),
				),

				array(
					'id' => 'h5_typography',
					'title' => esc_html__( 'H5 Tag', 'aardvark' ),
					'section' => $theme_slug . '_other_styling',
					'type'  => 'typography',
					'output' => 'h5',
					'default'   => array(
						'font-size' => array(
							'value' => '13',
						),
						'line-height' => array(
							'value' => '21',
						),
						'font-family' => 'Roboto',
						'font-backup' => 'Arial, Helvetica, sans-serif',
						'font-weight' => '400',
						'subsets' => 'latin',
						'letter-spacing' => array(
							'value' => '0',
						),
						'color' => '#232323',
						'text-transform' => 'none',
					),
				),

				array(
					'id' => 'h6_typography',
					'title' => esc_html__( 'H6 Tag', 'aardvark' ),
					'section' => $theme_slug . '_other_styling',
					'type'  => 'typography',
					'output' => 'h6',
					'default'   => array(
						'font-size' => array(
							'value' => '12',
						),
						'line-height' => array(
							'value' => '16',
						),
						'font-family' => 'Roboto',
						'font-backup' => 'Arial, Helvetica, sans-serif',
						'font-weight' => '400',
						'subsets' => 'latin',
						'letter-spacing' => array(
							'value' => '0',
						),
						'color' => '#232323',
						'text-transform' => 'none',
					),
				),

				array(
					'id' => 'divider_color',
					'title' => esc_html__( 'Divider', 'aardvark' ),
					'section' => $theme_slug . '_other_styling',
					'type'  => 'color_rgba',
					'desc'  => esc_html__( 'Divider color used throughout the theme.', 'aardvark' ),
					'output' => array(
						'color' => '.wp-block-separator.is-style-dots:before',
						'border-color' => 'hr, .wp-block-separator, .gp-sidebar-divider, #gp-new-search, .gp-divider-title-bg, 	#gp-share-icons, #gp-share-icons a, #gp-author-info-wrapper, .comment-body, .widget li, .gp-posts-masonry .gp-loop-content, .gp-recent-comments ul li, .gp-posts-list .gp-post-item, .gp-posts-large .gp-post-item, .gp-small-posts .gp-post-item, .gp-login-or-left-line, .gp-login-or-right-line, .gp-stats-list .gp-stats-col, .gp-theme #buddypress:not(.youzer) div.item-list-tabs, .gp-theme #buddypress:not(.youzer) div.item-list-tabs#object-nav li, .gp-theme #buddypress:not(.youzer) .main-navs, .gp-theme .widget.buddypress #friends-list li, .gp-theme .widget.buddypress #groups-list li, .gp-theme .widget.buddypress #members-list li, .gp-bps-wrapper form, .course-results-lessons .course h2, .course-container .gp-loop-meta .course-author, .gp-loop-meta .sensei-course-meta > span, .gp-loop-meta .lesson-meta > span, .gp-loop-meta .sensei-free-lessons, .gp-theme .quiz ol#sensei-quiz-list > li, .learner-profile #my-courses.ui-tabs .ui-tabs-nav, .learner-profile #learner-info .type-course, .gp-course-wrapper, .single-course .gp-course-wrapper .course-product, .gp-course-stat, .gp-course-details-wrapper .sensei-results-links a, .gp-course-wrapper .contact-teacher, .woocommerce div.product .woocommerce-tabs ul.tabs::before, .woocommerce-MyAccount-navigation li, #pmpro_account .pmpro_box, .gp-archive-wrapper .gp-filter-menus,.gp-theme #buddypress:not(.youzer) .bps_filters',
					),
					'default'   => '#e6e6e6',
					),				
	
				array(
					'id' => 'blockquote_border',
					'title' => esc_html__( 'Blockquote Border', 'aardvark' ),
					'section' => $theme_slug . '_other_styling',
					'type' => 'color_rgba',
					'output' => array( 'border-color' => 'blockquote' ),
					'default'   => '#39c8df',
					),
		
				array(
					'id' => 'blockquote_text_color',
					'title' => esc_html__( 'Blockquote Text', 'aardvark' ),
					'section' => $theme_slug . '_other_styling',
					'type' => 'color_rgba',
					'output' => 'blockquote:not(.has-text-color), blockquote:not(.has-text-color) a, blockquote:not(.has-text-color) .wp-block-pullquote__citation, .wp-block-pullquote blockquote:not(.has-text-color) cite, .wp-block-pullquote blockquote:not(.has-text-color) footer',
					'default' => '#232323',
					),

				array(
					'id' => 'pre_bg_color',
					'title' => esc_html__( 'Pre Background', 'aardvark' ),
					'section' => $theme_slug . '_other_styling',
					'type' => 'color_rgba',
					'output' => array( 'background-color' => 'pre:not(.wp-block-verse)' ),
					'default'   => '#f8f8f8',
				),
		
				array(
					'id' => 'pre_text_color',
					'title' => esc_html__( 'Pre Text', 'aardvark' ),
					'section' => $theme_slug . '_other_styling',
					'type' => 'color_rgba',
					'output' => 'pre:not(.wp-block-verse)',
					'default' => '#232323',
				),

			// Tables
			array(
				'id' => 'other_styling_table_section',
				'title' => esc_html__( 'Tables', 'aardvark' ),
				'section' => $theme_slug . '_other_styling',
				'type' => 'section-header',
				'class' => 'gp-setting gp-setting-begin',
			),
			
				array(
					'id' => 'misc_table_header_bg_color',
					'title' => esc_html__( 'Header Background', 'aardvark' ),
					'section' => $theme_slug . '_other_styling',
					'type' => 'color_rgba',
					'output' => array( 'background-color' => 'table:not(.wp-block-table) th, .wp-block-table:not(.is-style-stripes) thead td' ),
					'default' => '#e6e6e6',
				),

				array(
					'id' => 'misc_table_header_border_color',
					'title' => esc_html__( 'Header Border', 'aardvark' ),
					'section' => $theme_slug . '_other_styling',
					'type' => 'color_rgba',
					'output' => array( 'border-color' => 'table:not(.wp-block-table) th, .wp-block-table:not(.is-style-stripes) thead td' ),
					'default' => '#e6e6e6',
					),

				array(
					'id' => 'misc_table_header_text_color',
					'title' => esc_html__( 'Header Text', 'aardvark' ),
					'section' => $theme_slug . '_other_styling',
					'type' => 'color_rgba',
					'output' => array( 'color' => 'table:not(.wp-block-table) th, table:not(.wp-block-table) thead td' ),
					'default' => '',
				),

				array(
					'id' => 'misc_table_body_bg_color',
					'title' => esc_html__( 'Body Background', 'aardvark' ),
					'section' => $theme_slug . '_other_styling',
					'type' => 'color_rgba',
					'output' => array( 'background-color' => 'table:not(.wp-block-table) td, .wp-block-table:not(.is-style-stripes) tbody td' ),
					'default' => '',
				),	

				array(
					'id' => 'misc_table_body_border_color',
					'title' => esc_html__( 'Body Border', 'aardvark' ),
					'section' => $theme_slug . '_other_styling',
					'type' => 'color_rgba',
					'output' => array( 'border-color' => 'table:not(.wp-block-table) td, .wp-block-table:not(.is-style-stripes) tbody td' ),
					'default' => '#e6e6e6',
				),	

				array(
					'id' => 'misc_table_body_text_color',
					'title' => esc_html__( 'Body Text', 'aardvark' ),
					'section' => $theme_slug . '_other_styling',
					'type' => 'color_rgba',
					'output' => array( 'color' => 'table td' ),
					'default' => '',
				),		
			
			// Fields & Buttons
			array(
				'id' => 'other_styling_fields_buttons_section',
				'title' => esc_html__( 'Fields & Buttons', 'aardvark' ),
				'section' => $theme_slug . '_other_styling',
				'type' => 'section-header',
				'class' => 'gp-setting gp-setting-begin',
			),	
						
				array(
					'id' => 'input_bg',
					'title' => esc_html__( 'Input Box Background', 'aardvark' ),
					'section' => $theme_slug . '_other_styling',
					'type' => 'color_rgba',
					'output' => array( 'background-color' => 'input, textarea, .gp-theme #buddypress:not(.youzer) div.activity-comments form .ac-textarea, .gp-theme #buddypress:not(.youzer) form#whats-new-form textarea, .gp-theme #buddypress:not(.youzer) .dir-search input[type=search], .gp-theme #buddypress:not(.youzer) .dir-search input[type=text], .gp-theme #buddypress:not(.youzer) .groups-members-search input[type=search], .gp-theme #buddypress:not(.youzer) .groups-members-search input[type=text], .gp-theme #buddypress:not(.youzer) .standard-form input[type=color], .gp-theme #buddypress:not(.youzer) .standard-form input[type=date], .gp-theme #buddypress:not(.youzer) .standard-form input[type=datetime-local], .gp-theme #buddypress:not(.youzer) .standard-form input[type=datetime], .gp-theme #buddypress:not(.youzer) .standard-form input[type=email], .gp-theme #buddypress:not(.youzer) .standard-form input[type=month], .gp-theme #buddypress:not(.youzer) .standard-form input[type=number], .gp-theme #buddypress:not(.youzer) .standard-form input[type=password], .gp-theme #buddypress:not(.youzer) .standard-form input[type=range], .gp-theme #buddypress:not(.youzer) .standard-form input[type=search], .gp-theme #buddypress:not(.youzer) .standard-form input[type=tel], .gp-theme #buddypress:not(.youzer) .standard-form input[type=text], .gp-theme #buddypress:not(.youzer) .standard-form input[type=time], .gp-theme #buddypress:not(.youzer) .standard-form input[type=url], .gp-theme #buddypress:not(.youzer) .standard-form input[type=week], .gp-theme #buddypress:not(.youzer) .standard-form select, .gp-theme #buddypress:not(.youzer) .standard-form textarea' ),
					'default'   => '#fff',
				),

				array(
					'id' => 'input_border',
					'title' => esc_html__( 'Input Box Border', 'aardvark' ),
					'section' => $theme_slug . '_other_styling',
					'type' => 'border',
					'output' => 'input, textarea, .gp-theme #buddypress:not(.youzer) div.activity-comments form .ac-textarea, .gp-theme #buddypress:not(.youzer) form#whats-new-form textarea, .gp-theme #buddypress:not(.youzer) .rtm-plupload-list .rtm-upload-edit-desc, .gp-theme #buddypress:not(.youzer) .dir-search input[type=search], .gp-theme #buddypress:not(.youzer) .dir-search input[type=text], .gp-theme #buddypress:not(.youzer) .groups-members-search input[type=search], .gp-theme #buddypress:not(.youzer) .groups-members-search input[type=text], .gp-theme #buddypress:not(.youzer) .standard-form input[type=color], .gp-theme #buddypress:not(.youzer) .standard-form input[type=date], .gp-theme #buddypress:not(.youzer) .standard-form input[type=datetime-local], .gp-theme #buddypress:not(.youzer) .standard-form input[type=datetime], .gp-theme #buddypress:not(.youzer) .standard-form input[type=email], .gp-theme #buddypress:not(.youzer) .standard-form input[type=month], .gp-theme #buddypress:not(.youzer) .standard-form input[type=number], .gp-theme #buddypress:not(.youzer) .standard-form input[type=password], .gp-theme #buddypress:not(.youzer) .standard-form input[type=range], .gp-theme #buddypress:not(.youzer) .standard-form input[type=search], .gp-theme #buddypress:not(.youzer) .standard-form input[type=tel], .gp-theme #buddypress:not(.youzer) .standard-form input[type=text], .gp-theme #buddypress:not(.youzer) .standard-form input[type=time], .gp-theme #buddypress:not(.youzer) .standard-form input[type=url], .gp-theme #buddypress:not(.youzer) .standard-form input[type=week], .gp-theme #buddypress:not(.youzer) .standard-form select, .gp-theme #buddypress:not(.youzer) .standard-form textarea',  
					'default'   => array(
						'border-width' => 1,
						'border-color' => '#e6e6e6',
						'border-style' => 'solid',
						'border-radius' => 3,
					),
				),

				array(
					'id' => 'input_typography',
					'title' => esc_html__( 'Input Box Text', 'aardvark' ),
					'section' => $theme_slug . '_other_styling',
					'type'      => 'typography',
					'output' => 'input, textarea, .gp-theme #buddypress:not(.youzer) div.activity-comments form .ac-textarea, .gp-theme #buddypress:not(.youzer) div.activity-comments form textarea, .gp-theme #buddypress:not(.youzer) form#whats-new-form textarea, .gp-theme #buddypress:not(.youzer) .dir-search input[type=search], .gp-theme #buddypress:not(.youzer) .dir-search input[type=text], .gp-theme #buddypress:not(.youzer) .groups-members-search input[type=search], .gp-theme #buddypress:not(.youzer) .groups-members-search input[type=text], .gp-theme #buddypress:not(.youzer) .standard-form input[type=color], .gp-theme #buddypress:not(.youzer) .standard-form input[type=date], .gp-theme #buddypress:not(.youzer) .standard-form input[type=datetime-local], .gp-theme #buddypress:not(.youzer) .standard-form input[type=datetime], .gp-theme #buddypress:not(.youzer) .standard-form input[type=email], .gp-theme #buddypress:not(.youzer) .standard-form input[type=month], .gp-theme #buddypress:not(.youzer) .standard-form input[type=number], .gp-theme #buddypress:not(.youzer) .standard-form input[type=password], .gp-theme #buddypress:not(.youzer) .standard-form input[type=range], .gp-theme #buddypress:not(.youzer) .standard-form input[type=search], .gp-theme #buddypress:not(.youzer) .standard-form input[type=tel], .gp-theme #buddypress:not(.youzer) .standard-form input[type=text], .gp-theme #buddypress:not(.youzer) .standard-form input[type=time], .gp-theme #buddypress:not(.youzer) .standard-form input[type=url], .gp-theme #buddypress:not(.youzer) .standard-form input[type=week], .gp-theme #buddypress:not(.youzer) .standard-form select, .gp-theme #buddypress:not(.youzer) .standard-form textarea',
					'default'   => array(
						'font-size' => array(
							'value' => '16',
						),
						'line-height' => array(
							'value' => '20',
						),
						'font-family' => 'Roboto',
						'font-backup' => 'Arial, Helvetica, sans-serif',
						'font-weight' => '400',
						'subsets' => 'latin',
						'letter-spacing' => array(
							'value' => '0',
						),
						'color' => '#999',
						'text-transform' => 'none',
					),
				),
		
				array(
					'id' => 'select_bg',
					'title' => esc_html__( 'Selection Menu Background', 'aardvark' ),
					'section' => $theme_slug . '_other_styling',
					'type' => 'color_rgba',
					'output' => array( 'background-color' => 'select' ),
					'default'   => '#fff',
				),

				array(
					'id' => 'select_border',
					'title' => esc_html__( 'Selection Menu Border', 'aardvark' ),
					'section' => $theme_slug . '_other_styling',
					'type' => 'border',
					'output' => 'select', 
					'default'   => array(
						'border-width' => 1,
						'border-color' => '#e6e6e6',
						'border-style' => 'solid',
						'border-radius' => 3,
					),
				),

				array(
					'id' => 'select_typography',
					'title' => esc_html__( 'Selection Menu Text', 'aardvark' ),
					'section' => $theme_slug . '_other_styling',
					'type'      => 'typography',
					'output' => 'select',
					'default' => array(
						'font-size' => array(
							'value' => '16',
						),
						'line-height' => array(
							'value' => '17',
						),
						'font-family' => 'Roboto',
						'font-backup' => 'Arial, Helvetica, sans-serif',
						'font-weight' => '400',
						'subsets' => 'latin',
						'letter-spacing' => array(
							'value' => '0',
						),
						'color' => '#999',
						'text-transform' => 'none',
					),
				),
			
				array(
					'id' => 'button_bg',
					'title' => esc_html__( 'Button Background', 'aardvark' ),
					'section' => $theme_slug . '_other_styling',
					'type'      => 'color_gradient',
					'default' => array(
						'from' => '#009fe6',
						'to' => '#39c8df',
					),	
					'output' => 'input[type="button"], input[type="submit"], input[type="reset"], button, .button, .gp-theme #buddypress:not(.youzer) .comment-reply-link, .gp-theme #buddypress:not(.youzer) .generic-button a, .gp-theme #buddypress:not(.youzer) input[type=button], .gp-theme #buddypress:not(.youzer) input[type=reset], .gp-theme #buddypress:not(.youzer) input[type=submit], .gp-theme #buddypress:not(.youzer) ul.button-nav li a, a.bp-title-button, .gp-lesson-details-wrapper footer input, .gp-lesson-details-wrapper footer .button, .woocommerce #respond input#submit, .woocommerce a.button, .woocommerce button.button, .woocommerce input.button, .woocommerce #respond input#submit.alt, .woocommerce a.button.alt, .woocommerce button.button.alt, .woocommerce input.button.alt, .woocommerce div.product form.cart .button, .woocommerce #respond input#submit.alt.disabled, .woocommerce #respond input#submit.alt.disabled:hover, .woocommerce #respond input#submit.alt:disabled, .woocommerce #respond input#submit.alt:disabled:hover, .woocommerce #respond input#submit.alt:disabled[disabled], .woocommerce #respond input#submit.alt:disabled[disabled]:hover, .woocommerce input.button:disabled, .woocommerce input.button:disabled:hover, .woocommerce input.button:disabled[disabled], .woocommerce input.button:disabled[disabled]:hover, .woocommerce a.button.alt.disabled, .woocommerce a.button.alt.disabled:hover, .woocommerce a.button.alt:disabled, .woocommerce a.button.alt:disabled:hover, .woocommerce a.button.alt:disabled[disabled], .woocommerce a.button.alt:disabled[disabled]:hover, .woocommerce button.button.alt.disabled, .woocommerce button.button.alt.disabled:hover, .woocommerce button.button.alt:disabled, .woocommerce button.button.alt:disabled:hover, .woocommerce button.button.alt:disabled[disabled], .woocommerce button.button.alt:disabled[disabled]:hover, .woocommerce input.button.alt.disabled, .woocommerce input.button.alt.disabled:hover, .woocommerce input.button.alt:disabled, .woocommerce input.button.alt:disabled:hover, .woocommerce input.button.alt:disabled[disabled], .woocommerce input.button.alt:disabled[disabled]:hover, .pmpro_btn, .pmpro_btn:link, .pmpro_content_message a, .pmpro_content_message a:link, div.css-search div.em-search-main .em-search-submit, input[type="button"]:hover, input[type="submit"]:hover, input[type="reset"]:hover, .button:hover, .gp-theme #buddypress:not(.youzer) .comment-reply-link:hover, .gp-theme #buddypress:not(.youzer) div.generic-button a:hover, .gp-theme #buddypress:not(.youzer) input[type=button]:hover, .gp-theme #buddypress:not(.youzer) input[type=reset]:hover, .gp-theme #buddypress:not(.youzer) input[type=submit]:hover, .gp-theme #buddypress:not(.youzer) ul.button-nav li a:hover, .gp-theme #buddypress:not(.youzer) ul.button-nav li.current a, .gp-lesson-details-wrapper footer input:hover, .gp-lesson-details-wrapper footer .button:hover, .woocommerce #respond input#submit:hover, .woocommerce a.button:hover, .woocommerce button.button:hover, .woocommerce input.button:hover, .woocommerce #respond input#submit.alt:hover, .woocommerce a.button.alt:hover, .woocommerce button.button.alt:hover, .woocommerce input.button.alt:hover, .woocommerce div.product form.cart .button:hover, .pmpro_btn:hover, .pmpro_content_message a:hover, div.css-search div.em-search-main .em-search-submit:hover, .gp-bps-wrapper.ui-accordion .ui-accordion-header',
				),

				 array(
					'id' => 'button_bg_hover',
					'title' => esc_html__( 'Button Background Hover', 'aardvark' ),
					'section' => $theme_slug . '_other_styling',
					'type'      => 'color_gradient',
					'default' => array(
						'from' => '',
						'to' => '',
					),		
					'output' => 'input[type="button"]:hover, input[type="submit"]:hover, input[type="reset"]:hover, button:hover, .button:hover, .gp-theme #buddypress:not(.youzer) .comment-reply-link:hover, .gp-theme #buddypress:not(.youzer) div.generic-button a:hover, .gp-theme #buddypress:not(.youzer) input[type=button]:hover, .gp-theme #buddypress:not(.youzer) input[type=reset]:hover, .gp-theme #buddypress:not(.youzer) input[type=submit]:hover, .gp-theme #buddypress:not(.youzer) ul.button-nav li a:hover, .gp-theme #buddypress:not(.youzer) ul.button-nav li.current a, .gp-lesson-details-wrapper footer input:hover, .gp-lesson-details-wrapper footer .button:hover, .woocommerce #respond input#submit:hover, .woocommerce a.button:hover, .woocommerce button.button:hover, .woocommerce input.button:hover, .woocommerce #respond input#submit.alt:hover, .woocommerce a.button.alt:hover, .woocommerce button.button.alt:hover, .woocommerce input.button.alt:hover, .woocommerce div.product form.cart .button:hover, .pmpro_btn:hover, .pmpro_content_message a:hover, div.css-search div.em-search-main .em-search-submit:hover, .gp-bps-wrapper.ui-accordion .ui-accordion-header:hover',
				),

				array(
					'id' => 'button_border',
					'title' => esc_html__( 'Button Border', 'aardvark' ),
					'section' => $theme_slug . '_other_styling',
					'type' => 'border',
					'output' => 'input[type="button"], input[type="submit"], input[type="reset"], button, .button, .gp-theme #buddypress:not(.youzer) .comment-reply-link, .gp-theme #buddypress:not(.youzer) .generic-button a, .gp-theme #buddypress:not(.youzer) input[type=button], .gp-theme #buddypress:not(.youzer) input[type=reset], .gp-theme #buddypress:not(.youzer) input[type=submit], .gp-theme #buddypress:not(.youzer) ul.button-nav li a, a.bp-title-button,  .gp-bps-wrapper.ui-accordion .ui-accordion-header, .gp-lesson-details-wrapper footer input, .gp-lesson-details-wrapper footer .button, .woocommerce #respond input#submit, .woocommerce a.button, .woocommerce button.button, .woocommerce input.button, .woocommerce #respond input#submit.alt, .woocommerce a.button.alt, .woocommerce button.button.alt, .woocommerce input.button.alt, .woocommerce div.product form.cart .button, .woocommerce #respond input#submit.alt.disabled, .woocommerce #respond input#submit.alt.disabled:hover, .woocommerce #respond input#submit.alt:disabled, .woocommerce #respond input#submit.alt:disabled:hover, .woocommerce #respond input#submit.alt:disabled[disabled], .woocommerce #respond input#submit.alt:disabled[disabled]:hover, .woocommerce input.button:disabled, .woocommerce input.button:disabled:hover, .woocommerce input.button:disabled[disabled], .woocommerce input.button:disabled[disabled]:hover, .woocommerce a.button.alt.disabled, .woocommerce a.button.alt.disabled:hover, .woocommerce a.button.alt:disabled, .woocommerce a.button.alt:disabled:hover, .woocommerce a.button.alt:disabled[disabled], .woocommerce a.button.alt:disabled[disabled]:hover, .woocommerce button.button.alt.disabled, .woocommerce button.button.alt.disabled:hover, .woocommerce button.button.alt:disabled, .woocommerce button.button.alt:disabled:hover, .woocommerce button.button.alt:disabled[disabled], .woocommerce button.button.alt:disabled[disabled]:hover, .woocommerce input.button.alt.disabled, .woocommerce input.button.alt.disabled:hover, .woocommerce input.button.alt:disabled, .woocommerce input.button.alt:disabled:hover, .woocommerce input.button.alt:disabled[disabled], .woocommerce input.button.alt:disabled[disabled]:hover, .pmpro_btn, .pmpro_btn:link, .pmpro_content_message a, .pmpro_content_message a:link, div.css-search div.em-search-main .em-search-submit, input[type="button"]:hover, input[type="submit"]:hover, input[type="reset"]:hover, .button:hover, .gp-theme #buddypress:not(.youzer) .comment-reply-link:hover, .gp-theme #buddypress:not(.youzer) div.generic-button a:hover, .gp-theme #buddypress:not(.youzer) input[type=button]:hover, .gp-theme #buddypress:not(.youzer) input[type=reset]:hover, .gp-theme #buddypress:not(.youzer) input[type=submit]:hover, .gp-theme #buddypress:not(.youzer) ul.button-nav li a:hover, .gp-theme #buddypress:not(.youzer) ul.button-nav li.current a, .gp-lesson-details-wrapper footer input:hover, .gp-lesson-details-wrapper footer .button:hover, .woocommerce #respond input#submit:hover, .woocommerce a.button:hover, .woocommerce button.button:hover, .woocommerce input.button:hover, .woocommerce #respond input#submit.alt:hover, .woocommerce a.button.alt:hover, .woocommerce button.button.alt:hover, .woocommerce input.button.alt:hover, .woocommerce div.product form.cart .button:hover, .pmpro_btn:hover, .pmpro_content_message a:hover, div.css-search div.em-search-main .em-search-submit:hover, .gp-bps-wrapper.ui-accordion .ui-accordion-header:hover',
					'default'   => array(
						'border-width' => 0,
						'border-color' => '#e6e6e6',
						'border-style' => 'solid',
						'border-radius' => 3,
					),
				),
												
				array(
					'id' => 'button_typography',
					'title' => esc_html__( 'Button Text', 'aardvark' ),
					'section' => $theme_slug . '_other_styling',
					'type'      => 'typography',
					'output' => 'input[type="button"], input[type="submit"], input[type="reset"], button, .button, input[type="button"]:hover, input[type="submit"]:hover, input[type="reset"]:hover, .button:hover, a.bp-title-button, .gp-theme #buddypress:not(.youzer) .comment-reply-link, 
					.gp-theme #buddypress:not(.youzer) .generic-button a, .gp-theme #buddypress:not(.youzer) input[type=button], .gp-theme #buddypress:not(.youzer) input[type=reset], .gp-theme #buddypress:not(.youzer) input[type=submit], .gp-theme #buddypress:not(.youzer) ul.button-nav li a,.gp-bps-wrapper.ui-accordion .ui-accordion-header, .gp-theme #buddypress:not(.youzer) .comment-reply-link:hover, .gp-theme #buddypress:not(.youzer) div.generic-button a:hover, .gp-theme #buddypress:not(.youzer) input[type=button]:hover, .gp-theme #buddypress:not(.youzer) input[type=reset]:hover, .gp-theme #buddypress:not(.youzer) input[type=submit]:hover, .gp-theme #buddypress:not(.youzer) ul.button-nav li a:hover, .gp-theme #buddypress:not(.youzer) ul.button-nav li.current a, .gp-bps-wrapper.ui-accordion .ui-accordion-header:hover, .gp-theme .course-container a.button, .gp-theme .course-container a.button:visited, .gp-theme .course-container a.comment-reply-link, .gp-theme .course-container #commentform #submit, .gp-theme .course-container .submit, .gp-theme .course-container input[type=submit], .gp-theme .course-container input.button, .gp-theme .course-container button.button, .gp-theme .course a.button, .gp-theme .course a.button:visited, .gp-theme .course a.comment-reply-link, .gp-theme .course #commentform #submit, .gp-theme .course .submit, .gp-theme .course input[type=submit], .gp-theme .course input.button, .gp-theme .course button.button, .gp-theme .lesson a.button, .gp-theme .lesson a.button:visited, .gp-theme .lesson a.comment-reply-link, .gp-theme .lesson #commentform #submit, .gp-theme .lesson .submit, .gp-theme .lesson input[type=submit], .gp-theme .lesson input.button, .gp-theme .lesson button.button, .gp-theme .quiz a.button, .quiz a.button:visited, .gp-theme .quiz a.comment-reply-link, .gp-theme .quiz #commentform #submit, .gp-theme .quiz .submit, .gp-theme .quiz input[type=submit], .gp-theme .quiz input.button, .gp-theme .quiz button.button, .woocommerce #respond input#submit, .woocommerce a.button, .woocommerce button.button, .woocommerce input.button, .woocommerce #respond input#submit.alt, .woocommerce a.button.alt, .woocommerce button.button.alt, .woocommerce input.button.alt, .woocommerce div.product form.cart .button, .woocommerce #respond input#submit:hover, .woocommerce a.button:hover, .woocommerce button.button:hover, .woocommerce input.button:hover, .woocommerce #respond input#submit.alt:hover, .woocommerce a.button.alt:hover, .woocommerce button.button.alt:hover, .woocommerce input.button.alt:hover, .woocommerce div.product form.cart .button:hover, .woocommerce #respond input#submit.alt.disabled, .woocommerce #respond input#submit.alt.disabled:hover, .woocommerce #respond input#submit.alt:disabled, .woocommerce #respond input#submit.alt:disabled:hover, .woocommerce #respond input#submit.alt:disabled[disabled], .woocommerce #respond input#submit.alt:disabled[disabled]:hover, .woocommerce input.button:disabled, .woocommerce input.button:disabled:hover, .woocommerce input.button:disabled[disabled], .woocommerce input.button:disabled[disabled]:hover, .woocommerce a.button.alt.disabled, .woocommerce a.button.alt.disabled:hover, .woocommerce a.button.alt:disabled, .woocommerce a.button.alt:disabled:hover, .woocommerce a.button.alt:disabled[disabled], .woocommerce a.button.alt:disabled[disabled]:hover, .woocommerce button.button.alt.disabled, .woocommerce button.button.alt.disabled:hover, .woocommerce button.button.alt:disabled, .woocommerce button.button.alt:disabled:hover, .woocommerce button.button.alt:disabled[disabled], .woocommerce button.button.alt:disabled[disabled]:hover, .woocommerce input.button.alt.disabled, .woocommerce input.button.alt.disabled:hover, .woocommerce input.button.alt:disabled, .woocommerce input.button.alt:disabled:hover, .woocommerce input.button.alt:disabled[disabled], .woocommerce input.button.alt:disabled[disabled]:hover, .pmpro_btn, .pmpro_btn:link, .pmpro_content_message a, .pmpro_content_message a:link, .pmpro_btn:hover, .pmpro_btn:focus, .pmpro_checkout .pmpro_btn:hover, .pmpro_checkout .pmpro_btn:focus, .pmpro_content_message a:focus, .pmpro_content_message a:hover',
					'default'   => array(
					'font-size' => array(
						'value' => '14',
					),
					'line-height' => array(
						'value' => '14',
					),
					'font-family' => 'Roboto',
					'font-backup' => 'Arial, Helvetica, sans-serif',
					'font-weight' => '500',
					'subsets' => 'latin',
					'letter-spacing' => array(
						'value' => '0',
					),
					'color' => '#fff',
					'text-transform' => 'none',
				),
			),

			// Popup window
			array(
				'id' => 'other_styling_popup_section',
				'title' => esc_html__( 'Poup Window', 'aardvark' ),
				'section' => $theme_slug . '_other_styling',
				'type' => 'section-header',
				'class' => 'gp-setting gp-setting-begin',
			),
			
				array(
					'id' => 'login_popup_bg',
					'title' => esc_html__( 'Background', 'aardvark' ),
					'section' => $theme_slug . '_other_styling',
					'type'      => 'color',
					'output' => array( 'background-color' => '#gp-login-modal' ),
					'default' => '#fff',
				),

				array(
					'id' => 'login_popup_title',
					'title' => esc_html__( 'Title', 'aardvark' ),
					'section' => $theme_slug . '_other_styling',
					'type'      => 'typography',
					'output' => '.gp-login-title',
					'default'   => array(
						'font-size' => array(
							'value' => '19',
						),
						'line-height' => array(
							'value' => '19',
						),
						'font-family' => 'Roboto',
						'font-backup' => 'Arial, Helvetica, sans-serif',
						'font-weight' => '400',
						'subsets' => 'latin',
						'letter-spacing' => array(
							'value' => '0',
						),
						'color' => '#232323',
						'text-transform' => 'none',
					),
				),

				array(
					'id' => 'login_popup_link_colors',
					'title' => esc_html__( 'Links', 'aardvark' ),
					'section' => $theme_slug . '_other_styling',
					'type'      => 'link_color',
					'output' => '#gp-login-close,.gp-login-links a',
					'default'   => array(
						'regular' => '#232323',
						'hover'   => '#232323',
					),
				),

			// Other
			array(
				'id' => 'other_styling_other_section',
				'title' => esc_html__( 'Other', 'aardvark' ),
				'section' => $theme_slug . '_other_styling',
				'type' => 'section-header',
				'class' => 'gp-setting gp-setting-begin',
			),	
			
				array(
					'id' => 'misc_tab_link_colors',
					'title' => esc_html__( 'Tab Links', 'aardvark' ),
					'section' => $theme_slug . '_other_styling',
					'type' => 'color_rgba',
						'desc'  => esc_html__( 'Used for WooCommerce, BuddyPress and Sensei tabs.', 'aardvark' ),
					'output' => array( 'color' => '.gp-theme #buddypress:not(.youzer) div.item-list-tabs ul li a, .gp-theme #buddypress:not(.youzer) .main-navs ul li a, .gp-theme #buddypress:not(.youzer) .bp-subnavs ul li a, .gp-theme #buddypress:not(.youzer) div.item-list-tabs ul li a span, .gp-theme #buddypress:not(.youzer) .main-navs ul li a span, .woocommerce-account .woocommerce-MyAccount-navigation li a, .woocommerce div.product .woocommerce-tabs ul.tabs li a, .woocommerce div.product .woocommerce-tabs ul.tabs li.active a, .sensei-course-filters li a, .learner-profile #my-courses.ui-tabs .ui-tabs-nav li.ui-state-active a, .gp-theme #buddypress:not(.youzer) #gp-bp-tabs-button' ),
					'default' => '#232323',
					),
		
				array(
					'id' => 'address_bar_color',
					'title' => esc_html__( 'Address Bar Color', 'aardvark' ),
					'section' => $theme_slug . '_other_styling',
					'type'      => 'color_rgba',
					'desc' => esc_html__( 'The address bar color for Chrome on Android.', 'aardvark' ),
					'default' => '',
				),
													
			/**
			 * General - Custom Code
			 *
			 */
			// HTML Code 
			array(
				'id' => 'custom_header_footer_code_section',
				'title' => esc_html__( 'Header and Footer Code', 'aardvark' ),
				'section' => $theme_slug . '_custom_code',
				'desc' => esc_html__( 'Add your own HTML code to the header and footer of theme, for example Google Analytics or Adsense code.', 'aardvark' ),
				'type' => 'section-header',
				'class' => 'gp-setting gp-setting-begin',
			),
						
				array( 
					'id' => 'custom_header_code',
					'title' => esc_html__( 'Header', 'aardvark' ),
					'desc' => esc_html__( 'This code is added just before the </head> tag.', 'aardvark' ),
					'section' => $theme_slug . '_custom_code',
					'type'  => 'textarea',
					'validate' => 'html',
					'default' => '',
				),	
						
				array( 
					'id' => 'custom_footer_code',
					'title' => esc_html__( 'Footer', 'aardvark' ),
					'desc' => esc_html__( 'This code is added just before the </body> tag.', 'aardvark' ),
					'section' => $theme_slug . '_custom_code',
					'type'  => 'textarea',
					'validate' => 'html',
					'default' => '',
				),	
				
			// CSS Code 
			array(
				'id' => 'custom_code_css_section',
				'title' => esc_html__( 'CSS', 'aardvark' ),
				'section' => $theme_slug . '_custom_code',
				'desc' => esc_html__( 'Add your own CSS code.', 'aardvark' ),
				'type' => 'section-header',
				'class' => 'gp-setting gp-setting-begin',
			),
						 
				array(
					'id' => 'custom_css',
					'title' => esc_html__( 'Code', 'aardvark' ),
					'section' => $theme_slug . '_custom_code',
					'type'  => 'ace_editor',
					'format' => 'css',
					'default' => '',
				),

			// JS Code 
			array(
				'id' => 'custom_code_js_section',
				'title' => esc_html__( 'JavaScript', 'aardvark' ),
				'section' => $theme_slug . '_custom_code',
				'desc' => esc_html__( 'Add your own JavaScript code.', 'aardvark' ),
				'type' => 'section-header',
				'class' => 'gp-setting gp-setting-begin',
			),
			
				array( 
					'id' => 'js_code',
					'title' => esc_html__( 'Code', 'aardvark' ),
					'section' => $theme_slug . '_custom_code',
					'type'  => 'ace_editor',
					'format' => 'javascript',
					'default' => '',
				),
			 							
			/**
			 * Posts
			 *
			 */	
			 
			// Title header
			array(
				'id' => 'post_title_header_section',
				'title' => esc_html__( 'Title Header', 'aardvark' ),
				'section' => $theme_slug . '_posts',
				'type' => 'section-header',
				'class' => 'gp-setting gp-setting-begin',
			),
			
				array( 
					'id' => 'post_page_header',
					'title' => esc_html__( 'Display', 'aardvark' ),
					'section' => $theme_slug . '_posts',
					'type' => 'select',
					'options' => array(
						'gp-standard-page-header' => esc_html__( 'Standard', 'aardvark' ),
						'gp-fullwidth-page-header' => esc_html__( 'Full Width', 'aardvark' ),
						'gp-full-page-page-header' => esc_html__( 'Full Page', 'aardvark' ),
						'gp-minimal-page-header' => esc_html__( 'Minimal', 'aardvark' ),
						'gp-page-header-disabled' => esc_html__( 'Disabled', 'aardvark' ),
					),
					'default' => 'gp-standard-page-header',
				),

				array( 
					'id' => 'post_page_header_height',
					'title' => esc_html__( 'Height', 'aardvark' ),
					'section' => $theme_slug . '_posts',
					'type' => 'dimensions',
					'default' => array(
						'height' => 320,
					),
				),

			// Layout
			array(
				'id' => 'post_layout_section',
				'title' => esc_html__( 'Layout', 'aardvark' ),
				'section' => $theme_slug . '_posts',
				'type' => 'section-header',
				'class' => 'gp-setting gp-setting-begin',
			),
														
				array( 
					'id' => 'post_layout',
					'title' => esc_html__( 'Display', 'aardvark' ),	
					'section' => $theme_slug . '_posts',
					'type' => 'select',
					'options' => array(
						'gp-left-sidebar' => esc_html__( 'Left Sidebar', 'aardvark' ), 
						'gp-right-sidebar' => esc_html__( 'Right Sidebar', 'aardvark' ),
						'gp-both-sidebars' => esc_html__( 'Both Sidebars', 'aardvark' ), 
						'gp-no-sidebar' => esc_html__( 'No Sidebar', 'aardvark' ),
						'gp-fullwidth' => esc_html__( 'Full Width', 'aardvark' ),
					),
					'default' => 'gp-right-sidebar',
				),

				array(
					'id' => 'post_left_sidebar',
					'title' => esc_html__( 'Left Sidebar', 'aardvark' ),
					'section' => $theme_slug . '_posts',
					'type'    => 'select',
					'data'    => 'sidebars',
					'default' => 'gp-left-sidebar',
				),

				array(
					'id' => 'post_right_sidebar',	
					'title' => esc_html__( 'Right Sidebar', 'aardvark' ),
					'section' => $theme_slug . '_posts',
					'type'    => 'select',
					'data'    => 'sidebars',
					'default' => 'gp-right-sidebar',
				),

			// Image
			array(
				'id' => 'post_featured_image_section',
				'title' => esc_html__( 'Featured Image', 'aardvark' ),
				'section' => $theme_slug . '_posts',
				'type' => 'section-header',
				'class' => 'gp-setting gp-setting-begin',
			),
			
				array(  
					'id' => 'post_featured_image',
					'title' => esc_html__( 'Display', 'aardvark' ),
					'section' => $theme_slug . '_posts',
					'type' => 'radio',
					'options' => array(
						'enabled' => esc_html__( 'Enabled', 'aardvark' ),
						'disabled' => esc_html__( 'Disabled', 'aardvark' ),
					),	
					'default' => 'enabled',
				),	

				array(
					'id' => 'post_image_source',
					'title' => esc_html__( 'Image Source', 'aardvark' ),
					'section' => $theme_slug . '_posts',
					'type' => 'text',
					'desc' => esc_html__( 'Enter the meta key for the custom image field you want to use.', 'aardvark' ),
					'default' => '',
				),

				array(
					'id' => 'post_image_size',
					'title' => esc_html__( 'Image Size', 'aardvark' ),
					'section' => $theme_slug . '_posts',
					'type' => 'text',
					'desc' => esc_html__( 'Enter image size e.g. "thumbnail", "medium", "large", "full" or enter size in pixels e.g. 200 x 100 (width x height).', 'aardvark' ),
					'default' => '864 x 467',
				),

			// Post meta
			array(
				'id' => 'post_post_meta_section',
				'title' => esc_html__( 'Post Meta', 'aardvark' ),
				'section' => $theme_slug . '_posts',
				'type' => 'section-header',
				'class' => 'gp-setting gp-setting-begin',
			),
							
				array(
					'id' => 'post_meta',
					'title' => esc_html__( 'Display', 'aardvark' ),
					'section' => $theme_slug . '_posts',
					'type'  => 'checkbox',
					'options'   => array(
						'author' => esc_html__( 'Author', 'aardvark' ),
						'date' => esc_html__( 'Date', 'aardvark' ),
						'comment_count' => esc_html__( 'Comment Count', 'aardvark' ),
						'views' => esc_html__( 'Views', 'aardvark' ),
						'likes' => esc_html__( 'Likes', 'aardvark' ),
						'cats' => esc_html__( 'Categories', 'aardvark' ),
						'tags' => esc_html__( 'Tags', 'aardvark' ),
					),	
					'default'   => array(
						'author' => 1,
						'date' => 1,
						'comment_count' => 1,
						'views' => 1,
						'likes' => 1,
						'cats' => 0,
						'tags' => 1,
					),
				),
			
				array(
					'id' => 'post_meta_typography',
					'title' => esc_html__( 'Text', 'aardvark' ),
					'section' => $theme_slug . '_posts',
					'type'      => 'typography',
					'output' => array( '.gp-entry-meta, .gp-entry-meta a, .gp-entry-tags, .gp-entry-tags a, #gp-breadcrumbs' ),
					'default'   => array(
						'font-size' => array(
							'value' => '13',
						),
						'line-height' => array(
							'value' => '13',
						),
						'color' => '#b1b1b1',                           	
						'font-family' => 'Roboto',
						'font-backup' => 'Arial, Helvetica, sans-serif',
						'font-weight' => '400',
						'subsets' => 'latin',
						'letter-spacing' => array(
							'value' => '0',
						),
					),
				),			

			// Sub headers
			array(
				'id' => 'post_sub_header_section',
				'title' => esc_html__( 'Sub Headers', 'aardvark' ),
				'section' => $theme_slug . '_posts',
				'type' => 'section-header',
				'class' => 'gp-setting gp-setting-begin',
			),
			
				array(
					'id' => 'post_sub_header_typography',
					'title' => esc_html__( 'Sub Header', 'aardvark' ),
					'section' => $theme_slug . '_posts',
					'desc'  => esc_html__( 'Used for the related posts section, comments section etc.', 'aardvark' ),
					'output' => array( '.gp-divider-title, #comments h3, .woocommerce div.product .woocommerce-tabs .panel h2, .woocommerce .comment-reply-title' ),
					'type'      => 'typography',
					'default'   => array(
						'font-size' => array(
							'value' => '19',
						),
						'line-height' => array(
							'value' => '19',
						),
						'color' => '#232323',                           	
						'font-family' => 'Roboto',
						'font-backup' => 'Arial, Helvetica, sans-serif',
						'font-weight' => '400',
						'subsets' => 'latin',
						'letter-spacing' => array(
							'value' => '-0.25',
						),
					),
				),

			// Share icons
			array(
				'id' => 'post_share_icons_section',
				'title' => esc_html__( 'Share Icons', 'aardvark' ),
				'section' => $theme_slug . '_posts',
				'type' => 'section-header',
				'class' => 'gp-setting gp-setting-begin',
			),

				array(  
					'id' => 'post_share_icons',
					'title' => esc_html__( 'Display', 'aardvark' ),
					'section' => $theme_slug . '_posts',
					'type' => 'radio',
					'options' => array(
						'enabled' => esc_html__( 'Enabled', 'aardvark' ),
						'disabled' => esc_html__( 'Disabled', 'aardvark' ),
					),
					'default' => 'enabled',
				),
				
				array(
					'id' => 'post_share_icons_selection',
					'title' => esc_html__( 'Icons', 'aardvark' ),
					'section' => $theme_slug . '_posts',
					'type'  => 'checkbox',
					'options'   => array(
						'twitter' => esc_html__( 'Twitter', 'aardvark' ),
						'facebook' => esc_html__( 'Facebook', 'aardvark' ),
						'pinterest' => esc_html__( 'Pinterest', 'aardvark' ),
						'linkedin' => esc_html__( 'LinkedIn', 'aardvark' ),
						'reddit' => esc_html__( 'Reddit', 'aardvark' ),
						'tumblr' => esc_html__( 'Tumblr', 'aardvark' ),
						'email' => esc_html__( 'Email', 'aardvark' ),
						'whatsapp' => esc_html__( 'WhatsApp', 'aardvark' ),
					),	
					'default'   => array(
						'twitter' => 1,
						'facebook' => 1,
						'pinterest' => 1,
						'linkedin' => 1,
						'reddit' => 1,
						'tumblr' => 1,
						'email' => 1,
						'whatsapp' => 1,
					),
					'conditions' => array(
						'post_share_icons' => 'enabled',
					),
				),

				array(  
					'id' => 'post_share_icons_custom',
					'title' => esc_html__( 'Custom Icons', 'aardvark' ),
					'desc' => esc_html__( 'Add your custom share icon code e.g. <a href="http://your-share-link.com" class="your-icon-class"></a>', 'aardvark' ),
					'section' => $theme_slug . '_posts',
					'type'  => 'textarea',
					'default' => '',
					'conditions' => array(
						'post_share_icons' => 'enabled',
					),
				),
				
			// Post navigation
			array(
				'id' => 'post_navigation_section',
				'title' => esc_html__( 'Post Navigation', 'aardvark' ),
				'section' => $theme_slug . '_posts',
				'type' => 'section-header',
				'class' => 'gp-setting gp-setting-begin',
			),
			
				array(  
					'id' => 'post_navigation',
					'title' => esc_html__( 'Display', 'aardvark' ),
					'section' => $theme_slug . '_posts',
					'type' => 'radio',
					'options' => array(
						'enabled' => esc_html__( 'Enabled', 'aardvark' ),
						'disabled' => esc_html__( 'Disabled', 'aardvark' ),
					),
					'default' => 'enabled',
				),

				array(
					'id' => 'post_navigation_text_color',
					'title' => esc_html__( ' Text', 'aardvark' ),
					'section' => $theme_slug . '_posts',
					'type' => 'color_rgba',
					'output' => '.gp-post-link-header',
					'default'   => '#000',
					'conditions' => array(
						'post_navigation' => 'enabled',
					),
				),

				array(
					'id' => 'post_navigation_link_colors',
					'title' => esc_html__( 'Links', 'aardvark' ),
					'section' => $theme_slug . '_posts',
					'type'      => 'link_color',
					'output' => '#gp-post-navigation a',
					'default'   => array(
						'regular' => '#232323',
						'hover'       => '#39c8df',
					),
					'conditions' => array(
						'post_navigation' => 'enabled',
					),
				),

			// Voting panel
			array(
				'id' => 'post_voting_section',
				'title' => esc_html__( 'Voting Panel', 'aardvark' ),
				'section' => $theme_slug . '_posts',
				'type' => 'section-header',
				'class' => 'gp-setting gp-setting-begin',
			),

				array(  
					'id' => 'post_voting',
					'title' => esc_html__( 'Display', 'aardvark' ),
					'section' => $theme_slug . '_posts',
					'type' => 'radio',
					'options' => array(
						'enabled' => esc_html__( 'Enabled', 'aardvark' ),
						'disabled' => esc_html__( 'Disabled', 'aardvark' ),
					),
					'default' => 'enabled',
				),

				array(
					'id' => 'post_voting_title',				
					'title' => esc_html__( 'Title', 'aardvark' ),
					'section' => $theme_slug . '_posts',
					'type'  => 'text',
					'default'   => esc_html__( 'Have your say!', 'aardvark' ),
					'conditions' => array(
						'post_voting' => 'enabled',
					),
				),
			
				array(
					'id' => 'vote_bg',
					'title' => esc_html__( 'Button Background', 'aardvark' ),
					'section' => $theme_slug . '_posts',
					'type' => 'color_rgba',
					'output' => array( 'background-color' => '.gp-voting-button' ),
					'default'   => '#fff',
					'conditions' => array(
						'post_voting' => 'enabled',
					),
				),

				array(
					'id' => 'vote_border',
					'title' => esc_html__( 'Button Border', 'aardvark' ),
					'section' => $theme_slug . '_posts',
					'type' => 'color_rgba',
					'output' => array( 'border-color' => '.gp-voting-button' ),
					'default'   => '#e6e6e6',
					'conditions' => array(
						'post_voting' => 'enabled',
					),
				),

				array(
					'id' => 'vote_bg_hover',
					'title' => esc_html__( 'Button Background Hover', 'aardvark' ),
					'section' => $theme_slug . '_posts',
					'type' => 'color_rgba',
					'output' => array( 'background-color' => '.gp-voting-button:hover, .gp-voting-button.gp-voted' ),
					'default'   => '#f1f1f1',
					'conditions' => array(
						'post_voting' => 'enabled',
					),
				),

				array(
					'id' => 'vote_text_color',
					'title' => esc_html__( 'Button Text', 'aardvark' ),
					'section' => $theme_slug . '_posts',
					'type' => 'color_rgba',
					'output' => '.gp-voting-button',
					'default' => '#777',
					'conditions' => array(
						'post_voting' => 'enabled',
					),
				),	

				array(
					'id' => 'vote_text_color_hover',
					'title' => esc_html__( 'Button Text Hover', 'aardvark' ),
					'section' => $theme_slug . '_posts',
					'type' => 'color_rgba',
					'output' => '.gp-voting-button:hover, .gp-voting-button.gp-voted',
					'default' => '#777',
					'conditions' => array(
						'post_voting' => 'enabled',
					),
				),

			// Author panel
			array(
				'id' => 'post_author_info_section',
				'title' => esc_html__( 'Author Info Panel', 'aardvark' ),
				'section' => $theme_slug . '_posts',
				'type' => 'section-header',
				'class' => 'gp-setting gp-setting-begin',
			),
																   
				array(  
					'id' => 'post_author_info',
					'title' => esc_html__( 'Display', 'aardvark' ),
					'section' => $theme_slug . '_posts',
					'desc' => esc_html__( 'This panel will only show if the author has added text to the "Biographical Info" field under Users > Your Profile.', 'aardvark' ),
					'type' => 'radio',
					'options' => array(
						'enabled' => esc_html__( 'Enabled', 'aardvark' ),
						'disabled' => esc_html__( 'Disabled', 'aardvark' ),
					),	
					'default' => 'enabled',
				),
			
				array(
					'id' => 'author_info_bg',
					'title' => esc_html__( 'Background', 'aardvark' ),
					'section' => $theme_slug . '_posts',
					'type' => 'color_rgba',
					'output' => array( 'background-color' => '#gp-author-info-wrapper' ),
					'default'   => '#fff',
					'conditions' => array(
						'post_author_info' => 'enabled',
					),
				),
									
				array(
					'id' => 'author_info_border',
					'title' => esc_html__( 'Border', 'aardvark' ),
					'section' => $theme_slug . '_posts',
					'type' => 'color_rgba',
					'output' => array( 'border-color' => '#gp-author-info-wrapper' ),
					'default'   => '#e6e6e6',
					'conditions' => array(
						'post_author_info' => 'enabled',
					),
				),
			
				array(
					'id' => 'author_info_text_color',
					'title' => esc_html__( 'Text', 'aardvark' ),
					'section' => $theme_slug . '_posts',
					'type' => 'color_rgba',
					'output' => '#gp-author-info-wrapper',
					'default' => '#777',
					'conditions' => array(
						'post_author_info' => 'enabled',
					),
				),	
		
				array(
					'id' => 'author_info_link_colors',
					'title' => esc_html__( 'Links', 'aardvark' ),
					'section' => $theme_slug . '_posts',
					'type'      => 'link_color',
					'output' => '#gp-author-info-wrapper a',
					'default'   => array(
						'regular' => '#39c8df',
						'hover'       => '#00a0e3',
					),
					'conditions' => array(
						'post_author_info' => 'enabled',
					),
				),
			
			// Related items
			array(
				'id' => 'post_related_items_section',
				'title' => esc_html__( 'Related Items', 'aardvark' ),
				'section' => $theme_slug . '_posts',
				'type' => 'section-header',
				'class' => 'gp-setting gp-setting-begin',
			),
			
				array(  
					'id' => 'post_related_items',
					'title' => esc_html__( 'Display', 'aardvark' ),
					'section' => $theme_slug . '_posts',
					'type' => 'radio',
					'options' => array(
						'enabled' => esc_html__( 'Enabled', 'aardvark' ),
						'disabled' => esc_html__( 'Disabled', 'aardvark' ),
					),
					'default' => 'enabled',
				),
			
			/**
			 * Pages
			 *
			 */
			// Title header
			array(
				'id' => 'page_title_header_section',
				'title' => esc_html__( 'Title Header', 'aardvark' ),
				'section' => $theme_slug . '_pages',
				'type' => 'section-header',
				'class' => 'gp-setting gp-setting-begin',
			),

				array( 
					'id' => 'page_page_header',
					'title' => esc_html__( 'Display', 'aardvark' ),
					'section' => $theme_slug . '_pages',
					'type' => 'select',
					'options' => array(
						'gp-standard-page-header' => esc_html__( 'Standard', 'aardvark' ),
						'gp-fullwidth-page-header' => esc_html__( 'Full Width', 'aardvark' ),
						'gp-full-page-page-header' => esc_html__( 'Full Page', 'aardvark' ),
						'gp-minimal-page-header' => esc_html__( 'Minimal', 'aardvark' ),
						'gp-page-header-disabled' => esc_html__( 'Disabled', 'aardvark' ),
					),
					'default' => 'gp-standard-page-header',
				),

				array( 
					'id' => 'page_page_header_height',
					'title' => esc_html__( 'Height', 'aardvark' ),
					'section' => $theme_slug . '_pages',
					'type' => 'dimensions',
					'default' => array(
						'height' => 320,
					),	
				),
				
			// Page layout
			array(
				'id' => 'page_layout_section',
				'title' => esc_html__( 'Layout', 'aardvark' ),
				'section' => $theme_slug . '_pages',
				'type' => 'section-header',
				'class' => 'gp-setting gp-setting-begin',
			),
												
				array( 
					'id' => 'page_layout',
					'title' => esc_html__( 'Display', 'aardvark' ),
					'section' => $theme_slug . '_pages',				
					'type' => 'select',
					'options' => array(
							'gp-left-sidebar' => esc_html__( 'Left Sidebar', 'aardvark' ), 
							'gp-right-sidebar' => esc_html__( 'Right Sidebar', 'aardvark' ),
							'gp-both-sidebars' => esc_html__( 'Both Sidebars', 'aardvark' ), 
							'gp-no-sidebar' => esc_html__( 'No Sidebar', 'aardvark' ),
							'gp-fullwidth' => esc_html__( 'Full Width', 'aardvark' ),
						),
					'default' => 'gp-right-sidebar',
				),

				array(
					'id' => 'page_left_sidebar',
					'title' => esc_html__( 'Left Sidebar', 'aardvark' ),
					'section' => $theme_slug . '_pages',
					'type'    => 'select',
					'data'    => 'sidebars',
					'default' => 'gp-left-sidebar',
				),

				array(
					'id' => 'page_right_sidebar',
					'title' => esc_html__( 'Right Sidebar', 'aardvark' ),
					'section' => $theme_slug . '_pages',
					'type'    => 'select',
					'data'    => 'sidebars',
					'default' => 'gp-right-sidebar',
				),

			// Featured image
			array(
				'id' => 'page_featured_image_section',
				'title' => esc_html__( 'Featured Image', 'aardvark' ),
				'section' => $theme_slug . '_pages',
				'type' => 'section-header',
				'class' => 'gp-setting gp-setting-begin',
			),
			
				array(  
					'id' => 'page_featured_image',
					'title' => esc_html__( 'Display', 'aardvark' ),
					'section' => $theme_slug . '_pages',
					'type' => 'radio',
					'options' => array(
						'enabled' => esc_html__( 'Enabled', 'aardvark' ),
						'disabled' => esc_html__( 'Disabled', 'aardvark' ),
					),
					'default' => 'enabled',
				),		

				array(
					'id' => 'page_image_source',
					'title' => esc_html__( 'Image Source', 'aardvark' ),
					'section' => $theme_slug . '_pages',
					'type' => 'text',
					'desc' => esc_html__( 'Enter the meta key for the custom image field you want to use.', 'aardvark' ),
					'default' => '',
				),

				array(
					'id' => 'page_image_size',
					'title' => esc_html__( 'Image Size', 'aardvark' ),
					'section' => $theme_slug . '_pages',
					'type' => 'text',
					'desc' => esc_html__( 'Enter image size e.g. "thumbnail", "medium", "large", "full" or enter size in pixels e.g. 200 x 100 (width x height).', 'aardvark' ),
					'default' => '864 x 467',

				),

			// Share icons
			array(
				'id' => 'page_share_icons_section',
				'title' => esc_html__( 'Share Icons', 'aardvark' ),
				'section' => $theme_slug . '_pages',
				'type' => 'section-header',
				'class' => 'gp-setting gp-setting-begin',
			),

				array(  
					'id' => 'page_share_icons',
					'title' => esc_html__( 'Display', 'aardvark' ),
					'section' => $theme_slug . '_pages',
					'type' => 'radio',
					'options' => array(
						'enabled' => esc_html__( 'Enabled', 'aardvark' ),
						'disabled' => esc_html__( 'Disabled', 'aardvark' ),
					),
					'default' => 'disabled',
				),
				
			// Voting panel
			array(
				'id' => 'page_voting_section',
				'title' => esc_html__( 'Voting Panel', 'aardvark' ),
				'section' => $theme_slug . '_pages',
				'type' => 'section-header',
				'class' => 'gp-setting gp-setting-begin',
			),
						
				array(  
					'id' => 'page_voting',
					'title' => esc_html__( 'Display', 'aardvark' ),
					'section' => $theme_slug . '_pages',
					'type' => 'radio',
					'options' => array(
						'enabled' => esc_html__( 'Enabled', 'aardvark' ),
						'disabled' => esc_html__( 'Disabled', 'aardvark' ),
					),	
					'default' => 'disabled',
				),

				array(
					'id' => 'page_voting_title',
					'title' => esc_html__( 'Title', 'aardvark' ),
					'section' => $theme_slug . '_pages',
					'type'  => 'text',
					'default'   => esc_html__( 'Have your say!', 'aardvark' ),
					'conditions' => array(
						'page_voting' => 'enabled',
					),
				),
				
			// Author panel
			array(
				'id' => 'page_author_info_section',
				'title' => esc_html__( 'Author Info Panel', 'aardvark' ),
				'section' => $theme_slug . '_pages',
				'type' => 'section-header',
				'class' => 'gp-setting gp-setting-begin',
			),
			
				array(  
					'id' => 'page_author_info',
					'title' => esc_html__( 'Display', 'aardvark' ),
					'section' => $theme_slug . '_pages',
					'desc' => esc_html__( 'This panel will only show if the author has added text to the "Biographical Info" field under Users > Your Profile.', 'aardvark' ),
						'type' => 'radio',
					'options' => array(
							'enabled' => esc_html__( 'Enabled', 'aardvark' ),
							'disabled' => esc_html__( 'Disabled', 'aardvark' ),
						),
					'default' => 'disabled',
				),
			
			/**
			 * Pages - Post Submission
			 *
			 */
			array( 
				'id' => 'post_submission_list_page',
				'title' => esc_html__( 'Approved/Pending Posts Page', 'aardvark' ),
				'section' => $theme_slug . '_post_submission',
				'desc' => esc_html__( 'The page used to display approved and pending posts.', 'aardvark' ),
				'type' => 'select',
				'data' => 'pages',
				'default_pages' => array( 'bp-profile-posts' ),
				'default' => '',
			),

			array( 
				'id' => 'post_editing_page',
				'title' => esc_html__( 'Post Editing Page', 'aardvark' ),
				'section' => $theme_slug . '_post_submission',
				'desc' => esc_html__( 'The page used to display the edit form.', 'aardvark' ),
				'type' => 'select',
				'data' => 'pages',
				'default' => '',
			),
			
			array( 
				'id' => 'post_preview_page',
				'title' => esc_html__( 'Post Preview Page', 'aardvark' ),
				'section' => $theme_slug . '_post_submission',
				'desc' => esc_html__( 'The page used to display post previews.', 'aardvark' ),
				'type' => 'select',
				'data' => 'pages',
				'default' => '',
			),
						
			array( 
				'id' => 'post_submission_list_display',
				'title' => esc_html__( 'Approved/Pending Posts Display', 'aardvark' ),
				'section' => $theme_slug . '_post_submission',
				'type' => 'radio',
				'options' => array(
					'all_posts' => esc_html__( 'Show all posts by user', 'aardvark' ),
					'frontend_posts' => esc_html__( 'Show only posts submitted from frontend submission form', 'aardvark' ),
				),	
				'default' => 'frontend_posts',
			),			
			
			array( 
				'id' => 'post_editing_status',
				'title' => esc_html__( 'Post Editing Status', 'aardvark' ),
				'section' => $theme_slug . '_post_submission',
				'type' => 'select',
				'options' => array(
					'publish' => esc_html__( 'Approved posts are approved again once edited', 'aardvark' ),
					'pending' => esc_html__( 'Edited posts need to be approved again', 'aardvark' ),
					'disabled' => esc_html__( 'Disabled', 'aardvark' ),
				),	
				'default' => 'publish',
			),

			array( 
				'id' => 'post_editing_email_notification',
				'title' => esc_html__( 'Post Editing Email Notification', 'aardvark' ),
				'section' => $theme_slug . '_post_submission',
				'type' => 'radio',
				'desc' => esc_html__( 'Choose to receive an email notification when a user edits a post.', 'aardvark' ),
				'options' => array(
					'enabled' => esc_html__( 'Enabled', 'aardvark' ),
					'disabled' => esc_html__( 'Disabled', 'aardvark' ),
				),	
				'default' => 'disabled',
			),
			
			array( 
				'id' => 'post_submission_page',
				'title' => esc_html__( 'Post Submission Page', 'aardvark' ),
				'section' => $theme_slug . '_post_submission',
				'desc' => esc_html__( 'If the post edit form is not looking the same as your post submission form, select the page that is using your post submission form.', 'aardvark' ),
				'type' => 'select',
				'data' => 'pages',
				'default' => '',
			),			

			
			array( 
				'id' => 'post_deleting',
				'title' => esc_html__( 'Deleting Posts', 'aardvark' ),
				'section' => $theme_slug . '_post_submission',
				'type' => 'radio',
				'desc' => esc_html__( 'Choose whether users can delete posts.', 'aardvark' ),
				'options' => array(
					'enabled' => esc_html__( 'Enabled', 'aardvark' ),
					'disabled' => esc_html__( 'Disabled', 'aardvark' ),
				),
				'default' => 'enabled',	
			),

			/**
			 * Archives - Post Categories
			 *
			 */
			// Title Header
			array(
				'id' => 'cat_title_header_section',
				'title' => esc_html__( 'Title Header', 'aardvark' ),
				'section' => $theme_slug . '_archives',
				'type' => 'section-header',
				'class' => 'gp-setting gp-setting-begin',
			),	
					 
				array( 
					'id' => 'cat_page_header',
					'title' => esc_html__( 'Display', 'aardvark' ),
					'section' => $theme_slug . '_archives',
					'type' => 'select',
					'options' => array(
						'gp-standard-page-header' => esc_html__( 'Standard', 'aardvark' ),
						'gp-fullwidth-page-header' => esc_html__( 'Full Width', 'aardvark' ),
						'gp-full-page-page-header' => esc_html__( 'Full Page', 'aardvark' ),
						'gp-minimal-page-header' => esc_html__( 'Minimal', 'aardvark' ),
						'gp-page-header-disabled' => esc_html__( 'Disabled', 'aardvark' ),
					),	
					'default' => 'gp-standard-page-header',
				),

				array( 
					'id' => 'cat_page_header_height',
					'title' => esc_html__( 'Height', 'aardvark' ),
					'section' => $theme_slug . '_archives',
					'type' => 'dimensions',
					'default' => array(
						'height' => 320,	
					),
				),

			// Layout
			array(
				'id' => 'cat_layout_section',
				'title' => esc_html__( 'Layout', 'aardvark' ),
				'section' => $theme_slug . '_archives',
				'type' => 'section-header',
				'class' => 'gp-setting gp-setting-begin',
			),	
													
				array( 
					'id' => 'cat_layout',
					'title' => esc_html__( 'Display', 'aardvark' ),
					'section' => $theme_slug . '_archives',
					'type' => 'select',
					'options' => array(
						'gp-left-sidebar' => esc_html__( 'Left Sidebar', 'aardvark' ), 
						'gp-right-sidebar' => esc_html__( 'Right Sidebar', 'aardvark' ),
						'gp-both-sidebars' => esc_html__( 'Both Sidebars', 'aardvark' ), 
						'gp-no-sidebar' => esc_html__( 'No Sidebar', 'aardvark' ),
						'gp-fullwidth' => esc_html__( 'Full Width', 'aardvark' ),
					),
					'default' => 'gp-right-sidebar',
				),

				array(
					'id' => 'cat_left_sidebar',				
					'title' => esc_html__( 'Left Sidebar', 'aardvark' ),
					'section' => $theme_slug . '_archives',
					'type'    => 'select',
					'data'    => 'sidebars',
					'default' => 'gp-left-sidebar',
				),

				array(
					'id' => 'cat_right_sidebar',
					'title' => esc_html__( 'Right Sidebar', 'aardvark' ),
					'section' => $theme_slug . '_archives',
					'type'    => 'select',
						'data'    => 'sidebars',
					'default' => 'gp-right-sidebar',
					),
				
			// Format
			array(
				'id' => 'cat_format_section',
				'title' => esc_html__( 'Format', 'aardvark' ),
				'section' => $theme_slug . '_archives',
				'type' => 'section-header',
				'class' => 'gp-setting gp-setting-begin',			
			),
			
				array( 
					'id' => 'cat_format',
					'title' => esc_html__( 'Display', 'aardvark' ),
					'section' => $theme_slug . '_archives',
					'type' => 'select',
					'options' => array(
						'gp-posts-list' => esc_html__( 'List', 'aardvark' ),
						'gp-posts-large' => esc_html__( 'Large', 'aardvark' ),
						'gp-posts-columns-2' => esc_html__( '2 Columns', 'aardvark' ),
						'gp-posts-columns-3' => esc_html__( '3 Columns', 'aardvark' ),
						'gp-posts-columns-4' => esc_html__( '4 Columns', 'aardvark' ),
						'gp-posts-masonry' => esc_html__( 'Masonry', 'aardvark' ),	
					),
					'default' => 'gp-posts-list',
				),
			
				array( 
					'id' => 'cat_style',
					'title' => esc_html__( 'Style', 'aardvark' ),
					'section' => $theme_slug . '_archives',
					'type' => 'select',
					'options' => array(
						'gp-style-classic' => esc_html__( 'Classic', 'aardvark' ),
						'gp-style-modern' => esc_html__( 'Modern', 'aardvark' ),
					),
					'default' => 'gp-style-classic',
				),

			// Ordering
			array(
				'id' => 'cat_ordering_section',
				'title' => esc_html__( 'Ordering', 'aardvark' ),
				'section' => $theme_slug . '_archives',
				'type' => 'section-header',
				'class' => 'gp-setting gp-setting-begin',
			),	
			
				array(  
					'id' => 'cat_orderby',
					'title' => esc_html__( 'Order By', 'aardvark' ),
					'section' => $theme_slug . '_archives',
					'type' => 'select',
					'options' => array(
							'newest' => esc_html__( 'Newest', 'aardvark' ),
							'oldest' => esc_html__( 'Oldest', 'aardvark' ),
							'title_az' => esc_html__( 'Title (A-Z)', 'aardvark' ),
							'title_za' => esc_html__( 'Title (Z-A)', 'aardvark' ),
							'comment_count' => esc_html__( 'Most Comments', 'aardvark' ),
							'views' => esc_html__( 'Most Views', 'aardvark' ),
							'likes' => esc_html__( 'Most Likes', 'aardvark' ),
							'menu_order' => esc_html__( 'Menu Order', 'aardvark' ),
							'rand' => esc_html__( 'Random', 'aardvark' ),
						),
					'default' => 'newest',
					),
							
				array(
					'id' => 'cat_filters',
					'title' => esc_html__( 'Frontend Filter Menus', 'aardvark' ),
					'section' => $theme_slug . '_archives',
					'type'  => 'checkbox',
					'options'   => array(
							'date' => esc_html__( 'Date', 'aardvark' ),
							'title' => esc_html__( 'Title', 'aardvark' ),
							'comment_count' => esc_html__( 'Comment Count', 'aardvark' ),
							'views' => esc_html__( 'Views', 'aardvark' ),
							'likes' => esc_html__( 'Likes', 'aardvark' ),
						),
					'default'   => array(
							'date' => 0,
							'title' => 0,
							'comment_count' => 0,
							'views' => 0,
							'likes' => 0,
						),
					),
			
				array(
					'id' => 'cat_per_page',
					'title' => esc_html__( 'Items Per Page', 'aardvark' ),
					'section' => $theme_slug . '_archives',
					'type' => 'spinner',
					'min' => 1,
					'max' => 999999,
					'default' => 9,
					),

			// Featured image
			array(
				'id' => 'cat_featured_image_section',
				'title' => esc_html__( 'Featured Image', 'aardvark' ),
				'section' => $theme_slug . '_archives',
				'type' => 'section-header',
				'class' => 'gp-setting gp-setting-begin',
			),	
			
				array(
					'id' => 'cat_image_source',
					'title' => esc_html__( 'Image Source', 'aardvark' ),
					'section' => $theme_slug . '_archives',
					'type' => 'text',
					'desc' => esc_html__( 'Enter the meta key for the custom image field you want to use.', 'aardvark' ),
					'default' => '',
					),
		
				array(
					'id' => 'cat_image_size',
					'title' => esc_html__( 'Image Size', 'aardvark' ),
					'section' => $theme_slug . '_archives',
					'type' => 'text',
					'desc' => esc_html__( 'Enter image size e.g. "thumbnail", "medium", "large", "full" or enter size in pixels e.g. 200 x 100 (width x height).', 'aardvark' ),
					'default' => '',
					),

			// Post title
			array(
				'id' => 'cat_post_title_section',
				'title' => esc_html__( 'Post Title', 'aardvark' ),
				'section' => $theme_slug . '_archives',
				'type' => 'section-header',
				'class' => 'gp-setting gp-setting-begin',
			),	
			
				array(
					'id' => 'cat_list_title_classic_typography',
					'title' => esc_html__( 'List Title (Classic)', 'aardvark' ),
					'section' => $theme_slug . '_archives',
					'type'      => 'typography',
					'output' => array( '.gp-loop-title' ),
					'default'   => array(                           	
						'font-family' => 'Roboto',
						'font-backup' => 'Arial, Helvetica, sans-serif',
						'font-size' => array(
							'value' => '16',
						),
						'line-height' => array(
							'value' => '20',
						),
						'font-weight' => '500',
						'subsets' => 'latin',
						'letter-spacing' => array(
							'value' => '0',
						),
						'text-transform' => 'none',
						'color' => '#232323',
					),
				),

				array(
					'id' => 'cat_list_title_modern_typography',
					'title' => esc_html__( 'List Title (Modern)', 'aardvark' ),
					'section' => $theme_slug . '_archives',
					'type'      => 'typography',
					'output' => '.gp-style-modern .gp-loop-title',
					'default'   => array(   	
						'font-size' => array(
							'value' => '20',
						),
						'line-height' => array(
							'value' => '24',
						),
					),
				),

				array(
					'id' => 'cat_large_title_classic_typography',
					'title' => esc_html__( 'Large Title (Classic)', 'aardvark' ),
					'section' => $theme_slug . '_archives',
					'type'      => 'typography',
					'output' => array( '.gp-posts-large .gp-loop-title' ),
					'default'   => array(                           	
							'font-family' => 'Roboto',
							'font-backup' => 'Arial, Helvetica, sans-serif',
							'font-size' => array(
							'value' => '26',
						),
							'line-height' => array(
							'value' => '30',
						),
							'font-weight' => '500',
							'subsets' => 'latin',
							'letter-spacing' => array(
							'value' => '-0.5',
						),
							'text-transform' => 'none',
							'color' => '#232323',
						),
					),

				array(
					'id' => 'cat_large_title_modern_typography',
					'title' => esc_html__( 'Large Title (Modern)', 'aardvark' ),
					'section' => $theme_slug . '_archives',
					'type'      => 'typography',
					'output' => '.gp-posts-large.gp-modern-style .gp-loop-title',
					'default'   => array(    	
							'font-size' => array(
							'value' => '30',
						),
							'line-height' => array(
							'value' => '34',
						),
						),
					),

				array(
					'id' => 'cat_columns_masonry_title_classic_typography',
					'title' => esc_html__( 'Columns/Masonry Title (Classic)', 'aardvark' ),
					'section' => $theme_slug . '_archives',
					'type'      => 'typography',
					'output' => array( '[class*="gp-posts-columns-"] .gp-loop-title, .gp-posts-masonry .gp-loop-title, .gp-large-post .gp-loop-title' ),
					'default'   => array(                           	
							'font-family' => 'Roboto',
							'font-backup' => 'Arial, Helvetica, sans-serif',
							'font-size' => array(
							'value' => '16',
						),
							'line-height' => array(
							'value' => '20',
						),
							'font-weight' => '500',
							'subsets' => 'latin',
							'letter-spacing' => array(
							'value' => '0',
						),
							'text-transform' => 'none',
							'color' => '#232323',
						),
					),

				array(
					'id' => 'cat_columns_masonry_title_modern_typography',
					'title' => esc_html__( 'Columns/Masonry Title (Modern)', 'aardvark' ),
					'section' => $theme_slug . '_archives',
					'type'      => 'typography',
					'output' => array( '[class*="gp-posts-columns-"].gp-style-modern .gp-loop-title, .gp-posts-masonry.gp-style-modern .gp-loop-title, .gp-style-modern .gp-large-post .gp-loop-title' ),
					'default'   => array( 
							'font-size' => array(
							'value' => '20',
						),
							'line-height' => array(
							'value' => '24',
						),
						),
					),
				
				array(
					'id' => 'cat_post_title_link_colors',
					'title' => esc_html__( 'Title Links', 'aardvark' ),
					'section' => $theme_slug . '_archives',
					'type'      => 'link_color',
					'output' => '.gp-loop-title a',
					'default'   => array(
							'regular'       => '#232323',
							'hover'       => '#777',
						),
					),

			// Post meta
			array(
				'id' => 'cat_post_meta_section',
				'title' => esc_html__( 'Post Meta', 'aardvark' ),
				'section' => $theme_slug . '_archives',
				'type' => 'section-header',
				'class' => 'gp-setting gp-setting-begin',
			),	

				array(
					'id' => 'cat_meta',
					'title' => esc_html__( 'Display', 'aardvark' ),
					'section' => $theme_slug . '_archives',
					'type'  => 'checkbox',
					'options'   => array(
							'author' => esc_html__( 'Author', 'aardvark' ),
						'date' => esc_html__( 'Date', 'aardvark' ),
						'comment_count' => esc_html__( 'Comment Count', 'aardvark' ),
						'views' => esc_html__( 'Views', 'aardvark' ),
						'likes' => esc_html__( 'Likes', 'aardvark' ),
						'cats' => esc_html__( 'Categories', 'aardvark' ),
						'tags' => esc_html__( 'Tags', 'aardvark' ),
					),
				'default'   => array(
						'author' => 1,
						'date' => 1, 
						'comment_count' => 1,
						'views' => 0,
						'likes' => 0,
						'cats' => 0,
						'tags' => 0,
					),
				),

				array(
					'id' => 'cat_meta_classic_typography',
					'title' => esc_html__( 'Text (Classic)', 'aardvark' ),
					'section' => $theme_slug . '_archives',
					'type'      => 'typography',
					'output' => '.gp-loop-meta, .gp-loop-meta a, .gp-loop-tags a, .widget .gp-loop-meta, .widget .gp-loop-meta a, .widget .gp-loop-tag a, .gp-footer-widget .widget .gp-loop-meta, .gp-footer-widget .widget .gp-loop-meta a, .gp-footer-widget .widget .gp-loop-tag a, .gp-comment-meta time, .comment-reply-link, #cancel-comment-reply-link, .course-container .gp-loop-meta .course-author, .course-container .gp-loop-meta .course-author a, .gp-loop-meta .sensei-course-meta > span, .gp-loop-meta .lesson-meta > span, .gp-loop-meta .sensei-free-lessons, .gp-loop-meta .sensei-free-lessons a, .woocommerce #reviews #comments ol.comment-list li .comment-text p.meta',
					'default'   => array(
							'font-size' => array(
							'value' => '13',
						),
							'line-height' => array(
							'value' => '16',
						),
							'color' => '#b1b1b1',                           	
							'font-family' => 'Roboto',
							'font-backup' => 'Arial, Helvetica, sans-serif',
							'font-weight' => '400',
							'subsets' => 'latin',
							'letter-spacing' => array(
							'value' => '0',
						),
						),
					),

				array(
					'id' => 'cat_meta_modern_typography',
					'title' => esc_html__( 'Text (Modern)', 'aardvark' ),
					'section' => $theme_slug . '_archives',
					'type'      => 'typography',
					'output' => '.gp-style-modern .gp-loop-meta, .gp-style-modern .gp-loop-meta a, .gp-style-modern .gp-loop-tags a',
					'default'   => array(
							'font-size' => array(
							'value' => '14',
						),
							'line-height' => array(
							'value' => '17',
						),
						),
					),
				
			// Post content
			array(
				'id' => 'cat_post_content_section',
				'title' => esc_html__( 'Post Content', 'aardvark' ),
				'section' => $theme_slug . '_archives',
				'type' => 'section-header',
				'class' => 'gp-setting gp-setting-begin',
			),	
							
				array( 
					'id' => 'cat_content_display',
					'title' => esc_html__( 'Display', 'aardvark' ),
					'section' => $theme_slug . '_archives',
					'type' => 'radio',
					'options' => array(
							'excerpt' => esc_html__( 'Excerpt', 'aardvark' ),
							'full_content' => esc_html__( 'Full Content', 'aardvark' ),
						),
					'default' => 'excerpt',
					),

				array( 
					'id' => 'cat_excerpt_length',
					'title' => esc_html__( 'Excerpt Length', 'aardvark' ),
					'section' => $theme_slug . '_archives',
					'type' => 'spinner',
						'desc' => esc_html__( 'The number of characters in excerpts.', 'aardvark' ),
						'min' => 0,
						'max' => 999999,
					'default' => 200,
					),					
			
				array( 
					'id' => 'cat_alignment',
					'title' => esc_html__( 'Text Alignment', 'aardvark' ),
					'section' => $theme_slug . '_archives',
					'type' => 'select',
					'options' => array(
							'gp-align-left' => esc_html__( 'Left Aligned', 'aardvark' ),
							'gp-align-center' => esc_html__( 'Center Aligned', 'aardvark' ),
						),
					'default' => 'gp-align-left',
					),
				
				array(
					'id' => 'cat_post_text_classic_typography',
					'title' => esc_html__( 'Text (Classic)', 'aardvark' ),
					'section' => $theme_slug . '_archives',
					'type'      => 'typography',
					'output' => array( '.gp-loop-text' ),
					'default'   => array(                           	
							'font-family' => 'Roboto',
							'font-backup' => 'Arial, Helvetica, sans-serif',
							'font-size' => array(
							'value' => '14',
						),
							'line-height' => array(
							'value' => '24',
						),
							'font-weight' => '400',
							'subsets' => 'latin',
							'letter-spacing' => array(
							'value' => '0',
						),
							'text-transform' => 'none',
							'color' => '#777',
						),
					),

				array(
					'id' => 'cat_post_text_modern_typography',
					'title' => esc_html__( 'Text (Modern)', 'aardvark' ),
					'section' => $theme_slug . '_archives',
					'type'      => 'typography',
					'output' => array( '.gp-style-modern .gp-loop-text' ),
					'default'   => array(                           	
							'font-size' => array(
							'value' => '16',
						),
							'line-height' => array(
							'value' => '26',
						),
						),
					),
							  
				array(  
					'id' => 'cat_read_more_link',
					'title' => esc_html__( 'Read More Link', 'aardvark' ),
					'section' => $theme_slug . '_archives',
					'type' => 'radio',
					'options' => array(
							'enabled' => esc_html__( 'Enabled', 'aardvark' ),
							'disabled' => esc_html__( 'Disabled', 'aardvark' ),
						),
					'default' => 'disabled',
					),
			
			// Other
			array(
				'id' => 'cat_other_section',
				'title' => esc_html__( 'Other', 'aardvark' ),
				'section' => $theme_slug . '_archives',
				'type' => 'section-header',
				'class' => 'gp-setting gp-setting-begin',
			),	
			
				array(  
					'id' => 'cat_pagination',
					'title' => esc_html__( 'Pagination', 'aardvark' ),
					'section' => $theme_slug . '_archives',
					'type' => 'select',
						'desc' => esc_html__( 'Filters disabled if using load more button.', 'aardvark' ),
					'options' => array(
							'load-more' => esc_html__( 'Load More Button', 'aardvark' ),
							'page-numbers' => esc_html__( 'Page Numbers', 'aardvark' ),
							'disabled' => esc_html__( 'Disabled', 'aardvark' ),
						),
					'default' => 'page-numbers',
					),

			/**
			 * Archives - Search Results
			 *
			 */
			// Title header
			array(
				'id' => 'search_title_header_section',
				'title' => esc_html__( 'Title Header', 'aardvark' ),
				'section' => $theme_slug . '_archives_search_results',
				'type' => 'section-header',
				'class' => 'gp-setting gp-setting-begin',
			),
							 
				array( 
					'id' => 'search_page_header',
					'title' => esc_html__( 'Display', 'aardvark' ),
					'section' => $theme_slug . '_archives_search_results',
					'type' => 'select',
					'options' => array(
						'gp-standard-page-header' => esc_html__( 'Standard', 'aardvark' ),
						'gp-fullwidth-page-header' => esc_html__( 'Full Width', 'aardvark' ),
						'gp-full-page-page-header' => esc_html__( 'Full Page', 'aardvark' ),
						'gp-minimal-page-header' => esc_html__( 'Minimal', 'aardvark' ),
						'gp-page-header-disabled' => esc_html__( 'Disabled', 'aardvark' ),
					),	
					'default' => 'gp-standard-page-header',
				),

				array(
					'id' => 'search_page_header_bg', 
					'title' => esc_html__( 'Background', 'aardvark' ),
					'section' => $theme_slug . '_archives_search_results',
					'type' => 'media',	
					'format' => 'image',
					'default' => '',
				),

				array( 
					'id' => 'search_page_header_height',
					'title' => esc_html__( 'Height', 'aardvark' ),
					'section' => $theme_slug . '_archives_search_results',
					'type' => 'dimensions',
					'default' => array(
						'height' => 320,
					),		
				),

			// Layout
			array(
				'id' => 'search_layout_section',
				'title' => esc_html__( 'Layout', 'aardvark' ),
				'section' => $theme_slug . '_archives_search_results',
				'type' => 'section-header',
				'class' => 'gp-setting gp-setting-begin',
			),
																		
				array( 
					'id' => 'search_layout',
					'title' => esc_html__( 'Display', 'aardvark' ),
					'section' => $theme_slug . '_archives_search_results',
					'type' => 'select',
					'options' => array(
							'gp-left-sidebar' => esc_html__( 'Left Sidebar', 'aardvark' ), 
							'gp-right-sidebar' => esc_html__( 'Right Sidebar', 'aardvark' ),
							'gp-both-sidebars' => esc_html__( 'Both Sidebars', 'aardvark' ), 
							'gp-no-sidebar' => esc_html__( 'No Sidebar', 'aardvark' ),
							'gp-fullwidth' => esc_html__( 'Full Width', 'aardvark' ),
						),
					'default' => 'gp-right-sidebar',
					),

				array(
					'id' => 'search_left_sidebar',
					'title' => esc_html__( 'Left Sidebar', 'aardvark' ),
					'section' => $theme_slug . '_archives_search_results',
					'type'    => 'select',
						'data'    => 'sidebars',
					'default' => 'gp-left-sidebar',
					),

				array(
					'id' => 'search_right_sidebar',
					'title' => esc_html__( 'Right Sidebar', 'aardvark' ),
					'section' => $theme_slug . '_archives_search_results',
					'type'    => 'select',
						'data'    => 'sidebars',
					'default' => 'gp-right-sidebar',
				),

			// Format
			array(
				'id' => 'search_format_section',
				'title' => esc_html__( 'Format', 'aardvark' ),
				'section' => $theme_slug . '_archives_search_results',
				'type' => 'section-header',
				'class' => 'gp-setting gp-setting-begin',
			),
			
				array( 
					'id' => 'search_format',
					'title' => esc_html__( 'Display', 'aardvark' ),
					'section' => $theme_slug . '_archives_search_results',
					'type' => 'select',
					'options' => array(
							'gp-posts-list' => esc_html__( 'List', 'aardvark' ),
							'gp-posts-large' => esc_html__( 'Large', 'aardvark' ),
							'gp-posts-columns-2' => esc_html__( '2 Columns', 'aardvark' ),
							'gp-posts-columns-3' => esc_html__( '3 Columns', 'aardvark' ),
							'gp-posts-columns-4' => esc_html__( '4 Columns', 'aardvark' ),
							'gp-posts-masonry' => esc_html__( 'Masonry', 'aardvark' ),
						),
					'default' => 'gp-posts-columns-2',
					),
			
				array( 
					'id' => 'search_style',
					'title' => esc_html__( 'Style', 'aardvark' ),
					'section' => $theme_slug . '_archives_search_results',
					'type' => 'select',
					'options' => array(
							'gp-style-classic' => esc_html__( 'Classic', 'aardvark' ),
							'gp-style-modern' => esc_html__( 'Modern', 'aardvark' ),
						),	
					'default' => 'gp-style-classic',
					),

			// Ordering
			array(
				'id' => 'search_ordering_section',
				'title' => esc_html__( 'Ordering', 'aardvark' ),
				'section' => $theme_slug . '_archives_search_results',
				'type' => 'section-header',
				'class' => 'gp-setting gp-setting-begin',
			),
			
				array(  
					'id' => 'search_post_types',
					'title' => esc_html__( 'Post Types', 'aardvark' ),
					'section' => $theme_slug . '_archives_search_results',
					'type' => 'select',
					'format' => 'multi',
					'data' => 'post_types',
					'select2' => true,
					'default' => array( 'post' => 'post' ),
				),

				array(  
					'id' => 'search_orderby',
					'title' => esc_html__( 'Order By', 'aardvark' ),
					'section' => $theme_slug . '_archives_search_results',
					'type' => 'select',
					'options' => array(
						'newest' => esc_html__( 'Newest', 'aardvark' ),
						'oldest' => esc_html__( 'Oldest', 'aardvark' ),
						'title_az' => esc_html__( 'Title (A-Z)', 'aardvark' ),
						'title_za' => esc_html__( 'Title (Z-A)', 'aardvark' ),
						'comment_count' => esc_html__( 'Most Comments', 'aardvark' ),
						'views' => esc_html__( 'Most Views', 'aardvark' ),
						'likes' => esc_html__( 'Most Likes', 'aardvark' ),
						'menu_order' => esc_html__( 'Menu Order', 'aardvark' ),
						'rand' => esc_html__( 'Random', 'aardvark' ),
						'relevance' => esc_html__( 'Relevance', 'aardvark' ),
					),
					'default' => 'relevance',
					),
			
				array(
					'id' => 'search_filters',
					'title' => esc_html__( 'Frontend Filter Menus', 'aardvark' ),
					'section' => $theme_slug . '_archives_search_results',
					'type'  => 'checkbox',
					'options'   => array(
							'relevance' => esc_html__( 'Relevance', 'aardvark' ),
							'date' => esc_html__( 'Date', 'aardvark' ),
							'title' => esc_html__( 'Title', 'aardvark' ),
							'comment_count' => esc_html__( 'Comment Count', 'aardvark' ),
							'views' => esc_html__( 'Views', 'aardvark' ),
							'likes' => esc_html__( 'Likes', 'aardvark' ),
						),
					'default'   => array(
						'relevance' => 0,
						'date' => 0,
						'title' => 0,
						'comment_count' => 0,
						'views' => 0,
						'likes' => 0,
					),
				),

				array(
					'id' => 'search_per_page',				
					'title' => esc_html__( 'Items Per Page', 'aardvark' ),
					'section' => $theme_slug . '_archives_search_results',
					'type' => 'spinner',
					'min' => 1,
					'max' => 999999,
					'default' => 8,
				),

			// Featured image
			array(
				'id' => 'search_featured_image_section',
				'title' => esc_html__( 'Featured Image', 'aardvark' ),
				'section' => $theme_slug . '_archives_search_results',
				'type' => 'section-header',
				'class' => 'gp-setting gp-setting-begin',
			),
			
				array(
					'id' => 'search_image_source',
					'title' => esc_html__( 'Image Source', 'aardvark' ),
					'section' => $theme_slug . '_archives_search_results',
					'type' => 'text',
					'desc' => esc_html__( 'Enter the meta key for the custom image field you want to use.', 'aardvark' ),
					'default' => '',
				),

				array(
					'id' => 'search_image_size',
					'title' => esc_html__( 'Image Size', 'aardvark' ),
					'section' => $theme_slug . '_archives_search_results',
					'type' => 'text',
					'desc' => esc_html__( 'Enter image size e.g. "thumbnail", "medium", "large", "full" or enter size in pixels e.g. 200 x 100 (width x height).', 'aardvark' ),
					'default' => '',
				),
			
			// Post meta
			array(
				'id' => 'search_post_meta_section',
				'title' => esc_html__( 'Post Meta', 'aardvark' ),
				'section' => $theme_slug . '_archives_search_results',
				'type' => 'section-header',
				'class' => 'gp-setting gp-setting-begin',
			),
							
				array(
					'id' => 'search_meta',				
					'title' => esc_html__( 'Display', 'aardvark' ),
					'section' => $theme_slug . '_archives_search_results',
					'type'  => 'checkbox',
					'options'   => array(
							'author' => esc_html__( 'Author', 'aardvark' ),
							'date' => esc_html__( 'Date', 'aardvark' ),
							'comment_count' => esc_html__( 'Comment Count', 'aardvark' ),
							'views' => esc_html__( 'Views', 'aardvark' ),
							'likes' => esc_html__( 'Likes', 'aardvark' ),
							'cats' => esc_html__( 'Categories', 'aardvark' ),
							'tags' => esc_html__( 'Tags', 'aardvark' ),
						),
					'default'   => array(
							'author' => 1,
							'date' => 1, 
							'comment_count' => 1,
							'views' => 0,
							'likes' => 0,
							'cats' => 0,
							'tags' => 0,
						),
					),
				
			// Post content
			array(
				'id' => 'search_post_content_section',
				'title' => esc_html__( 'Post Content', 'aardvark' ),
				'section' => $theme_slug . '_archives_search_results',
				'type' => 'section-header',
				'class' => 'gp-setting gp-setting-begin',
			),
			
				array( 
					'id' => 'search_content_display',
					'title' => esc_html__( 'Display', 'aardvark' ),
					'section' => $theme_slug . '_archives_search_results',
					'type' => 'radio',
					'options' => array(
							'excerpt' => esc_html__( 'Excerpt', 'aardvark' ),
							'full_content' => esc_html__( 'Full Content', 'aardvark' ),
						),
					'default' => 'excerpt',
					),

				array( 
					'id' => 'search_excerpt_length',
					'title' => esc_html__( 'Excerpt Length', 'aardvark' ),
					'section' => $theme_slug . '_archives_search_results',
					'type' => 'spinner',
					'desc' => esc_html__( 'The number of characters in excerpts.', 'aardvark' ),
					'min' => 0,
					'max' => 999999,
					'default' => 0,
					),
			
				array( 
					'id' => 'search_alignment',
					'title' => esc_html__( 'Text Alignment', 'aardvark' ),
					'section' => $theme_slug . '_archives_search_results',
					'type' => 'select',
					'options' => array(
							'gp-align-left' => esc_html__( 'Left Aligned', 'aardvark' ),
							'gp-align-center' => esc_html__( 'Center Aligned', 'aardvark' ),
						),
					'default' => 'gp-align-left',
					),
										   
				array(  
					'id' => 'search_read_more_link',
					'title' => esc_html__( 'Read More Link', 'aardvark' ),
					'section' => $theme_slug . '_archives_search_results',
					'type' => 'radio',
					'options' => array(
							'enabled' => esc_html__( 'Enabled', 'aardvark' ),
							'disabled' => esc_html__( 'Disabled', 'aardvark' ),
						),
					'default' => 'disabled',
					),

			// Other
			array(
				'id' => 'search_other_section',
				'title' => esc_html__( 'Other', 'aardvark' ),
				'section' => $theme_slug . '_archives_search_results',
				'type' => 'section-header',
				'class' => 'gp-setting gp-setting-begin',
			),
			
				array(  
					'id' => 'search_pagination',
					'title' => esc_html__( 'Pagination', 'aardvark' ),
					'section' => $theme_slug . '_archives_search_results',
					'type' => 'select',
						'desc' => esc_html__( 'Filters disabled if using load more button.', 'aardvark' ),
					'options' => array(
							'load-more' => esc_html__( 'Load More Button', 'aardvark' ),
							'page-numbers' => esc_html__( 'Page Numbers', 'aardvark' ),
							'disabled' => esc_html__( 'Disabled', 'aardvark' ),
						),
					'default' => 'page-numbers',
					),
		
			/**
			 * Archives - Author Posts
			 *
			 */
			// Title Header
			array(
				'id' => 'search_title_header_section',
				'title' => esc_html__( 'Title Header', 'aardvark' ),
				'section' => $theme_slug . '_archives_author_posts',
				'type' => 'section-header',
				'class' => 'gp-setting gp-setting-begin',
			),
			
				array( 
					'id' => 'author_page_header',
					'title' => esc_html__( 'Display', 'aardvark' ),
					'section' => $theme_slug . '_archives_author_posts',
					'type' => 'select',
					'options' => array(
						'gp-standard-page-header' => esc_html__( 'Standard', 'aardvark' ),
						'gp-fullwidth-page-header' => esc_html__( 'Full Width', 'aardvark' ),
						'gp-full-page-page-header' => esc_html__( 'Full Page', 'aardvark' ),
						'gp-minimal-page-header' => esc_html__( 'Minimal', 'aardvark' ),
						'gp-page-header-disabled' => esc_html__( 'Disabled', 'aardvark' ),
					),
					'default' => 'gp-standard-page-header',
				),

				array(
					'id' => 'author_page_header_bg', 
					'title' => esc_html__( 'Background', 'aardvark' ),
					'section' => $theme_slug . '_archives_author_posts',
					'type'  => 'media',			
					'format' => 'image',	
					'default' => '',
					),

				array( 
					'id' => 'author_page_header_height',
					'title' => esc_html__( 'Height', 'aardvark' ),
					'section' => $theme_slug . '_archives_author_posts',
					'type' => 'dimensions',
					'default' => array(
						'height' => 320,
					),	
				 ),

			// Layout
			array(
				'id' => 'author_layout_section',
				'title' => esc_html__( 'Layout', 'aardvark' ),
				'section' => $theme_slug . '_archives_author_posts',
				'type' => 'section-header',
				'class' => 'gp-setting gp-setting-begin',
			),
																	
				array( 
					'id' => 'author_layout',
					'title' => esc_html__( 'Display', 'aardvark' ),
					'section' => $theme_slug . '_archives_author_posts',
					'type' => 'select',
					'options' => array(
							'gp-left-sidebar' => esc_html__( 'Left Sidebar', 'aardvark' ), 
							'gp-right-sidebar' => esc_html__( 'Right Sidebar', 'aardvark' ),
							'gp-both-sidebars' => esc_html__( 'Both Sidebars', 'aardvark' ), 
							'gp-no-sidebar' => esc_html__( 'No Sidebar', 'aardvark' ),
							'gp-fullwidth' => esc_html__( 'Full Width', 'aardvark' ),
						),
					'default' => 'gp-right-sidebar',
					),

				array(
					'id' => 'author_left_sidebar',
					'title' => esc_html__( 'Left Sidebar', 'aardvark' ),
					'section' => $theme_slug . '_archives_author_posts',
					'type'    => 'select',
						'data'    => 'sidebars',
					'default' => 'gp-left-sidebar',
					),

				array(
					'id' => 'author_right_sidebar',				
					'title' => esc_html__( 'Right Sidebar', 'aardvark' ),
					'section' => $theme_slug . '_archives_author_posts',
					'type'    => 'select',
						'data'    => 'sidebars',
					'default' => 'gp-right-sidebar',
					),

			// Format
			array(
				'id' => 'author_format_section',
				'title' => esc_html__( 'Format', 'aardvark' ),
				'section' => $theme_slug . '_archives_author_posts',
				'type' => 'section-header',
				'class' => 'gp-setting gp-setting-begin',
			),
			
				array( 
					'id' => 'author_format',
					'title' => esc_html__( 'Display', 'aardvark' ),
					'section' => $theme_slug . '_archives_author_posts',
					'type' => 'select',
					'options' => array(
							'gp-posts-list' => esc_html__( 'List', 'aardvark' ),
							'gp-posts-large' => esc_html__( 'Large', 'aardvark' ),
							'gp-posts-columns-2' => esc_html__( '2 Columns', 'aardvark' ),
							'gp-posts-columns-3' => esc_html__( '3 Columns', 'aardvark' ),
							'gp-posts-columns-4' => esc_html__( '4 Columns', 'aardvark' ),
							'gp-posts-masonry' => esc_html__( 'Masonry', 'aardvark' ),
						),
					'default' => 'gp-posts-list',
					),

				array( 
					'id' => 'author_style',
					'title' => esc_html__( 'Style', 'aardvark' ),
					'section' => $theme_slug . '_archives_author_posts',
					'type' => 'select',
					'options' => array(
							'gp-style-classic' => esc_html__( 'Classic', 'aardvark' ),
							'gp-style-modern' => esc_html__( 'Modern', 'aardvark' ),
						),
					'default' => 'gp-style-classic',
					),						
		
			// Ordering
			array(
				'id' => 'author_ordering_section',
				'title' => esc_html__( 'Ordering', 'aardvark' ),
				'section' => $theme_slug . '_archives_author_posts',
				'type' => 'section-header',
				'class' => 'gp-setting gp-setting-begin',
			),

				array(  
					'id' => 'author_post_types',
					'title' => esc_html__( 'Post Types', 'aardvark' ),
					'section' => $theme_slug . '_archives_author_posts',
					'type' => 'select',
					'format' => 'multi',
					'data' => 'post_types',
					'select2' => true,
					'default' => array( 'post' => 'post' ),
					),

				array(  
					'id' => 'author_orderby',
					'title' => esc_html__( 'Order By', 'aardvark' ),
					'section' => $theme_slug . '_archives_author_posts',
					'type' => 'select',
					'options' => array(
							'newest' => esc_html__( 'Newest', 'aardvark' ),
							'oldest' => esc_html__( 'Oldest', 'aardvark' ),
							'title_az' => esc_html__( 'Title (A-Z)', 'aardvark' ),
							'title_za' => esc_html__( 'Title (Z-A)', 'aardvark' ),
							'comment_count' => esc_html__( 'Most Comments', 'aardvark' ),
							'views' => esc_html__( 'Most Views', 'aardvark' ),
							'likes' => esc_html__( 'Most Likes', 'aardvark' ),
							'menu_order' => esc_html__( 'Menu Order', 'aardvark' ),
							'rand' => esc_html__( 'Random', 'aardvark' ),
							'relevance' => esc_html__( 'Relevance', 'aardvark' ),
						),
					'default' => 'newest',
					),

				array(
					'id' => 'author_filters',
					'title' => esc_html__( 'Frontend Filter Menus', 'aardvark' ),
					'section' => $theme_slug . '_archives_author_posts',
					'type'  => 'checkbox',
					'options'   => array(
							'date' => esc_html__( 'Date', 'aardvark' ),
							'title' => esc_html__( 'Title', 'aardvark' ),
							'comment_count' => esc_html__( 'Comment Count', 'aardvark' ),
							'views' => esc_html__( 'Views', 'aardvark' ),
							'likes' => esc_html__( 'Likes', 'aardvark' ),
						),
					'default'   => array(
							'date' => 0,
							'title' => 0,
							'comment_count' => 0,
							'views' => 0,
							'likes' => 0,
						),
					),
			
				array(
					'id' => 'author_per_page',				
					'title' => esc_html__( 'Items Per Page', 'aardvark' ),
					'section' => $theme_slug . '_archives_author_posts',
					'type' => 'spinner',
					'min' => 1,
					'max' => 999999,
					'default' => 8,
				),

			// Featured Image
			array(
				'id' => 'author_featured_image_section',
				'title' => esc_html__( 'Featured Image', 'aardvark' ),
				'section' => $theme_slug . '_archives_author_posts',
				'type' => 'section-header',
				'class' => 'gp-setting gp-setting-begin',
			),
			
				array(
					'id' => 'author_image_source',
					'title' => esc_html__( 'Image Source', 'aardvark' ),
					'section' => $theme_slug . '_archives_author_posts',
					'type' => 'text',
						'desc' => esc_html__( 'Enter the meta key for the custom image field you want to use.', 'aardvark' ),
					'default' => '',
					),

				array(
					'id' => 'author_image_size',
					'title' => esc_html__( 'Image Size', 'aardvark' ),
					'section' => $theme_slug . '_archives_author_posts',
					'type' => 'text',
						'desc' => esc_html__( 'Enter image size e.g. "thumbnail", "medium", "large", "full" or enter size in pixels e.g. 200 x 100 (width x height).', 'aardvark' ),
					'default' => '',
					),

			// Post meta
			array(
				'id' => 'author_post_meta_section',
				'title' => esc_html__( 'Post Meta', 'aardvark' ),
				'section' => $theme_slug . '_archives_author_posts',
				'type' => 'section-header',
				'class' => 'gp-setting gp-setting-begin',
			),

				array(
					'id' => 'author_meta',
					'title' => esc_html__( 'Display', 'aardvark' ),
					'section' => $theme_slug . '_archives_author_posts',
					'type'  => 'checkbox',
					'options'   => array(
						'author' => esc_html__( 'Author', 'aardvark' ),
						'date' => esc_html__( 'Date', 'aardvark' ),
						'comment_count' => esc_html__( 'Comment Count', 'aardvark' ),
						'views' => esc_html__( 'Views', 'aardvark' ),
						'likes' => esc_html__( 'Likes', 'aardvark' ),
						'cats' => esc_html__( 'Categories', 'aardvark' ),
						'tags' => esc_html__( 'Tags', 'aardvark' ),
					),
					'default'   => array(
						'author' => 1,
						'date' => 1, 
						'comment_count' => 1,
						'views' => 0,
						'likes' => 0,
						'cats' => 0,
						'tags' => 0,
					),
				),
						
			// Post content
			array(
				'id' => 'author_post_content_section',
				'title' => esc_html__( 'Post Content', 'aardvark' ),
				'section' => $theme_slug . '_archives_author_posts',
				'type' => 'section-header',
				'class' => 'gp-setting gp-setting-begin',
			),
			
				array( 
					'id' => 'author_content_display',
					'title' => esc_html__( 'Display', 'aardvark' ),
					'section' => $theme_slug . '_archives_author_posts',
					'type' => 'radio',
					'options' => array(
							'excerpt' => esc_html__( 'Excerpt', 'aardvark' ),
							'full_content' => esc_html__( 'Full Content', 'aardvark' ),
						),
					'default' => 'excerpt',
					),

				array( 
					'id' => 'author_excerpt_length',
					'title' => esc_html__( 'Excerpt Length', 'aardvark' ),
					'section' => $theme_slug . '_archives_author_posts',
					'type' => 'spinner',
					'desc' => esc_html__( 'The number of characters in excerpts.', 'aardvark' ),
					'min' => 0,
					'max' => 999999,
					'default' => 0,
				),

				array( 
					'id' => 'author_alignment',
					'title' => esc_html__( 'Text Alignment', 'aardvark' ),
					'section' => $theme_slug . '_archives_author_posts',
					'type' => 'select',
					'options' => array(
							'gp-align-left' => esc_html__( 'Left Aligned', 'aardvark' ),
							'gp-align-center' => esc_html__( 'Center Aligned', 'aardvark' ),
						),
					'default' => 'gp-align-left',
					),
									   
				array(  
					'id' => 'author_read_more_link',
					'title' => esc_html__( 'Read More Link', 'aardvark' ),
					'section' => $theme_slug . '_archives_author_posts',
					'type' => 'radio',
					'options' => array(
							'enabled' => esc_html__( 'Enabled', 'aardvark' ),
							'disabled' => esc_html__( 'Disabled', 'aardvark' ),
						),
					'default' => 'disabled',
					),

			// Other
			array(
				'id' => 'author_other_section',
				'title' => esc_html__( 'Other', 'aardvark' ),
				'section' => $theme_slug . '_archives_author_posts',
				'type' => 'section-header',
				'class' => 'gp-setting gp-setting-begin',
			),
			
				array(  
					'id' => 'author_pagination',
					'title' => esc_html__( 'Pagination', 'aardvark' ),
					'section' => $theme_slug . '_archives_author_posts',
					'type' => 'select',
					'desc' => esc_html__( 'Filters disabled if using load more button.', 'aardvark' ),
					'options' => array(
						'load-more' => esc_html__( 'Load More Button', 'aardvark' ),
						'page-numbers' => esc_html__( 'Page Numbers', 'aardvark' ),
						'disabled' => esc_html__( 'Disabled', 'aardvark' ),
					),
					'default' => 'page-numbers',
				),

			/**
			 * Membership
			 *
			 */
			// Frontend
			 array(
				'id' => '_section_membership_frontend',
				'title' => esc_html__( 'Frontend', 'aardvark' ),
				'section' => $theme_slug . '_membership',
				'label_for' => 'gp-section-header',	
				'type' => 'section-header',
				'class' => 'gp-setting gp-setting-begin',	 
			),
				array(
					'id' => 'login_register_popup_redirect',
					'title' => esc_html__( 'Frontend Popup Form', 'aardvark' ),
					'section' => $theme_slug . '_membership',
					'desc' => esc_html__( 'Show the login/register/lost password popup window. Add "#login", "#register" and "#lost-password" to the end of your URL e.g. http://domain.com/#login', 'aardvark' ),
					'type' => 'radio',
					'options'   => array(
						'enabled' => esc_html__( 'Enabled', 'aardvark' ),
						'disabled' => esc_html__( 'Disabled', 'aardvark' ),
					),
					'default'   => 'enabled',			
				),
				array(
					'id' => 'login_page',
					'title' => esc_html__( 'Login Page', 'aardvark' ),
					'section' => $theme_slug . '_membership',
					'desc' => esc_html__( 'Your login page (e.g. the page that includes the Login/Register Form element).', 'aardvark' ),
					'type' => 'select',
					'data' => 'pages',
					'select2' => true,	
					'conditions' => array(
						'login_register_popup_redirect' => 'disabled',
					),
				),
				array(
					'id' => 'login_register_page_redirect',
					'title' => esc_html__( 'Frontend Restriction Redirect', 'aardvark' ),
					'section' => $theme_slug . '_membership',
					'desc' => esc_html__( 'Redirect non logged in users to this page before they can access the site (e.g. login page).', 'aardvark' ),
					'type' => 'select',
					'data' => 'pages',
					'select2' => true,
				),
				array(
					'id' => 'login_register_page_redirect_exclusion',
					'title' => esc_html__( 'Frontend Restriction Redirect Exclusions', 'aardvark' ),
					'section' => $theme_slug . '_membership',
					'desc' => esc_html__( 'Exclude specific pages from frontend redirection.', 'aardvark' ),
					'type' => 'select',
					'format' => 'multi',
					'data' => 'pages',
					'select2' => true,
				),
				array(
					'id' => 'login_register_page_redirect_url_exclusion',
					'title' => esc_html__( 'Frontend Restriction Redirect URL Exclusions', 'aardvark' ),
					'section' => $theme_slug . '_membership',
					'desc' => esc_html__( 'Exclude specific URLs from frontend redirection, add each URL on a new line.', 'aardvark' ),
					'type' => 'textarea',
				),
				array(
					'id' => 'members_homepage',
					'title' => esc_html__( 'Members Homepage', 'aardvark' ),
					'section' => $theme_slug . '_membership',
					'desc' => esc_html__( 'The homepage members see. To set the homepage for non logged in users click', 'aardvark' ) . ' <a href="' . admin_url( 'options-reading.php' ) . '" target="_blank">' . esc_html__( 'here', 'aardvark' ) . '</a>. ' . esc_html__( 'Install the Paid Memberships Pro plugin to set the homepage for different membership levels.', 'aardvark' ),
					'type' => 'select',
					'data' => 'pages',
					'default_pages' => array( 'dashboard', 'profile', 'author' ),
					'select2' => true,
				),
				array(
					'id' => 'login_redirect',
					'title' => esc_html__( 'Member Login Redirect', 'aardvark' ),
					'section' => $theme_slug . '_membership',
					'desc' => esc_html__( 'Redirect the user to this page after logging in, leave empty to redirect to the page they logged in from.', 'aardvark' ),
					'type' => 'select',
					'data' => 'pages',
					'default_pages' => array( 'dashboard', 'profile', 'author' ),
					'select2' => true,
				),
				array(
					'id' => 'login_redirect_admin',
					'title' => esc_html__( 'Admin Login Redirect', 'aardvark' ),
					'section' => $theme_slug . '_membership',
					'desc' => esc_html__( 'Redirect the admin to this page after logging in, leave empty to redirect to the page they logged in from.', 'aardvark' ),
					'type' => 'select',
					'data' => 'pages',
					'default_pages' => array( 'dashboard', 'profile', 'author' ),
					'select2' => true,
				),
				array(
					'id' => 'registration_gdpr',
					'title' => esc_html__( 'Registration Privacy Policy Checkbox (GDPR)', 'aardvark' ),
					'section' => $theme_slug . '_membership',
					'desc' => esc_html__( 'Add a privacy policy checkbox to the theme\'s registration form (this does not add a checkbox to the BuddyPress or Paid Membership Pro registration pages).', 'aardvark' ),
					'type' => 'radio',
					'options'   => array(
						'enabled' => esc_html__( 'Enabled', 'aardvark' ),
						'disabled' => esc_html__( 'Disabled', 'aardvark' )
					),
					'default'   => 'disabled',
				),
				array(
					'id' => 'registration_gdpr_text',
					'title' => esc_html__( 'Registration Privacy Policy Text', 'aardvark' ),
					'section' => $theme_slug . '_membership',				
					'desc' => esc_html__( 'Add your own privacy policy text next to the checkbox. To add a link within your text use HTML tags e.g. "This is my text and this is a <a href="http://domain.com/privacy-policy">link</a>."', 'aardvark' ),
					'type' => 'textarea',
					'conditions' => array(
						'registration_gdpr' => 'enabled',
					),
				),

			// Backend
			array(
				'id' => '_section_membership_backend',
				'title' => esc_html__( 'Backend', 'aardvark' ),
				'section' => $theme_slug . '_membership',
				'label_for' => 'gp-section-header',	
				'type' => 'section-header',
				'class' => 'gp-setting gp-setting-begin',	 
			),
				array(
					'id' => 'login_register_popup_backend_redirect',
					'title' => esc_html__( 'Backend Popup Form', 'aardvark' ),
					'section' => $theme_slug . '_membership',
					'desc' => esc_html__( 'Redirect to the homepage and show the login popup window when a user tries to access the backend.', 'aardvark' ),
					'type' => 'radio',
					'options'   => array(
						'enabled' => esc_html__( 'Enabled', 'aardvark' ),
						'disabled' => esc_html__( 'Disabled', 'aardvark' )
					),
					'default'   => 'disabled',	
				),	
				array(
					'id' => 'login_register_page_backend_redirect',
					'title' => esc_html__( 'Backend Restriction Redirect', 'aardvark' ),
					'section' => $theme_slug . '_membership',
					'desc' => esc_html__( 'Redirect non logged in users to this page (e.g. login page) before they can access the backend. ', 'aardvark' ),
					'type' => 'select',
					'data' => 'pages',
					'select2' => true,			
				),		
						
			/**
			 * Buddypress
			 *
			 */	

			/**
			 * BuddyPress - General
			 *
			 */
			// Main header
			array(
				'id' => 'bp_main_header_section',
				'title' => esc_html__( 'Main Header', 'aardvark' ),
				'section' => $theme_slug . '_buddypress',
				'label_for' => 'gp-section-header',	
				'type' => 'section-header',
				'class' => 'gp-setting gp-setting-begin',	 
			),
			
				array( 
					'id' => 'bp_header_layout',
					'title' => esc_html__( 'Layout', 'aardvark' ),
					'section' => $theme_slug . '_buddypress',
					'type' => 'image_select',
					'options' => array( 
						'default' => array( esc_html__( 'Default', 'aardvark' ), 'img' => get_template_directory_uri() . '/lib/framework/settings/images/default.jpg' ),
						'gp-header-logo-left-1' => array( esc_html__( 'Header 1', 'aardvark' ), 'img' => get_template_directory_uri() . '/lib/framework/settings/images/logo-left-1.jpg' ),
						'gp-header-logo-left-2' => array( esc_html__( 'Header 2', 'aardvark' ), 'img' => get_template_directory_uri() . '/lib/framework/settings/images/logo-left-2.jpg' ),
						'gp-header-logo-right-1' => array( esc_html__( 'Header 3', 'aardvark' ), 'img' => get_template_directory_uri() . '/lib/framework/settings/images/logo-right-1.jpg' ),
						'gp-header-nav-bottom-1' => array( esc_html__( 'Header 4', 'aardvark' ), 'img' => get_template_directory_uri() . '/lib/framework/settings/images/nav-bottom-1.jpg' ),
						'gp-header-nav-bottom-2' => array( esc_html__( 'Header 5', 'aardvark' ), 'img' => get_template_directory_uri() . '/lib/framework/settings/images/nav-bottom-2.jpg' ),
						'gp-header-nav-bottom-3' => array( esc_html__( 'Header 6', 'aardvark' ), 'img' => get_template_directory_uri() . '/lib/framework/settings/images/nav-bottom-3.jpg' ),
						'gp-header-side-menu' => array( esc_html__( 'Header 7', 'aardvark' ), 'img' => get_template_directory_uri() . '/lib/framework/settings/images/side-menu.jpg' ),
					),
					'default' => 'default',
				),

			// Title header
			array(
				'id' => 'bp_title_header_section',
				'title' => esc_html__( 'Title Header', 'aardvark' ),
				'section' => $theme_slug . '_buddypress',
				'label_for' => 'gp-section-header',	
				'type' => 'section-header',
				'class' => 'gp-setting gp-setting-begin',
			),
			
				array( 
					'id' => 'bp_page_header',
					'title' => esc_html__( 'Display', 'aardvark' ),
					'section' => $theme_slug . '_buddypress',
					'type' => 'select',
					'options' => array(
						'gp-standard-page-header' => esc_html__( 'Standard', 'aardvark' ),
						'gp-fullwidth-page-header' => esc_html__( 'Full Width', 'aardvark' ),
						'gp-full-page-page-header' => esc_html__( 'Full Page', 'aardvark' ),
						'gp-minimal-page-header' => esc_html__( 'Minimal', 'aardvark' ),
						'gp-page-header-disabled' => esc_html__( 'Disabled', 'aardvark' ),
					),
					'default' => 'gp-standard-page-header',
				),

				array(
					'id' => 'bp_page_header_bg', 
					'title' => esc_html__( 'Background', 'aardvark' ),
					'section' => $theme_slug . '_buddypress',
					'type'  => 'media',
					'default' => '',
				),

				array( 
					'id' => 'bp_page_header_height',
					'title' => esc_html__( 'Height', 'aardvark' ),
					'section' => $theme_slug . '_buddypress',
					'type' => 'dimensions',
					'default' => array(
						'height' => 320,	
					),	
				),

			// Layout
			array(
				'id' => 'bp_layout_section',
				'title' => esc_html__( 'Layout', 'aardvark' ),
				'section' => $theme_slug . '_buddypress',
				'label_for' => 'gp-section-header',	
				'type' => 'section-header',
				'class' => 'gp-setting gp-setting-begin',
			),
			
				array( 
					'id' => 'bp_layout',
					'title' => esc_html__( 'Display', 'aardvark' ),	
					'section' => $theme_slug . '_buddypress',
					'type' => 'select',
					'options' => array(
						'gp-left-sidebar' => esc_html__( 'Left Sidebar', 'aardvark' ), 
						'gp-right-sidebar' => esc_html__( 'Right Sidebar', 'aardvark' ),
						'gp-both-sidebars' => esc_html__( 'Both Sidebars', 'aardvark' ), 
						'gp-no-sidebar' => esc_html__( 'No Sidebar', 'aardvark' ),
						'gp-fullwidth' => esc_html__( 'Full Width', 'aardvark' ),
					),
					'default' => 'gp-right-sidebar',
				),

				array(
					'id' => 'bp_left_sidebar',
					'title' => esc_html__( 'Left Sidebar', 'aardvark' ),
					'section' => $theme_slug . '_buddypress',
					'type'    => 'select',
					'data'    => 'sidebars',
					'default' => 'gp-left-sidebar',
				),

				array(
					'id' => 'bp_right_sidebar',
					'title' => esc_html__( 'Right Sidebar', 'aardvark' ),
					'section' => $theme_slug . '_buddypress',
					'type'    => 'select',
						'data'    => 'sidebars',
					'default' => 'gp-right-sidebar',
				),

			/**
			 * BuddyPress - Activity Page
			 *
			 */
			// Main header
			array(
				'id' => 'bp_activity_main_header_section',
				'title' => esc_html__( 'Main Header', 'aardvark' ),
				'section' => $theme_slug . '_buddypress_activity_page',
				'label_for' => 'gp-section-header',	
				'type' => 'section-header',
				'class' => 'gp-setting gp-setting-begin',
			),	
				
				array( 
					'id' => 'bp_activity_header_layout',
					'title' => esc_html__( 'Layout', 'aardvark' ),
					'section' => $theme_slug . '_buddypress_activity_page',
					'type' => 'image_select',
					'options' => array( 
					'default' => array( esc_html__( 'Default', 'aardvark' ), 'img' => get_template_directory_uri() . '/lib/framework/settings/images/default.jpg' ),
						'gp-header-logo-left-1' => array( esc_html__( 'Header 1', 'aardvark' ), 'img' => get_template_directory_uri() . '/lib/framework/settings/images/logo-left-1.jpg' ),
						'gp-header-logo-left-2' => array( esc_html__( 'Header 2', 'aardvark' ), 'img' => get_template_directory_uri() . '/lib/framework/settings/images/logo-left-2.jpg' ),
						'gp-header-logo-right-1' => array( esc_html__( 'Header 3', 'aardvark' ), 'img' => get_template_directory_uri() . '/lib/framework/settings/images/logo-right-1.jpg' ),
						'gp-header-nav-bottom-1' => array( esc_html__( 'Header 4', 'aardvark' ), 'img' => get_template_directory_uri() . '/lib/framework/settings/images/nav-bottom-1.jpg' ),
						'gp-header-nav-bottom-2' => array( esc_html__( 'Header 5', 'aardvark' ), 'img' => get_template_directory_uri() . '/lib/framework/settings/images/nav-bottom-2.jpg' ),
						'gp-header-nav-bottom-3' => array( esc_html__( 'Header 6', 'aardvark' ), 'img' => get_template_directory_uri() . '/lib/framework/settings/images/nav-bottom-3.jpg' ),
						'gp-header-side-menu' => array( esc_html__( 'Header 7', 'aardvark' ), 'img' => get_template_directory_uri() . '/lib/framework/settings/images/side-menu.jpg' ),
					),
					'default' => 'default',
				),

			// Title header
			array(
				'id' => 'bp_activity_title_header_section',
				'title' => esc_html__( 'Title Header', 'aardvark' ),
				'section' => $theme_slug . '_buddypress_activity_page',
				'label_for' => 'gp-section-header',	
				'type' => 'section-header',
				'class' => 'gp-setting gp-setting-begin',
			),	
			
				array( 
					'id' => 'bp_activity_page_header',
					'title' => esc_html__( 'Display', 'aardvark' ),
					'section' => $theme_slug . '_buddypress_activity_page',
					'type' => 'select',
					'options' => array(
						'default' => esc_html__( 'Default', 'aardvark' ),
						'gp-standard-page-header' => esc_html__( 'Standard', 'aardvark' ),
						'gp-fullwidth-page-header' => esc_html__( 'Full Width', 'aardvark' ),
						'gp-full-page-page-header' => esc_html__( 'Full Page', 'aardvark' ),
						'gp-minimal-page-header' => esc_html__( 'Minimal', 'aardvark' ),
						'gp-page-header-disabled' => esc_html__( 'Disabled', 'aardvark' ),
					),
					'default' => 'gp-standard-page-header',
				),

				array(
					'id' => 'bp_activity_page_header_bg', 
					'title' => esc_html__( 'Background', 'aardvark' ),
					'section' => $theme_slug . '_buddypress_activity_page',
					'type'  => 'media',			
					'default' => '',
				),

				array( 
					'id' => 'bp_activity_page_header_height',
					'title' => esc_html__( 'Height', 'aardvark' ),
					'section' => $theme_slug . '_buddypress_activity_page',
					'type' => 'dimensions',
					'default' => array(
						'height' => '',
					),
				),
	
			// Layout
			array(
				'id' => 'bp_activity_layout_section',
				'title' => esc_html__( 'Layout', 'aardvark' ),
				'section' => $theme_slug . '_buddypress_activity_page',
				'label_for' => 'gp-section-header',	
					'type' => 'section-header',
				'class' => 'gp-setting gp-setting-begin',
			),	
									
				array( 
					'id' => 'bp_activity_layout',
					'title' => esc_html__( 'Display', 'aardvark' ),
					'section' => $theme_slug . '_buddypress_activity_page',
					'type' => 'select',
					'options' => array(
						'default' => esc_html__( 'Default', 'aardvark' ),
						'gp-left-sidebar' => esc_html__( 'Left Sidebar', 'aardvark' ), 
						'gp-right-sidebar' => esc_html__( 'Right Sidebar', 'aardvark' ),
						'gp-both-sidebars' => esc_html__( 'Both Sidebars', 'aardvark' ), 
						'gp-no-sidebar' => esc_html__( 'No Sidebar', 'aardvark' ),
						'gp-fullwidth' => esc_html__( 'Full Width', 'aardvark' ),
					),
					'default' => 'default',
				),

				array(
					'id' => 'bp_activity_left_sidebar',
					'title' => esc_html__( 'Left Sidebar', 'aardvark' ),
					'section' => $theme_slug . '_buddypress_activity_page',
					'type' => 'select',
					'data' => 'sidebars',
					'default'  => 'default',
				),

				array(
					'id' => 'bp_activity_right_sidebar',
					'title' => esc_html__( 'Right Sidebar', 'aardvark' ),
					'section' => $theme_slug . '_buddypress_activity_page',
					'type' => 'select',
					'data' => 'sidebars',
					'default'  => 'default',
				),
			
			// Stream
			array(
				'id' => 'bp_activity_stream_section',
				'title' => esc_html__( 'Stream', 'aardvark' ),
				'section' => $theme_slug . '_buddypress_activity_page',
				'label_for' => 'gp-section-header',	
				'type' => 'section-header',
				'class' => 'gp-setting gp-setting-begin',
			),	
			
				array(
					'id' => 'bp_activity_list_bg',
					'title' => esc_html__( 'Background', 'aardvark' ),
					'section' => $theme_slug . '_buddypress_activity_page',
					'type'      => 'color_rgba',
					'output' => array( 
						'background-color' => '.gp-theme #buddypress:not(.youzer) .activity-list .activity-content, .gp-theme #buddypress:not(.youzer) #activity-stream .activity-comments ul, .gp-theme #buddypress:not(.youzer) div.activity-comments form.ac-form, .gp-theme #buddypress:not(.youzer) div#message-thread div.odd, .gp-theme #buddypress:not(.youzer) div#message-thread div.alt, .gp-theme #buddypress:not(.youzer) table#message-threads.sitewide-notices tr', 
						'border-bottom-color' => '.gp-theme #buddypress:not(.youzer) div.activity-comments:after, .gp-theme #buddypress:not(.youzer) div#message-thread div.message-box:after, .gp-theme #buddypress:not(.youzer) table#message-threads.sitewide-notices tr:after' 
					),
					'default' => '#f8f8f8',
				),

				array(
					'id' => 'bp_activity_text_color',
					'title' => esc_html__( 'Text', 'aardvark' ),
					'section' => $theme_slug . '_buddypress_activity_page',
					'type'      => 'color_rgba',
					'output' => array( 'color' => '.gp-theme #buddypress:not(.youzer) ul.activity-list > li, .gp-theme #buddypress:not(.youzer) .activity-list .activity-content .activity-header, .gp-theme #buddypress:not(.youzer) .activity-list .activity-content .comment-header, .gp-theme #buddypress:not(.youzer) ul.activity-list > li a.activity-time-since, .gp-theme #buddypress:not(.youzer) ul.activity-list > li a.activity-time-since:hover' ),
					'default'  => '#777',
				),

				array(
					'id' => 'bp_activity_link_color',
					'title' => esc_html__( 'Links', 'aardvark' ),
					'section' => $theme_slug . '_buddypress_activity_page',
					'type'      => 'link_color',
					'output' => '.gp-theme #buddypress:not(.youzer) ul.activity-list > li a',
					'default' => array(
						'regular'  => '',
						'hover'    => '',	
					),	
				),
						
				array(
					'id' => 'bp_activity_button_text_color',
					'title' => esc_html__( 'Button Text', 'aardvark' ),
					'section' => $theme_slug . '_buddypress_activity_page',
					'type'      => 'link_color',
					'output' =>'.gp-theme #buddypress:not(.youzer) ul.activity-list > li div.activity-meta a, .gp-theme #buddypress:not(.youzer) ul.activity-list > li .acomment-options a',
					'default' => array(
						'regular' => '#999',
						'hover' => '#232323',	
					),	
				),

			/**
			 * BuddyPress - Members Page
			 *
			 */			
			// Main header
			array(
				'id' => 'bp_members_main_header_section',
				'title' => esc_html__( 'Main Header', 'aardvark' ),
				'section' => $theme_slug . '_buddypress_members_page',
				'label_for' => 'gp-section-header',	
				'type' => 'section-header',
				'class' => 'gp-setting gp-setting-begin',
			),
						 
				array( 
					'id' => 'bp_members_header_layout',
					'title' => esc_html__( 'Layout', 'aardvark' ),
					'section' => $theme_slug . '_buddypress_members_page',
					'type' => 'image_select',
					'options' => array( 
						'default' => array( esc_html__( 'Default', 'aardvark' ), 'img' => get_template_directory_uri() . '/lib/framework/settings/images/default.jpg' ),
						'gp-header-logo-left-1' => array( esc_html__( 'Header 1', 'aardvark' ), 'img' => get_template_directory_uri() . '/lib/framework/settings/images/logo-left-1.jpg' ),
						'gp-header-logo-left-2' => array( esc_html__( 'Header 2', 'aardvark' ), 'img' => get_template_directory_uri() . '/lib/framework/settings/images/logo-left-2.jpg' ),
						'gp-header-logo-right-1' => array( esc_html__( 'Header 3', 'aardvark' ), 'img' => get_template_directory_uri() . '/lib/framework/settings/images/logo-right-1.jpg' ),
						'gp-header-nav-bottom-1' => array( esc_html__( 'Header 4', 'aardvark' ), 'img' => get_template_directory_uri() . '/lib/framework/settings/images/nav-bottom-1.jpg' ),
						'gp-header-nav-bottom-2' => array( esc_html__( 'Header 5', 'aardvark' ), 'img' => get_template_directory_uri() . '/lib/framework/settings/images/nav-bottom-2.jpg' ),
						'gp-header-nav-bottom-3' => array( esc_html__( 'Header 6', 'aardvark' ), 'img' => get_template_directory_uri() . '/lib/framework/settings/images/nav-bottom-3.jpg' ),
						'gp-header-side-menu' => array( esc_html__( 'Header 7', 'aardvark' ), 'img' => get_template_directory_uri() . '/lib/framework/settings/images/side-menu.jpg' ),
					),
					'default' => 'default',
				),

			// Title header
			array(
				'id' => 'bp_members_title_header_section',
				'title' => esc_html__( 'Title Header', 'aardvark' ),
				'section' => $theme_slug . '_buddypress_members_page',
				'label_for' => 'gp-section-header',	
				'type' => 'section-header',
				'class' => 'gp-setting gp-setting-begin',
			),

				array( 
					'id' => 'bp_members_page_header',
					'title' => esc_html__( 'Display', 'aardvark' ),
					'section' => $theme_slug . '_buddypress_members_page',
					'type' => 'select',
					'options' => array(
						'default' => esc_html__( 'Default', 'aardvark' ),
						'gp-standard-page-header' => esc_html__( 'Standard', 'aardvark' ),
						'gp-fullwidth-page-header' => esc_html__( 'Full Width', 'aardvark' ),
						'gp-full-page-page-header' => esc_html__( 'Full Page', 'aardvark' ),
						'gp-minimal-page-header' => esc_html__( 'Minimal', 'aardvark' ),
						'gp-page-header-disabled' => esc_html__( 'Disabled', 'aardvark' ),
					),	
					'default' => 'gp-standard-page-header',
					),

				array(
					'id' => 'bp_members_page_header_bg', 
					'title' => esc_html__( 'Background', 'aardvark' ),
					'section' => $theme_slug . '_buddypress_members_page',
					'type'  => 'media',			
					'default' => '',
				),

				array( 
					'id' => 'bp_members_page_header_height',
					'title' => esc_html__( 'Directory Height', 'aardvark' ),
					'section' => $theme_slug . '_buddypress_members_page',
					'type' => 'dimensions',
					'default' => array(
						'height' => '',
					),	
				),

				array( 
					'id' => 'bp_profile_page_header_height',
					'title' => esc_html__( 'Profile Height', 'aardvark' ),
					'section' => $theme_slug . '_buddypress_members_page',
					'type' => 'dimensions',
					'default' => array(
						'height' => 'auto',
					),	
				),
								
			// Layout
			array(
				'id' => 'bp_members_layout_section',
				'title' => esc_html__( 'Layout', 'aardvark' ),
				'section' => $theme_slug . '_buddypress_members_page',
				'label_for' => 'gp-section-header',	
				'type' => 'section-header',
				'class' => 'gp-setting gp-setting-begin',
			),
																	
				array( 
					'id' => 'bp_members_layout',
					'title' => esc_html__( 'Directory Page', 'aardvark' ),
					'section' => $theme_slug . '_buddypress_members_page',
					'type' => 'select',
					'options' => array(
					'default' => esc_html__( 'Default', 'aardvark' ),
						'gp-left-sidebar' => esc_html__( 'Left Sidebar', 'aardvark' ), 
						'gp-right-sidebar' => esc_html__( 'Right Sidebar', 'aardvark' ),
						'gp-both-sidebars' => esc_html__( 'Both Sidebars', 'aardvark' ), 
						'gp-no-sidebar' => esc_html__( 'No Sidebar', 'aardvark' ),
						'gp-fullwidth' => esc_html__( 'Full Width', 'aardvark' ),
					),	
					'default' => 'gp-no-sidebar',
				),

				array( 
					'id' => 'bp_profile_layout',
					'title' => esc_html__( 'Profile Page', 'aardvark' ),
					'section' => $theme_slug . '_buddypress_members_page',
					'type' => 'select',
					'options' => array(
					'default' => esc_html__( 'Default', 'aardvark' ),
						'gp-left-sidebar' => esc_html__( 'Left Sidebar', 'aardvark' ), 
						'gp-right-sidebar' => esc_html__( 'Right Sidebar', 'aardvark' ),
						'gp-both-sidebars' => esc_html__( 'Both Sidebars', 'aardvark' ), 
						'gp-no-sidebar' => esc_html__( 'No Sidebar', 'aardvark' ),
						'gp-fullwidth' => esc_html__( 'Full Width', 'aardvark' ),
					),
					'default' => 'default',
				),

				array(
					'id' => 'bp_members_left_sidebar',
					'title' => esc_html__( 'Left Sidebar', 'aardvark' ),
					'section' => $theme_slug . '_buddypress_members_page',				
					'type'    => 'select',
					'data' => 'sidebars',
					'default'  => 'default',
				),

				array(
					'id' => 'bp_members_right_sidebar',
					'title' => esc_html__( 'Right Sidebar', 'aardvark' ),
					'section' => $theme_slug . '_buddypress_members_page',
					'type'    => 'select',
					'data' => 'sidebars',
					'default'  => 'default',
					),		

			// Other
			array(
				'id' => 'bp_members_other_section',
				'title' => esc_html__( 'Other', 'aardvark' ),
				'section' => $theme_slug . '_buddypress_members_page',
				'label_for' => 'gp-section-header',	
				'type' => 'section-header',
				'class' => 'gp-setting gp-setting-begin',
			),
			
				array( 
					'id' => 'bp_members_masonry_format',
					'title' => esc_html__( 'Masonry Alignment', 'aardvark' ),
					'section' => $theme_slug . '_buddypress_members_page',
					'desc' => esc_html__( 'If you are having issues loading members directory content try disabling this option.', 'aardvark' ),
					'type' => 'radio',
					'options' => array( 
						'enabled' => esc_html__( 'Enabled', 'aardvark' ),
						'disabled' => esc_html__( 'Disabled', 'aardvark' ),
					),	
					'default' => 'enabled',
				),

				array( 
					'id' => 'bp_members_cover_images',
					'title' => esc_html__( 'Cover Images', 'aardvark' ),
					'section' => $theme_slug . '_buddypress_members_page',
					'desc' => esc_html__( 'Whether to show cover images in the Members directory.', 'aardvark' ),
					'type' => 'radio',
					'options' => array( 
						'enabled' => esc_html__( 'Enabled', 'aardvark' ),
						'disabled' => esc_html__( 'Disabled', 'aardvark' ),
					),
					'default' => 'enabled',
				),

				array( 
					'id' => 'bp_profile_header_buttons',
					'title' => esc_html__( 'Profile Header Buttons', 'aardvark' ),
					'section' => $theme_slug . '_buddypress_members_page',
					'type' => 'checkbox',
					'options' => array( 
						'avatar' => esc_html__( 'Update Avatar Button', 'aardvark' ),
						'cover-image' => esc_html__( 'Update Cover Image Button', 'aardvark' ),
					),
					'default' => array(
						'avatar' => 1,
						'cover-image' => 1,
					),
				),

				array( 
					'id' => 'bp_profile_posts_tab',
					'title' => esc_html__( 'Profile Posts Tab', 'aardvark' ),
					'section' => $theme_slug . '_buddypress_members_page',
					'type' => 'radio',
					'options' => array( 
						'enabled' => esc_html__( 'Enabled', 'aardvark' ),
						'disabled' => esc_html__( 'Disabled', 'aardvark' ),
					),
					'default' => 'enabled',
				),

			/**
			 * BuddyPress - Groups Page
			 *
			 */
			// Main header
			array(
				'id' => 'bp_groups_main_header_section',
				'title' => esc_html__( 'Main Header', 'aardvark' ),
				'section' => $theme_slug . '_buddypress_groups_page',
				'label_for' => 'gp-section-header',	
				'type' => 'section-header',
				'class' => 'gp-setting gp-setting-begin',
			),	
			
				array( 
					'id' => 'bp_groups_header_layout',
					'title' => esc_html__( 'Layout', 'aardvark' ),
					'section' => $theme_slug . '_buddypress_groups_page',
					'type' => 'image_select',
					'options' => array( 
							'default' => array( esc_html__( 'Default', 'aardvark' ), 'img' => get_template_directory_uri() . '/lib/framework/settings/images/default.jpg' ),
							'gp-header-logo-left-1' => array( esc_html__( 'Header 1', 'aardvark' ), 'img' => get_template_directory_uri() . '/lib/framework/settings/images/logo-left-1.jpg' ),
							'gp-header-logo-left-2' => array( esc_html__( 'Header 2', 'aardvark' ), 'img' => get_template_directory_uri() . '/lib/framework/settings/images/logo-left-2.jpg' ),
							'gp-header-logo-right-1' => array( esc_html__( 'Header 3', 'aardvark' ), 'img' => get_template_directory_uri() . '/lib/framework/settings/images/logo-right-1.jpg' ),
							'gp-header-nav-bottom-1' => array( esc_html__( 'Header 4', 'aardvark' ), 'img' => get_template_directory_uri() . '/lib/framework/settings/images/nav-bottom-1.jpg' ),
							'gp-header-nav-bottom-2' => array( esc_html__( 'Header 5', 'aardvark' ), 'img' => get_template_directory_uri() . '/lib/framework/settings/images/nav-bottom-2.jpg' ),
							'gp-header-nav-bottom-3' => array( esc_html__( 'Header 6', 'aardvark' ), 'img' => get_template_directory_uri() . '/lib/framework/settings/images/nav-bottom-3.jpg' ),
							'gp-header-side-menu' => array( esc_html__( 'Header 7', 'aardvark' ), 'img' => get_template_directory_uri() . '/lib/framework/settings/images/side-menu.jpg' ),
						),
					'default' => 'default',
					),
	
			// Title header
			array(
				'id' => 'bp_groups_title_header_section',
				'title' => esc_html__( 'Title Header', 'aardvark' ),
				'section' => $theme_slug . '_buddypress_groups_page',
				'label_for' => 'gp-section-header',	
				'type' => 'section-header',
				'class' => 'gp-setting gp-setting-begin',
			),
					
				array( 
					'id' => 'bp_groups_page_header',
					'title' => esc_html__( 'Display', 'aardvark' ),
					'section' => $theme_slug . '_buddypress_groups_page',
					'type' => 'select',
					'options' => array(
						'default' => esc_html__( 'Default', 'aardvark' ),
						'gp-standard-page-header' => esc_html__( 'Standard', 'aardvark' ),
						'gp-fullwidth-page-header' => esc_html__( 'Full Width', 'aardvark' ),
						'gp-full-page-page-header' => esc_html__( 'Full Page', 'aardvark' ),
						'gp-minimal-page-header' => esc_html__( 'Minimal', 'aardvark' ),
						'gp-page-header-disabled' => esc_html__( 'Disabled', 'aardvark' ),
					),
					'default' => 'gp-standard-page-header',
				),

				array(
					'id' => 'bp_groups_page_header_bg', 
					'title' => esc_html__( 'Background', 'aardvark' ),
					'section' => $theme_slug . '_buddypress_groups_page',
					'type'  => 'media',			
					'default' => '',
				),

				array( 
					'id' => 'bp_groups_page_header_height',
					'title' => esc_html__( 'Height', 'aardvark' ),
					'section' => $theme_slug . '_buddypress_groups_page',
					'type' => 'dimensions',
					'default' => array(
						'height' => 'auto',
					),	
				),
				
			// Layout
			array(
				'id' => 'bp_groups_layout_section',
				'title' => esc_html__( 'Layout', 'aardvark' ),
				'section' => $theme_slug . '_buddypress_groups_page',
				'label_for' => 'gp-section-header',	
				'type' => 'section-header',
				'class' => 'gp-setting gp-setting-begin',
			),
										
				array( 
					'id' => 'bp_groups_layout',
					'title' => esc_html__( 'Display', 'aardvark' ),
					'section' => $theme_slug . '_buddypress_groups_page',
					'type' => 'select',
					'options' => array(
						'default' => esc_html__( 'Default', 'aardvark' ),
						'gp-left-sidebar' => esc_html__( 'Left Sidebar', 'aardvark' ), 
						'gp-right-sidebar' => esc_html__( 'Right Sidebar', 'aardvark' ),
						'gp-both-sidebars' => esc_html__( 'Both Sidebars', 'aardvark' ), 
						'gp-no-sidebar' => esc_html__( 'No Sidebar', 'aardvark' ),
						'gp-fullwidth' => esc_html__( 'Full Width', 'aardvark' ),
					),
					'default' => 'gp-no-sidebar',
				),

				array(
					'id' => 'bp_groups_left_sidebar',
					'title' => esc_html__( 'Left Sidebar', 'aardvark' ),
					'section' => $theme_slug . '_buddypress_groups_page',			
					'type'    => 'select',
					'data' => 'sidebars',
					'default'  => 'default',
				),

				array(
					'id' => 'bp_groups_right_sidebar',
					'title' => esc_html__( 'Right Sidebar', 'aardvark' ),
					'section' => $theme_slug . '_buddypress_groups_page',
					'type'    => 'select',
					'data' => 'sidebars',
					'default'  => 'default',
				),
				
			// Other
			array(
				'id' => 'bp_groups_other_section',
				'title' => esc_html__( 'Other', 'aardvark' ),
				'section' => $theme_slug . '_buddypress_groups_page',
				'label_for' => 'gp-section-header',	
				'type' => 'section-header',
				'class' => 'gp-setting gp-setting-begin',
			),
			
				array( 
					'id' => 'bp_groups_masonry_format',
					'title' => esc_html__( 'Masonry Alignment', 'aardvark' ),
					'section' => $theme_slug . '_buddypress_groups_page',
					'desc' => esc_html__( 'If you are having issues loading groups directory content try disabling this option.', 'aardvark' ),
					'type' => 'radio',
					'options' => array( 
						'enabled' => esc_html__( 'Enabled', 'aardvark' ),
						'disabled' => esc_html__( 'Disabled', 'aardvark' ),
					),
					'default' => 'enabled',
				),

				array( 
					'id' => 'bp_groups_cover_images',
					'title' => esc_html__( 'Cover Images', 'aardvark' ),
					'section' => $theme_slug . '_buddypress_groups_page',
					'desc' => esc_html__( 'Whether to show cover images in the Groups directory.', 'aardvark' ),
					'type' => 'radio',
					'options' => array( 
							'enabled' => esc_html__( 'Enabled', 'aardvark' ),
							'disabled' => esc_html__( 'Disabled', 'aardvark' ),
						),
					'default' => 'enabled',
					),

			/**
			 * BuddyPress - Registration Page
			 *
			 */
			// Main header
			array(
				'id' => 'bp_register_main_header_section',
				'title' => esc_html__( 'Main Header', 'aardvark' ),
				'section' => $theme_slug . '_buddypress_registration_page',
				'label_for' => 'gp-section-header',	
				'type' => 'section-header',
				'class' => 'gp-setting gp-setting-begin',
			),
			
				array( 
					'id' => 'bp_register_header_display',
					'title' => esc_html__( 'Display', 'aardvark' ),
					'section' => $theme_slug . '_buddypress_registration_page',
					'type' => 'select',
					'options' => array( 
						'default' => esc_html__( 'Default', 'aardvark' ),
							'gp-header-above-content' => esc_html__( 'Above Content', 'aardvark' ),
							'gp-header-over-content' => esc_html__( 'Over Content', 'aardvark' ),
							'gp-header-disabled' => esc_html__( 'Disabled', 'aardvark' ),
						),
					'default' => 'default',
					),
			
				array( 
					'id' => 'bp_register_header_layout',
					'title' => esc_html__( 'Layout', 'aardvark' ),
					'section' => $theme_slug . '_buddypress_registration_page',
					'type' => 'image_select',
					'options' => array( 
							'default' => array( esc_html__( 'Default', 'aardvark' ), 'img' => get_template_directory_uri() . '/lib/framework/settings/images/default.jpg' ),
							'gp-header-logo-left-1' => array( esc_html__( 'Header 1', 'aardvark' ), 'img' => get_template_directory_uri() . '/lib/framework/settings/images/logo-left-1.jpg' ),
							'gp-header-logo-left-2' => array( esc_html__( 'Header 2', 'aardvark' ), 'img' => get_template_directory_uri() . '/lib/framework/settings/images/logo-left-2.jpg' ),
							'gp-header-logo-right-1' => array( esc_html__( 'Header 3', 'aardvark' ), 'img' => get_template_directory_uri() . '/lib/framework/settings/images/logo-right-1.jpg' ),
							'gp-header-nav-bottom-1' => array( esc_html__( 'Header 4', 'aardvark' ), 'img' => get_template_directory_uri() . '/lib/framework/settings/images/nav-bottom-1.jpg' ),
							'gp-header-nav-bottom-2' => array( esc_html__( 'Header 5', 'aardvark' ), 'img' => get_template_directory_uri() . '/lib/framework/settings/images/nav-bottom-2.jpg' ),
							'gp-header-nav-bottom-3' => array( esc_html__( 'Header 6', 'aardvark' ), 'img' => get_template_directory_uri() . '/lib/framework/settings/images/nav-bottom-3.jpg' ),
							'gp-header-side-menu' => array( esc_html__( 'Header 7', 'aardvark' ), 'img' => get_template_directory_uri() . '/lib/framework/settings/images/side-menu.jpg' ),
						),
					'default' => 'default',
					),
				
			// Footer
			array(
				'id' => 'bp_register_footer_section',
				'title' => esc_html__( 'Footer', 'aardvark' ),
				'section' => $theme_slug . '_buddypress_registration_page',
				'label_for' => 'gp-section-header',	
					'type' => 'section-header',
				'class' => 'gp-setting gp-setting-begin',
			),
			
				array( 
					'id' => 'bp_register_footer_display',
					'title' => esc_html__( 'Display', 'aardvark' ),
					'section' => $theme_slug . '_buddypress_registration_page',
					'type' => 'select',
					'options' => array( 
						'default' => esc_html__( 'Default', 'aardvark' ),
							'enabled' => esc_html__( 'Enabled', 'aardvark' ),
							'disabled' => esc_html__( 'Disabled', 'aardvark' ),
						),	
					'default' => 'default',
					),
			
			// Title header
			array(
				'id' => 'bp_register_title_header_section',
				'title' => esc_html__( 'Title Header', 'aardvark' ),
				'section' => $theme_slug . '_buddypress_registration_page',
				'label_for' => 'gp-section-header',	
					'type' => 'section-header',
				'class' => 'gp-setting gp-setting-begin',
			),
						
				array( 
					'id' => 'bp_register_page_header',
					'title' => esc_html__( 'Display', 'aardvark' ),
					'section' => $theme_slug . '_buddypress_registration_page',
					'type' => 'select',
					'options' => array(
						'default' => esc_html__( 'Default', 'aardvark' ),
						'gp-standard-page-header' => esc_html__( 'Standard', 'aardvark' ),
						'gp-fullwidth-page-header' => esc_html__( 'Full Width', 'aardvark' ),
						'gp-full-page-page-header' => esc_html__( 'Full Page', 'aardvark' ),
						'gp-minimal-page-header' => esc_html__( 'Minimal', 'aardvark' ),
						'gp-page-header-disabled' => esc_html__( 'Disabled', 'aardvark' ),
					),
					'default' => 'gp-standard-page-header',
				),

				array(
					'id' => 'bp_register_page_header_bg', 
					'title' => esc_html__( 'Background', 'aardvark' ),
					'section' => $theme_slug . '_buddypress_registration_page',
					'type'  => 'media',			
					'default' => '',
				),

				array( 
					'id' => 'bp_register_page_header_height',
					'title' => esc_html__( 'Height', 'aardvark' ),
					'section' => $theme_slug . '_buddypress_registration_page',
					'type' => 'dimensions',
					'default' => array(
						'height' => '',
					),	
				),
	
			// Layout
			array(
				'id' => 'bp_register_layout_section',
				'title' => esc_html__( 'Layout', 'aardvark' ),
				'section' => $theme_slug . '_buddypress_registration_page',
				'label_for' => 'gp-section-header',	
				'type' => 'section-header',
				'class' => 'gp-setting gp-setting-begin',
			),
										
				array( 
					'id' => 'bp_register_layout',
					'title' => esc_html__( 'Display', 'aardvark' ),
					'section' => $theme_slug . '_buddypress_registration_page',
					'type' => 'select',
					'options' => array(
						'default' => esc_html__( 'Default', 'aardvark' ),
							'gp-left-sidebar' => esc_html__( 'Left Sidebar', 'aardvark' ), 
							'gp-right-sidebar' => esc_html__( 'Right Sidebar', 'aardvark' ),
							'gp-both-sidebars' => esc_html__( 'Both Sidebars', 'aardvark' ), 
							'gp-no-sidebar' => esc_html__( 'No Sidebar', 'aardvark' ),
							'gp-fullwidth' => esc_html__( 'Full Width', 'aardvark' ),
						),
					'default' => 'gp-no-sidebar',
					),

				array(
					'id' => 'bp_register_left_sidebar',
					'title' => esc_html__( 'Left Sidebar', 'aardvark' ),
					'section' => $theme_slug . '_buddypress_registration_page',
					'type'    => 'select',
					'data' => 'sidebars',
					'default'  => 'default',
				),

				array(
					'id' => 'bp_register_right_sidebar',
					'title' => esc_html__( 'Right Sidebar', 'aardvark' ),
					'section' => $theme_slug . '_buddypress_registration_page',
					'type'    => 'select',
					'data' => 'sidebars',
					'default'  => 'default',
				),

			/**
			 * BuddyPress - Activation Page
			 *
			 */
			// Main header
			array(
				'id' => 'bp_activate_main_header_section',
				'title' => esc_html__( 'Main Header', 'aardvark' ),
				'section' => $theme_slug . '_buddypress_activation_page',
				'label_for' => 'gp-section-header',	
				'type' => 'section-header',
				'class' => 'gp-setting gp-setting-begin',
			),

				array( 
					'id' => 'bp_activate_header_display',
					'title' => esc_html__( 'Display', 'aardvark' ),
					'section' => $theme_slug . '_buddypress_activation_page',
					'type' => 'select',
					'options' => array( 
						'default' => esc_html__( 'Default', 'aardvark' ),
						'gp-header-above-content' => esc_html__( 'Above Content', 'aardvark' ),
						'gp-header-over-content' => esc_html__( 'Over Content', 'aardvark' ),
						'gp-header-disabled' => esc_html__( 'Disabled', 'aardvark' ),
					),	
					'default' => 'default',
				),
			
				array( 
					'id' => 'bp_activate_header_layout',
					'title' => esc_html__( 'Layout', 'aardvark' ),
					'section' => $theme_slug . '_buddypress_activation_page',
					'type' => 'image_select',
					'options' => array( 
						'default' => array( esc_html__( 'Default', 'aardvark' ), 'img' => get_template_directory_uri() . '/lib/framework/settings/images/default.jpg' ),
							'gp-header-logo-left-1' => array( esc_html__( 'Header 1', 'aardvark' ), 'img' => get_template_directory_uri() . '/lib/framework/settings/images/logo-left-1.jpg' ),
							'gp-header-logo-left-2' => array( esc_html__( 'Header 2', 'aardvark' ), 'img' => get_template_directory_uri() . '/lib/framework/settings/images/logo-left-2.jpg' ),
							'gp-header-logo-right-1' => array( esc_html__( 'Header 3', 'aardvark' ), 'img' => get_template_directory_uri() . '/lib/framework/settings/images/logo-right-1.jpg' ),
							'gp-header-nav-bottom-1' => array( esc_html__( 'Header 4', 'aardvark' ), 'img' => get_template_directory_uri() . '/lib/framework/settings/images/nav-bottom-1.jpg' ),
							'gp-header-nav-bottom-2' => array( esc_html__( 'Header 5', 'aardvark' ), 'img' => get_template_directory_uri() . '/lib/framework/settings/images/nav-bottom-2.jpg' ),
							'gp-header-nav-bottom-3' => array( esc_html__( 'Header 6', 'aardvark' ), 'img' => get_template_directory_uri() . '/lib/framework/settings/images/nav-bottom-3.jpg' ),
							'gp-header-side-menu' => array( esc_html__( 'Header 7', 'aardvark' ), 'img' => get_template_directory_uri() . '/lib/framework/settings/images/side-menu.jpg' ),
						),
					'default' => 'default',
					),

			// Footer
			array(
				'id' => 'bp_activate_footer_section',
				'title' => esc_html__( 'Footer', 'aardvark' ),
				'section' => $theme_slug . '_buddypress_activation_page',
				'label_for' => 'gp-section-header',	
				'type' => 'section-header',
				'class' => 'gp-setting gp-setting-begin',
			),
			
				array( 
					'id' => 'bp_activate_footer_display',
					'title' => esc_html__( 'Display', 'aardvark' ),
					'section' => $theme_slug . '_buddypress_activation_page',
					'type' => 'select',
					'options' => array( 
						'default' => esc_html__( 'Default', 'aardvark' ),
						'enabled' => esc_html__( 'Enabled', 'aardvark' ),
						'disabled' => esc_html__( 'Disabled', 'aardvark' ),
					),
					'default' => 'default',
					),

			// Title header
			array(
				'id' => 'bp_activate_title_header_section',
				'title' => esc_html__( 'Title Header', 'aardvark' ),
				'section' => $theme_slug . '_buddypress_activation_page',
				'label_for' => 'gp-section-header',	
				'type' => 'section-header',
				'class' => 'gp-setting gp-setting-begin',
			),
						
				array( 
					'id' => 'bp_activate_page_header',
					'title' => esc_html__( 'Display', 'aardvark' ),
					'section' => $theme_slug . '_buddypress_activation_page',
					'type' => 'select',
					'options' => array(
						'default' => esc_html__( 'Default', 'aardvark' ),
						'gp-standard-page-header' => esc_html__( 'Standard', 'aardvark' ),
						'gp-fullwidth-page-header' => esc_html__( 'Full Width', 'aardvark' ),
						'gp-full-page-page-header' => esc_html__( 'Full Page', 'aardvark' ),
						'gp-minimal-page-header' => esc_html__( 'Minimal', 'aardvark' ),
						'gp-page-header-disabled' => esc_html__( 'Disabled', 'aardvark' ),
					),	
					'default' => 'gp-standard-page-header',
					),

				array(
					'id' => 'bp_activate_page_header_bg', 
					'title' => esc_html__( 'Background', 'aardvark' ),
					'section' => $theme_slug . '_buddypress_activation_page',
					'type'  => 'media',			
					'default' => '',
				),

				array( 
					'id' => 'bp_activate_page_header_height',
					'title' => esc_html__( 'Height', 'aardvark' ),
					'section' => $theme_slug . '_buddypress_activation_page',
					'type' => 'dimensions',
					'default' => array(
						'height' => '',
					),		
				),

			// Layout
			array(
				'id' => 'bp_activate_layout_section',
				'title' => esc_html__( 'Layout', 'aardvark' ),
				'section' => $theme_slug . '_buddypress_activation_page',
				'label_for' => 'gp-section-header',	
				'type' => 'section-header',
				'class' => 'gp-setting gp-setting-begin',
			),
										
				array( 
					'id' => 'bp_activate_layout',
					'title' => esc_html__( 'Display', 'aardvark' ),
					'section' => $theme_slug . '_buddypress_activation_page',
					'type' => 'select',
					'options' => array(
					'default' => esc_html__( 'Default', 'aardvark' ),
						'gp-left-sidebar' => esc_html__( 'Left Sidebar', 'aardvark' ), 
						'gp-right-sidebar' => esc_html__( 'Right Sidebar', 'aardvark' ),
						'gp-both-sidebars' => esc_html__( 'Both Sidebars', 'aardvark' ), 
						'gp-no-sidebar' => esc_html__( 'No Sidebar', 'aardvark' ),
						'gp-fullwidth' => esc_html__( 'Full Width', 'aardvark' ),
					),
					'default' => 'gp-no-sidebar',
				),

				array(
					'id' => 'bp_activate_left_sidebar',
					'title' => esc_html__( 'Left Sidebar', 'aardvark' ),
					'section' => $theme_slug . '_buddypress_activation_page',
					'type'    => 'select',
					'data' => 'sidebars',
					'default'  => 'default',
				),

				array(
					'id' => 'bp_activate_right_sidebar',
					'title' => esc_html__( 'Right Sidebar', 'aardvark' ),
					'section' => $theme_slug . '_buddypress_activation_page',
					'type'    => 'select',
					'data' => 'sidebars',
					'default'  => 'default',
				),

			/**
			 * BuddyPress - bbPress
			 *
			 */
			// Main header
			array(
				'id' => 'bppress_main_header_section',
				'title' => esc_html__( 'Main Header', 'aardvark' ),
				'section' => $theme_slug . '_buddypress_bbpress',
				'label_for' => 'gp-section-header',	
				'type' => 'section-header',
				'class' => 'gp-setting gp-setting-begin',
			),
						 
				array( 
					'id' => 'bbpress_header_layout',
					'title' => esc_html__( 'Layout', 'aardvark' ),
					'section' => $theme_slug . '_buddypress_bbpress',
					'type' => 'image_select',
					'options' => array( 
						'default' => array( esc_html__( 'Default', 'aardvark' ), 'img' => get_template_directory_uri() . '/lib/framework/settings/images/default.jpg' ),
						'gp-header-logo-left-1' => array( esc_html__( 'Header 1', 'aardvark' ), 'img' => get_template_directory_uri() . '/lib/framework/settings/images/logo-left-1.jpg' ),
						'gp-header-logo-left-2' => array( esc_html__( 'Header 2', 'aardvark' ), 'img' => get_template_directory_uri() . '/lib/framework/settings/images/logo-left-2.jpg' ),
						'gp-header-logo-right-1' => array( esc_html__( 'Header 3', 'aardvark' ), 'img' => get_template_directory_uri() . '/lib/framework/settings/images/logo-right-1.jpg' ),
						'gp-header-nav-bottom-1' => array( esc_html__( 'Header 4', 'aardvark' ), 'img' => get_template_directory_uri() . '/lib/framework/settings/images/nav-bottom-1.jpg' ),
						'gp-header-nav-bottom-2' => array( esc_html__( 'Header 5', 'aardvark' ), 'img' => get_template_directory_uri() . '/lib/framework/settings/images/nav-bottom-2.jpg' ),
						'gp-header-nav-bottom-3' => array( esc_html__( 'Header 6', 'aardvark' ), 'img' => get_template_directory_uri() . '/lib/framework/settings/images/nav-bottom-3.jpg' ),
						'gp-header-side-menu' => array( esc_html__( 'Header 7', 'aardvark' ), 'img' => get_template_directory_uri() . '/lib/framework/settings/images/side-menu.jpg' ),
					),	
					'default' => 'default',
				),

			// Title header
			array(
				'id' => 'bppress_title_header_section',
				'title' => esc_html__( 'Title Header', 'aardvark' ),
				'section' => $theme_slug . '_buddypress_bbpress',
				'label_for' => 'gp-section-header',	
				'type' => 'section-header',
				'class' => 'gp-setting gp-setting-begin',
			),	
					
				array( 
					'id' => 'bbpress_page_header',
					'title' => esc_html__( 'Display', 'aardvark' ),
					'section' => $theme_slug . '_buddypress_bbpress',
					'type' => 'select',
					'options' => array(
						'gp-standard-page-header' => esc_html__( 'Standard', 'aardvark' ),
						'gp-fullwidth-page-header' => esc_html__( 'Full Width', 'aardvark' ),
						'gp-full-page-page-header' => esc_html__( 'Full Page', 'aardvark' ),
						'gp-minimal-page-header' => esc_html__( 'Minimal', 'aardvark' ),
						'gp-page-header-disabled' => esc_html__( 'Disabled', 'aardvark' ),
					),
					'default' => 'gp-standard-page-header',
				),

				array(
					'id' => 'bbpress_page_header_bg', 
					'title' => esc_html__( 'Background', 'aardvark' ),
					'section' => $theme_slug . '_buddypress_bbpress',
					'type'  => 'media',			
					'default' => '',
				),

				array( 
					'id' => 'bbpress_page_header_height',
					'title' => esc_html__( 'Height', 'aardvark' ),
					'section' => $theme_slug . '_buddypress_bbpress',
					'type' => 'dimensions',
					'default' => array(
						'height' => 320,			
					),	
				),

			// Layout
			array(
				'id' => 'bppress_layout_section',
				'title' => esc_html__( 'Layout', 'aardvark' ),
				'section' => $theme_slug . '_buddypress_bbpress',
				'label_for' => 'gp-section-header',	
				'type' => 'section-header',
				'class' => 'gp-setting gp-setting-begin',
			),	
						
				array(						
					'id' => 'bbpress_layout',
					'title' => esc_html__( 'Display', 'aardvark' ),		
					'section' => $theme_slug . '_buddypress_bbpress',
					'type' => 'select',
					'options' => array(
						'gp-left-sidebar' => esc_html__( 'Left Sidebar', 'aardvark' ), 
						'gp-right-sidebar' => esc_html__( 'Right Sidebar', 'aardvark' ),
						'gp-both-sidebars' => esc_html__( 'Both Sidebars', 'aardvark' ), 
						'gp-no-sidebar' => esc_html__( 'No Sidebar', 'aardvark' ),
						'gp-fullwidth' => esc_html__( 'Full Width', 'aardvark' ),
					),	
					'default' => 'gp-no-sidebar',
				),

				array(
					'id' => 'bbpress_left_sidebar',
					'title' => esc_html__( 'Left Sidebar', 'aardvark' ),
					'section' => $theme_slug . '_buddypress_bbpress',
					'type'    => 'select',
					'data'    => 'sidebars',
					'default' => 'gp-left-sidebar',
				),

				array(
					'id' => 'bbpress_right_sidebar',
					'title' => esc_html__( 'Right Sidebar', 'aardvark' ),
					'section' => $theme_slug . '_buddypress_bbpress',
					'type'    => 'select',
					'data'    => 'sidebars',
					'default' => 'gp-right-sidebar',
					),
	
			// Other
			array(
				'id' => 'bppress_other_section',
				'title' => esc_html__( 'Other', 'aardvark' ),
				'section' => $theme_slug . '_buddypress_bbpress',
				'label_for' => 'gp-section-header',	
					'type' => 'section-header',
				'class' => 'gp-setting gp-setting-begin',
			),	
					
				array(
					'id' => 'bbpress_forum_cat_header_text_color',
					'title' => esc_html__( 'Forum Category Header Text', 'aardvark' ),
					'section' => $theme_slug . '_buddypress_bbpress',
					'type'      => 'color_rgba',
					'output' => '.gp-theme #bbpress-forums .gp-forum-home .bbp-forum-title, .gp-theme #bbpress-forums .bbp-topics .bbp-header, .gp-theme #bbpress-forums .bbp-replies .bbp-header, .gp-theme #bbpress-forums .bbp-search-results .bbp-header',
					'default'   => '#232323',
					),

				array(
					'id' => 'bbpress_meta_text_color',
					'title' => esc_html__( 'Forum Meta Text', 'aardvark' ),
					'section' => $theme_slug . '_buddypress_bbpress',
					'type'      => 'color_rgba',
					'output' => '.gp-theme #bbpress-forums .topic-reply-counts, .gp-theme #bbpress-forums .freshness-forum-link, .gp-theme #bbpress-forums .freshness-forum-link a, .gp-theme #bbpress-forums .bbp-topic-meta, .gp-theme #bbpress-forums .bbp-topic-meta a, .gp-theme #bbpress-forums .bbp-body .bbp-forum-freshness, .gp-theme #bbpress-forums .bbp-body .bbp-forum-freshness a, .gp-theme #bbpress-forums .bbp-body .bbp-topic-freshness a, .gp-theme #bbpress-forums .bbp-body .bbp-topic-voice-count, .gp-theme #bbpress-forums .bbp-body .bbp-topic-reply-count, .gp-theme #bbpress-forums .bbp-forum-header .bbp-meta, .gp-theme #bbpress-forums .bbp-topic-header .bbp-meta, .gp-theme #bbpress-forums .bbp-reply-header .bbp-meta, .gp-theme #bbpress-forums .bbp-author-role',
					'default'   => '#b1b1b1',
					),
										
				array(
					'id' => 'bbpress_forum_border',
					'title' => esc_html__( 'Forum Borders', 'aardvark' ),
					'section' => $theme_slug . '_buddypress_bbpress',
					'type'      => 'color_rgba',
					'output' => array( 'border-color' => '.gp-theme #bbpress-forums .gp-forum-home li.odd-forum-row, .gp-theme #bbpress-forums .gp-forum-home li.even-forum-row,  .gp-theme #bbpress-forums .bbp-topics .bbp-header, .gp-theme #bbpress-forums div.bbp-forum-header, .gp-theme #bbpress-forums div.bbp-topic-header, .gp-theme #bbpress-forums div.bbp-reply-header, .gp-theme #bbpress-forums li.bbp-body ul.forum, .gp-theme #bbpress-forums .bbp-topics ul.topic' ),
					'default'   => '#e6e6e6',
				),

				array(
					'id' => 'bbpress_sticky_topic_bg',
					'title' => esc_html__( 'Sticky Topic Background', 'aardvark' ),
					'section' => $theme_slug . '_buddypress_bbpress',
					'type'      => 'color_rgba',
					'important' => true,
					'output' => array( 'background-color' => '.gp-theme #bbpress-forums .bbp-topics ul.sticky, .gp-theme #bbpress-forums .bbp-topics ul.super-sticky' ),
					'default'   => '#f6fdff',
				),

			/**
			 * WooCommerce
			 *
			 */
			 
			/**
			 * WooCommerce - Shop Page
			 *
			 */	
			// Title header
			array(
				'id' => 'wc_shop_title_header_section',
				'title' => esc_html__( 'Title Header', 'aardvark' ),
				'section' => $theme_slug . '_woocommerce',
				'label_for' => 'gp-section-header',	
				'type' => 'section-header',
				'class' => 'gp-setting gp-setting-begin',
			),	
			
				array( 
					'id' => 'wc_shop_page_header',
					'title' => esc_html__( 'Display', 'aardvark' ),
					'section' => $theme_slug . '_woocommerce',
					'type' => 'select',
					'options' => array(
						'gp-standard-page-header' => esc_html__( 'Standard', 'aardvark' ),
						'gp-fullwidth-page-header' => esc_html__( 'Full Width', 'aardvark' ),
						'gp-full-page-page-header' => esc_html__( 'Full Page', 'aardvark' ),
						'gp-minimal-page-header' => esc_html__( 'Minimal', 'aardvark' ),
						'gp-page-header-disabled' => esc_html__( 'Disabled', 'aardvark' ),
					),
					'default' => 'gp-standard-page-header',
					),

				array(
					'id' => 'wc_shop_page_header_bg', 
					'title' => esc_html__( 'Background', 'aardvark' ),
					'section' => $theme_slug . '_woocommerce',
					'type'  => 'media',			
					'default' => '',
					'conditions' => array(
						'wc_shop_page_header' => array(
							'value' => array( 'gp-fullwidth-page-header', 'gp-full-page-page-header' ),
							'operator' => 'in_array',
						),	
					),
				),

				array( 
					'id' => 'wc_shop_page_header_height',
					'title' => esc_html__( 'Height', 'aardvark' ),
					'section' => $theme_slug . '_woocommerce',
					'type' => 'dimensions',
					'default' => array(
						'height' => 320,
					),	
					'conditions' => array(
						'wc_shop_page_header' => array( 'gp-fullwidth-page-header', 'gp-full-page-page-header' ),	
					),
				),

			// Layout
			array(
				'id' => 'wc_shop_layout_section',
				'title' => esc_html__( 'Layout', 'aardvark' ),
				'section' => $theme_slug . '_woocommerce',
				'label_for' => 'gp-section-header',	
				'type' => 'section-header',
				'class' => 'gp-setting gp-setting-begin',
			),	
											
				array( 
					'id' => 'wc_shop_layout',
					'title' => esc_html__( 'Display', 'aardvark' ),
					'section' => $theme_slug . '_woocommerce',
					'type' => 'select',
					'options' => array(
							'gp-left-sidebar' => esc_html__( 'Left Sidebar', 'aardvark' ), 
							'gp-right-sidebar' => esc_html__( 'Right Sidebar', 'aardvark' ),
							'gp-both-sidebars' => esc_html__( 'Both Sidebars', 'aardvark' ), 
							'gp-no-sidebar' => esc_html__( 'No Sidebar', 'aardvark' ),
							'gp-fullwidth' => esc_html__( 'Full Width', 'aardvark' ),
						),	
					'default' => 'gp-left-sidebar',
					),

				array(
					'id' => 'wc_shop_left_sidebar',
					'title' => esc_html__( 'Left Sidebar', 'aardvark' ),
					'section' => $theme_slug . '_woocommerce',
					'type'    => 'select',
						'data'    => 'sidebars',
					'default' => 'gp-left-sidebar',
				),

				array(
					'id' => 'wc_shop_right_sidebar',
					'title' => esc_html__( 'Right Sidebar', 'aardvark' ),
					'section' => $theme_slug . '_woocommerce',
					'type'    => 'select',
						'data'    => 'sidebars',
					'default' => 'gp-right-sidebar',
					),

			// Ordering
			array(
				'id' => 'wc_shop_ordering_section',
				'title' => esc_html__( 'Ordering', 'aardvark' ),
				'section' => $theme_slug . '_woocommerce',
				'label_for' => 'gp-section-header',	
				'type' => 'section-header',
				'class' => 'gp-setting gp-setting-begin',
			),

				array(
					'id' => 'wc_shop_per_page',
					'title' => esc_html__( 'Items Per Page', 'aardvark' ),
					'section' => $theme_slug . '_woocommerce',
					'type' => 'spinner',
					'min' => 1,
					'max' => 999999,
					'default' => 12,
				),

				array(  
					'id' => 'wc_products_per_row',
					'title' => esc_html__( 'Items Per Row', 'aardvark' ),
					'section' => $theme_slug . '_woocommerce',
					'type' => 'spinner',
					'default'   => 3,
				),

			// Other
			array(
				'id' => 'wc_shop_other_section',
				'title' => esc_html__( 'Other', 'aardvark' ),
				'section' => $theme_slug . '_woocommerce',
				'label_for' => 'gp-section-header',	
					'type' => 'section-header',
				'class' => 'gp-setting gp-setting-begin',
			),
			
				array(  
					'id' => 'wc_secondary_hover_image',
					'title' => esc_html__( 'Secondary Hover Image', 'aardvark' ),
					'section' => $theme_slug . '_woocommerce',
					'desc' => esc_html__( 'Show the secondary gallery image when hovering over the primary image on product category pages.', 'aardvark' ),
					'type' => 'select',
					'options'   => array(
						'enabled' => esc_html__( 'Enabled', 'aardvark' ),
						'disabled' => esc_html__( 'Disabled', 'aardvark' ),
					), 
					'default'   => 'enabled',
				),

				array(
					'id' => 'misc_price_color',
					'title' => esc_html__( 'Price Color', 'aardvark' ),
					'section' => $theme_slug . '_woocommerce',
					'type' => 'color_rgba',
					'desc'  => esc_html__( 'Used in WooCommerce and Sensei.', 'aardvark' ),
					'output' => array( 'color' => '.gp-loop-price, .woocommerce ul.products li.product .price, .woocommerce div.product p.price, .woocommerce div.product span.price, .widget_sensei_category_courses .course-price, .widget_sensei_course_component .course-price, .course-container .course-product-price', ),
					'default' => '#39c8df',
				),

				array(
					'id' => 'misc_star_color',
					'title' => esc_html__( 'Star Rating Color', 'aardvark' ),
					'section' => $theme_slug . '_woocommerce',
					'type' => 'color_rgba',
					'desc'  => esc_html__( 'Used in WooCommerce.', 'aardvark' ),
					'output' => array( 'color' => '.woocommerce .star-rating, .woocommerce p.stars a' ),
					'default' => '#FFC01F',
				),
			
			/**
			 * WooCommerce - Product Categories/Tags
			 *
			 */
			// Title header
			array(
				'id' => 'wc_product_cat_title_header_section',
				'title' => esc_html__( 'Title Header', 'aardvark' ),
				'section' => $theme_slug . '_woocommerce_product_categories',
				'label_for' => 'gp-section-header',	
				'type' => 'section-header',
				'class' => 'gp-setting gp-setting-begin',
			),
						 
				array( 
					'id' => 'wc_product_cat_page_header',
					'title' => esc_html__( 'Display', 'aardvark' ),
					'section' => $theme_slug . '_woocommerce_product_categories',
					'type' => 'select',
					'desc' => esc_html__( 'The shop page header on the page.', 'aardvark' ),
					'options' => array(
						'gp-standard-page-header' => esc_html__( 'Standard', 'aardvark' ),
						'gp-fullwidth-page-header' => esc_html__( 'Full Width', 'aardvark' ),
						'gp-full-page-page-header' => esc_html__( 'Full Page', 'aardvark' ),
						'gp-minimal-page-header' => esc_html__( 'Minimal', 'aardvark' ),
						'gp-page-header-disabled' => esc_html__( 'Disabled', 'aardvark' ),
					),
					'default' => 'gp-standard-page-header',
				),

				array( 
					'id' => 'wc_product_cat_page_header_height',
					'title' => esc_html__( 'Height', 'aardvark' ),
					'section' => $theme_slug . '_woocommerce_product_categories',
					'type' => 'dimensions',
					'default'  => array(
						'height' => 320,	
					),	
				 ),
				 
			// Layout
			array(
				'id' => 'wc_product_cat_layout_section',
				'title' => esc_html__( 'Layout', 'aardvark' ),
				'section' => $theme_slug . '_woocommerce_product_categories',
				'label_for' => 'gp-section-header',	
				'type' => 'section-header',
				'class' => 'gp-setting gp-setting-begin',
			),
											
				array( 
					'id' => 'wc_product_cat_layout',
					'title' => esc_html__( 'Display', 'aardvark' ),
					'section' => $theme_slug . '_woocommerce_product_categories',
					'type' => 'select',
					'options' => array(
						'gp-left-sidebar' => esc_html__( 'Left Sidebar', 'aardvark' ), 
						'gp-right-sidebar' => esc_html__( 'Right Sidebar', 'aardvark' ),
						'gp-both-sidebars' => esc_html__( 'Both Sidebars', 'aardvark' ), 
						'gp-no-sidebar' => esc_html__( 'No Sidebar', 'aardvark' ),
						'gp-fullwidth' => esc_html__( 'Full Width', 'aardvark' ),
					),
					'default' => 'gp-left-sidebar',
				),

				array(
					'id' => 'wc_product_cat_left_sidebar',
					'title' => esc_html__( 'Left Sidebar', 'aardvark' ),
					'section' => $theme_slug . '_woocommerce_product_categories',
					'type'    => 'select',
					'data'    => 'sidebars',
					'default' => 'gp-left-sidebar',
				),

				array(
					'id' => 'wc_product_cat_right_sidebar',
					'title' => esc_html__( 'Right Sidebar', 'aardvark' ),
					'section' => $theme_slug . '_woocommerce_product_categories',
					'type'    => 'select',
						'data'    => 'sidebars',
					'default' => 'gp-right-sidebar',
				),
				
			// Ordering
			array(
				'id' => 'wc_product_cat_ordering_section',
				'title' => esc_html__( 'Ordering', 'aardvark' ),
				'section' => $theme_slug . '_woocommerce_product_categories',
				'label_for' => 'gp-section-header',	
					'type' => 'section-header',
				'class' => 'gp-setting gp-setting-begin',
			),
			
				array(
					'id' => 'wc_product_cat_per_page',
					'title' => esc_html__( 'Items Per Page', 'aardvark' ),
					'section' => $theme_slug . '_woocommerce_product_categories',
					'type' => 'spinner',
					'min' => 1,
					'max' => 999999,
					'default' => 12,
				),
			
			/**
			 * WooCommerce - Product Pages
			 *
			 */
			// Title header
			array(
				'id' => '_section_wc_product_pages_title_header',
				'title' => esc_html__( 'Ordering', 'aardvark' ),
				'section' => $theme_slug . '_woocommerce_product_pages',
				'label_for' => 'gp-section-header',	
				'type' => 'section-header',
				'class' => 'gp-setting gp-setting-begin',
			),
						 
				array( 
					'id' => 'wc_product_page_header',
					'title' => esc_html__( 'Display', 'aardvark' ),
					'section' => $theme_slug . '_woocommerce_product_pages',
					'type' => 'select',
					'options' => array(
						'gp-standard-page-header' => esc_html__( 'Standard', 'aardvark' ),
						'gp-fullwidth-page-header' => esc_html__( 'Full Width', 'aardvark' ),
						'gp-full-page-page-header' => esc_html__( 'Full Page', 'aardvark' ),
						'gp-minimal-page-header' => esc_html__( 'Minimal', 'aardvark' ),
						'gp-page-header-disabled' => esc_html__( 'Disabled', 'aardvark' ),
					),
					'default' => 'gp-minimal-page-header',
				),

				array( 
					'id' => 'wc_product_page_header_height',
					'title' => esc_html__( 'Height', 'aardvark' ),
					'section' => $theme_slug . '_woocommerce_product_pages',
					'type' => 'dimensions',
					'default' => array(
						'height' => 320,
					),	
				),

			// Layout
			array(
				'id' => 'wc_product_pages_layout_section',
				'title' => esc_html__( 'Layout', 'aardvark' ),
				'section' => $theme_slug . '_woocommerce_product_pages',
				'label_for' => 'gp-section-header',	
				'type' => 'section-header',
				'class' => 'gp-setting gp-setting-begin',
			),
										
				array( 
					'id' => 'wc_product_layout',
					'title' => esc_html__( 'Display', 'aardvark' ),
					'section' => $theme_slug . '_woocommerce_product_pages',
					'type' => 'select',
					'options' => array(
						'gp-left-sidebar' => esc_html__( 'Left Sidebar', 'aardvark' ), 
						'gp-right-sidebar' => esc_html__( 'Right Sidebar', 'aardvark' ),
						'gp-both-sidebars' => esc_html__( 'Both Sidebars', 'aardvark' ), 
						'gp-no-sidebar' => esc_html__( 'No Sidebar', 'aardvark' ),
						'gp-fullwidth' => esc_html__( 'Full Width', 'aardvark' ),
					),	
					'default' => 'gp-no-sidebar',
				),

				array(
					'id' => 'wc_product_left_sidebar',
					'title' => esc_html__( 'Left Sidebar', 'aardvark' ),
					'section' => $theme_slug . '_woocommerce_product_pages',
					'type'    => 'select',
					'data'    => 'sidebars',
					'default' => 'gp-left-sidebar',
				),

				array(
					'id' => 'wc_product_right_sidebar',
					'title' => esc_html__( 'Right Sidebar', 'aardvark' ),
					'section' => $theme_slug . '_woocommerce_product_pages',
					'type'    => 'select',
					'data'    => 'sidebars',
					'default' => 'gp-right-sidebar',
				),

			/**
			 * Sensei
			 *
			 */	
		
			/**
			 * Sensei - Course Archives
			 *
			 */
			// Title header
			array(
				'id' => 'courses_title_header_section',
				'title' => esc_html__( 'Title Header', 'aardvark' ),
				'section' => $theme_slug . '_sensei',
				'label_for' => 'gp-section-header',	
					'type' => 'section-header',
				'class' => 'gp-setting gp-setting-begin',
			),
			
				array( 
					'id' => 'courses_page_header',
					'title' => esc_html__( 'Display', 'aardvark' ),
					'section' => $theme_slug . '_sensei',
					'type' => 'select',
					'options' => array(
						'gp-standard-page-header' => esc_html__( 'Standard', 'aardvark' ),
						'gp-fullwidth-page-header' => esc_html__( 'Full Width', 'aardvark' ),
						'gp-full-page-page-header' => esc_html__( 'Full Page', 'aardvark' ),
						'gp-minimal-page-header' => esc_html__( 'Minimal', 'aardvark' ),
						'gp-page-header-disabled' => esc_html__( 'Disabled', 'aardvark' ),
					),
					'default' => 'gp-standard-page-header',
					),

				array(
					'id' => 'courses_page_header_bg', 
					'title' => esc_html__( 'Background', 'aardvark' ),
					'section' => $theme_slug . '_sensei',
					'type'  => 'media',			
					'default' => '',
					'conditions' => array(
						'courses_page_header' => array(
							'value' => array( 'gp-fullwidth-page-header', 'gp-full-page-page-header' ),
							'operator' => 'in_array',
						),	
					),
				),

				array( 
					'id' => 'courses_page_header_height',
					'title' => esc_html__( 'Height', 'aardvark' ),
					'section' => $theme_slug . '_sensei',
					'type' => 'dimensions',
					'default' => array(
						'height' => 320,
					),
					'conditions' => array(
						'courses_page_header' => array(
							'value' => array( 'gp-fullwidth-page-header', 'gp-full-page-page-header' ),
							'operator' => 'in_array',
						),	
					),
				 ),

			// Layout
			array(
				'id' => 'courses_layout_section',
				'title' => esc_html__( 'Layout', 'aardvark' ),
				'section' => $theme_slug . '_sensei',
				'label_for' => 'gp-section-header',	
					'type' => 'section-header',
				'class' => 'gp-setting gp-setting-begin',
			),
											
				array( 
					'id' => 'courses_layout',
					'title' => esc_html__( 'Display', 'aardvark' ),
					'section' => $theme_slug . '_sensei',
					'type' => 'select',
					'options' => array(
							'gp-left-sidebar' => esc_html__( 'Left Sidebar', 'aardvark' ), 
							'gp-right-sidebar' => esc_html__( 'Right Sidebar', 'aardvark' ),
							'gp-both-sidebars' => esc_html__( 'Both Sidebars', 'aardvark' ), 
							'gp-no-sidebar' => esc_html__( 'No Sidebar', 'aardvark' ),
							'gp-fullwidth' => esc_html__( 'Full Width', 'aardvark' ),
						),	
					'default' => 'gp-right-sidebar',
					),

				array(
					'id' => 'courses_left_sidebar',
					'title' => esc_html__( 'Left Sidebar', 'aardvark' ),
					'section' => $theme_slug . '_sensei',
					'type'    => 'select',
					'data'    => 'sidebars',
					'default' => 'gp-left-sidebar',
				),

				array(
					'id' => 'courses_right_sidebar',
					'title' => esc_html__( 'Right Sidebar', 'aardvark' ),
					'section' => $theme_slug . '_sensei',
					'type'    => 'select',
					'data'    => 'sidebars',
					'default' => 'gp-right-sidebar',
				),

			// Format
			array(
				'id' => 'courses_format_section',
				'title' => esc_html__( 'Format', 'aardvark' ),
				'section' => $theme_slug . '_sensei',
				'label_for' => 'gp-section-header',	
				'type' => 'section-header',
				'class' => 'gp-setting gp-setting-begin',
			),
			
				array( 
					'id' => 'courses_format',
					'title' => esc_html__( 'Display', 'aardvark' ),
					'section' => $theme_slug . '_sensei',
					'type' => 'select',
					'options' => array(
						'gp-posts-list' => esc_html__( 'List', 'aardvark' ),
						'gp-posts-large' => esc_html__( 'Large', 'aardvark' ),
						'gp-posts-columns-2' => esc_html__( '2 Columns', 'aardvark' ),
						'gp-posts-columns-3' => esc_html__( '3 Columns', 'aardvark' ),
						'gp-posts-columns-4' => esc_html__( '4 Columns', 'aardvark' ),
						'gp-posts-masonry' => esc_html__( 'Masonry', 'aardvark' ),
					),
					'default' => 'gp-posts-list',
				),
			
				array( 
					'id' => 'courses_style',
					'title' => esc_html__( 'Style', 'aardvark' ),
					'section' => $theme_slug . '_sensei',
					'type' => 'select',
					'options' => array(
						'gp-style-classic' => esc_html__( 'Classic', 'aardvark' ),
						'gp-style-modern' => esc_html__( 'Modern', 'aardvark' ),
					),
					'default' => 'gp-style-classic',
				),						

			// Post content
			array(
				'id' => 'courses_post_content_section',
				'title' => esc_html__( 'Post Content', 'aardvark' ),
				'section' => $theme_slug . '_sensei',
				'label_for' => 'gp-section-header',	
				'type' => 'section-header',
				'class' => 'gp-setting gp-setting-begin',
			),
						
				array( 
					'id' => 'courses_alignment',
					'title' => esc_html__( 'Text Alignment', 'aardvark' ),
					'section' => $theme_slug . '_sensei',
					'type' => 'select',
					'options' => array(
						'gp-align-left' => esc_html__( 'Left Aligned', 'aardvark' ),
						'gp-align-center' => esc_html__( 'Center Aligned', 'aardvark' ),
					),
					'default' => 'gp-align-left',
				),	

			/**
			 * Sensei - Course Pages
			 *
			 */
			// Title header
			array(
				'id' => 'course_page_title_header_section',
				'title' => esc_html__( 'Title Header', 'aardvark' ),
				'section' => $theme_slug . '_sensei_course_pages',
				'label_for' => 'gp-section-header',	
				'type' => 'section-header',
				'class' => 'gp-setting gp-setting-begin',
			),
				
				array( 
					'id' => 'course_page_header',
					'title' => esc_html__( 'Display', 'aardvark' ),
					'section' => $theme_slug . '_sensei_course_pages',
					'type' => 'select',
					'options' => array(
						'gp-standard-page-header' => esc_html__( 'Standard', 'aardvark' ),
						'gp-fullwidth-page-header' => esc_html__( 'Full Width', 'aardvark' ),
						'gp-full-page-page-header' => esc_html__( 'Full Page', 'aardvark' ),
						'gp-minimal-page-header' => esc_html__( 'Minimal', 'aardvark' ),
						'gp-page-header-disabled' => esc_html__( 'Disabled', 'aardvark' ),
					),
					'default' => 'gp-standard-page-header',
				),

				array( 
					'id' => 'course_page_header_height',
					'title' => esc_html__( 'Height', 'aardvark' ),
					'section' => $theme_slug . '_sensei_course_pages',
					'type' => 'dimensions',
					'default' => array(
						'height' => 320,
					),	
				 ),

			// Layout
			array(
				'id' => 'course_page_layout_section',
				'title' => esc_html__( 'Layout', 'aardvark' ),
				'section' => $theme_slug . '_sensei_course_pages',
				'label_for' => 'gp-section-header',	
				'type' => 'section-header',
				'class' => 'gp-setting gp-setting-begin',					
			),
			
				array( 
					'id' => 'course_layout',
					'title' => esc_html__( 'Display', 'aardvark' ),
					'section' => $theme_slug . '_sensei_course_pages',
					'type' => 'select',
					'options' => array(
						'gp-left-sidebar' => esc_html__( 'Left Sidebar', 'aardvark' ), 
						'gp-right-sidebar' => esc_html__( 'Right Sidebar', 'aardvark' ),
						'gp-both-sidebars' => esc_html__( 'Both Sidebars', 'aardvark' ), 
						'gp-no-sidebar' => esc_html__( 'No Sidebar', 'aardvark' ),
						'gp-fullwidth' => esc_html__( 'Full Width', 'aardvark' ),
					),	
					'default' => 'gp-right-sidebar',
				),

				array(
					'id' => 'course_left_sidebar',
					'title' => esc_html__( 'Left Sidebar', 'aardvark' ),
					'section' => $theme_slug . '_sensei_course_pages',
					'type'    => 'select',
					'data'    => 'sidebars',
					'default' => 'gp-left-sidebar',
				),

				array(
					'id' => 'course_right_sidebar',
					'title' => esc_html__( 'Right Sidebar', 'aardvark' ),
					'section' => $theme_slug . '_sensei_course_pages',
					'type'    => 'select',
					'data'    => 'sidebars',
					'default' => 'gp-right-sidebar',
				),

			/**
			 * Sensei - Lesson Pages
			 *
			 */
			// Title Header
			array(
				'id' => 'lesson_title_header_section',
				'title' => esc_html__( 'Title Header', 'aardvark' ),
				'section' => $theme_slug . '_sensei_lesson_pages',
				'label_for' => 'gp-section-header',	
				'type' => 'section-header',
				'class' => 'gp-setting gp-setting-begin',
			),	
			
				array( 
					'id' => 'lesson_page_header',
					'title' => esc_html__( 'Display', 'aardvark' ),
					'section' => $theme_slug . '_sensei_lesson_pages',
					'type' => 'select',
					'options' => array(
						'gp-standard-page-header' => esc_html__( 'Standard', 'aardvark' ),
						'gp-fullwidth-page-header' => esc_html__( 'Full Width', 'aardvark' ),
						'gp-full-page-page-header' => esc_html__( 'Full Page', 'aardvark' ),
						'gp-minimal-page-header' => esc_html__( 'Minimal', 'aardvark' ),
						'gp-page-header-disabled' => esc_html__( 'Disabled', 'aardvark' ),
					),
					'default' => 'gp-standard-page-header',
				),

				array( 
					'id' => 'lesson_page_header_height',
					'title' => esc_html__( 'Height', 'aardvark' ),
					'section' => $theme_slug . '_sensei_lesson_pages',
					'type' => 'dimensions',
					'default' => array(
						'height' => 320,	
					),		
				),

			// Layout
			array(
				'id' => 'lesson_layout_section',
				'title' => esc_html__( 'Layout', 'aardvark' ),
				'section' => $theme_slug . '_sensei_lesson_pages',
				'label_for' => 'gp-section-header',	
				'type' => 'section-header',
				'class' => 'gp-setting gp-setting-begin',
			),	
										
				array( 
					'id' => 'lesson_layout',
					'title' => esc_html__( 'Display', 'aardvark' ),
					'section' => $theme_slug . '_sensei_lesson_pages',
					'type' => 'select',
					'options' => array(
						'gp-left-sidebar' => esc_html__( 'Left Sidebar', 'aardvark' ), 
						'gp-right-sidebar' => esc_html__( 'Right Sidebar', 'aardvark' ),
						'gp-both-sidebars' => esc_html__( 'Both Sidebars', 'aardvark' ), 
						'gp-no-sidebar' => esc_html__( 'No Sidebar', 'aardvark' ),
						'gp-fullwidth' => esc_html__( 'Full Width', 'aardvark' ),
					),	
					'default' => 'gp-right-sidebar',
				),

				array(
					'id' => 'lesson_left_sidebar',
					'title' => esc_html__( 'Left Sidebar', 'aardvark' ),
					'section' => $theme_slug . '_sensei_lesson_pages',
					'type'    => 'select',
					'data'    => 'sidebars',
					'default' => 'gp-left-sidebar',
				),

				array(
					'id' => 'lesson_right_sidebar',
					'title' => esc_html__( 'Right Sidebar', 'aardvark' ),
					'section' => $theme_slug . '_sensei_lesson_pages',
					'type'    => 'select',
					'data'    => 'sidebars',
					'default' => 'gp-right-sidebar',
				),

			/**
			 * Advanced
			 *
			 */
			// General
			array(
				'id' => 'advanced_section',
				'title' => esc_html__( 'General', 'aardvark' ),
				'section' => $theme_slug . '_advanced',
				'label_for' => 'gp-section-header',	
				'type' => 'section-header',
				'class' => 'gp-setting gp-setting-begin',	
			),

				array(  
					'id' => 'ajax',
					'title' => esc_html__( 'Ajax', 'aardvark' ),
					'section' => $theme_slug . '_advanced',
					'desc' => esc_html__( 'Frontend filtering and pagination are loaded using ajax.', 'aardvark' ),
					'type' => 'radio',
					'options'   => array(
						'gp-ajax-loop' => esc_html__( 'Enabled', 'aardvark' ),
						'gp-standard-loop' => esc_html__( 'Disabled', 'aardvark' )
					),
					'default'   => 'gp-ajax-loop',			
				),

				array(  
					'id' => 'lightbox',
					'title' => esc_html__( 'Lightbox', 'aardvark' ),
					'section' => $theme_slug . '_advanced',
					'type'  => 'select',
					'desc' => esc_html__( 'Make sure the images open the media file and not the attachment page.', 'aardvark' ),
					'options'   => array(
						'group_images' => esc_html__( 'All images on page show as gallery within lightbox window', 'aardvark' ),
						'separate_images' => esc_html__( 'Images are not grouped', 'aardvark' ),
						'disabled' => esc_html__( 'Disabled', 'aardvark' ),
					),	
					'default' => 'group_images',
				),

				array(  
					'id' => 'automatic_video_resizing',
					'title' => esc_html__( 'Automatic Video Resizing', 'aardvark' ),
					'section' => $theme_slug . '_advanced',
					'type'  => 'radio',
					'desc' => esc_html__( 'Videos are automatically resized for a better appearance. You can enable this option and still disable it for specific videos by adding the class "wp-embedded-content" to your iframe.', 'aardvark' ),
					'options'   => array(
						'enabled' => esc_html__( 'Enabled', 'aardvark' ),
						'disabled' => esc_html__( 'Disabled', 'aardvark' ),
					),	
					'default' => 'enabled',
				),

				array(  
					'id' => 'fontawesome5',
					'title' => esc_html__( 'FontAwesome 5', 'aardvark' ),
					'section' => $theme_slug . '_advanced',
					'type'  => 'radio',
					'desc' => esc_html__( 'Use FontAwesome 5 instead of FontAwesome 4. Please note WPBakery Page Builder plugin still uses FontAwesome 4, so enabling this will stop their FontAwesome icons from working.', 'aardvark' ),
					'options'   => array(
						'enabled' => esc_html__( 'Enabled', 'aardvark' ),
						'disabled' => esc_html__( 'Disabled', 'aardvark' ),
					),	
					'default' => 'disabled',
				),

			// Import/Export
			array(
				'id' => 'import_export_section',
				'title' => esc_html__( 'Import/Export', 'aardvark' ),
				'section' => $theme_slug . '_advanced',				
				'label_for' => 'gp-section-header',	
				'type' => 'section-header',
				'class' => 'gp-setting gp-setting-begin',
			),	

				array(
					'id' => 'import_settings',
					'title' => esc_html__( 'Import', 'aardvark' ),
					'section' => $theme_slug . '_advanced',
					'desc' => esc_html__( 'Upload your theme options file with a .txt extension.', 'aardvark' ),
					'type' => 'import',
				),
				
				array(
					'id' => 'export_settings',
					'title' => esc_html__( 'Export', 'aardvark' ),
					'section' => $theme_slug . '_advanced',
					'desc' => esc_html__( 'Downloads a .txt file that contains all your theme options data.', 'aardvark' ),
					'type' => 'export',
				),		
												 
		);	

		$settings = apply_filters( 'ghostpool_global_settings', $settings, $theme_slug );

		return $settings;
		
	}
}