<?php

// Set order of variables
$key_order = array(
	'border-width',
	'border-top',
	'border-right',
	'border-bottom',
	'border-left',
	'border-style',
	'border-color',
);
$new_order = array();
foreach( $key_order as $key ) {
	if ( isset( $default[$key] ) ) {
		$new_order[$key] = $default[$key];
	}
}

if ( isset( $new_order ) ) {

	// Setting title
	$wp_customize->add_setting( 
		$id,
		array(
			'capability' => 'edit_theme_options',
			'type' => 'theme_mod',
		)
	);		
	$wp_customize->add_control(
		new GhostPool_Title_Control( 
		$wp_customize,
		$id,
		array(
			'label'      => $title,
			'section'    => $section,
			'settings'   => $id,
			'type'       => 'title',
		) )
	);
	
	// Settings
	foreach( $new_order as $key => $default_value ) {					

		if ( 'border-width' === $key OR 'border-top' === $key OR 'border-right' === $key OR 'border-bottom' === $key OR 'border-left' === $key ) {

			$wp_customize->add_setting( 
				$id . '[' . $key . ']', 
				array(
					'default' => $default_value,
					'capability' => 'edit_theme_options',
					'type' => 'option',
					'sanitize_callback' => 'ghostpool_sanitize_dimensions',
				) 
			);
			$wp_customize->add_control(
				$id . '[' . $key . ']',  
				array(
					'label'      => '',
					'description' => '',
					'section'    => $section,
					'settings' => $id . '[' . $key . ']',
				)
			);
		}	
	
		if ( 'border-style' === $key ) {
			$wp_customize->add_setting( 
				$id . '[' . $key . ']', 
				array(
					'default' => $default_value,
					'capability' => 'edit_theme_options',
					'type' => 'option',
					'sanitize_callback' => 'ghostpool_customizer_sanitize_select',
				) 
			);
			$wp_customize->add_control(
				$id . '[' . $key . ']',  
				array(
					'label'      => '',
					'description' => '',
					'section'    => $section,
					'settings' => $id . '[' . $key . ']',  
					'type' => 'select',
					'choices' => array(
						'solid'  => 'Solid',
						'dashed' => 'Dashed',
						'dotted' => 'Dotted',
						'double' => 'Double',
						'none'   => 'None',
					), 
				)
			);
		}	

		if ( 'border-color' === $key ) {
			$wp_customize->add_setting( 
				$id . '[' . $key . ']', 
				array(
					'default' => $default_value,
					'capability' => 'edit_theme_options',
					'type' => 'option',
					'sanitize_callback' => 'ghostpool_sanitize_colors',
				) 
			);
			$wp_customize->add_control(
				new WP_Customize_Color_Control( 
					$wp_customize,
					$id . '[' . $key . ']',  
					array(
						'label'      => '',
						'description' => '',
						'section'    => $section,
						'settings' => $id . '[' . $key . ']',  
						'choices' => array(
							'solid'  => 'Solid',
							'dashed' => 'Dashed',
							'dotted' => 'Dotted',
							'double' => 'Double',
							'none'   => 'None',
						), 
					)
				)	
			);
		}	
		
	}
	
}