<?php

// Set order of variables
$key_order = array(
	'regular',
	'hover',
	'active',
);
$new_order = array();
foreach( $key_order as $key ) {
	if ( isset( $default[$key] ) ) {
		$new_order[$key] = $default[$key];
	}
}

if ( isset( $new_order ) ) {

	// Setting title
	$wp_customize->add_setting( 
		$id,
		array(
			'capability' => 'edit_theme_options',
			'type' => 'theme_mod',
		)
	);		
	$wp_customize->add_control(
		new GhostPool_Title_Control( 
		$wp_customize,
		$id,
		array(
			'label'      => $title,
			'section'    => $section,
			'settings'   => $id,
			'type'       => 'title',
		) )
	);
		
	// Settings	
	foreach( $new_order as $key => $default_value  ) {
		
		if ( 'regular' === $key ) {
			$title = esc_html__( 'Regular', 'aardvark' );
		} elseif ( 'hover' === $key ) {
			$title = esc_html__( 'Hover', 'aardvark' );
		} elseif ( 'active' === $key ) {
			$title = esc_html__( 'Active', 'aardvark' );
		}
			
		$wp_customize->add_setting( 
			$id . '[' . $key . ']',
			array(
				'default' => $default_value ,
				'capability' => 'edit_theme_options',
				'type' => 'option',
				'sanitize_callback' => 'ghostpool_sanitize_colors',
			)
		);
					
		$wp_customize->add_control(
			new WP_Customize_Color_Control( 
			$wp_customize,
			$id . '[' . $key . ']',
			array(
				'label'      => $title,
				'section'    => $section,
				'settings'   => $id . '[' . $key . ']',
			) )
		);
		
	}
	
}