jQuery( function( $ ) {
	
	'use strict';

	// Submit forms
	var formArray = ['.gp-login-form', '.gp-lost-password-form', '.gp-register-form'];

	$.each( formArray, function( index, value ) {

		$( value ).on( 'submit', function( e ) {
		
			e.preventDefault();

			var form = $( this );

			// Show verfying... text
			form.find( '.gp-login-results' ).fadeIn( 'slow' ).html( '<div>' + ghostpool_ajax_login_params.loading_message + '</div>' );

			var formParameters = { 
				action: 'ghostpool_ajax_login',
				formType: form.find( '[name="form_type"]' ).val(),
				loginUsername: form.find( '[name="log"]' ).val(), 
				loginPassword: form.find( '[name="pwd"]' ).val(), 			
				loginRemember: form.find( '[name="rememberme"]' ).val(),
				registrationUsername: form.find( '[name="user_login"]' ).val(), 
				registrationEmail: form.find( '[name="user_email"]' ).val(), 
				registrationPassword: form.find( '[name="user_pass"]' ).val(), 
				registrationConfirmPassword: form.find( '[name="user_confirm_pass"]' ).val(),
				resetLogin: form.find( '[name="login"]' ).val(), 
				resetKey: form.find( '[name="key"]' ).val(), 
				resetPass1: form.find( '[name="pass1"]' ).val(), 
				resetPass2: form.find( '[name="pass2"]' ).val()
				//ghostpool_ajax_login_nonce: form.find( '[name*="ghostpool_ajax_login_nonce"]' ).val()	
			};
						
			$.ajax({
				type: 'POST',
				url: ghostpool_ajax_login_params.ajax_url,
				data: formParameters,
				dataType: 'json',
				success: function( data ) {
					
					// Show success/error message
					form.find( '.gp-login-results' ).fadeIn( 'slow' ).html( '<div>' + data.message + '</div>' );
			
					// Upon successfull login, redirect
                    if ( data.status == 'login-success' ) {
					
                    	if ( data.redirect != '' ) {
                    		document.location.href = data.redirect;
                    	} else {
							document.location.reload();
						}
						
					}
					
					// Upon successfull registration
                    if ( data.status == 'registration-success' ) {
						form.find( '.gp-input' ).hide();
					}	
					
					// Upon succesfull lost password submission
					if ( data.status == 'lost-password-success' ) {
						form.find( '.gp-input' ).hide();       	
               		}
               		
					// Upon succesfull password reset
					if ( data.status == 'reset-password-success' ) {
						form.find( '.gp-input' ).hide();       	
               		}
					
				},
				error: function( xhr, status, error ) {
			
					// Reset captcha on error
					if ( form.find( '.gglcptch > div' ).length > 0 ) {
						grecaptcha.getResponse();
						grecaptcha.reset();
					}
					
					// Show error message
					form.find( '.gp-login-results' ).fadeIn( 'slow' ).html( '<div>' + xhr.responseText + '</div>' );
					
				}
			});
			
		});

	});

	// Close modal window when clicking outside of it		
	$( document ).mouseup( function( e ) {
		var container = $( '#gp-login-modal' );
		if ( ! container.is( e.target ) && container.has( e.target ).length === 0 ) {
			$( '#login' ).hide();
			$( '#gp-login-modal .gp-login-results > div' ).remove();
		}
	});

	// Close modal window when clicking close button
	$( '#gp-login-close' ).on( 'click', function() {		
		$( '#login' ).hide();
		$( '#gp-login-modal .gp-login-results > div' ).remove();
	});	

	// Switch to login form when clicking links
	$( 'a.gp-login-link' ).on( 'click', function( event ) {
		event.preventDefault();
		var parent = $( this ).closest( '.gp-login-register-form' );
		parent.find( '.gp-login-form-wrapper' ).show();
		parent.find( '.gp-register-form-wrapper, .gp-lost-password-form-wrapper' ).hide();
		parent.find( '.gp-login-results > div' ).remove();
	});	
	
	// Open login modal window when clicking link	
	if ( $( '.gp-login-form-wrapper' ).length > 0 ) {
		$( 'a[href*="#login"]' ).on( 'click', function( event ) {
			event.preventDefault();
			$( '#login' ).show();
			$( '.gp-login-form-wrapper' ).show();
			$( '.gp-register-form-wrapper, .gp-lost-password-form-wrapper' ).hide();
			$( '.gp-login-results > div' ).remove();
		});	
	}
	
	// Open login modal window directly from URL
	if ( /#login/.test( window.location.href ) && $( '.gp-login-form-wrapper' ).length > 0 ) {
		$( '#login' ).show();
		$( '.gp-login-form-wrapper' ).show();
		$( '.gp-register-form-wrapper, .gp-lost-password-form-wrapper' ).hide();
		$( '.gp-login-results > div' ).remove();
	}	

	// Switch to lost password form when clicking link								
	if ( $( '.gp-lost-password-form-wrapper' ).length > 0 ) {
		$( 'a.gp-lost-password-link' ).on( 'click', function( event ) {
			event.preventDefault();
			var parent = $( this ).closest( '.gp-login-register-form' );
			parent.find( '.gp-lost-password-form-wrapper, .gp-input' ).show();	
			parent.find( '.gp-input input' ).val( '' );
			parent.find( '.gp-register-form-wrapper, .gp-login-form-wrapper' ).hide();
			parent.find( '.gp-login-results > div' ).remove();
		});	
	}
			
	// Open lost password modal window directly from URL
	if ( /#lost-password/.test( window.location.href ) && $( '.gp-lost-password-form-wrapper' ).length > 0 ) {
		$( '#login' ).show();
		$( '.gp-lost-password-form-wrapper' ).show();
		$( '.gp-register-form-wrapper, .gp-login-form-wrapper' ).hide();
		$( '.gp-login-results > div' ).remove();
	}
			
	// Open reset password modal window directly from URL
	if ( /reset_pwd=true/.test( window.location.href ) && $( '.gp-lost-password-form-wrapper' ).length > 0 ) {
		$( '#login' ).show();
		$( '.gp-lost-password-form-wrapper' ).show();
		$( '.gp-register-form-wrapper, .gp-login-form-wrapper' ).hide();
		$( '.gp-login-results > div' ).remove();
	}
	
	// Switch to registration form when clicking link	
	$( 'a.gp-register-link' ).on( 'click', function( event ) {
		event.preventDefault();
		var parent = $( this ).closest( '.gp-login-register-form' );
		parent.find( '.gp-register-form-wrapper, .gp-input' ).show();
		parent.find( '.gp-input input' ).val( '' );
		parent.find( '.gp-login-form-wrapper, .gp-lost-password-form-wrapper' ).hide();
		parent.find( '.gp-login-results > div' ).remove();
	});
	
	// Open registration modal window when clicking link	
	if ( $( '.gp-register-form-wrapper' ).length > 0 ) {
		$( 'a[href*="#register"]' ).on( 'click', function( event ) {
			event.preventDefault();
			$( '#login' ).show();
			$( '.gp-register-form-wrapper, .gp-register-form .gp-input' ).show();
			$( '.gp-register-form .gp-input input' ).val( '' );
			$( '.gp-login-form-wrapper, .gp-lost-password-form-wrapper' ).hide();
			$( '.gp-login-results > div' ).remove();
		});
	}
	
	// Open registration modal window directly from URL
	if ( /#register/.test( window.location.href ) && $( '.gp-register-form-wrapper' ).length > 0 ) {
		$( '#login' ).show();
		$( '.gp-register-form-wrapper, .gp-register-form .gp-input' ).show();
		$( '.gp-register-form .gp-input input' ).val( '' );
		$( '.gp-login-form-wrapper, .gp-lost-password-form-wrapper' ).hide();
		$( '.gp-login-results > div' ).remove();
	}

});	