<?php

global $wp_embed;

$image = ghostpool_image_data( ghostpool_option( 'post_image_size' ) );
	
if ( get_post_meta( get_the_ID(), 'gp_video_embed_url', true ) ) {
	
	$output = do_shortcode( $wp_embed->run_shortcode( '[embed width="' . absint( $image['width'] ) . '" height="' . absint( $image['height'] ) . '"]' . esc_url( get_post_meta( get_the_ID(), 'gp_video_embed_url', true ) ) . '[/embed]' ) );

} else { 

	$mp4 = '';
	$m4v = '';
	$webm = '';
	$ogv = '';

	if ( get_post_meta( get_the_ID(), 'gp_video_mp4_url', true ) ) {	
		$mp4 = wp_get_attachment_url( get_post_meta( get_the_ID(), 'gp_video_mp4_url', true ) );
	}

	if ( get_post_meta( get_the_ID(), 'gp_video_m4v_url', true ) ) {		
		$m4v = wp_get_attachment_url( get_post_meta( get_the_ID(), 'gp_video_m4v_url', true ) );
	}

	if ( get_post_meta( get_the_ID(), 'gp_video_webm_url', true ) ) {	
		$webm = wp_get_attachment_url( get_post_meta( get_the_ID(), 'gp_video_webm_url', true ) );
	}

	if ( get_post_meta( get_the_ID(), 'gp_video_ogv_url', true ) ) {	
		$ogv = wp_get_attachment_url( get_post_meta( get_the_ID(), 'gp_video_ogv_url', true ) );
	}

	$output = do_shortcode( '[video mp4="' . esc_url( $mp4 ) . '" m4v="' . esc_url( $m4v ) . '" webm="' . esc_url( $webm ). '" ogv="' . esc_url( $ogv ) . '" width="' . absint( $image['width'] ) . '" height="' . absint( $image['height'] ) . '"][/video]' );

}

if ( ! empty( $output ) ) {
	echo '<div class="gp-video-wrapper">' . $output . '</div>'; 
}