<?php

// Page options
$display_image = ( get_post_meta( get_the_ID(), 'gp_featured_image', true ) && get_post_meta( get_the_ID(), 'gp_featured_image', true ) != 'default' ) ? get_post_meta( get_the_ID(), 'gp_featured_image', true ) : ghostpool_option( 'page_featured_image' );
$image = ghostpool_image_data( ghostpool_option( 'page_image_size' ) );	
$image_source = ghostpool_option( 'page_image_source' );

if ( ( has_post_thumbnail() OR $image_source ) && $display_image == 'enabled' ) { ?>
	<div class="gp-post-thumbnail gp-entry-featured">
		<?php if ( $image_source && get_post_meta( get_the_ID(), $image_source, true ) ) {
			$image_id = get_post_meta( get_the_ID(), $image_source, true );
			echo wp_get_attachment_image( $image_id, $image['name'] );
		} elseif ( has_post_thumbnail() ) {
			echo get_the_post_thumbnail( get_the_ID(), $image['name'] );
		} ?>
		<?php $attachment_id = get_post( get_post_thumbnail_id() ); if ( isset( $attachment_id->post_excerpt ) ) { ?><div class="wp-caption-text"><?php echo esc_attr( $attachment_id->post_excerpt ); ?></div><?php } ?>
	</div>
<?php } ?>

<div class="gp-entry-content">

	<?php if ( have_posts() ) : while ( have_posts() ) : the_post();
		the_content();
	endwhile;
	endif; ?>

	<?php wp_link_pages( array(
		'before' => '<div class="gp-entry-pagination">',
		'after'  => '</div>',
		'next_or_number' => 'ghostpool_next_and_number',
		'nextpagelink' => '',
		'previouspagelink' => '',
	) ); ?>

</div>

<?php if ( ! function_exists( 'pmpro_has_membership_access' ) OR ( function_exists( 'pmpro_has_membership_access' ) && pmpro_has_membership_access() ) ) { ?>

	<?php if ( function_exists( 'ghostpool_share_icons' ) && 'enabled' === ghostpool_option( 'page_share_icons' ) ) {
		echo ghostpool_share_icons();
	} ?>
		
	<?php if ( function_exists( 'ghostpool_voting' ) && ghostpool_option( 'page_voting' ) == 'enabled' ) {
		echo ghostpool_voting( get_the_ID(), ghostpool_option( 'page_voting_title' ) );
	} ?>	
	
	<?php if ( ghostpool_option( 'page_author_info' ) == 'enabled' ) {
		get_template_part( 'lib/sections/single/author-info' );
	} ?>

	<?php comments_template();
	
}	