<?php 

/**
 * Get settings
 *
 */
$settings = get_query_var( 'ghostpool_loop_settings' );
if ( $settings &&  is_array( $settings ) ) {
	extract( $settings );
} else {
	$settings = get_query_var( 'ghostpool_page_settings' );
	if ( $settings && is_array( $settings ) ) {
		extract( $settings );
	}
}

// Use standard post ID if none specified
if ( ! isset( $post_id ) ) {
	$post_id = get_the_ID();
}

$mp3 = '';
$ogg = '';

if ( get_post_meta( $post_id, 'gp_audio_mp3_url', true ) ) {
	$mp3 = wp_get_attachment_url( get_post_meta( $post_id, 'gp_audio_mp3_url', true ) );
}

if ( get_post_meta( $post_id, 'gp_audio_ogg_url', true ) ) {
	$ogg = wp_get_attachment_url( get_post_meta( $post_id, 'gp_audio_ogg_url', true ) );
}
		
echo do_shortcode( '[audio mp3="' . esc_url( $mp3 ) . '" ogg="' . esc_url( $ogg ) . '"][/audio]' );