<?php 

/**
 * Get settings
 * var $meta_author, $meta_date, $meta_comment_count, $meta_views, $meta_likes, $meta_cats
 *
 */
$settings = get_query_var( 'ghostpool_loop_settings' );
if ( $settings &&  is_array( $settings ) ) {
	extract( $settings );
} else {
	$settings = get_query_var( 'ghostpool_page_settings' );
	if ( $settings && is_array( $settings ) ) {
		extract( $settings );
	}
}

if ( $meta_author == true OR $meta_date == true OR $meta_comment_count == true OR $meta_views == true OR $meta_likes == true OR $meta_cats == true ) { ?>

	<div class="gp-loop-meta">

		<?php if ( $meta_author == true ) { ?><span class="gp-post-meta gp-meta-author"><?php echo ghostpool_author_name( get_the_ID() ); ?></span><?php } ?>

		<?php if ( $meta_date == true ) { ?>	
			<span class="gp-post-meta gp-meta-date"><a href="<?php if ( get_post_format() == 'link' ) { echo esc_url( get_post_meta( get_the_ID(), 'gp_link', true ) ); } else { the_permalink(); } ?>" title="<?php the_title_attribute(); ?>"<?php if ( get_post_format() == 'link' ) { ?> target="<?php echo esc_attr( get_post_meta( get_the_ID(), 'gp_link_target', true ) ); ?>"<?php } ?>><time datetime="<?php echo get_the_date( 'c' ); ?>"><?php the_time( get_option( 'date_format' ) ); ?></time></a></span>
		<?php } ?>

		<?php if ( $meta_comment_count == true ) { ?><span class="gp-post-meta gp-meta-comments"><?php comments_popup_link( esc_html__( 'No Comments', 'aardvark' ), esc_html__( '1 Comment', 'aardvark' ), esc_html__( '% Comments', 'aardvark' ), 'comments-link', esc_html__( 'Comments Closed', 'aardvark' ) ); ?></span><?php } ?>

		<?php if ( function_exists( 'wpp_get_views' ) && $meta_views == true ) { ?><span class="gp-post-meta gp-meta-views"><?php if ( function_exists( 'wpp_get_views' ) ) { echo wpp_get_views( get_the_ID() ); } ?> <?php esc_html_e( 'views', 'aardvark' ); ?></span><?php } ?>		

		<?php if ( $meta_likes == true ) { ?>
			<span class="gp-post-meta gp-meta-likes"><?php if ( function_exists( 'ghostpool_voting_show_up_votes' ) ) { echo ghostpool_voting_show_up_votes(); } ?></span>
		<?php } ?>

		<?php if ( $meta_cats == true ) { ?>
			<span class="gp-post-meta gp-meta-cats"><?php echo ghostpool_exclude_cats( get_the_ID(), false, true ); ?></span>
		<?php } ?>
	
	</div>

<?php }