<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
<meta charset="<?php bloginfo( 'charset' ); ?>">
<meta name="viewport" content="width=device-width, initial-scale=1">
<?php if ( ghostpool_option( 'address_bar_color' ) ) { ?>
	<meta name="theme-color" content="<?php echo ghostpool_option( 'address_bar_color' ); ?>"/>
<?php } ?>
<link rel="profile" href="http://gmpg.org/xfn/11" />
<?php if ( is_singular() && pings_open( get_queried_object() ) ) { ?>
	<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>" />
<?php } ?>
<?php wp_head(); ?>
</head>
<body <?php body_class(); ?>>

<?php if ( function_exists( 'wp_body_open' ) ) {
	wp_body_open();
} ?>

<?php get_template_part( 'lib/sections/header/page-loader' ); ?>

<?php

// Page options
if ( function_exists( 'bp_is_active' ) && bp_is_register_page() ) {
	$header_display = ghostpool_option( 'bp_register_header_display' ) != 'default' ? ghostpool_option( 'bp_register_header_display' ) : ghostpool_option( 'header_display' );	
} elseif ( function_exists( 'bp_is_active' ) && bp_is_activation_page() ) {
	$header_display = ghostpool_option( 'bp_activate_header_display' ) != 'default' ? ghostpool_option( 'bp_activate_header_display' ) : ghostpool_option( 'header_display' );	
} else {
	$header_display = ( get_post_meta( get_the_ID(), 'gp_page_header_display', true ) && get_post_meta( get_the_ID(), 'gp_page_header_display', true ) != 'default' ) ? get_post_meta( get_the_ID(), 'gp_page_header_display', true ) : ghostpool_option( 'header_display' );	
} ?>

<div id="gp-global-wrapper"<?php if ( $header_display != 'gp-header-disabled' && ghostpool_option( 'side_menu_show_by_default' ) == 'enabled' ) { ?> class="gp-active-desktop-side-menu gp-side-menu-open-default <?php echo ghostpool_option( 'side_menu' ); ?>"<?php } ?>>
		
	<?php if ( $header_display != 'gp-header-disabled' ) { get_template_part( 'lib/sections/header/side-menu-left' ); } ?>
		
	<div id="gp-site-wrapper">	

		<?php if ( $header_display != 'gp-header-disabled' ) { ?>
		
			<?php if ( ! function_exists( 'elementor_theme_do_location' ) OR ! elementor_theme_do_location( 'header' ) ) { ?>

				<?php get_template_part( 'lib/sections/header/top-header' ); ?>
		
				<?php get_template_part( 'lib/sections/header/mobile-header' ); ?>

				<?php get_template_part( 'lib/sections/header/standard-header' ); ?>
				
				<div class="gp-clear"></div>
			
			<?php } ?>
	
		<?php } ?>
						
		<div id="gp-page-wrapper">