<?php
		
/**
 * Add Responsive Pro defaults
 *
 */	
if ( ! function_exists( 'ghostpool_bbvcedo_default_devices' ) ) {
	function ghostpool_bbvcedo_default_devices() {
		
		if ( defined( 'BESTBUG_RPPRO_POSTTYPE_DEVICE' ) ) {

			if ( '1' !== get_option( 'ghostpool_plugin_defaults_responsive_pro' ) ) {
			
				// Enable for all shortcodes
				update_option( 'bbrppro_all_vcshortcodes', 'vc_row,vc_row_inner,vc_column,vc_column_inner,vc_column_text,vc_section,vc_icon,vc_separator,vc_zigzag,vc_text_separator,vc_message,vc_hoverbox,vc_facebook,vc_tweetmeme,vc_googleplus,vc_pinterest,vc_toggle,vc_single_image,vc_gallery,vc_images_carousel,vc_tta_tabs,vc_tta_tour,vc_tta_accordion,vc_tta_pageable,vc_tta_section,vc_custom_heading,vc_btn,vc_cta,vc_widget_sidebar,vc_posts_slider,vc_video,vc_gmaps,vc_raw_html,vc_raw_js,vc_flickr,vc_progress_bar,vc_pie,vc_round_chart,vc_line_chart,vc_wp_search,vc_wp_meta,vc_wp_recentcomments,vc_wp_calendar,vc_wp_pages,vc_wp_tagcloud,vc_wp_custommenu,vc_wp_text,vc_wp_posts,vc_wp_links,vc_wp_categories,vc_wp_archives,vc_wp_rss,vc_empty_space,vc_basic_grid,vc_media_grid,vc_masonry_grid,vc_masonry_media_grid,vc_tabs,vc_tour,vc_tab,vc_accordion,vc_accordion_tab,vc_posts_grid,vc_carousel,vc_button,vc_button2,vc_cta_button,vc_cta_button2,gp_activity,gp_bp_groups,gp_bp_members,gp_bp_whos_online,gp_bp_profile_search,gp_carousel_posts,gp_carousel_images,gp_featured_box,gp_login_register_form,gp_particles,gp_posts,gp_post_submission_form,gp_post_submission_form_2,gp_showcase,gp_statistics,gp_team,gp_team_member,gp_testimonial_slider,gp_testimonial,woocommerce_my_account,recent_products,featured_products,product,products,add_to_cart,add_to_cart_url,product_page,product_category,product_categories,sale_products,best_selling_products,top_rated_products,product_attribute,related_products,vc_gutenberg,bb_responsive_pro,gp_pricing_column' );
				update_option( 'bb_rppro_shortcodes', 'vc_row,vc_column,vc_custom_heading' );
				update_option( 'bb_rppro_title', 'Responsive' );
				update_option( 'bb_rppro_group', 'Responsive PRO' );
				update_option( 'bb_rppro_tabs_on_right', 'yes' );
				update_option( 'bb_rppro_add_div_container', 'no' );
				update_option( 'bb_rppro_all_shortcodes', 'yes' );
				update_option( 'bb_rppro_add_option', 'yes' );
			
				// Create device sizes
				if ( post_type_exists( 'bb_device' ) ) {
			
					// Default devices
					$device_args = array(
					  'post_title'    => esc_html__( 'Default devices', 'aardvark' ),
					  'post_status'   => 'publish',
					  'post_type' => 'bb_device',
					  'post_name' => 'x_large',
					);
					$device_id = wp_insert_post( $device_args );
					if ( $device_id ) { 
						add_post_meta( $device_id, 'use_font_icon', 'yes' ); 
						add_post_meta( $device_id, 'font_icon', 'dashicons dashicons-desktop' ); 
						add_post_meta( $device_id, 'order', '1' );
					}
			
					// Large devices
					$device_args = array(
					  'post_title'    => esc_html__( 'Large devices', 'aardvark' ),
					  'post_status'   => 'publish',
					  'post_type' => 'bb_device',
					  'post_name' => 'large',
					);
					$device_id = wp_insert_post( $device_args );
					if ( $device_id ) {
						add_post_meta( $device_id, 'mediafeature', 'max-width' ); 
						add_post_meta( $device_id, 'breakpoint', '1199' ); 
						add_post_meta( $device_id, 'use_font_icon', 'yes' ); 
						add_post_meta( $device_id, 'font_icon', 'dashicons dashicons-laptop' ); 
						add_post_meta( $device_id, 'order', '2' );
					}
			
					// Medium devices
					$device_args = array(
					  'post_title'    => esc_html__( 'Medium devices', 'aardvark' ),
					  'post_status'   => 'publish',
					  'post_type' => 'bb_device',
					  'post_name' => 'medium',
					);
					$device_id = wp_insert_post( $device_args );
					if ( $device_id ) {
						add_post_meta( $device_id, 'mediafeature', 'max-width' ); 
						add_post_meta( $device_id, 'breakpoint', '991' ); 
						add_post_meta( $device_id, 'use_font_icon', 'yes' ); 
						add_post_meta( $device_id, 'font_icon', 'dashicons dashicons-tablet' ); 
						add_post_meta( $device_id, 'order', '3' );
					}
			
					// Small devices
					$device_args = array(
					  'post_title'    => esc_html__( 'Small devices', 'aardvark' ),
					  'post_status'   => 'publish',
					  'post_type' => 'bb_device',
					  'post_name' => 'small',
					);
					$device_id = wp_insert_post( $device_args );
					if ( $device_id ) {
						add_post_meta( $device_id, 'mediafeature', 'max-width' ); 
						add_post_meta( $device_id, 'breakpoint', '767' ); 
						add_post_meta( $device_id, 'use_font_icon', 'yes' ); 
						add_post_meta( $device_id, 'font_icon', 'dashicons dashicons-image-rotate-right' ); 
						add_post_meta( $device_id, 'order', '4' );
					}
			
					// Extra small devices
					$device_args = array(
					  'post_title'    => esc_html__( 'Extra small devices', 'aardvark' ),
					  'post_status'   => 'publish',
					  'post_type' => 'bb_device',
					  'post_name' => 'x_small',
					);
					$device_id = wp_insert_post( $device_args );
					if ( $device_id ) {
						add_post_meta( $device_id, 'mediafeature', 'max-width' ); 
						add_post_meta( $device_id, 'breakpoint', '479' ); 
						add_post_meta( $device_id, 'use_font_icon', 'yes' ); 
						add_post_meta( $device_id, 'font_icon', 'dashicons dashicons-smartphone' ); 
						add_post_meta( $device_id, 'order', '5' );
					}
					
				}	
				
				update_option( 'ghostpool_plugin_defaults_responsive_pro', '1' );
		
			}

		}

	}		
}		
add_action( 'init', 'ghostpool_bbvcedo_default_devices' );

/**
 * Set default option values for Responsive Visual Composer
 *
 */
if ( class_exists( 'BestBugVCEDO' ) ) {
	function ghostpool_bbvcedo_options_by_elements_default() {	
		return 'all';
	}	
	add_filter( 'bbvcedo_options_by_elements_default', 'ghostpool_bbvcedo_options_by_elements_default' );	
}

/**
 * Add additional Responsive Page Builder device sizes
 *
 */	
if ( ! function_exists( 'ghostpool_bbvcedo_devices_default' ) ) {
	function ghostpool_bbvcedo_devices_default() {
		return array(
			'x_large_css' => array(
				'label' => 'Default devices',
				'mediafeature' => '',
				'breakpoint' => '',
				'icon' => 'class_icon',
				'class_icon' => 'dashicons dashicons-desktop',
				'image_icon' => '',
				'order' => 1,
			),
			'large_css' => array(
				'label' => 'Large devices',
				'mediafeature' => 'max-width',
				'breakpoint' => '1199',
				'icon' => 'class_icon',
				'class_icon' => 'dashicons dashicons-laptop',
				'image_icon' => '',
				'order' => 2,
			),
			'medium_css' => array(
				'label' => 'Medium devices',
				'mediafeature' => 'max-width',
				'breakpoint' => '991',
				'icon' => 'class_icon',
				'class_icon' => 'dashicons dashicons-tablet',
				'image_icon' => '',
				'order' => 3,
			),
			'small_css' => array(
				'label' => 'Small devices',
				'mediafeature' => 'max-width',
				'breakpoint' => '767',
				'icon' => 'class_icon',
				'class_icon' => 'dashicons dashicons-image-rotate-right',
				'image_icon' => '',
				'order' => 4,
			),
			'x_small_css' => array(
				'label' => 'Extra Small devices',
				'mediafeature' => 'max-width',
				'breakpoint' => '479',
				'icon' => 'class_icon',
				'class_icon' => 'dashicons dashicons-smartphone',
				'image_icon' => '',
				'order' => 5,
			),
		);
	}
}
add_filter( 'bbvcedo_devices_default', 'ghostpool_bbvcedo_devices_default' );

/**
 * Set default option values for WordPress Social Login
 *
 */
if ( has_action( 'wordpress_social_login' ) && get_option( 'ghostpool_wp_social_defaults' ) !== '1' ) {
	function ghostpool_wp_social_defaults() {	
		update_option( 'wsl_settings_social_icon_set', 'none' );
	}	
	add_action( 'init', 'ghostpool_wp_social_defaults', 1 );	
	update_option( 'ghostpool_wp_social_defaults', '1' );		
}

/**
 * Theia sticky sidebars
 *
 */	
if ( ! function_exists( 'ghostpool_theia_sticky_sidebar_defaults' ) ) {
	function ghostpool_theia_sticky_sidebar_defaults() {
	
		if ( ! class_exists( 'TssOptions' ) ) {
			return;
		}
		
		if ( '1' === get_option( 'ghostpool_theia_sticky_sidebar_defaults' ) ) {
			return;
		}
		
		$options = get_option( 'tss_general' );
		
		if ( $options ) {
		
			if ( ! empty( $options['sidebars'] ) ) {
				return;
			}
	
			$options['sidebars'][0] = array(
				'sidebarName'                => 'Aardvark Sticky Sidebar',
				'sidebarSelector'            => '.gp-sidebar',
				'containerSelector'          => '.gp-inner-container',
				'additionalMarginTop'        => 100,
				'additionalMarginBottom'     => 20,
				'updateSidebarHeight'        => false,
				'minWidth'                   => 1081,
				'disableOnResponsiveLayouts' => true,
				'sidebarBehavior'            => 'modern',
				'enabledPosts'               => ''
			);
							
			$options['sidebars'][1] = array(
				'sidebarName'                => 'Youzer Sticky Sidebar',
				'sidebarSelector'            => '.youzer-sidebar',
				'containerSelector'          => '.gp-inner-container',
				'additionalMarginTop'        => 100,
				'additionalMarginBottom'     => 20,
				'updateSidebarHeight'        => false,
				'minWidth'                   => 1081,
				'disableOnResponsiveLayouts' => true,
				'sidebarBehavior'            => 'modern',
				'enabledPosts'               => ''
			);
				
			update_option( 'tss_general', $options );			
			update_option( 'ghostpool_theia_sticky_sidebar_defaults', '1' );	

		}

	}	
}	
add_action( 'init', 'ghostpool_theia_sticky_sidebar_defaults', 1 );

/**
 * Importer fixes
 *
 */
if ( ! function_exists( 'ghostpool_import_fixes' ) ) {	
	function ghostpool_import_fixes() {

		// Fix for events being set as drafts
		if ( function_exists( 'em_init' ) ) {
			$events = array( 'Grand Designs Live London', 'Comic-Con', 'Camden Town Brewery' );
			foreach( $events as $event ) {
				$event_page = get_page_by_title( $event, OBJECT, 'event' );
				if ( isset( $event_page->ID ) && 'publish' !== get_post_status( $event_page->ID ) && 'trash' !== get_post_status( $event_page->ID ) && 'event' === get_post_type( $event_page->ID ) ) {
					wp_update_post( array( 
						'ID' => $event_page->ID,  
						'post_status' => 'publish',
					) );
				}	
			}
		}
		
		// Fix for BPS forms being set as drafts
		if ( defined( 'BPS_FORM' ) ) {
			$bps_form = get_page_by_title( 'Member Search', OBJECT, 'bps_form' );
			if ( isset( $bps_form->ID ) && 'publish' !== get_post_status( $bps_form->ID ) && 'bps_form' === get_post_type( $bps_form->ID ) ) {
				wp_update_post(array(
					'ID' => $bps_form->ID,
					'post_status' => 'publish',
				) );
			}
		}
			
	}
	add_action( 'admin_init', 'ghostpool_import_fixes' );	
}