<?php if ( ! function_exists( 'ghostpool_metaboxes_settings' ) ) {
	function ghostpool_metaboxes_settings() {

		$settings = array();

		/**
		 * Blog Template Settings
		 *
		 */	 
		$blog_template = array(					

			array( 
				'id' => 'gp_blog_post_types',
				'title' => esc_html__( 'Post Types', 'aardvark' ),
				'type' => 'checkbox',
				'data' => 'post_types',
				'default' => array( 'post' ),
			),

			array(
				'id'       => 'gp_blog_page_ids',
				'title'    => esc_html__( 'Post/Page IDs', 'aardvark' ),
				'desc' => esc_html__( 'Enter the post/pages IDs you want to show - separate IDs with a comma e.g. 123, 456, 789', 'aardvark' ),
				'type'     => 'text',
				'default' => '',
			),

			array(
				'id'       => 'gp_blog_cats',
				'title'    => esc_html__( 'Categories', 'aardvark' ),
				'desc' => esc_html__( 'Enter the category slugs you want to display posts from - separate slugs with a comma e.g. category-1, category-2, category-3', 'aardvark' ),
				'type'     => 'text',
				'default' => '',
			),

			array(
				'id'       => 'gp_blog_tags',
				'title'    => esc_html__( 'Tags', 'aardvark' ),
				'desc' => esc_html__( 'Enter the tag slugs you want to display posts from - separate slugs with a comma e.g. tag-1, tag-2, tag-3', 'aardvark' ),
				'type'     => 'text',
				'default' => '',
			),
									
			array( 
				'id' => 'gp_blog_format',
				'title' => esc_html__( 'Format', 'aardvark' ),
				'type' => 'select',
				'options' => array(
					'gp-posts-list' => esc_html__( 'List', 'aardvark' ),
					'gp-posts-large' => esc_html__( 'Large', 'aardvark' ),
					'gp-posts-columns-2' => esc_html__( '2 Columns', 'aardvark' ),
					'gp-posts-columns-3' => esc_html__( '3 Columns', 'aardvark' ),
					'gp-posts-columns-4' => esc_html__( '4 Columns', 'aardvark' ),
					'gp-posts-masonry' => esc_html__( 'Masonry', 'aardvark' ),
				),
				'default' => 'gp-posts-list',
			),						
		
			array( 
				'id' => 'gp_blog_style',
				'title' => esc_html__( 'Style', 'aardvark' ),
				'type' => 'select',
				'options' => array(
					'gp-style-classic' => esc_html__( 'Classic', 'aardvark' ),
					'gp-style-modern' => esc_html__( 'Modern', 'aardvark' ),
				),
				'default' => 'gp-style-classic',
			),						
		
			array( 
				'id' => 'gp_blog_alignment',
				'title' => esc_html__( 'Content Alignment', 'aardvark' ),
				'type' => 'select',
				'options' => array(
					'gp-align-left' => esc_html__( 'Left Aligned', 'aardvark' ),
					'gp-align-center' => esc_html__( 'Center Aligned', 'aardvark' ),
				),
				'default' => 'gp-align-left',
			),

			array(  
				'id' => 'gp_blog_orderby',
				'title' => esc_html__( 'Order By', 'aardvark' ),
				'type' => 'select',
				'options' => array(
					'newest' => esc_html__( 'Newest', 'aardvark' ),
					'oldest' => esc_html__( 'Oldest', 'aardvark' ),
					'title_az' => esc_html__( 'Title (A-Z)', 'aardvark' ),
					'title_za' => esc_html__( 'Title (Z-A)', 'aardvark' ),
					'comment_count' => esc_html__( 'Most Comments', 'aardvark' ),
					'views' => esc_html__( 'Most Views', 'aardvark' ),
					'likes' => esc_html__( 'Most Likes', 'aardvark' ),
					'menu_order' => esc_html__( 'Menu Order', 'aardvark' ),
					'rand' => esc_html__( 'Random', 'aardvark' ),
				),
				'default' => 'newest',
			),
														
			array(
				'id'       => 'gp_blog_per_page',
				'type'     => 'spinner',
				'title'    => esc_html__( 'Items Per Page', 'aardvark' ),
				'min' => 1,
				'max' => 999999,
				'default' => 8,
			),
		
			array(
				'id'       => 'gp_blog_image_source',
				'title'    => esc_html__( 'Image Source', 'aardvark' ),
				'type'     => 'text',
				'desc' => esc_html__( 'Enter the meta key for the custom image field you want to use.', 'aardvark' ),
				'default' => '',
			),
		
			array(
				'id'       => 'gp_blog_image_size',
				'title'    => esc_html__( 'Image Size', 'aardvark' ),
				'type'     => 'text',
				'desc' => esc_html__( 'Enter image size e.g. "thumbnail", "medium", "large", "full" or enter size in pixels e.g. 200 x 100 (width x height).', 'aardvark' ),
				'default' => '',
			),
								
			array( 
				'id' => 'gp_blog_content_display',
				'title' => esc_html__( 'Content Display', 'aardvark' ),
				'type' => 'radio',
				'options' => array(
					'excerpt' => esc_html__( 'Excerpt', 'aardvark' ),
					'full_content' => esc_html__( 'Full Content', 'aardvark' ),
				),
				'default' => 'excerpt',
			),

			array( 
				'id' => 'gp_blog_excerpt_length',
				'title' => esc_html__( 'Excerpt Length', 'aardvark' ),
				'type' => 'spinner',
				'desc' => esc_html__( 'The number of characters in excerpts.', 'aardvark' ),
				'min' => 0,
				'max' => 999999,
				'default' => 100,
				'conditions' => array(
					'gp_blog_content_display' => 'excerpt',
				),
			),

			array(
				'id'        => 'gp_blog_meta',
				'type'      => 'checkbox',
				'title'     => esc_html__( 'Post Meta', 'aardvark' ),
				'options'   => array(
					'author' => esc_html__( 'Author', 'aardvark' ),
					'date' => esc_html__( 'Date', 'aardvark' ),
					'comment_count' => esc_html__( 'Comment Count', 'aardvark' ),
					'views' => esc_html__( 'Views', 'aardvark' ),
					'likes' => esc_html__( 'Likes', 'aardvark' ),
					'cats' => esc_html__( 'Categories', 'aardvark' ),
					'tags' => esc_html__( 'Tags', 'aardvark' ),
				),
				'default'   => array(
					'author' => 'true',
					'date' => 'true',
					'comment_count' => 'true',
					'views' => 'false',
					'likes' => 'false',
					'cats' => 'false',
					'tags' => 'false',
				),
			),

			array(
				'id'        => 'gp_blog_filters',
				'type'      => 'checkbox',
				'title'     => esc_html__( 'Filters (Sorting)', 'aardvark' ),
				'desc' => esc_html__( 'Filters disabled if using load more button.', 'aardvark' ),
				'options'   => array(
					'date' => esc_html__( 'Date', 'aardvark' ),
					'title' => esc_html__( 'Title', 'aardvark' ),
					'comment_count' => esc_html__( 'Comment Count', 'aardvark' ),
					'views' => esc_html__( 'Views', 'aardvark' ),
					'likes' => esc_html__( 'Likes', 'aardvark' ),
				),
				'default'   => array(
					'date' => 'true',
					'title' => 'true',
					'comment_count' => 'true',
					'views' => 'true',
					'likes' => 'true',
				),
			),

			array(
				'id'       => 'gp_blog_filter_cat_id',
				'type'     => 'select',
				'title'    => esc_html__( 'Filter (Categories)', 'aardvark' ),
				'data' => 'categories',
				'args' => array( 'hide_empty' => false ),
				'desc' => esc_html__( 'Choosing a category will display the subcategories of this category or leave blank to display all categories.', 'aardvark' ),
				'default' => '',
			),
					
			array(  
				'id' => 'gp_blog_read_more_link',
				'title' => esc_html__( 'Read More Link', 'aardvark' ),
				'type' => 'radio',
				'options' => array(
					'enabled' => esc_html__( 'Enabled', 'aardvark' ),
					'disabled' => esc_html__( 'Disabled', 'aardvark' ),
				),
				'default' => 'disabled',
			),
	
		);
		$settings[] = array(
			'id' => 'gp-blog-template',
			'title' => esc_html__( 'Blog Template Settings', 'aardvark' ),
			'post_types' => array( 'page' ),
			'page_templates' => array( 'blog-template.php' ),
			'position' => 'normal',
			'priority' => 'high',
			'section' => $blog_template
		);

		/**
		 * Link Template Settings
		 *
		 */	 
		$link_template = array(

			array( 
				'id' => 'gp_link',
				'title' => esc_html__( 'Link', 'aardvark' ),
				'type' => 'text',
				'validate'  => 'url',
				'default' => '',
			),

			array( 
				'id' => 'gp_link_target',
				'title' => esc_html__( 'Link Target', 'aardvark' ),
				'type' => 'select',
				'options' => array(
					'_blank' => esc_html__( 'New Window', 'aardvark' ),
					'_self' => esc_html__( 'Same Window', 'aardvark' ),
				),
				'default' => '_self',
			),
											 
		);
		$settings[] = array(
			'id' => 'gp-link-template',
			'title' => esc_html__( 'Link Template Settings', 'aardvark' ),
			'post_types' => array( 'page' ),
			'page_templates' => array( 'link-template.php' ),
			'position' => 'normal',
			'priority' => 'high',
			'section' => $link_template
		);
		$settings[] = array(
			'id' => 'gp-link-format',
			'title' => esc_html__( 'Link Format Settings', 'aardvark' ),
			'post_types' => array( 'post' ),
			'post_formats' => array( 'link' ),
			'page_templates' => array( 'link-template.php' ),
			'position' => 'normal',
			'priority' => 'high',
			'section' => $link_template
		);
		
		/**
		 * Audio Format Settings
		 *
		 */	
		$audio_format = array(

			array(
				'id'        => 'gp_audio_mp3_url',
				'type'      => 'media',
				'format'    => 'audio',
				'title'     => esc_html__( 'MP3 Audio File', 'aardvark' ),
			),

			array(
				'id'        => 'gp_audio_ogg_url',
				'type'      => 'media',
				'format'    => 'audio',
				'title'     => esc_html__( 'OGG Audio File', 'aardvark' ),
			),
											 
		);
		$settings[] = array(
			'id' => 'gp-audio-format',
			'title' => esc_html__( 'Audio Format Settings', 'aardvark' ),
			'post_types' => array( 'post' ),
			'post_formats' => array( 'audio' ),
			'position' => 'normal',
			'priority' => 'high',
			'section' => $audio_format
		);

		/**
		 * Video Format Settings
		 *
		 */	
		$video_format = array(

			array(
				'id'        => 'gp_video_embed_url',
				'type'      => 'text',
				'title'     => esc_html__( 'Video URL', 'aardvark' ),
				'desc'      => esc_html__( 'Video URL uploaded to one of the major video sites e.g. YouTube, Vimeo, blip.tv, etc.', 'aardvark' ),
				'validate'  => 'url',
				'default' => '',
			),

			array(
				'id'        => 'gp_video_m4v_url',
				'type'      => 'media',
				'format'    => 'video',
				'title'     => esc_html__( 'M4V Video', 'aardvark' ),
				'default' => '',
			),

			array(
				'id'        => 'gp_video_mp4_url',
				'type'      => 'media',
				'format'    => 'video',
				'title'     => esc_html__( 'MP4 Video', 'aardvark' ),
				'default' => '',
			),

			array(
				'id'        => 'gp_video_webm_url',
				'type'      => 'media',
				'format'    => 'video',
				'title'     => esc_html__( 'WebM Video', 'aardvark' ),
				'default' => '',
			),

			array(
				'id'        => 'gp_video_ogv_url',
				'type'      => 'media',
				'format'    => 'video',
				'title'     => esc_html__( 'OGV Video', 'aardvark' ),
				'default' => '',
			),
											 
		);
		$settings[] = array(
			'id' => 'gp-video-format',
			'title' => esc_html__( 'Video Format Settings', 'aardvark' ),
			'post_types' => array( 'post' ),
			'post_formats' => array( 'video' ),
			'position' => 'normal',
			'priority' => 'high',
			'section' => $video_format
		);

		/**
		 * Gallery Format Settings
		 *
		 */	
		$gallery_format = array(

			array(
				'id'        => 'gp_gallery_slider',
				'type'      => 'gallery',
				'title'     => esc_html__( 'Gallery Slider', 'aardvark' ),
				 'desc'  => esc_html__( 'Create a new gallery slider by selecting an existing image or uploading new ones using the WordPress native uploader.', 'aardvark' ),
			),
											 
		);
		$settings[] = array(
			'id' => 'gp-gallery-format',
			'title' => esc_html__( 'Gallery Format Settings', 'aardvark' ),
			'post_types' => array( 'post' ),
			'post_formats' => array( 'gallery' ),
			'position' => 'normal',
			'priority' => 'high',
			'section' => $gallery_format
		);
		
		/**
		 * General Settings
		 *
		 */	 
		$general = array(

			array( 
				'id' => 'gp_page_header_layout',
				'title' => esc_html__( 'Header Layout', 'aardvark' ),
				'type' => 'image_select',
				'options' => array( 
					'default' => array( esc_html__( 'Default', 'aardvark' ), 'img' => get_template_directory_uri() . '/lib/framework/settings/images/default.jpg' ),
					'gp-header-logo-left-1' => array( esc_html__( 'Header 1', 'aardvark' ), 'img' => get_template_directory_uri() . '/lib/framework/settings/images/logo-left-1.jpg' ),
					'gp-header-logo-left-2' => array( esc_html__( 'Header 2', 'aardvark' ), 'img' => get_template_directory_uri() . '/lib/framework/settings/images/logo-left-2.jpg' ),
					'gp-header-logo-right-1' => array( esc_html__( 'Header 3', 'aardvark' ), 'img' => get_template_directory_uri() . '/lib/framework/settings/images/logo-right-1.jpg' ),
					'gp-header-nav-bottom-1' => array( esc_html__( 'Header 4', 'aardvark' ), 'img' => get_template_directory_uri() . '/lib/framework/settings/images/nav-bottom-1.jpg' ),
					'gp-header-nav-bottom-2' => array( esc_html__( 'Header 5', 'aardvark' ), 'img' => get_template_directory_uri() . '/lib/framework/settings/images/nav-bottom-2.jpg' ),
					'gp-header-nav-bottom-3' => array( esc_html__( 'Header 6', 'aardvark' ), 'img' => get_template_directory_uri() . '/lib/framework/settings/images/nav-bottom-3.jpg' ),
					'gp-header-side-menu' => array( esc_html__( 'Header 7', 'aardvark' ), 'img' => get_template_directory_uri() . '/lib/framework/settings/images/side-menu.jpg' ),
				),
				'default' => 'default',
			),

			array( 
				'id' => 'gp_page_header_display',
				'title' => esc_html__( 'Header Display', 'aardvark' ),
				'type' => 'select',
				'options' => array( 
					'default' => esc_html__( 'Default', 'aardvark' ),
					'gp-header-above-content' => esc_html__( 'Above Content', 'aardvark' ),
					'gp-header-over-content' => esc_html__( 'Over Content', 'aardvark' ),
					'gp-header-disabled' => esc_html__( 'Disabled', 'aardvark' ),
				),
				'default' => 'default',
			),

			array( 
				'id' => 'gp_page_footer_display',
				'title' => esc_html__( 'Footer Display', 'aardvark' ),
				'type' => 'select',
				'options' => array( 
					'default' => esc_html__( 'Default', 'aardvark' ),
					'enabled' => esc_html__( 'Enabled', 'aardvark' ),
					'disabled' => esc_html__( 'Disabled', 'aardvark' ),
				),
				'default' => 'default',
			),
																											
			array( 
				'id' => 'gp_page_header',
				'title' => esc_html__( 'Title Header', 'aardvark' ),
				'type' => 'select',
				'options' => array(
					'default' => esc_html__( 'Default', 'aardvark' ),
					'gp-standard-page-header' => esc_html__( 'Standard', 'aardvark' ),
					'gp-fullwidth-page-header' => esc_html__( 'Full Width', 'aardvark' ),
					'gp-full-page-page-header' => esc_html__( 'Full Page', 'aardvark' ),
					'gp-minimal-page-header' => esc_html__( 'Minimal', 'aardvark' ),
					'gp-page-header-disabled' => esc_html__( 'Disabled', 'aardvark' ),
				),
				'default' => 'default',
			),

			array(
				'id' => 'gp_page_header_bg', 
				'title' => esc_html__( 'Title Header Background Image', 'aardvark' ),
				'type'      => 'media',
				'format'    => 'image',
				'default' => '',
				'conditions' => array(
					'gp_page_header' => array(
						'value' => array( 'default', 'gp-fullwidth-page-header', 'gp-full-page-page-header' ),
						'operator' => 'in_array',
					),	
				),
			),	

			array( 
				'id' => 'gp_page_header_height',
				'title' => esc_html__( 'Title Header Height', 'aardvark' ),
				'type' => 'dimensions',
				'default' => array(
					'height' => '',
				),	
				'conditions' => array(
					'gp_page_header' => array(
						'value' => array( 'default', 'gp-fullwidth-page-header', 'gp-full-page-page-header' ),
						'operator' => 'in_array',
					),	
				),
			 ),

			array(
				'id' => 'gp_page_header_video', 
				'title' => esc_html__( 'Title Header Video URL', 'aardvark' ),
				'desc' => esc_html__( 'Supports YouTube, Vimeo and HTML5 video. For multiple HTML5 formats, each video should have exactly the same filename but remove the extension (e.g. .mp4) from the filename in the text box.', 'aardvark' ),
				'type'      => 'text',
				'default' => '',
				'conditions' => array(
					'gp_page_header' => array(
						'value' => array( 'default', 'gp-fullwidth-page-header', 'gp-full-page-page-header' ),
						'operator' => 'in_array',
					),	
				),
			),
							
			array(
				'id' => 'gp_page_header_video_bg', 
				'title' => esc_html__( 'Title Header Video Background URL', 'aardvark' ),
				'desc' => esc_html__( 'Supports YouTube, Vimeo and HTML5 video. For multiple HTML5 formats, each video should have exactly the same filename but remove the extension (e.g. .mp4) from the filename in the text box.', 'aardvark' ),
				'type'      => 'text',
				'default' => '',
				'conditions' => array(
					'gp_page_header' => array(
						'value' => array( 'default', 'gp-fullwidth-page-header', 'gp-full-page-page-header' ),
						'operator' => 'in_array',
					),	
				),
			),
				
			array( 
				'id' => 'gp_custom_title',
				'title' => esc_html__( 'Custom Title', 'aardvark' ),
				'type' => 'text',
				'desc' => esc_html__( 'Overwrites the default title.', 'aardvark' ),
				'default' => '',
			),
					
			array( 
				'id' => 'gp_subtitle',
				'title' => esc_html__( 'Subtitle', 'aardvark' ),
				'type' => 'textarea',
				'default' => '',
			),

			array( 
				'id' => 'gp_layout',
				'title' => esc_html__( 'Page Layout', 'aardvark' ),					
				'type' => 'select',
				'options' => array(
					'default' => esc_html__( 'Default', 'aardvark' ),
					'gp-left-sidebar' => esc_html__( 'Left Sidebar', 'aardvark' ), 
					'gp-right-sidebar' => esc_html__( 'Right Sidebar', 'aardvark' ),
					'gp-both-sidebars' => esc_html__( 'Both Sidebars', 'aardvark' ), 
					'gp-no-sidebar' => esc_html__( 'No Sidebar', 'aardvark' ),
					'gp-fullwidth' => esc_html__( 'Full Width', 'aardvark' ),
				),	
				'default' => 'default',
			),

			array(
				'id'      => 'gp_left_sidebar',
				'type'    => 'select',
				'title'   => esc_html__( 'Left Sidebar', 'aardvark' ),
				'data'    => 'sidebars',
				'default' => 'default',
				'conditions' => array(
					'gp_layout' => array(
						'value' => array( 'default', 'gp-left-sidebar', 'gp-both-sidebars' ),
						'operator' => 'in_array',
					),	
				),
			),

			array(
				'id'      => 'gp_right_sidebar',
				'type'    => 'select',
				'title'   => esc_html__( 'Right Sidebar', 'aardvark' ),
				'data'    => 'sidebars',
				'default' => 'default',
				'conditions' => array(
					'gp_layout' => array(
						'value' => array( 'default', 'gp-right-sidebar', 'gp-both-sidebars' ),
						'operator' => 'in_array',
					),	
				),
			),

			array(  
				'id' => 'gp_featured_image',
				'title' => esc_html__( 'Featured Image', 'aardvark' ),
				'type' => 'select',
				'options' => array(
					'default' => esc_html__( 'Default', 'aardvark' ),
					'enabled' => esc_html__( 'Enabled', 'aardvark' ),
					'disabled' => esc_html__( 'Disabled', 'aardvark' ),
				),
				'default' => 'default',
			),
				
		);

		$settings[] = array(
			'id' => 'gp-general',
			'title' => esc_html__( 'General Settings', 'aardvark' ),
			'post_types' => array( 'post', 'page', 'product' ),
			'position' => 'normal',
			'priority' => 'high',
			'section' => $general
		);
		
		$settings = apply_filters_deprecated( 'ghostpool_redux_metabox_options', array( $settings ), '3.0', 'ghostpool_metaboxes_settings' );

		return $settings;

	}		
}		