<?php if ( ! function_exists( 'ghostpool_taxonomies_settings' ) ) {
	function ghostpool_taxonomies_settings() {

		$settings = array();

		/**
		 * Product taxonomies
		 *
		 */	 
		$product_taxs = array( 
		
			array(
				'id'      => 'exclude',
				'title'    => esc_html__( 'Exclude', 'aardvark' ),
				'desc'    => esc_html__( 'Exclude this item from showing up in post meta text.', 'aardvark' ),
				'type'    => 'select',
				'options' => array( 
					'enabled' => esc_html__( 'Enabled', 'aardvark' ),
					'disabled' => esc_html__( 'Disabled', 'aardvark' ),
				),
				'default' => 'disabled',
			),
				
			array( 
				'id'      => 'page_header',
				'title'    => esc_html__( 'Title Header', 'aardvark' ),
				'type'    => 'select',
				'options' => array( 
					'default' => esc_html__( 'Default', 'aardvark' ), 
					'gp-standard-page-header' => esc_html__( 'Standard', 'aardvark' ),
					'gp-fullwidth-page-header' => esc_html__( 'Full Width', 'aardvark' ), 
					'gp-full-page-page-header' => esc_html__( 'Full Page', 'aardvark' ),
					'gp-minimal-page-header' => esc_html__( 'Minimal', 'aardvark' ),
					'gp-page-header-disabled' => esc_html__( 'Disabled', 'aardvark' ),
				),
				'default' => 'default',
			),
		
			array( 
				'id'      => 'page_header_bg',
				'title'    => esc_html__( 'Title Header Background', 'aardvark' ),
				'type'    => 'media',
				'format'    => 'image',
				'default' => '',
				'conditions' => array(
					'page_header' => array(
						'value' => array( 'default', 'gp-fullwidth-page-header', 'gp-full-page-page-header' ),
						'operator' => 'in_array',
					),	
				),
			),

			array( 
				'id'      => 'layout',
				'title'    => esc_html__( 'Page Layout', 'aardvark' ),
				'type'    => 'select',
				'options' => array( 
					'default' => esc_html__( 'Default', 'aardvark' ), 
					'gp-left-sidebar' => esc_html__( 'Left Sidebar', 'aardvark' ), 
					'gp-right-sidebar' => esc_html__( 'Right Sidebar', 'aardvark' ), 
					'gp-both-sidebars' => esc_html__( 'Both Sidebars', 'aardvark' ), 
					'gp-no-sidebar' => esc_html__( 'No Sidebars', 'aardvark' ), 
					'gp-fullwidth' => esc_html__( 'Full Width', 'aardvark' ),
				),
				'default' => 'default',
			),

			array( 
				'id'      => 'left_sidebar',
				'title'    => esc_html__( 'Left Sidebar', 'aardvark' ),
				'type'    => 'select',
				'data'    => 'sidebars',
				'default' => 'default',
				'conditions' => array(
					'layout' => array(
						'value' => array( 'default', 'gp-left-sidebar', 'gp-both-sidebars' ),
						'operator' => 'in_array',
					),	
				),
			),

			array( 
				'id'      => 'right_sidebar',
				'title'    => esc_html__( 'Right Sidebar', 'aardvark' ),
				'type'    => 'select',
				'data'    => 'sidebars',
				'default' => 'default',
				'conditions' => array(
					'layout' => array(
						'value' => array( 'default', 'gp-right-sidebar', 'gp-both-sidebars' ),
						'operator' => 'in_array',
					),	
				),
			),
		
		);			
		
		$settings[] = array(
			'id' => 'gp-product-taxs',
			'taxs'  => array( 'product_cat', 'product_tag' ),
			'section' => $product_taxs
		);
		
		/**
		 * Defaults taxonomies
		 *
		 */	 
		$default_taxs = array( 
		
			array(
				'id'      => 'exclude',
				'title'    => esc_html__( 'Exclude', 'aardvark' ),
				'desc'    => esc_html__( 'Exclude this item from showing up in post meta text.', 'aardvark' ),
				'type'    => 'select',
				'options' => array( 
					'enabled' => esc_html__( 'Enabled', 'aardvark' ),
					'disabled' => esc_html__( 'Disabled', 'aardvark' ),
				),
				'default' => 'disabled',
			),
				
			array( 
				'id'      => 'page_header',
				'title'    => esc_html__( 'Title Header', 'aardvark' ),
				'type'    => 'select',
				'options' => array( 
					'default' => esc_html__( 'Default', 'aardvark' ), 
					'gp-standard-page-header' => esc_html__( 'Standard', 'aardvark' ),
					'gp-fullwidth-page-header' => esc_html__( 'Full Width', 'aardvark' ), 
					'gp-full-page-page-header' => esc_html__( 'Full Page', 'aardvark' ),
					'gp-minimal-page-header' => esc_html__( 'Minimal', 'aardvark' ),
					'gp-page-header-disabled' => esc_html__( 'Disabled', 'aardvark' ),
				),
				'default' => 'default',
			),
		
			array( 
				'id'      => 'page_header_bg',
				'title'    => esc_html__( 'Title Header Background', 'aardvark' ),
				'type'    => 'media',
				'format'    => 'image',
				'default' => '',
				'conditions' => array(
					'page_header' => array(
						'value' => array( 'default', 'gp-fullwidth-page-header', 'gp-full-page-page-header' ),
						'operator' => 'in_array',
					),	
				),
			),

			array( 
				'id'      => 'layout',
				'title'    => esc_html__( 'Page Layout', 'aardvark' ),
				'type'    => 'select',
				'options' => array( 
					'default' => esc_html__( 'Default', 'aardvark' ), 
					'gp-left-sidebar' => esc_html__( 'Left Sidebar', 'aardvark' ), 
					'gp-right-sidebar' => esc_html__( 'Right Sidebar', 'aardvark' ), 
					'gp-both-sidebars' => esc_html__( 'Both Sidebars', 'aardvark' ), 
					'gp-no-sidebar' => esc_html__( 'No Sidebars', 'aardvark' ), 
					'gp-fullwidth' => esc_html__( 'Full Width', 'aardvark' ),
				),
				'default' => 'default',
			),

			array( 
				'id'      => 'left_sidebar',
				'title'    => esc_html__( 'Left Sidebar', 'aardvark' ),
				'type'    => 'select',
				'data'    => 'sidebars',
				'default' => 'default',
				'conditions' => array(
					'layout' => array(
						'value' => array( 'default', 'gp-left-sidebar', 'gp-both-sidebars' ),
						'operator' => 'in_array',
					),	
				),
			),

			array( 
				'id'      => 'right_sidebar',
				'title'    => esc_html__( 'Right Sidebar', 'aardvark' ),
				'type'    => 'select',
				'data'    => 'sidebars',
				'default' => 'default',
				'conditions' => array(
					'layout' => array(
						'value' => array( 'default', 'gp-right-sidebar', 'gp-both-sidebars' ),
						'operator' => 'in_array',
					),	
				),
			),
	
			array( 
				'id'      => 'format',
				'title'    => esc_html__( 'Format', 'aardvark' ),
				'type'    => 'select',
				'options' => array( 
					'default' => esc_html__( 'Default', 'aardvark' ), 
					'gp-posts-list' => esc_html__( 'List', 'aardvark' ),
					'gp-posts-large' => esc_html__( 'Large', 'aardvark' ),
					'gp-posts-columns-2' => esc_html__( '2 Columns', 'aardvark' ), 
					'gp-posts-columns-3' => esc_html__( '3 Columns', 'aardvark' ), 
					'gp-posts-columns-4' => esc_html__( '4 Columns', 'aardvark' ),
					'gp-posts-masonry' => esc_html__( 'Masonry', 'aardvark' ), 
				),
				'default' => 'default',
			),

			array( 
				'id'      => 'style',
				'title'    => esc_html__( 'Style', 'aardvark' ),
				'type'    => 'select',
				'options' => array( 
					'default' => esc_html__( 'Default', 'aardvark' ),
					'gp-style-classic' => esc_html__( 'Classic', 'aardvark' ),
					'gp-style-modern' => esc_html__( 'Modern', 'aardvark' ),
				),
				'default' => 'default',
			),

			array( 
				'id'      => 'alignment',
				'title'    => esc_html__( 'Alignment', 'aardvark' ),
				'type'    => 'select',
				'options' => array( 
					'default' => esc_html__( 'Default', 'aardvark' ),
					'gp-align-left' => esc_html__( 'Left Aligned', 'aardvark' ),
					'gp-align-center' => esc_html__( 'Center Aligned', 'aardvark' ),
				),
				'default' => 'default',
			),
			
		);			
		
		$settings[] = array(
			'id' => 'gp-default-taxs',
			'taxs'  => array( 'category', 'post_tag' ),
			'section' => $default_taxs
		);
								
		$settings = apply_filters_deprecated( 'ghostpool_custom_category_options', array( $settings ), '3.0', 'ghostpool_taxonomies_settings' );
		
		return $settings;
				
	}
}