<?php if ( ! class_exists( 'GhostPool_Custom_CSS' ) ) {
	class GhostPool_Custom_CSS {
	
		private $framework;
		
		public function __construct() {
			
			// Framework data 
			$this->framework = ghostpool_framework_data();
			
			add_action( 'wp_enqueue_scripts', array( $this, 'enqueue_scripts' ), 11 );
						
		}

		/**
		* Output Google web fonts URL
		*
		*/
		function ghostpool_google_webfonts( $fonts_used, $subsets_used ) {

			// Get all fonts used
			$fonts = array();
			
			// Remove backup fonts from used fonts
			$backup_fonts = ghostpool_backup_fonts_array();
			$fonts_used = array_diff_key( $fonts_used, array_flip( $backup_fonts ) );
			
			foreach( $fonts_used as $font_family => $font_data ) {
				$fonts[$font_family] = array_unique( $fonts_used[$font_family], SORT_REGULAR );	
				$fonts[$font_family] = array_merge_recursive( $fonts[$font_family]) ;		
			}		
	
			$url = '';
	
			// Get all font styles for each font family
			foreach( $fonts as $font_family => $font ) {
				$styles = array();
				foreach( $font as $f ) {
					$all_styles[] = $f['style'];
				}
				$styles = implode( ',', ( array_unique( $all_styles ) ) );
				$url .= $font_family . ':' . $styles . '|';

			}
	
			// Remove final separator
			if ( $url ) {
			
				$url = rtrim( $url, '|' );
	
				// Append subsets to URL
				$subset = implode( ',', array_unique( $subsets_used ) );

				// Generate URL
				$url = $url . '&' . 'subsets=' . $subset;

				return 'https://fonts.googleapis.com/css?family=' . $url;
				
			}
				
		}								

		/**
		* Cycle through each setting type
		*
		*/
		function ghostpool_custom_css_types( $setting = array(), $value = '', $theme_options = '', $output_type = '' ) {

			if ( is_array( $setting ) ) {
				extract( $setting );
			}
			
			$custom_css = '';
			$fonts_used = array();
			$subsets_used = array();
				
			$important = ( true === $important ) ? '!important' : '';
				
			if ( '' !== $output && ( '' !== $default OR '' !== $value ) ) { 

				// Add media query
				$custom_css .= isset( $media_query ) && '' !== $media_query ? $media_query . '{' : '';					
		
				// Border
				if ( 'border' === $type ) {

					$border_width = '';
		
					if ( isset( $value['border-top'] ) ) {			
						$border_width .= 'border-top: ' . $value['border-top'] . $units . ' ' . $value['border-style'] . ' ' . $value['border-color'] . $important . ';';
					}
					if ( isset( $value['border-right'] ) ) {			
						$border_width .= 'border-right: ' . $value['border-right'] . $units . ' ' . $value['border-style'] . ' ' . $value['border-color'] . $important . ';';
					}
					if ( isset( $value['border-bottom'] ) ) {			
						$border_width .= 'border-bottom: ' . $value['border-bottom'] . $units . ' ' . $value['border-style'] . ' ' . $value['border-color'] . $important . ';';
					} 
					if ( isset( $value['border-left'] ) ) {			
						$border_width .= 'border-left: ' . $value['border-left'] . $units . ' ' . $value['border-style'] . ' ' . $value['border-color'] . $important . ';';
					}
					if ( isset( $value['border-width'] ) ) {		
						$border_width .= 'border: ' . $value['border-width'] . $units . ' ' . $value['border-style'] . ' ' . $value['border-color'] . $important . ';';
					}
					if ( isset( $value['border-radius'] ) ) {		
						$border_width .= 'border-radius: ' . $value['border-radius'] . $units . $important . ';';
					}
											
					$custom_css .= $output . '{' . $border_width . '}';
									
				// Color/Color rgba
				} elseif ( 'color' === $type OR 'color_rgba' === $type ) {
	
					if ( is_array( $output ) ) {

						foreach( $output as $attribute => $selectors ) {
							$custom_css .= $selectors . '{' . $attribute . ':' . $value . $important . ';}';
						}
					
					} else {
		
						$custom_css .= $output . '{color:' . $value . ';}';
		
					}

				// Color Gradient
				} elseif ( 'color_gradient' === $type ) {
							
					if ( is_array( $output ) ) {
		
						foreach( $output as $attribute => $selectors ) {
		
							if ( $value['from'] ) {			
								$custom_css .= $selectors . '{' . $attribute . ':' . $value['from'] . $important . ';}';
							}
		
							if ( $value['to'] ) {
								$custom_css .= $selectors . '{' . $attribute . ': -webkit-linear-gradient(left, ' . $value['from'] . ' 0%, ' . $value['to'] . ' 50%,' . $value['from'] . ' 100%);background-image: linear-gradient(to right, ' . $value['from'] . ' 0%, ' . $value['to'] . ' 50%,' . $value['from'] . ' 100%)' . $important . ';}';
							}
			
						}
			
					} else {
		
						if ( $value['from'] ) {			
							$custom_css .= $output . '{background-color:' . $value['from'] . $important . ';}';
						}
	
						if ( $value['to'] ) {
							$custom_css .= $output . '{background-image: -webkit-linear-gradient(left, ' . $value['from'] . ' 0%, ' . $value['to'] . ' 50%,' . $value['from'] . ' 100%);background-image: linear-gradient(to right, ' . $value['from'] . ' 0%, ' . $value['to'] . ' 50%,' . $value['from'] . ' 100%)' . $important . ';}';
						}
		
					}	

				// Link colors
				} elseif ( 'link_color' === $type ) {
		
					foreach( $default as $attribute => $v ) {

						if ( 'regular' === $attribute ) {
							$custom_css .= $output . '{color:' . $value['regular'] . $important . ';}';
						}
			
						if ( 'hover' === $attribute ) {
							$output = str_replace( ',', ':hover,', $output );
							$output = $output . ':hover';
							$output = str_replace( ':before:hover', ':hover:before', $output );
							$output = str_replace( ':after:hover', ':hover:after', $output );
							$custom_css .= $output . '{color:' . $value['hover'] . $important . ';}';
						}
			
						if ( 'active' === $attribute ) {						
							$output = str_replace( ',', ':active,', $output );
							$output = $output . ':active';
							$custom_css .= $output . '{color:' . $value['active'] . $important . ';}';
						}
				
					}	

				// Select
				} elseif ( 'select' === $type ) {

					foreach( $output as $attribute => $selector ) {
						$custom_css .= $selector . '{' . $attribute . ':' . $value . $important . ';}';
					}

				// Typography
				} elseif ( 'typography' === $type ) {

					$output = is_array( $output ) ? implode( ',', $output ) : $output;
		
					$custom_css .= $output . '{';
		
					foreach( $default as $attribute => $v ) {

						$new_value = isset( $value[$attribute] ) ? $value[$attribute] : $v;
					
						if ( '' !== $new_value ) {
						
							if ( 'font-size' === $attribute OR 'line-height' === $attribute OR 'letter-spacing' === $attribute OR 'word-spacing' === $attribute ) {
								$new_units = isset( $new_value['units'] ) ? $new_value['units'] : 'px';
								$new_value = isset( $new_value['value'] ) ? $new_value['value'] : $v['value'];
							} else {			
								$new_units = '';
							}
							
							if ( 'font-family' === $attribute ) {
			
								$style = isset( $value['font-weight'] ) ? $value['font-weight'] : '';
								$fonts_used[$new_value][] = array(
									'style' => $style,
								);			
								if ( 'fonts_used' === $output_type ) {
									return array(
										'new_value' => $new_value,
										'style' => $style,
									);
								}
			
								$font_backup = isset( $value['font-backup'] ) ? ', ' . $value['font-backup'] : '';
								$new_value = $new_value . $font_backup;
							}
			
							if ( 'subsets' === $attribute ) {
								$subset = isset( $value['subsets'] ) ? $value['subsets'] : '';
								$subsets_used[] = $subset;
								if ( 'subsets_used' === $output_type ) {
									return $subset;
								}
							}
			
							if ( 'font-weight' === $attribute ) {
								$font_data = preg_split('#(?<=\d)(?=[a-z])#i', $new_value );
								$font_weight = $font_data[0];
								$font_style = ! empty( $font_data[1] ) ? ';font-style:' . $font_data[1] : '';
								$new_value = $font_weight . $font_style;
							}
		
							if ( '' !== $new_value && ( 'font-backup' !== $attribute && 'subsets' !== $attribute ) ) {
								$custom_css .= $attribute . ':' . ghostpool_add_units( $new_value, $new_units ) . $important . ';';
							}
						
						}	
		
					}
	
					$custom_css .= '}';
									
				// Background
				} elseif ( 'background' === $type ) {

					$custom_css .= $output . '{';
		
					foreach( $default as $attribute => $v ) {

						$new_value = isset( $value[$attribute] ) ? $value[$attribute] : $v;
				
						if ( '' !== $new_value ) {
					
							if ( 'background-image' === $attribute ) {
								$new_value = 'url(' . ghostpool_image_url( $new_value ) . ')';									
							}
						
							if ( 'background-color' === $attribute OR 'background-image' === $attribute OR ( 'background-image' !== $attribute && ( isset( $value['background-image'] ) && '' !== $value['background-image'] ) ) )  {
		
								$custom_css .= $attribute . ':' . $new_value . $important . ';';
							
							}	
						
						}	
		
					}
	
					$custom_css .= '}';
		
				// Spacing/Dimensions
				} elseif ( 'spacing' === $type OR 'dimensions' === $type ) {
				
					$output = is_array( $output ) ? implode( ',', $output ) : $output;

					$custom_css .= $output . '{';
		
					foreach( $default as $attribute => $v ) {
				
						if ( is_rtl() && $rtl ) {
							if ( 'margin-left' === $attribute ) {
								$attribute = 'margin-right';
							} elseif ( 'margin-right' === $attribute ) {
								$attribute = 'margin-left';
							} elseif ( 'padding-left' === $attribute ) {
								$attribute = 'margin-right';
							} elseif ( 'padding-right' === $attribute ) {
								$attribute = 'padding-left';
							}
						}	

						$new_value = isset( $value[$attribute] ) ? $value[$attribute] : $v;
		
						if ( '' !== $new_value ) {
							$custom_css .= $attribute . ':' . ghostpool_add_units( $new_value, $units ) . $important . ';';
						}
		
					}
	
					$custom_css .= '}';
		
				}	
	
				$custom_css .= isset( $media_query ) && '' !== $media_query ? '}' : '';

				return $custom_css;
				
			}
		} //end function
						
		public function enqueue_scripts() {

			$settings = ghostpool_global_settings( $this->framework['theme_slug'] );

			if ( $settings ) {
								
				$custom_css = '';
				$theme_options = get_option( $this->framework['option_name'] );
				$fonts_used = array();
				$subsets_used = array();
							
				// Go through each setting
				foreach( $settings as $setting ) {
									
					// Get extracted setting variables
					$setting = ghostpool_default_setting_fields( $setting );						
					if ( is_array( $setting ) ) {
						extract( $setting );
					}
	
					// Switch to styling variables when appropriate
					if ( 'styling' === $type ) {
						
						if ( $styling ) {
							foreach( $styling as $style_id => $style ) {
								$setting['type'] = $style['type'];
								$setting['default'] = isset( $style['default'] ) ? $style['default'] : '';
								$setting['output'] = isset( $style['output'] ) ? $style['output'] : '';
								$setting['value'] = isset( $theme_options[$id][$style_id] ) ? $theme_options[$id][$style_id] : $default;
								$custom_css .= $this->ghostpool_custom_css_types( $setting, $setting['value'], $theme_options );
							}
						}
						
					} else {
					
						$value = isset( $theme_options[$id] ) ? $theme_options[$id] : $default;
						
						if ( 'typography' === $type && ( isset( $default['font-family'] ) OR isset( $default['subsets'] ) ) ) {
							
							$all_fonts_used = $this->ghostpool_custom_css_types( $setting, $value, $theme_options, 'fonts_used' );
							if ( isset( $all_fonts_used['new_value'] ) && isset( $all_fonts_used['style'] ) ) {
								$fonts_used[$all_fonts_used['new_value']][] = array(
									'style' => $all_fonts_used['style'],
								);
							}
							
							$subsets_used[] = $this->ghostpool_custom_css_types( $setting, $value, $theme_options, 'subsets_used' );
																							
						}
						
						$custom_css .= $this->ghostpool_custom_css_types( $setting, $value, $theme_options );
	
					}
					
				} // end foreach
	
				$custom_css .=
		
				'.gp-active{color: ' . ghostpool_option( 'general_link_colors', 'regular' ) . ';}' . 

				'.gp-nav .menu li .gp-menu-tabs li.gp-selected a{color:' . ghostpool_option( 'dropdown_menu_link_colors', 'hover' ) . ' !important;}' .

				'#gp-top-header .menu > .menu-item.current-menu-item > a{color: ' . ghostpool_option( 'top_header_nav_link_colors', 'hover' ) . ';}' .
	
				'#gp-top-header .menu > .menu-item > .gp-menu-text{color: ' . ghostpool_option( 'top_header_nav_link_colors', 'regular' ) . ';}' .

				'#gp-main-header-primary-nav > .menu > .menu-item > .gp-menu-text{color: ' . ghostpool_option( 'main_header_primary_nav_link_colors', 'regular' ) . ';}' .

				'#gp-main-header-secondary-nav > .menu > .menu-item > .gp-menu-text{color: ' . ghostpool_option( 'main_header_secondary_nav_link_colors', 'regular' ) . ';}' .

				'#gp-main-header-primary-nav > .menu > .menu-item.current-menu-item > a{color: ' . ghostpool_option( 'main_header_primary_nav_link_colors', 'hover' ) . ';}' .

				'#gp-side-menu-nav .menu-item.current-menu-item > a{color: ' . ghostpool_option( 'side_menu_nav_link_colors', 'hover' ) . ';}' .

				'#gp-side-menu-nav .sub-menu .menu-item.current-menu-item > a{color: ' . ghostpool_option( 'side_menu_nav_sub_menu_link_colors', 'hover' ) . ';}' .

				'.widget .current-cat > a,.widget .current-cat > span,.widget .current_page_item a{color: ' . ghostpool_option( 'widget_link_colors', 'hover' ) . ';}' . 

				'.gp-footer-widget .widget .current-cat > a,.gp-footer-widget .widget .current-cat > span,.gp-footer-widget .widget .current_page_item a{color: ' . ghostpool_option( 'footer_widget_link_colors', 'hover' ) . ';}' . 

				'@media only screen and (min-width: 992px){' .

					'.gp-header-over-content.gp-header-nav-bottom-1.gp-standard-page-header #gp-page-title,.gp-header-over-content.gp-header-nav-bottom-2.gp-standard-page-header #gp-page-title,.gp-header-over-content.gp-header-nav-bottom-3.gp-standard-page-header #gp-page-title{padding-top:' . ghostpool_add_units( ghostpool_option( 'desktop_header_height', 'height' ) + ghostpool_option( 'desktop_header_nav_height', 'height' ) ) . ';}' .

					'#gp-side-menu-content{height: calc(100% - ' . ghostpool_add_units( ghostpool_option( 'side_menu_header_height', 'height' ) + 50 ) . ');}' .
	
					'.admin-bar #gp-side-menu-content{height: calc(100% - ' . ghostpool_add_units( ghostpool_option( 'side_menu_header_height', 'height' ) + 50 + 32 ) . ');}' .
		
				'}';
				
				if ( isset( $theme_options['custom_css'] ) && '' !== $theme_options['custom_css'] ) {
					$custom_css .= $theme_options['custom_css'];
				}
				
				wp_register_style( 'ghostpool-custom-css', false );
				wp_enqueue_style( 'ghostpool-custom-css' );
				wp_add_inline_style( 'ghostpool-custom-css', $custom_css );
				
				if ( '' !== $this->ghostpool_google_webfonts( $fonts_used, $subsets_used ) ) {
					wp_enqueue_style( 'ghostpool-google-fonts', $this->ghostpool_google_webfonts( $fonts_used, $subsets_used ), array(), AARDVARK_THEME_VERSION );	
				}
				
			}
	
		}

	}
}
new GhostPool_Custom_CSS();