<?php
	
if ( 'ace_editor' === $type ) {	

	$type = 'textarea';
	$callback = 'ghostpool_sanitize_xss';
		
} elseif ( 'image_select' === $type ) {

	$type = 'radio';
	$callback = 'ghostpool_customizer_sanitize_select';
	foreach( $options as $key => $value ) {	
		if ( isset( $value['img'] ) ) {
			unset( $value['img'] );
		}
		$value = implode( ',', $value );
		$options[$key] = $value;
	}

} elseif ( 'radio' === $type ) {
	
	$callback = 'ghostpool_customizer_sanitize_select';
	
} elseif ( 'spinner' === $type OR 'slider' === $type ) {
	
	$type = 'text';
	$callback = 'absint';

} elseif ( 'textarea' === $type ) {
	
	$callback = 'wp_kses_post';
	
} else {

	$callback = 'sanitize_text_field';

}
	
$wp_customize->add_setting( 
	$id, 
	array(
		'default' => $default,
		'capability' => 'edit_theme_options',
		'type' => 'option',
		'sanitize_callback' => $callback,
	)
);
						
$wp_customize->add_control(
	$id,
	array(
		'label'      => $title,
		'description' => $desc,
		'section'    => $section,
		'settings'   => $id,
		'type' => $type,
		'choices'  => $options,	
	)
);