<?php if ( ! class_exists( 'GhostPool_Framework_Taxonomies' ) ) {
	class GhostPool_Framework_Taxonomies {

 		private $framework;
 		private $settings;
		     
		public function __construct() {
		
			// Framework data 
			$this->framework = ghostpool_framework_data();
			
			// Load settings
			$this->settings = ghostpool_taxonomies_settings( $this->framework['theme_slug'] );
			
			global $pagenow;
		
			if ( 'edit-tags.php' === $pagenow OR 'term.php' === $pagenow ) {
				add_action( 'admin_enqueue_scripts', array( $this, 'enqueue_scripts' ) );
			}
			
			add_action( 'category_term_edit_form_top', array( $this, 'top_wrapper' ) );
			add_action( 'post_tag_term_edit_form_top', array( $this, 'top_wrapper' ) );
			add_action( 'product_term_edit_form_top', array( $this, 'top_wrapper' ) );
			add_action( 'category_edit_form', array( $this, 'bottom_wrapper' ) );
			add_action( 'post_tag_edit_form', array( $this, 'bottom_wrapper' ) );
			add_action( 'product_edit_form', array( $this, 'bottom_wrapper' ) );
			add_action( 'category_pre_add_form', array( $this, 'top_wrapper' ) );
			add_action( 'post_tag_pre_add_form', array( $this, 'top_wrapper' ) );
			add_action( 'product_pre_add_form', array( $this, 'top_wrapper' ) );
			add_action( 'category_add_form', array( $this, 'bottom_wrapper' ) );
			add_action( 'post_tag_add_form', array( $this, 'bottom_wrapper' ) );
			add_action( 'product_add_form', array( $this, 'bottom_wrapper' ) );
			add_action( 'category_add_form_fields', array( $this, 'register_settings' ) );
			add_action( 'post_tag_add_form_fields', array( $this, 'register_settings' ) );	
			add_action( 'product_cat_add_form_fields', array( $this, 'register_settings' ) );
			add_action( 'product_tag_add_form_fields', array( $this, 'register_settings' ) );
			add_action( 'edit_category_form_fields', array( $this, 'register_settings' ) );	
			add_action( 'post_tag_edit_form_fields', array( $this, 'register_settings' ) );
			add_action( 'product_cat_edit_form_fields', array( $this, 'register_settings' ) );
			add_action( 'product_tag_edit_form_fields', array( $this, 'register_settings' ) );
			add_action( 'created_category', array( $this, 'save_settings' ) );
			add_action( 'created_post_tag', array( $this, 'save_settings' ) );
			add_action( 'created_product_cat', array( $this, 'save_settings' ) );
			add_action( 'created_product_tag', array( $this, 'save_settings' ) );
			add_action( 'edit_category', array( $this, 'save_settings' ) );
			add_action( 'edited_post_tag', array( $this, 'save_settings' ) );			
			add_action( 'edited_product_cat', array( $this, 'save_settings' ) );
			add_action( 'edited_product_tag', array( $this, 'save_settings' ) );
		
		}

		public function enqueue_scripts() {
		
			wp_enqueue_style( 'ghostpool-framework-settings' );
			//wp_enqueue_script( 'ghostpool-framework-global' );
			wp_enqueue_script( 'ghostpool-framework-conditions' );

		}

		public function top_wrapper() {
			echo '<div class="gp-settings-section gp-show">';
		}
		public function bottom_wrapper() {
			echo '</div>';
		}
		
		/**
		 * Register settings fields
		 *
		 */						
		public function register_settings( $term ) {
			
			wp_nonce_field( 'ghostpool_framework_taxonomies_action', 'ghostpool_framework_taxonomies_nonce' );

			// Create each setting		
			if ( $this->settings ) {		
			
				foreach ( $this->settings as $settings ) {	
			
					// Get current screen
					$screen = get_current_screen();
				
					// Check if this setting should be shown on this taxonomy
					if ( isset( $settings['taxs'] ) && in_array( $screen->taxonomy, $settings['taxs'] ) ) {
				
						foreach( $settings['section'] as $setting ) {
						
							// Get extracted setting variables
							$parsed_settings = ghostpool_default_setting_fields( $setting );
							extract( $parsed_settings );
				
							// Name variable
							$name = 'ghostpool_taxonomy_settings[' . $id . ']';
											
							// Get value
							$value = null;
							$tax_options = '';
							if ( isset( $term->term_id ) ) {
								$term_id = $term->term_id;
								$tax_options = get_option( "taxonomy_$term_id" );
								if ( isset( $tax_options[$id] ) ) {
									$value = $tax_options[$id];
								}
							}
												
							if ( 'edit-tags' === $screen->base ) {
								if ( isset( $title ) ) {
									echo '<div class="form-field gp-setting ' . esc_attr( $class ) . '"><label for="' . sanitize_html_class( $id ) . '">' . esc_attr( $title ) . '</label>';
								}
							} else {
								if ( isset( $title ) ) {
									echo '<tr class="form-field gp-setting ' . esc_attr( $class ) . '"><th scope="row" valign="top"><label for="' . sanitize_html_class( $id ) . '>">' . esc_attr( $title ) . '</label></th><td>';
								}
							}	
					
							// Load field types
							ghostpool_settings_field_types( $name, $value, $parsed_settings );

							// Conditions
							ghostpool_conditions( 'taxonomies', $parsed_settings, $tax_options );	
					
							if ( 'edit-tags' === $screen->base ) {
								echo '</div>';
							} else {
								echo '</td></tr>';
							}	

						}
						
					}	

				}
					
			}
	
		}
		
		/**
		 * Save settings
		 *
		 */
		public function save_settings( $term_id ) {

			$term_id = (int) $term_id;
			
			if ( ! isset( $_POST['ghostpool_framework_taxonomies_nonce'] ) ) {
				return;
			}
 
			if ( ! wp_verify_nonce( $_POST['ghostpool_framework_taxonomies_nonce'], 'ghostpool_framework_taxonomies_action' ) ) {
				return;
			}
			
			if ( ! current_user_can( 'manage_categories', $term_id ) ) {
				return;
			}
						
			// Get the data being saved
			if ( isset( $_POST['ghostpool_taxonomy_settings'] ) ) {
			
				// Get current taxonomy values
				$values = get_option( "taxonomy_$term_id" );

				// Get data being saved
				if ( $this->settings ) {
					foreach( $this->settings as $settings ) {
						foreach( $settings['section'] as $setting ) {
									
							// Sanitize data
							if ( isset( $_POST['ghostpool_taxonomy_settings'][$setting['id']] ) ) {
								$values[$setting['id']] = ghostpool_sanitize_data( $_POST['ghostpool_taxonomy_settings'][$setting['id']], $setting );
							} else {
								$values[$setting['id']] = '';
							}
						
						}
					}
				}	
				
				update_option( "taxonomy_$term_id", $values );
				
			}
			
		}
			
	}
}
		
if ( is_admin() ) {
	new GhostPool_Framework_Taxonomies();
}