<?php	

function ghostpool_editor_style() {

	$custom_css = '';

	$custom_css .= '.edit-post-layout__content .edit-post-visual-editor {';
		if ( ghostpool_option( 'content_bg' ) ) { 
			$custom_css .= 'background-color: ' . ghostpool_option( 'content_bg' ) . ';';
		} elseif ( ghostpool_option( 'content_wrapper_bg', 'background-color' ) ) { 
			$custom_css .= 'background-color: ' . ghostpool_option( 'content_wrapper_bg', 'background-color' ) . ';';
		} elseif ( ghostpool_option( 'page_bg', 'background-color' ) ) { 
			$custom_css .= 'background-color: ' . ghostpool_option( 'page_bg', 'background-color' ) . ';';
		}
	$custom_css .=  '}';
		
	$custom_css .= '.editor-styles-wrapper .editor-block-list__layout,
	.editor-block-list__layout .wp-block-paragraph,
	.editor-block-list__layout .wp-block-image figcaption {
	font-size: ' . ghostpool_add_units( ghostpool_option( 'general_typography', 'font-size', 'value' ) ) . ';
	line-height: ' . ghostpool_add_units( ghostpool_option( 'general_typography', 'line-height', 'value' ) ) . ';
	letter-spacing: ' . ghostpool_add_units( ghostpool_option( 'general_typography', 'letter-spacing', 'value' ) ) . ';
	color: ' . ghostpool_option( 'general_typography', 'color' ) . ';
	font-family: ' . ghostpool_option( 'general_typography', 'font-family' ) . ',' . ghostpool_option( 'general_typography', 'font-backup' ) . ';
	font-weight: ' . ghostpool_option( 'general_typography', 'font-weight' ) . ';
	text-transform: ' . ghostpool_option( 'general_typography', 'text-transform' ) . ';
	}';
	
	$custom_css .= '.editor-styles-wrapper a {
	color: ' . ghostpool_option( 'general_link_colors', 'regular' ) . ';
	}';

	$custom_css .= '.editor-styles-wrapper a:hover {
	color: ' . ghostpool_option( 'general_link_colors', 'hover' ) . ';
	}';

	$custom_css .= '.editor-styles-wrapper .editor-post-title__block .editor-post-title__input {
	font-size: ' . ghostpool_add_units( ghostpool_option( 'min_mobile_page_title_typography', 'font-size', 'value' ) ) . ';
	line-height: ' . ghostpool_add_units( ghostpool_option( 'min_mobile_page_title_typography', 'line-height', 'value' ) ) . ';
	letter-spacing: ' . ghostpool_add_units( ghostpool_option( 'min_mobile_page_title_typography', 'letter-spacing', 'value' ) ) . ';
	color: ' . ghostpool_option( 'min_page_title_typography', 'color' ) . ';
	font-family: ' . ghostpool_option( 'min_page_title_typography', 'font-family' ) . ',' . ghostpool_option( 'min_page_title_typography', 'font-backup' ) . ';
	font-weight: ' . ghostpool_option( 'min_page_title_typography', 'font-weight' ) . ';
	text-transform: ' . ghostpool_option( 'min_page_title_typography', 'text-transform' ) . ';
	}';
	
	$custom_css .= '@media only screen and (min-width: 992px) {
		.editor-styles-wrapper .editor-post-title__block .editor-post-title__input {
		font-size: ' . ghostpool_add_units( ghostpool_option( 'min_page_title_typography', 'font-size', 'value' ) ) . ';
		line-height: ' . ghostpool_add_units( ghostpool_option( 'min_page_title_typography', 'line-height', 'value' ) ) . ';
		letter-spacing: ' . ghostpool_add_units( ghostpool_option( 'min_page_title_typography', 'letter-spacing', 'value' ) ) . ';
		}
	}';

	$custom_css .= '.editor-block-list__layout .wp-block-heading h1 {
	font-size: ' . ghostpool_add_units( ghostpool_option( 'h1_typography', 'font-size', 'value' ) ) . ';
	line-height: ' . ghostpool_add_units( ghostpool_option( 'h1_typography', 'line-height', 'value' ) ) . ';
	font-family: ' . ghostpool_option( 'h1_typography', 'font-family' ) . ', ' . ghostpool_option( 'h1_typography', 'font-backup' ) . ';
	font-weight: ' . ghostpool_option( 'h1_typography', 'font-weight' ) . ';
	letter-spacing: ' . ghostpool_add_units( ghostpool_option( 'h1_typography', 'letter-spacing', 'value' ) ) . ';
	color: ' . ghostpool_option( 'h1_typography', 'color' ) . ';
	text-transform: ' . ghostpool_option( 'h1_typography', 'text-transform' ) . ';
	}';	
		
	$custom_css .= '.editor-block-list__layout .wp-block-heading h2 {
	font-size: ' . ghostpool_add_units( ghostpool_option( 'h2_typography', 'font-size', 'value' ) ) . ';
	line-height: ' . ghostpool_add_units( ghostpool_option( 'h2_typography', 'line-height', 'value' ) ) . ';
	font-family: ' . ghostpool_option( 'h2_typography', 'font-family' ) . ', ' . ghostpool_option( 'h2_typography', 'font-backup' ) . ';
	font-weight: ' . ghostpool_option( 'h2_typography', 'font-weight' ) . ';
	letter-spacing: ' . ghostpool_add_units( ghostpool_option( 'h2_typography', 'letter-spacing', 'value' ) ) . ';
	color: ' . ghostpool_option( 'h2_typography', 'color' ) . ';
	text-transform: ' . ghostpool_option( 'h2_typography', 'text-transform' ) . ';
	}';	

	$custom_css .= '.editor-block-list__layout .wp-block-heading h3 {
	font-size: ' . ghostpool_add_units( ghostpool_option( 'h3_typography', 'font-size', 'value' ) ) . ';
	line-height: ' . ghostpool_add_units( ghostpool_option( 'h3_typography', 'line-height', 'value' ) ) . ';
	font-family: ' . ghostpool_option( 'h3_typography', 'font-family' ) . ', ' . ghostpool_option( 'h3_typography', 'font-backup' ) . ';
	font-weight: ' . ghostpool_option( 'h3_typography', 'font-weight' ) . ';
	letter-spacing: ' . ghostpool_add_units( ghostpool_option( 'h3_typography', 'letter-spacing', 'value' ) ) . ';
	color: ' . ghostpool_option( 'h3_typography', 'color' ) . ';
	text-transform: ' . ghostpool_option( 'h3_typography', 'text-transform' ) . ';
	}';	
	
	$custom_css .= '.editor-block-list__layout .wp-block-heading h4 {
	font-size: ' . ghostpool_add_units( ghostpool_option( 'h4_typography', 'font-size', 'value' ) ) . ';
	line-height: ' . ghostpool_add_units( ghostpool_option( 'h4_typography', 'line-height', 'value' ) ) . ';
	font-family: ' . ghostpool_option( 'h4_typography', 'font-family' ) . ', ' . ghostpool_option( 'h4_typography', 'font-backup' ) . ';
	font-weight: ' . ghostpool_option( 'h4_typography', 'font-weight' ) . ';
	letter-spacing: ' . ghostpool_add_units( ghostpool_option( 'h4_typography', 'letter-spacing', 'value' ) ) . ';
	color: ' . ghostpool_option( 'h4_typography', 'color' ) . ';
	text-transform: ' . ghostpool_option( 'h4_typography', 'text-transform' ) . ';
	}';

	$custom_css .= '.editor-block-list__layout .wp-block-heading h5 {
	font-size: ' . ghostpool_add_units( ghostpool_option( 'h5_typography', 'font-size', 'value' ) ) . ';
	line-height: ' . ghostpool_add_units( ghostpool_option( 'h5_typography', 'line-height', 'value' ) ) . ';
	font-family: ' . ghostpool_option( 'h5_typography', 'font-family' ) . ', ' . ghostpool_option( 'h5_typography', 'font-backup' ) . ';
	font-weight: ' . ghostpool_option( 'h5_typography', 'font-weight' ) . ';
	letter-spacing: ' . ghostpool_add_units( ghostpool_option( 'h5_typography', 'letter-spacing', 'value' ) ) . ';
	color: ' . ghostpool_option( 'h5_typography', 'color' ) . ';
	text-transform: ' . ghostpool_option( 'h5_typography', 'text-transform' ) . ';
	}';	

	$custom_css .= '.editor-block-list__layout .wp-block-heading h6 {
	font-size: ' . ghostpool_add_units( ghostpool_option( 'h6_typography', 'font-size', 'value' ) ) . ';
	line-height: ' . ghostpool_add_units( ghostpool_option( 'h6_typography', 'line-height', 'value' ) ) . ';
	font-family: ' . ghostpool_option( 'h6_typography', 'font-family' ) . ', ' . ghostpool_option( 'h6_typography', 'font-backup' ) . ';
	font-weight: ' . ghostpool_option( 'h6_typography', 'font-weight' ) . ';
	letter-spacing: ' . ghostpool_add_units( ghostpool_option( 'h6_typography', 'letter-spacing', 'value' ) ) . ';
	color: ' . ghostpool_option( 'h6_typography', 'color' ) . ';
	text-transform: ' . ghostpool_option( 'h6_typography', 'text-transform' ) . ';
	}';	
	
	$custom_css .= '.editor-block-list__layout .wp-block-quote, 
	.editor-block-list__layout .wp-block-pullquote blockquote {
	border-color: ' . ghostpool_option( 'blockquote_border' ) . ';
	}';
	
	$custom_css .= '.editor-block-list__layout .wp-block-quote:not(.has-text-color),
	.editor-block-list__layout .wp-block-quote:not(.has-text-color) p, 
	.editor-block-list__layout .wp-block-quote:not(.has-text-color) a,
	.editor-styles-wrapper .editor-block-list__layout blockquote:not(.has-text-color) p,
	.editor-block-list__layout blockquote:not(.has-text-color) .wp-block-quote__citation,
	.editor-block-list__layout blockquote:not(.has-text-color) .wp-block-pullquote__citation,
	.editor-block-list__layout .wp-block-pullquote blockquote:not(.has-text-color) cite, 
	.editor-block-list__layout .wp-block-pullquote blockquote:not(.has-text-color) footer {
	color: ' . ghostpool_option( 'blockquote_text_color' ) . ';
	}';

	$custom_css .= '.editor-block-list__layout .wp-block-preformatted,
	.editor-block-list__layout .wp-block-code,
	.editor-block-list__layout .wp-block-code .editor-plain-text {
	background-color: ' . ghostpool_option( 'pre_bg_color' ) . ';
	}';

	$custom_css .= '.editor-block-list__layout .wp-block-preformatted,
	.editor-block-list__layout .wp-block-code,
	.editor-block-list__layout .wp-block-code .editor-plain-text {
	color: ' . ghostpool_option( 'pre_text_color' ) . ';
	}';

	$custom_css .= '.editor-block-list__layout .wp-block-separator {
	border-color: ' . ghostpool_option( 'divider_color' ) . ';
	}';		

	$custom_css .= '.editor-block-list__layout .wp-block-separator.is-style-dots:before {
	color: ' . ghostpool_option( 'divider_color' ) . ';
	}';		
	
	$custom_css .= '.editor-block-list__layout .wp-block-table:not(.is-style-stripes) th {
	background-color: ' . ghostpool_option( 'misc_table_header_bg_color' ) . ';
	}';	

	$custom_css .= '.editor-block-list__layout .wp-block-table:not(.is-style-stripes) th {
	border-color: ' . ghostpool_option( 'misc_table_header_border_color' ) . ';
	}';	
		
	$custom_css .= '.editor-block-list__layout .wp-block-table th {
	color: ' . ghostpool_option( 'misc_table_header_text_color' ) . ';
	}';	
	
	$custom_css .= '.editor-block-list__layout .wp-block-table:not(.is-style-stripes) td {
	background-color: ' . ghostpool_option( 'misc_table_body_bg_color' ) . ';
	}';	
	
	$custom_css .= '.editor-block-list__layout .wp-block-table:not(.is-style-stripes) td {
	border-color: ' . ghostpool_option( 'misc_table_body_border_color' ) . ';
	}';	
	
	$custom_css .= '.editor-block-list__layout .wp-block-table td {
	color: ' . ghostpool_option( 'misc_table_body_text_color' ) . ';
	}';						
	
	wp_register_style( 'ghostpool-gutenberg', false );
	wp_enqueue_style( 'ghostpool-gutenberg' );
	wp_add_inline_style( 'ghostpool-gutenberg', $custom_css );

}
add_action( 'enqueue_block_editor_assets', 'ghostpool_editor_style' );