<?php if ( ! class_exists( 'GhostPool_Setup' ) ) {
	class GhostPool_Setup {

		protected static $_instance = null;

		public $slug = 'aardvark-theme-setup';

		public function __construct() {
			
			add_action( 'admin_menu', array( $this, 'add_menu_page' ), 1 );
			add_action( 'admin_init', array( $this, 'redirect_to_setup' ), 0 );

			if ( ( isset( $_GET['page'] ) && $this->slug === $_GET['page'] ) OR ( isset( $_REQUEST['action'] ) && $_REQUEST['action'] == 'ghostpool_do_plugin_action' ) ) {
				add_action( 'admin_init', array( $this, 'config_addons' ), 12 );
			}
		
			if ( isset( $_GET['page'] ) && $this->slug === $_GET['page'] ) {
				add_action( 'admin_enqueue_scripts', array( $this, 'enqueue_scripts' ) );
			}			
			
			add_action( 'tgmpa_register', array( $this, 'register_plugins' ) );
			
			$this->load_dependencies();
			
		}

		public static function getInstance() {
			if ( is_null( self::$_instance ) ) {
				self::$_instance = new self();
			}
			return self::$_instance;
		}

		public function enqueue_scripts() {
			$wp_scripts = wp_scripts();
			wp_enqueue_style( 'jquery-ui-theme-smoothness', sprintf( '//ajax.googleapis.com/ajax/libs/jqueryui/%s/themes/smoothness/jquery-ui.css', $wp_scripts->registered['jquery-ui-core']->ver ) );						
			wp_enqueue_script( 'jquery-ui-tooltip' );
			wp_enqueue_style( 'theme-setup', get_template_directory_uri() . '/lib/framework/theme-setup/assets/theme-setup.css', array(), AARDVARK_THEME_VERSION );
			wp_enqueue_script( 'jquery-ui-tooltip' );
			wp_enqueue_script( 'theme-setup', get_template_directory_uri() . '/lib/framework/theme-setup/assets/theme-setup.js', array( 'jquery' ), AARDVARK_THEME_VERSION );
		}
		
		public function load_dependencies() {
			if ( version_compare( phpversion(), '5.2.4', '>=' ) ) {
				require_once( get_theme_file_path( '/lib/framework/theme-setup/class-tgm-plugin-activation.php' ) );
			}
			require_once( get_theme_file_path( '/lib/framework/theme-setup/class-addons.php' ) );
			require_once( get_theme_file_path( '/lib/framework/theme-setup/importer/class-importer.php' ) );
		}
		
		public function add_menu_page() {

			add_menu_page( 
				esc_html__( 'Aardvark', 'aardvark' ),
				esc_html__( 'Aardvark', 'aardvark' ),
				'manage_options',
				$this->slug, 
				'',
				'dashicons-analytics',
				75
			);
		
			add_submenu_page(
				$this->slug,
				esc_html__( 'Theme Setup', 'aardvark' ),
				esc_html__( 'Theme Setup', 'aardvark' ),
				'manage_options',
				$this->slug,
				array( $this, 'setup_page' )
			);
		
		}

		function setup_page() {
			require( get_theme_file_path( '/lib/framework/theme-setup/template-theme-setup.php' ) );
		}

		public function redirect_to_setup() {
			global $pagenow;
			if ( isset( $_GET['activated'] ) && $pagenow == 'admin.php' ) {
				wp_redirect( admin_url( 'admin.php?page=' . $this->slug ) );
				exit;
			}
		}

		public function register_plugins() {

			$plugins = array();
	
			$plugins[] = array(
				'name'               => esc_html__( 'Aardvark Plugin', 'aardvark' ),
				'slug'               => 'aardvark-plugin',
				'source'             => get_theme_file_path( '/lib/plugins/aardvark-plugin.zip' ),
				'required'           => true,
				'version'            => AARDVARK_PLUGIN_VERSION,
			);

			$plugins[] = array(
				'name'               => esc_html__( 'WPBakery Page Builder', 'aardvark' ),
				'slug'               => 'js_composer',
				'source'             => get_theme_file_path( '/lib/plugins/js_composer.zip' ),
				'required'           => true,
				'version'            => WPB_PLUGIN_VERSION,
			);

			$plugins[] = array(
				'name'               => esc_html__( 'Responsive for WPBakery Page Builder', 'aardvark' ),
				'slug'               => 'vc_responsive_design',
				'source'             => get_theme_file_path( '/lib/plugins/vc_responsive_design.zip' ),
				'required'           => true,
				'version'            => RESPONSIVE_WPB_VERSION,
			);

			$plugins[] = array(
				'name'               => esc_html__( 'LayerSlider WP', 'aardvark' ),
				'slug'               => 'LayerSlider',
				'source'             => get_theme_file_path( '/lib/plugins/LayerSlider.zip' ),
				'required'           => false,
				'version'            => LAYERSLIDER_VERSION,
				'force_deactivation'    => true,
			);
				
			$plugins[] = array(
				'name'   		     => esc_html__( 'Theia Sticky Sidebar', 'aardvark' ),
				'slug'   		     => 'theia-sticky-sidebar',
				'source'   		     => get_theme_file_path( '/lib/plugins/theia-sticky-sidebar.zip' ),
				'required'   		 => false,
				'version'   		 => THEIA_STICKY_VERSION,
			);

			$plugins[] = array(
				'name'               => esc_html__( 'Ultimate Reviewer', 'aardvark' ),
				'slug'               => 'ultimate-reviewer',
				'source'             => get_theme_file_path( '/lib/plugins/ultimate-reviewer.zip' ),
				'required'           => false,
				'version'            => ULTIMATE_REVIEWER_VERSION,
			);

			$plugins[] = array(
				'name'               => esc_html__( 'Youzer', 'aardvark' ),
				'slug'               => 'youzer',
				'source'             => get_theme_file_path( '/lib/plugins/youzer.zip' ),
				'required'           => false,
				'version'            => YOUZER_VERSION,
			);
	
			$plugins[] = array(
				'name'      		=> esc_html__( 'Sensei LMS', 'aardvark' ),
				'slug'      		=> 'sensei-lms',
				'required' 			=> false,
			);
																																	
			if ( function_exists( 'is_sensei' ) ) {
				$plugins[] = array(
					'name'      		=> esc_html__( 'Sensei Certificates', 'aardvark' ),
					'slug'      		=> 'sensei-certificates',
					'source'			=> get_theme_file_path( '/lib/plugins/sensei-certificates.zip' ),
					'required' 			=> false,
					'version'   		=> SENSEI_CERTIFICATES,
				);
			}
			
			$plugins[] = array(
				'name'      		=> esc_html__( 'Paid Membership Pro', 'aardvark' ),
				'slug'      		=> 'paid-memberships-pro',
				'required' 			=> false,
			);
	
			$plugins[] = array(
				'name'      		=> esc_html__( 'Paid Membership Pro - BuddyPress Add On', 'aardvark' ),
				'slug'      		=> 'pmpro-buddypress',
				'required' 			=> false,
			);
	
			$plugins[] = array(
				'name'   		     => esc_html__( 'BuddyPress', 'aardvark' ),
				'slug'   		     => 'buddypress',
				'required'   		 => false,
			);
	
			$plugins[] = array(
				'name'      		=> esc_html__( 'BuddyPress Xprofile Custom Fields Type', 'aardvark' ),
				'slug'      		=> 'bp-xprofile-custom-field-types',
				'required' 			=> false,
			);

			$plugins[] = array(
				'name'   		     => esc_html__( 'BP Profile Search', 'aardvark' ),
				'slug'   		     => 'bp-profile-search',
				'required'   		 => false,
			);
	
			if ( ! function_exists( 'yz_is_activity_component' ) ) { 
				$plugins[] = array(
					'name'      		=> esc_html__( 'rtMedia', 'aardvark' ),
					'slug'      		=> 'buddypress-media',
					'required' 			=> false,
				);
			}
			
			$plugins[] = array(
				'name'   		     => esc_html__( 'bbPress', 'aardvark' ),
				'slug'   		     => 'bbpress',
				'required'   		 => false,
			);
										
			$plugins[] = array(
				'name'   		     => esc_html__( 'WooCommerce', 'aardvark' ),
				'slug'   		     => 'woocommerce',
				'required'   		 => false,
			);
	
			$plugins[] = array(
				'name'      		=> esc_html__( 'WordPress Popular Posts', 'aardvark' ),
				'slug'      		=> 'wordpress-popular-posts',
				'required' 			=> false,
			);

			$plugins[] = array(
				'name'      		=> esc_html__( 'WP Live Chat Support', 'aardvark' ),
				'slug'      		=> 'wp-live-chat-support',
				'required' 			=> false,
			);
	
			$plugins[] = array(
				'name'      		=> esc_html__( 'Events Manager', 'aardvark' ),
				'slug'      		=> 'events-manager',
				'required' 			=> false,
			);

			$plugins[] = array(
				'name'      		=> esc_html__( 'Envato Market', 'aardvark' ),
				'slug'      		=> 'envato-market',
				'source'			=> 'https://envato.github.io/wp-envato-market/dist/envato-market.zip',
				'required' 			=> false,
			);

			$config = array(
				'id'           => 'aardvark',
				'default_path' => '',
				'menu'         => 'tgmpa-install-plugins',
				'has_notices'  => true,                 
				'dismissable'  => true,                  
				'dismiss_msg'  => '',
				'is_automatic' => true,
				'message'      => '',
			);

			tgmpa( $plugins, $config );

		}

		public function config_addons() {

			// Optional and not included plugins
			GhostPool_Addons_Manager()->plugins = array( 'optional-not-included-plugins' => 'optional-not-included-plugins' ) + GhostPool_Addons_Manager()->plugins;					

			// Optional and included plugins
			GhostPool_Addons_Manager()->plugins = array( 'youzer' => GhostPool_Addons_Manager()->plugins['youzer'] ) + GhostPool_Addons_Manager()->plugins;
			
			GhostPool_Addons_Manager()->plugins = array( 'ultimate-reviewer' => GhostPool_Addons_Manager()->plugins['ultimate-reviewer'] ) + GhostPool_Addons_Manager()->plugins;
			
			GhostPool_Addons_Manager()->plugins = array( 'theia-sticky-sidebar' => GhostPool_Addons_Manager()->plugins['theia-sticky-sidebar'] ) + GhostPool_Addons_Manager()->plugins;
			
			if ( function_exists( 'is_sensei' ) ) {
				GhostPool_Addons_Manager()->plugins = array( 'sensei-certificates' => GhostPool_Addons_Manager()->plugins['sensei-certificates'] ) + GhostPool_Addons_Manager()->plugins;
			}	
			
			GhostPool_Addons_Manager()->plugins = array( 'LayerSlider' => GhostPool_Addons_Manager()->plugins['LayerSlider'] ) + GhostPool_Addons_Manager()->plugins;
			
			GhostPool_Addons_Manager()->plugins = array( 'optional-included-plugins' => 'optional-included-plugins' ) + GhostPool_Addons_Manager()->plugins;
						
			// Required plugins
			GhostPool_Addons_Manager()->plugins = array( 'vc_responsive_design' => GhostPool_Addons_Manager()->plugins['vc_responsive_design'] ) + GhostPool_Addons_Manager()->plugins;
		
			GhostPool_Addons_Manager()->plugins = array( 'js_composer' => GhostPool_Addons_Manager()->plugins['js_composer'] ) + GhostPool_Addons_Manager()->plugins;
		
			GhostPool_Addons_Manager()->plugins = array( 'aardvark-plugin' => GhostPool_Addons_Manager()->plugins['aardvark-plugin'] ) + GhostPool_Addons_Manager()->plugins;
		
			GhostPool_Addons_Manager()->plugins = array( 'required-plugins' => 'required-plugins' ) + GhostPool_Addons_Manager()->plugins;
			
			
			// Child Theme
			$prepend = array(
				'aardvark-child' => array(
					'addon_type'  => 'child_theme',
					'name'        => 'Aardvark Child Theme',
					'slug'        => 'aardvark-child',
					'source'      => get_template_directory() . '/lib/plugins/aardvark-child.zip',
					'source_type' => 'bundled',
					'version'     => '1.0',
					'required'    => false,
					'description' => esc_html__( 'If you want to edit the theme files, activate the child theme and make your changes to this so you can safely update the parent theme.', 'aardvark' ),
				)
			);

			GhostPool_Addons_Manager()->plugins = $prepend + GhostPool_Addons_Manager()->plugins;
			
			GhostPool_Addons_Manager()->plugins = array( 'child-theme' => 'child-theme' ) + GhostPool_Addons_Manager()->plugins;	
			
				
		}

	}

}
GhostPool_Setup::getInstance();