<?php 


/**
 *  Link display
 *
 */
if ( ! isset( $display ) ) { 
	$display = array( 'login-form', 'register-form', 'lost-password-form' );
	$css_classes = 'gp-login-display';
} 

/**
 * Login link
 *
 */
if ( in_array( 'login-form', $display ) ) { 
	if ( has_filter( 'ghostpool_login_url' ) ) {
		$login_link = apply_filters( 'ghostpool_login_url', '' );
	} else {
		$login_link = '<a href="#" class="gp-login-link">' . esc_html__( 'Sign In', 'aardvark' ) . '</a>';
	}
} else {
	$login_link = '';
}
					 
/**
 * Register link
 *
 */
if ( get_option( 'users_can_register' ) && in_array( 'register-form', $display ) ) {
	if ( has_filter( 'ghostpool_register_url' ) ) {
		$register_link = apply_filters( 'ghostpool_register_url', '' );
	} elseif ( function_exists( 'bp_is_active' ) ) {
		$register_link = '<a href="' . esc_url( bp_get_signup_page( false ) ) . '" class="gp-bp-register-link">' . esc_html__( 'Register', 'aardvark' ) . '</a>';
	} else {
		$register_link = '<a href="#" class="gp-register-link">' . esc_html__( 'Register', 'aardvark' ). '</a>';
	}
} else {
	$register_link = '';
}

/**
 * Lost password link
 *
 */
if ( in_array( 'lost-password-form', $display ) ) {
	if ( has_filter( 'ghostpool_lost_password_url' ) ) {
		$lost_password_link = apply_filters( 'ghostpool_lost_password_url', '' );
	} else {
		$lost_password_link = '<a href="#" class="gp-lost-password-link">' . esc_html__( 'Lost Password', 'aardvark' ) . '</a>';
	}
} else { 
	$lost_password_link = '';
}
										
?>

<div class="gp-login-register-form <?php if ( isset( $css_classes ) ) { echo esc_attr( $css_classes ); } ?>">


	<?php 
	
	 // If Youzer membership system is activated, exit
	if ( function_exists( 'yz_is_membership_system_active' ) && true === yz_is_membership_system_active() ) {
		
		echo esc_html__( 'Deactivate the Youzer Membership System to use the theme\'s login form', 'aardvark' ) . ' <a href="' .  admin_url( 'admin.php?page=youzer-panel' ) . '">' . esc_html__( 'here', 'aardvark' ) . '</a>.';
		
	} else { ?>

		<?php if ( in_array( 'login-form', $display ) ) { ?>
	
			<div class="gp-login-form-wrapper">

				<h5 class="gp-login-title"><?php esc_html_e( 'Sign In', 'aardvark' ); ?></h5>		

				<form name="loginform" class="gp-login-form" action="<?php echo esc_url( site_url( 'wp-login.php', 'login_post' ) ); ?>" method="post">

					<p class="username gp-input"><input type="text" autocomplete="username" name="log" class="user_login" value="<?php if ( ! empty( $user_login ) ) { echo esc_html( stripslashes( $user_login ), 1 ); } ?>" size="20" placeholder="<?php esc_html_e( 'Username Or Email', 'aardvark' ); ?>" required /></p>

					<p class="password gp-input"><input type="password" autocomplete="current-password" name="pwd" class="user_pass" size="20" placeholder="<?php esc_html_e( 'Password', 'aardvark' ); ?>" required /></p>
				
					<div class="gp-login-form-actions gp-input">
						<?php do_action( 'login_form' ); ?>
					</div>
				
					<p class="rememberme gp-input"><input name="rememberme" class="rememberme" type="checkbox" value="forever" /> <?php esc_html_e( 'Remember Me', 'aardvark' ); ?></p>
					
					<?php if ( has_action( 'wordpress_social_login' ) OR has_action( 'login_form', 'the_champ_login_button' ) ) { ?>
						<div class="gp-social-login gp-input">
							<div class="gp-login-or-lines">
								<div class="gp-login-or-left-line"></div>
								<div class="gp-login-or-text"><?php esc_html_e( 'or', 'aardvark' ); ?></div>
								<div class="gp-login-or-right-line"></div>
							</div>	
							<?php if ( has_action( 'wordpress_social_login' ) ) { 
								do_action( 'wordpress_social_login' ); 
							} 
							if ( has_action( 'login_form', 'the_champ_login_button' ) ) { 
								echo do_shortcode( '[TheChamp-Login]' ); 
							} ?>
						</div>
					<?php } ?>
								
					<input type="submit" name="wp-submit" class="wp-submit gp-input" value="<?php esc_html_e( 'Sign In', 'aardvark' ); ?>" />
	
					<div class="gp-login-results"></div>

					<div class="gp-login-links">
						<?php echo wp_kses_post( $register_link ); ?>
						<?php echo wp_kses_post( $lost_password_link ); ?>
					</div>
				
					<input type="hidden" name="form_type" value="login" />
		
					<?php if ( isset( $element_nonce ) && true == $element_nonce ) { ?>
						<?php wp_nonce_field( 'ghostpool_ajax_login_action', 'ghostpool_ajax_login_page_nonce' ); ?>
					<?php } else { ?>	
						<?php wp_nonce_field( 'ghostpool_ajax_login_action', 'ghostpool_ajax_login_popup_nonce' ); ?>
					<?php } ?>	

				</form>

			</div>
	
		<?php } ?>
	
		<?php if ( in_array( 'lost-password-form', $display ) ) { ?>	
		
			<div class="gp-lost-password-form-wrapper">

				<h5 class="gp-login-title"><?php esc_html_e( 'Lost Password', 'aardvark' ); ?></h5>

				<form name="lostpasswordform" class="gp-lost-password-form" action="#" method="post">
			
					<?php if ( isset( $_GET['reset_pwd'] ) && true == $_GET['reset_pwd'] ) { ?>
				
						<input type="hidden" name="login" value="<?php echo $_GET['login'] ?>" autocomplete="off">
						<input type="hidden" name="key" value="<?php echo strip_tags( $_GET['key'] ); ?>" />
				
						<p class="gp-login-desc gp-input"><?php esc_html_e( 'Please enter your new password below.', 'aardvark' ); ?></p>	
	
						<p class="pass1 gp-input"><input type="password" name="pass1" class="pass1" size="20" placeholder="<?php esc_html_e( 'New Password', 'aardvark' ); ?>" required /></p>
					
						<p class="pass2 gp-input"><input type="password" name="pass2" class="pass2" size="20" placeholder="<?php esc_html_e( 'Confirm New Password', 'aardvark' ); ?>" required /></p>
				
						<?php do_action( 'lostpassword_form' ); ?>

						<input type="submit" name="wp-submit" class="wp-submit gp-input" value="<?php esc_html_e( 'Reset Password', 'aardvark' ); ?>" />
					
						<div class="gp-login-results"></div>
					
						<div class="gp-login-links">
							<?php echo wp_kses_post( $login_link ); ?>
						</div>
				
						<input type="hidden" name="form_type" value="reset_password" />

						<?php if ( isset( $element_nonce ) && true == $element_nonce ) { ?>
							<?php wp_nonce_field( 'ghostpool_ajax_login_action', 'ghostpool_ajax_reset_password_page_nonce' ); ?>
						<?php } else { ?>	
							<?php wp_nonce_field( 'ghostpool_ajax_login_action', 'ghostpool_ajax_reset_password_popup_nonce' ); ?>
						<?php } ?>	
				
					<?php } else { ?>
	
						<p class="gp-login-desc gp-input"><?php esc_html_e( 'Please enter your username or email address. You will receive a link to create a new password via email.', 'aardvark' ); ?></p>	
	
						<p class="gp-input"><input type="text" autocomplete="off" name="user_login" class="user_login" value="" size="20" placeholder="<?php esc_html_e( 'Username or Email', 'aardvark' ); ?>" required /></p>
				
						<?php do_action( 'lostpassword_form' ); ?>

						<input type="submit" name="wp-submit" class="wp-submit gp-input" value="<?php esc_html_e( 'Reset Password', 'aardvark' ); ?>" />

						<div class="gp-login-results"></div>

						<div class="gp-login-links">
							<?php echo wp_kses_post( $login_link ); ?>
						</div>
					
						<input type="hidden" name="form_type" value="lost_password" />

						<?php if ( isset( $element_nonce ) && true == $element_nonce ) { ?>
							<?php wp_nonce_field( 'ghostpool_ajax_login_action', 'ghostpool_ajax_lost_password_page_nonce' ); ?>
						<?php } else { ?>	
							<?php wp_nonce_field( 'ghostpool_ajax_login_action', 'ghostpool_ajax_lost_password_popup_nonce' ); ?>
						<?php } ?>	
					
					<?php } ?>	
								
				</form>

			</div>
	
		<?php } ?>
				
		<?php if ( get_option( 'users_can_register' ) && ! function_exists( 'bp_is_active' ) && in_array( 'register-form', $display ) ) { ?>

			<div class="gp-register-form-wrapper">

				<h5 class="gp-login-title"><?php esc_html_e( 'Sign Up', 'aardvark' ); ?></h5>		

				<form name="registerform" class="gp-register-form" action="<?php echo esc_url( site_url( 'wp-login.php?action=register', 'login_post' ) ); ?>" method="post">
		
					<p class="username gp-input"><input type="text" autocomplete="off" name="user_login" class="user_login" value="<?php if ( ! empty( $user_login ) ) { echo esc_html( stripslashes( $user_login ), 1 ); } ?>" size="20" placeholder="<?php esc_html_e( 'Username', 'aardvark' ); ?>" required /></p>

					<p class="email gp-input"><input type="email" autocomplete="off" name="user_email" class="user_email" size="25" placeholder="<?php esc_html_e( 'Email', 'aardvark' ); ?>" required /></p>

					<p class="password gp-input"><span class="gp-password-icon"></span><input type="password" autocomplete="new-password" name="user_confirm_pass" class="user_confirm_pass" size="25" placeholder="<?php esc_attr_e( 'Password', 'aardvark' ); ?>" required /></p>
			
					<p class="password gp-input"><span class="gp-password-icon"></span><input type="password" autocomplete="new-password" name="user_pass" class="user_pass" size="25" placeholder="<?php esc_attr_e( 'Confirm Password', 'aardvark' ); ?>" required /></p>
		
					<?php do_action( 'register_form' ); ?>
		
					<input type="submit" name="wp-submit" class="wp-submit gp-input" value="<?php esc_html_e( 'Sign Up', 'aardvark' ); ?>" />
				
					<?php if ( ghostpool_option( 'registration_gdpr' ) == 'enabled' ) { ?>
						<p class="gp-gdpr"><input name="gdpr" class="gdpr gp-input" type="checkbox" value="1" required /> <label><?php echo wp_kses_post( ghostpool_option( 'registration_gdpr_text' ) ); ?></label></p>
					<?php } ?>
				
					<div class="gp-login-results"></div>
						
					<div class="gp-login-links">
						<?php echo wp_kses_post( $login_link ); ?>
					</div>
				
					<input type="hidden" name="form_type" value="registration" />

					<?php if ( isset( $element_nonce ) && true == $element_nonce ) { ?>
						<?php wp_nonce_field( 'ghostpool_ajax_login_action', 'ghostpool_ajax_registration_page_nonce' ); ?>
					<?php } else { ?>	
						<?php wp_nonce_field( 'ghostpool_ajax_login_action', 'ghostpool_ajax_registration_popup_nonce' ); ?>
					<?php } ?>	
	
				</form>
	
			</div>

		<?php } ?>
	
	<?php } ?>
		
</div>	