<?php if ( ! function_exists( 'ghostpool_post_submission_form_2' ) ) {
	function ghostpool_post_submission_form_2( $atts, $content = null ) {	
		
		extract( shortcode_atts( array(
			'post_title_field' => 'enabled',
			'post_title_field_title' => '',
			'post_title_field_placeholder' => esc_html__( 'Enter title', 'aardvark-plugin' ),
			'post_title_field_required' => '1',
			'featured_image_field' => 'enabled',
			'featured_image_field_title' => '',
			'featured_image_field_button_text' => esc_html__( 'Add image', 'aardvark-plugin' ),
			'featured_image_field_required' => '1',
			'name_field' => 'enabled',
			'name_field_title' => '',
			'name_field_placeholder' => esc_html__( 'Name', 'aardvark-plugin' ),
			'name_field_required' => '1',
			'email_field' => 'enabled',
			'email_field_title' => '',
			'email_field_placeholder' => esc_html__( 'Email', 'aardvark-plugin' ),
			'email_field_required' => '1',
			'cats_field' => 'dropdown',
			'cats_field_title' => '',
			'cats_field_placeholder' => esc_html__( 'Select a category', 'aardvark-plugin' ),
			'cats_field_required' => '1',
			'cats_user_available' => '',
			'cats_auto' => '',
			'tags_field' => 'textbox',
			'tags_field_title' => '',
			'tags_field_placeholder' => esc_html__( 'Separate tags with commas', 'aardvark-plugin' ),
			'tags_field_required' => '1',
			'tags_user_available' => '',
			'tags_auto' => '',
			'post_format_default' => '0',
			'post_formats_field' => 'enabled',
			'post_formats_field_title' => '',
			'standard' => '1',
			'audio' => '1',
			'audio_field_button_text' => esc_html__( 'Add audio', 'aardvark-plugin' ),
			'aside' => '1',
			'chat' => '1',
			'gallery' => '1',
			'gallery_field_button_text' => esc_html__( 'Add gallery images', 'aardvark-plugin' ),
			'image' => '1',
			'link' => '1',
			'link_field_placeholder' => esc_html__( 'Link', 'aardvark-plugin' ),
			'quote' => '1',
			'status' => '1',
			'video' => '1',
			'video_field_button_text' => esc_html__( 'Add videos', 'aardvark-plugin' ),
			'post_content_field' => 'enabled',
			'post_content_editor' => 'tinymce',
			'post_content_field_title' => '',
			'post_content_field_placeholder' => esc_html__( 'Enter text', 'aardvark-plugin' ),
			'post_content_field_required' => '1',
			'toc_field' => 'disabled',
			'toc_field_title' => '',
			'toc_field_text' => '',
			'toc_field_required' => '1',		
			'gdpr_field' => 'disabled',
			'gdpr_field_title' => '',	
			'gdpr_field_text' => '',
			'gdpr_field_required' => '1',
			'submit_button_text' => esc_html__( 'Submit Post', 'aardvark-plugin' ),
			'required_field_text' => esc_html__( 'This field is required.', 'aardvark-plugin' ),
			'login_text' => esc_html__( "To login to submit a post please click <a href='%LOGIN_LINK%'>here</a>.", 'aardvark-plugin' ),
			'visitors_can_post' => 'enabled',
			'post_submission_status' => 'pending',
			'post_submission_email_notification' => 'enabled',
			'post_submission_email_address' => '',
			'post_submission_subject' => esc_html__( 'Post Submission', 'aardvark-plugin' ),
			'classes' => '',
			'css' => '',
		), $atts ) );
		
		// Unique Name	
		STATIC $i = 0;
		$i++;
		$form_id = 'gp_post_submission_form_wrapper_' . $i;
		
		// If editing post use this data
		$post_id = 0;
		$form = 'submission';
		if ( isset( $_GET['post_edit'] ) && $_GET['post_edit'] == 1 ) {
					
			// Form Type
			$form = 'edit';
			
			// Pass ID of post being edited from URL
			$post_edit = get_post( $_GET['id'] );
			$post_id = $post_edit->ID;

			// If this is not your post, exit
			$current_user = wp_get_current_user();
			if ( (int) $current_user->ID !== (int) $post_edit->post_author ) {
				return;
			}
		
			// Get shortcode variables from submission page		
			if ( (int) ghostpool_option( 'post_submission_page' ) > 0 ) {
				$submission_page_id = (int) ghostpool_option( 'post_submission_page' );
			} else {
				$submission_page_id = (int) get_post_meta( $post_id, 'ghostpool_post_submission_page_id', true );
			}
			
			if ( $submission_page_id ) {

				$submission_page = get_post( $submission_page_id );
				if ( is_object( $submission_page ) && $submission_page->post_content ) {
					$shortcode = preg_match_all( "/\[gp_post_submission_form_2(.*?)\]/", $submission_page->post_content, $variables ) ? $variables[1] : '';
					if ( '' !== $shortcode ) {
						if ( is_array( $shortcode ) ) {
							$shortcode = implode( ',', $shortcode );
						}
						$shortcode_matches = '';
						preg_match_all( '/(\w+)\s*=\s*"(.*?)"/', $shortcode, $shortcode_matches );
						if ( '' !== $shortcode_matches ) {			
							$variables = array();
							for( $i = 0; $i < count( $shortcode_matches[1] ); $i++ ) {
								$variables[$shortcode_matches[1][$i]] = $shortcode_matches[2][$i];
							}
						}
						if ( is_array( $variables ) ) {
							extract( $variables );
						}
				
					}
				}
					
			}
			
		}
					
		// Classes
		$css_classes = array(
			'gp-post-form',
			'gp-post-submission-form',
			$classes,
		);
		$css_classes = trim( implode( ' ', array_filter( array_unique( $css_classes ) ) ) );
		$css_classes = apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, $css_classes . vc_shortcode_custom_css_class( $css, ' ' ), '', $atts );
								
		ob_start(); ?>
		
		<?php if ( ( 'enabled' === $visitors_can_post && ! is_user_logged_in() ) OR is_user_logged_in() ) { ?>

			<div id="<?php echo sanitize_html_class( $form_id ); ?>">
					
				<form class="<?php echo esc_attr( $css_classes ); ?>" method="post" enctype="multipart/form-data" data-form="<?php echo esc_attr( $form ); ?>">	
				
					<div class="gp-loader gp-remove-loader">
						<div class="sk-folding-cube">
							<div class="sk-cube1 sk-cube"></div> <div class="sk-cube2 sk-cube"></div> <div class="sk-cube4 sk-cube"></div> <div class="sk-cube3 sk-cube"></div> 
						 </div>
					</div>

					<?php if ( 'submission' === $form ) { ?>
					
						<div class="gp-success <?php echo esc_attr( $css_classes ); ?>">
							<strong><?php esc_html_e( 'Thanks for submitting your post!', 'aardvark-plugin' ); ?></strong>
							<p><?php if ( 'approved' === $post_submission_status ) {
								echo esc_html__( 'Your post was succesfully added. You can view your post', 'aardvark-plugin' ) . ' <span class="gp-view-post-link"><a href="' . get_permalink( $_GET['post_id'] ) . '">' . esc_html__( 'here', 'aardvark-plugin' ) . '</a>.</span>';
							} else {
								esc_html_e( 'Your post is currently being reviewed. ', 'aardvark-plugin' );
								if ( is_user_logged_in() ) {
									echo esc_html__( 'You can check the status of your post', 'aardvark-plugin' ) . ' <span class="gp-view-post-link"><a href="' . ghostpool_get_page_url( ghostpool_option( 'post_submission_list_page' ) ) . '">' . esc_html__( 'here', 'aardvark-plugin' ) . '</a>.</span>';
								}	
							} ?></p>
						</div>
					
					<?php } else { ?>
												
						<div class="gp-success">
							<strong><?php esc_html_e( 'Thanks for editing your post!', 'aardvark-plugin' ); ?></strong>
							<p><?php if ( ghostpool_option( 'post_editing' ) == 'approved' ) {
								echo esc_html__( 'Your post was succesfully edited. You can view your post', 'aardvark-plugin' ) . ' <span class="gp-view-post-link"><a href="' . get_permalink( $_GET['id'] ) . '">' . esc_html__( 'here', 'aardvark-plugin' ) . '</a>.</span>';
							} else {
								esc_html_e( 'Your post is currently being reviewed. ', 'aardvark-plugin' );
								if ( is_user_logged_in() ) {
									echo esc_html__( 'You can check the status of your post', 'aardvark-plugin' ) . ' <span class="gp-view-post-link"><a href="' . ghostpool_get_page_url( ghostpool_option( 'post_submission_list_page' ) ) . '">' . esc_html__( 'here', 'aardvark-plugin' ) . '</a>.</span>';
								}	
							} ?></p>
						</div>
					
					<?php } ?>
					
					<?php if ( 'enabled' === $post_title_field ) { 
					
						// Is required?
						$required = ( '1' == $post_title_field_required ) ? 'required' : 'not-required';
						
						?>	
									
						<div class="gp-post-form-title gp-field-container" data-required="<?php echo esc_attr( $required ); ?>">
							
							<?php if ( $post_title_field_title ) { ?>
								<div class="gp-field-title"><?php echo esc_attr( $post_title_field_title ); ?></div>
							<?php } ?>
							
							<input type="text" name="ghostpool_post_title" class="gp-field gp-post-form-title-field" value="<?php if ( 'edit' === $form ) { echo esc_attr( stripslashes( $post_edit->post_title ) ); } ?>" placeholder="<?php esc_attr_e( $post_title_field_placeholder ); ?>"<?php echo esc_attr( $required ); ?>>
							
							<div class="gp-message"><?php esc_attr_e( $required_field_text ); ?></div>
							
						</div>
						
					<?php }
					
					// Featured image field
					if ( 'enabled' === $featured_image_field ) { 
					
						// Is required?
						$required = ( '1' == $featured_image_field_required ) ? 'required' : 'not-required';
						
						?>

						<div class="gp-post-form-upload gp-field-container" data-required="<?php echo esc_attr( $required ); ?>">
							<?php if ( $featured_image_field_title ) { ?>
								<div class="gp-field-title"><?php echo esc_attr( $featured_image_field_title ); ?></div>
							<?php } ?>
							<a id="gp-upload-image" href="#" class="gp-upload-item button gp-field" data-add-text="<?php esc_attr_e( $featured_image_field_button_text ); ?>" /><?php esc_attr_e( $featured_image_field_button_text ); ?></a>							
							<div class="gp-uploads">
								<?php if ( has_post_thumbnail( $post_id ) ) { 
									$image = wp_get_attachment_image_src( get_post_thumbnail_id( $post_id ), 'thumbnail' ); ?>
									<div class="gp-upload-preview">
										<img src="<?php echo esc_url( $image[0] ); ?>" />
									</div>
								<?php } ?>
							</div>
							<input type="hidden" name="ghostpool_upload_image" class="gp-post-form-upload-field" value="<?php if ( has_post_thumbnail( $post_id ) ) { ?>yes<?php } ?>" <?php echo esc_attr( $required ); ?> />
							
							<div class="gp-message"><?php esc_attr_e( $required_field_text ); ?></div>
							
						</div>
						
					<?php } 
					
					// Name field
					if ( 'enabled' === $name_field ) { 
						if ( ! is_user_logged_in() ) {
						
							// Is required?
							$required = ( '1' == $name_field_required ) ? 'required' : 'not-required';
							
							?>
						
							<div class="gp-post-form-name gp-field-container" data-required="<?php echo esc_attr( $required ); ?>">
								
								<?php if ( $name_field_title ) { ?>
									<div class="gp-field-title"><?php echo esc_attr( $name_field_title ); ?></div>
								<?php } ?>
								
								<input type="text" name="ghostpool_post_username" class="gp-field gp-post-form-name-field" value="<?php if ( isset( $_POST['ghostpool_post_username'] ) ) { echo esc_attr( $_POST['ghostpool_post_username'] ); } ?>" placeholder="<?php esc_attr_e( $name_field_placeholder ); ?>" <?php echo esc_attr( $required ); ?>>
								
								<div class="gp-message"><?php esc_attr_e( $required_field_text ); ?></div>
								
							</div>
							
						<?php } else { ?>
						
							<input type="hidden" name="ghostpool_username" value="">
							
						<?php }
					}
					
					// Email field
					if ( 'enabled' === $email_field ) {
					
						if ( ! is_user_logged_in() ) { 
						
							// Is required?
							$required = ( '1' == $email_field_required ) ? 'required' : 'not-required';
												
							?>
							
							<div class="gp-post-form-email gp-field-container" data-required="<?php echo esc_attr( $required ); ?>">
								<?php if ( $email_field_title ) { ?>
									<div class="gp-field-title"><?php echo esc_attr( $email_field_title ); ?></div>
								<?php } ?>
								<input type="text" name="ghostpool_post_email" class="gp-field gp-post-form-email-field" value="<?php if ( isset( $_POST['ghostpool_post_email'] ) ) { echo esc_attr( $_POST['ghostpool_post_email'] ); } ?>" placeholder="<?php esc_attr_e( $email_field_placeholder ); ?>" <?php echo esc_attr( $required ); ?>>
								<div class="gp-message"><?php esc_attr_e( $required_field_text ); ?></div>
							</div>
							
						<?php } else { ?>
						
							<input type="hidden" name="ghostpool_email" value="">
							
						<?php } 
					}
					
					// Categories field
					if ( 'disabled' !== $cats_field ) {
					
						// Is required?
						$required = ( '1' == $cats_field_required ) ? 'required' : 'not-required';
						
						?>
						
						<div class="gp-post-form-categories gp-field-container<?php if ( 'checkboxes' === $cats_field ) { ?> gp-checkbox-multi-field<?php } ?>" data-required="<?php echo esc_attr( $required ); ?>">
						
							<?php if ( $cats_field_title ) { ?>
								<div class="gp-field-title"><?php echo esc_attr( $cats_field_title ); ?></div>
							<?php } ?>
							
							<?php if ( 'dropdown' === $cats_field OR 'multi_dropdown' === $cats_field OR 'checkboxes' === $cats_field ) {
							
								// Available user categories
								if ( empty( $cats_user_available ) ) {	
									$cat_ids = 'all';
								} else {
									$cat_ids = $cats_user_available;
								}
							
								// Category query
								$args = array(
									'taxonomy'   => 'category',
									'include' 	 => $cat_ids,
									'hide_empty' => false,
								);	
						
								$terms = get_terms( $args );

								if ( ! empty( $terms ) && ! is_wp_error( $terms ) ) {
							
									if ( 'dropdown' === $cats_field OR 'multi_dropdown' === $cats_field ) { ?>
									
										<select name="ghostpool_post_categories<?php if ( 'multi_dropdown' === $cats_field ) { ?>[]<?php } ?>" class="gp-field gp-post-form-categories-field" <?php echo esc_attr( $required ); ?><?php if ( 'multi_dropdown' === $cats_field ) { ?> multiple<?php } ?>>	
											<?php if ( $cats_field_placeholder ) { ?>
												<option value=""><?php esc_attr_e( $cats_field_placeholder ); ?></option>
											<?php } ?>								
											<?php foreach ( $terms as $term ) { 
												if ( 'edit' === $form && in_array( $term->term_id, $post_edit->post_category ) ) {
													$selected = ' selected';
												} else {
													$selected = '';
												} ?>
												<option value="<?php echo esc_attr( $term->term_id ); ?>"<?php echo esc_attr( $selected ); ?>><?php echo esc_attr( $term->name ); ?></option>
											<?php } ?>
										</select>
									
									<?php } elseif ( 'checkboxes' === $cats_field ) {
								
										foreach ( $terms as $term ) { 
											if ( 'edit' === $form && in_array( $term->term_id, $post_edit->post_category ) ) {
												$checked = ' checked';
											} else {
												$checked = '';
											} ?>
											<input type="checkbox" name="ghostpool_post_categories[]" class="gp-post-form-categories-field" value="<?php echo esc_attr( $term->term_id ); ?>"<?php echo esc_attr( $checked ); ?> /><?php echo esc_attr( $term->name ); ?>
										<?php }
								
									} 
								
								}
								
							} ?>
								
							<div class="gp-message"><?php esc_attr_e( $required_field_text ); ?></div>
								
						</div>

					<?php }
					
					// Post Formats field
					if ( 'enabled' === $post_formats_field ) { ?>
						<div class="gp-post-form-formats gp-field-container">
								
							<?php if ( $post_formats_field_title ) { ?>
								<div class="gp-field-title"><?php echo esc_attr( $post_formats_field_title ); ?></div>
							<?php } ?>
							
							<select name="ghostpool_post_formats" class="gp-field gp-post-form-post-format-field">	
								<option value="0"><?php esc_html_e( 'Standard', 'aardvark-plugin' ); ?></option>							
								<?php if ( current_theme_supports( 'post-formats' ) ) {
									$post_formats = get_theme_support( 'post-formats' );
									if ( is_array( $post_formats[0] ) ) {
										foreach ( $post_formats[0] as $post_format ) {
											if ( '1' != $standard && '0' === $post_format) { 
											} elseif ( '1' != $aside && 'aside' === $post_format) { 
											} elseif ( '1' != $audio && 'audio' === $post_format) { 
											} elseif ( '1' != $chat && 'chat' === $post_format) { 
											} elseif ( '1' != $gallery && 'gallery' === $post_format) { 
											} elseif ( '1' != $image && 'image' === $post_format) { 
											} elseif ( '1' != $link && 'link' === $post_format) { 
											} elseif ( '1' != $quote && 'quote' === $post_format) {
											} elseif ( '1' != $status && 'status' === $post_format) {
											} elseif ( '1' != $video && 'video' === $post_format) { 
											} else { 
											
												if ( $post_format === get_post_format( $post_id ) ) {
													$selected = ' selected';
												} elseif ( $post_format_default === $post_format ) {
													$selected = ' selected';
												} else {
													$selected = '';
												} ?>
												<option value="<?php echo esc_attr( $post_format ); ?>"<?php echo esc_attr( $selected ); ?>><?php echo esc_attr( ucfirst( $post_format ) ); ?></option>
											<?php }	
										} 
									}	
								} ?>
							</select>	
							<div class="gp-message"><?php esc_attr_e( $required_field_text ); ?></div>
						</div>
					<?php } ?>	

					<?php if ( $audio == '1' ) { 

						$mp3 = get_post_meta( $post_id, 'gp_audio_mp3_url', true );
						$ogg = get_post_meta( $post_id, 'gp_audio_ogg_url', true );
						
						?>	
						<div class="gp-post-form-format-field gp-post-form-audio gp-field-container">
							<a id="gp-upload-audio" href="#" class="gp-upload-item button gp-field gp-post-form-audio-field" data-add-text="<?php esc_attr_e( $audio_field_button_text ); ?>" /><?php esc_attr_e( $audio_field_button_text ); ?></a>						
							<div class="gp-uploads">
								<?php if ( $mp3 OR $ogg ) { ?>
									<ul class="gp-upload-list">
										<?php if ( $mp3 ) { ?>
											<li><?php echo basename( get_attached_file( $mp3 ) ); ?></li> 
										<?php } ?>
										<?php if ( $ogg ) { ?>
											<li><?php echo basename( get_attached_file( $ogg ) );  ?></li> 
										<?php } ?>
									</ul>	
								<?php } ?>	
							</div>
							<div class="gp-field-desc"><?php esc_html_e( 'Can upload 2 versions of the same file (mp3, ogg)', 'aardvark-plugin' ); ?></div>	
						</div>
					<?php } ?>	
					
					<?php if ( $gallery == '1' ) { ?>				
						<div class="gp-post-form-format-field gp-post-form-gallery gp-field-container">
							<a id="gp-upload-gallery" href="#" class="gp-upload-item button gp-field gp-post-form-gallery-field" data-add-text="<?php esc_attr_e( $gallery_field_button_text ); ?>" /><?php esc_attr_e( $gallery_field_button_text ); ?></a>							
							<div class="gp-uploads"></div>
						</div>
					<?php } ?>
										
					<?php if ( $link == '1' ) { ?>				
						<div class="gp-post-form-format-field gp-post-form-link gp-field-container">
							<input type="text" name="ghostpool_post_link" class="gp-field gp-post-form-link-field" value="<?php echo get_post_meta( $post_id, 'gp_link', true ); ?>" placeholder="<?php esc_attr_e( $link_field_placeholder ); ?>" <?php echo esc_attr( $required ); ?>>
							<div class="gp-message"><?php esc_attr_e( $required_field_text ); ?></div>
						</div>
					<?php } ?>
						
					<?php if ( $video == '1' ) { 
					
						$m4v = get_post_meta( $post_id, 'gp_video_m4v_url', true );
						$mp4 = get_post_meta( $post_id, 'gp_video_mp4_url', true );
						$webm = get_post_meta( $post_id, 'gp_video_webm_url', true );
						$ogv = get_post_meta( $post_id, 'gp_video_ogv_url', true );
						
						?>		
						<div class="gp-post-form-format-field gp-post-form-video gp-field-container">
							<a id="gp-upload-video" href="#" class="gp-upload-item button gp-field gp-post-form-video-field" data-add-text="<?php esc_attr_e( $video_field_button_text ); ?>" /><?php esc_attr_e( $video_field_button_text ); ?></a>							
							<div class="gp-uploads">
								<?php if ( $m4v OR $mp4 OR $webm OR $ogv ) { ?>
									<ul class="gp-upload-list">
										<?php if ( $m4v ) { ?>
											<li><?php echo basename( get_attached_file( $m4v ) ); ?></li>
										<?php } ?>
										<?php if ( $mp4 ) { ?>
											<li><?php echo basename( get_attached_file( $mp4 ) ); ?></li>
										<?php } ?>
										<?php if ( $webm ) { ?>
											<li><?php echo basename( get_attached_file( $webm ) ); ?></li>
										<?php } ?>
										<?php if ( $ogv ) { ?>
											<li><?php echo basename( get_attached_file( $ogv ) ); ?></li>
										<?php } ?>
									</ul>
								<?php } ?>	
							</div>
							<div class="gp-field-desc"><?php esc_html_e( 'Can upload 4 versions of the same file (mp4, m4v, ogv, webm)', 'aardvark-plugin' ); ?></div>		
						</div>
					<?php }
					
					// Post content field
					if ( 'enabled' === $post_content_field ) { 
						
						// Is required?
						$required = ( '1' == $post_content_field_required ) ? 'required' : 'not-required';
					
						?>				
						
						<div class="gp-post-form-content gp-field-container" data-required="<?php echo esc_attr( $required ); ?>">
							<?php if ( $post_content_field_title ) { ?>
								<div class="gp-field-title"><?php echo esc_attr( $post_content_field_title ); ?></div>
							<?php }
							
							if ( isset( $_POST['ghostpool_post_content'] ) ) {
								$post_content = stripslashes( html_entity_decode( $_POST['ghostpool_post_content'] ) );
							} elseif ( 'edit' === $form ) { 
								$post_content = stripslashes( $post_edit->post_content ); 
							} else {
								$post_content = '';
							}
							
							if ( 'tinymce' === $post_content_editor ) {
							
								wp_editor( $post_content, 'ghostpool_post_content', array(
									'editor_class' => 'gp-post-form-content-field',
									'default_editor' => 'tinymce',
									'quicktags' => apply_filters( 'ghostpool_post_submission_form_quicktags', true ),
								) );
							
							} else { ?>
							
								<textarea name="ghostpool_post_content" class="gp-field gp-post-form-content-field" placeholder="<?php esc_attr_e( $post_content_field_placeholder ); ?>" <?php echo esc_attr( $required ); ?>><?php if ( isset( $_POST['ghostpool_post_content'] ) ) { echo stripslashes( html_entity_decode( $_POST['ghostpool_post_content'] ) ); } ?><?php if ( 'edit' === $form ) { echo stripslashes( $post_edit->post_content ); } ?></textarea>
							
							<?php } ?>
							
							<div class="gp-message"><?php esc_attr_e( $required_field_text ); ?></div>
						</div>
					<?php }
					
					// Tags field
					if ( 'disabled' !== $tags_field ) { 						
					
						// Is required?
						$required = ( '1' == $tags_field_required ) ? 'required' : 'not-required';
					
						?>
					
						<div class="gp-post-form-tags gp-field-container<?php if ( 'checkboxes' === $tags_field ) { ?> gp-checkbox-multi-field<?php } ?>" data-required="<?php echo esc_attr( $required ); ?>">
						
							<?php if ( $tags_field_title ) { ?>
								<div class="gp-field-title"><?php echo esc_attr( $tags_field_title ); ?></div>
							<?php } ?>
							
							<?php if ( 'dropdown' === $tags_field OR 'multi_dropdown' === $tags_field OR 'checkboxes' === $tags_field ) {

								// Available user tags
								if ( empty( $tags_user_available ) ) {	
									$tag_ids = 'all';
								} else {
									$tag_ids = $tags_user_available;
								}
							
								// Tag query
								$args = array(
									'taxonomy'   => 'post_tag',
									'include' 	 => $tag_ids,
									'hide_empty' => false,
								);	
						
								$terms = get_terms( $args );

								if ( ! empty( $terms ) && ! is_wp_error( $terms ) ) {
							
									if ( 'dropdown' === $tags_field OR 'multi_dropdown' === $tags_field ) { ?>
									
										<select name="ghostpool_post_tags<?php if ( 'multi_dropdown' === $tags_field ) { ?>[]<?php } ?>" class="gp-field gp-post-form-tags-field" <?php echo esc_attr( $required ); ?><?php if ( 'multi_dropdown' === $tags_field ) { ?> multiple<?php } ?>>	
											<?php if ( $tags_field_placeholder ) { ?>
												<option value=""><?php esc_attr_e( $tags_field_placeholder ); ?></option>							
											<?php } ?>
											<?php foreach ( $terms as $term ) { 
												if ( 'edit' === $form && in_array( $term->slug, $post_edit->tags_input ) ) {
													$selected = ' selected';
												} else {
													$selected = '';
												} ?>
												<option value="<?php echo esc_attr( $term->slug ); ?>"<?php echo esc_attr( $selected ); ?>><?php echo esc_attr( $term->name ); ?></option>
											<?php } ?>
										</select>
									
									<?php } elseif ( 'checkboxes' === $tags_field ) {
								
										foreach ( $terms as $term ) { 
											if ( 'edit' === $form && in_array( $term->slug, $post_edit->tags_input ) ) {
												$checked = ' checked';
											} else {
												$checked = '';
											} ?>
											<input type="checkbox" name="ghostpool_post_tags[]" class="gp-post-form-tags-field" value="<?php echo esc_attr( $term->slug ); ?>"<?php echo esc_attr( $checked ); ?>/><?php echo esc_attr( $term->name ); ?>
										<?php }
								
									} 
								
								}
								
							} else { ?>
							
								<input type="text" name="ghostpool_post_tags" class="gp-field gp-post-form-tags-field" value="<?php if ( 'edit' === $form ) { echo esc_attr( implode( ',', $post_edit->tags_input ) ); } ?>" placeholder="<?php esc_attr_e( $tags_field_placeholder ); ?>" <?php echo esc_attr( $required ); ?>/>

							<?php } ?>
							
							<div class="gp-message"><?php esc_attr_e( $required_field_text ); ?></div>

						</div>
						
					<?php }
					
					// Terms of Use field
					if ( 'enabled' === $toc_field && 'submission' === $form ) { 
					
						// Is required?
						$required = ( '1' == $toc_field_required ) ? 'required' : 'not-required';
					
						?>
						<div class="gp-post-form-toc gp-field-container gp-checkbox-single-field" data-required="<?php echo esc_attr( $required ); ?>">							
							<?php if ( $toc_field_title ) { ?>
								<div class="gp-field-title"><?php echo esc_attr( $toc_field_title ); ?></div>
							<?php } ?>
							<input type="checkbox" name="ghostpool_post_toc" value="1" <?php echo esc_attr( $required ); ?>/> <label><?php echo rawurldecode( base64_decode( $toc_field_text ) ); ?></label>
							<div class="gp-message"><?php esc_attr_e( $required_field_text ); ?></div>
						</div>
					<?php } ?>
	
					<div class="gp-post-form-submit">
						<input type="submit" value="<?php echo esc_attr( $submit_button_text ); ?>" tabindex="40" class="gp-submit" name="submit" />
					</div>
					
					<?php 
					
					// GDPR field
					if ( 'enabled' === $gdpr_field && 'submission' === $form ) { 
					
						// Is required?
						$required = ( '1' == $gdpr_field_required ) ? 'required' : 'not-required';

						?>

						<div class="gp-post-form-gdpr gp-field-container gp-checkbox-single-field" data-required="<?php echo esc_attr( $required ); ?>">							
							<?php if ( $gdpr_field_title ) { ?>
								<div class="gp-field-title"><?php echo esc_attr( $gdpr_field_title ); ?></div>
							<?php } ?>
							<input name="gdpr" type="checkbox" value="1" <?php echo esc_attr( $required ); ?>/> <label><?php echo rawurldecode( base64_decode( $gdpr_field_text ) ); ?></label>
							<div class="gp-message"><?php esc_attr_e( $required_field_text ); ?></div>
						</div>
						
					<?php } ?>
					
					<?php if ( 'submission' === $form ) { ?>
					
						<input type="hidden" value="<?php echo get_the_ID(); ?>" class="gp-post-form-submission-page-id">
					
						<?php if ( $cats_auto ) { ?>
							<input type="hidden" value="<?php echo esc_attr( $cats_auto ); ?>" class="gp-post-form-cats-auto">
						<?php } ?>	
					
						<?php if ( $tags_auto ) { ?>
							<input type="hidden" value="<?php echo esc_attr( $tags_auto ); ?>" class="gp-post-form-tags-auto">
						<?php } ?>
					
						<?php if ( $post_format_default ) { ?>
							<input type="hidden" value="<?php echo esc_attr( $post_format_default ); ?>" class="gp-post-form-post-format-default">
						<?php } ?>
						
						<?php if ( $post_submission_status ) { ?>
							<input type="hidden" value="<?php echo esc_attr( $post_submission_status ); ?>" class="gp-post-form-submission-status">
						<?php } ?>
						
						<?php if ( $post_submission_email_notification ) { ?>
							<input type="hidden" value="<?php echo esc_attr( $post_submission_email_notification ); ?>" class="gp-post-form-submission-email-notification">
						<?php } ?>
					
						<?php if ( $post_submission_email_address ) { ?>
							<input type="hidden" value="<?php echo esc_attr( antispambot( $post_submission_email_address ) ); ?>" class="gp-post-submission-email-address">
						<?php } ?>	
					
						<?php if ( $post_submission_subject ) { ?>
							<input type="hidden" value="<?php echo esc_attr( $post_submission_subject ); ?>" class="gp-post-submission-subject">
						<?php } ?>
						
					<?php } ?>	
					
					<?php if ( 'edit' === $form ) { ?>
					
						<?php if ( $post_id > 0 ) { ?>
							<input type="hidden" class="gp-post-form-edit-id" value="<?php echo absint( $post_id ); ?>" />
						<?php } ?>
						
						<?php if ( $post_submission_email_address ) { ?>
							<input type="hidden" value="<?php echo esc_attr( antispambot( $post_submission_email_address ) ); ?>" class="gp-post-submission-email-address">
						<?php } ?>	
					
						<?php if ( $post_submission_subject ) { ?>
							<input type="hidden" value="<?php echo esc_attr( $post_submission_subject ); ?>" class="gp-post-submission-subject">
						<?php } ?>
						
					<?php } ?>
					
				</form>
			
			</div>
			
		<?php } else { ?>

			<?php if ( $login_text ) {
				$login_text = rawurldecode( base64_decode( $login_text ) );
				$login_text = preg_replace( "/%LOGIN_LINK%/", wp_login_url(), $login_text );
				?>
				<div class="gp-post-submission-login">
					<strong><?php echo wp_kses_post( $login_text ); ?></strong>
				</div>
			<?php } ?>
			
		<?php } ?>
		
		<?php

		$output_string = ob_get_contents();
		ob_end_clean();
		return $output_string;

	}
}
add_shortcode( 'gp_post_submission_form_2', 'ghostpool_post_submission_form_2' );